#include "jp/ggaf/dx/effect/MassPointSpriteEffect.h"

#include "jp/ggaf/dx/God.h"
#include "jp/ggaf/dx/exception/CriticalException.h"
#include "jp/ggaf/dx/scene/Spacetime.h"


using namespace GgafDx;

MassPointSpriteEffect::MassPointSpriteEffect(const char* prm_effect_name) : MassEffect(prm_effect_name) {
    _obj_effect |= Obj_GgafDx_MassPointSpriteEffect;
    Camera* const pCam = pGOD->getSpacetime()->getCamera();
    //VF[_[ʂ̃O[oϐݒ
    HRESULT hr;
    //ˉeϊs
    hr = _pID3DXEffect->SetMatrix("g_matProj", pCam->getProjectionMatrix() );
    checkDxException(hr, D3D_OK, "SetMatrix(g_matProj) Ɏs܂B");
    hr = _pID3DXEffect->SetFloat("g_dist_CamZ_default", -(pCam->getZOrigin()));
    checkDxException(hr, D3D_OK, "SetFloat(g_dist_CamZ_default) Ɏs܂B");
//    hr = _pID3DXEffect->SetFloat("g_zn", pCam->getZNear());
//    checkDxException(hr, D3D_OK, "SetFloat(g_zn) Ɏs܂B");
    hr = _pID3DXEffect->SetFloat("g_zf", pCam->getZFar());
    checkDxException(hr, D3D_OK, "SetFloat(g_zf) Ɏs܂B");

    //VF[_[nh
    _h_matView  = _pID3DXEffect->GetParameterByName( nullptr, "g_matView" );
    _hTexSize = _pID3DXEffect->GetParameterByName( nullptr, "g_TexSize" );
    _hTextureSplitRowcol = _pID3DXEffect->GetParameterByName( nullptr, "g_TextureSplitRowcol" );
    _hInvTextureSplitRowcol = _pID3DXEffect->GetParameterByName( nullptr, "g_InvTextureSplitRowcol" );
}

void MassPointSpriteEffect::setParamPerFrame() {
    Camera* const pCam = pGOD->getSpacetime()->getCamera();
    HRESULT hr = _pID3DXEffect->SetMatrix(_h_matView, pCam->getViewMatrix() );
    checkDxException(hr, D3D_OK, "setParamPerFrame SetMatrix(_h_matView) Ɏs܂B");
}

MassPointSpriteEffect::~MassPointSpriteEffect() {
}

