#include "jp/ggaf/dx/actor/ex/CubeMapMeshActor.h"

#include "jp/ggaf/dx/God.h"
#include "jp/ggaf/dx/exception/CriticalException.h"
#include "jp/ggaf/dx/effect/ex/CubeMapMeshEffect.h"
#include "jp/ggaf/dx/model/ex/CubeMapMeshModel.h"


using namespace GgafDx;


CubeMapMeshActor::CubeMapMeshActor(const char* prm_name,
                                   const char* prm_model_id,
                                   const char* prm_effect_id,
                                   const char* prm_technique,
                                   Checker* prm_pChecker) :
                                           MeshActor(prm_name,
                                                           prm_model_id,
                                                           TYPE_CUBEMAPMESH_MODEL,
                                                           prm_effect_id,
                                                           TYPE_CUBEMAPMESH_EFFECT,
                                                           prm_technique,
                                                           prm_pChecker) ,
                                            ICubeMapActor() {
    _obj_class |= Obj_GgafDx_CubeMapMeshActor;
    _class_name = "CubeMapMeshActor";
    _pCubeMapMeshModel = (CubeMapMeshModel*)_pModel;
    _pCubeMapMeshEffect = (CubeMapMeshEffect*)_pEffect;
}

void CubeMapMeshActor::processDraw() {
    ID3DXEffect* const pID3DXEffect = _pMeshEffect->_pID3DXEffect;
    HRESULT hr;
    hr = pID3DXEffect->SetMatrix(_pCubeMapMeshEffect->_h_matWorld, &_matWorld );
    checkDxException(hr, D3D_OK, "SetMatrix(g_matWorld) Ɏs܂B");
    hr = pID3DXEffect->SetFloat(_pCubeMapMeshEffect->_h_reflectance, getCubeMapReflectance());
    checkDxException(hr, D3D_OK, "SetFloat(_h_reflectances) Ɏs܂B");
    God::_pID3DDevice9->SetTexture(1, getCubeMapTexture());
    if (_pBumpMapTextureConnection) {
        hr = God::_pID3DDevice9->SetTexture(2, getBumpMapTexture());
        checkDxException(hr, D3D_OK, "SetTexture() Ɏs܂B");
        hr = pID3DXEffect->SetMatrix(_pCubeMapMeshEffect->_h_matInvWorld, getInvMatWorldRotMv() );
        checkDxException(hr, D3D_OK, "SetMatrix(_h_matInvWorld) Ɏs܂B");
        //TODO:tsŌvZΗǂAAł͂₭邽߂getInvMatWorldRotMv()őpB
        //getInvMatWorldRotMv() Ȃ̂ŁAgklĂȂBƂɊg嗦ႤꍇAov}bv͂ƂȂB
    }
    ((MeshModel*)_pCubeMapMeshModel)->MeshModel::draw(this);
}

CubeMapMeshActor::~CubeMapMeshActor() {
}
