#ifndef GGAF_DX_FIXEDFRAMECURVEMANUFACTURE_H_
#define GGAF_DX_FIXEDFRAMECURVEMANUFACTURE_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dx/util/curve/CurveManufacture.h"

namespace GgafDx {

/**
 * ԌŒ莞ԁit[jړɂAXvCȐړ̂߂̏Zbg .
 * SẴAN^[ɋʂXvC̏͂ɏWB
 * @version 1.00
 * @since 2009/10/28
 * @author Masatoshi Tsuge
 */
class FixedFrameCurveManufacture : public CurveManufacture {

public:
    /** [r]PԂ̎gp\t[ */
    double _frame_of_segment;
    /** [r]̕⊮_BɕKvȈړx̃e[u */
    velo* _paSPMvVeloTo;
    /** [rw]1t[\ȉ]ppx */
    angvelo _angvelo_rzry_mv;
    /** [rw]@ */
    int _turn_way;
    /** [rw]œKL */
    bool _turn_optimize;
    /** [r]ŏIn_܂ł̃t[ */
    frame _spent_frames;

public:
    /**
     * RXgN^ .
     * @param prm_coord_spl_file XvCWt@C
     * @param prm_spent_frames n_(AN^[̌Wł͂Ȃ)`ŏIn_܂ł̃t[
     * @param prm_angvelo_rzry_mv AN^[̐px
     * @param prm_turn_way AN^[̐@(ftHg TURN_CLOSE_TO)
     * @param prm_turn_optimaize AN^[̐̍œKIvV(ftHg false)
     */
    FixedFrameCurveManufacture(const char* prm_coord_spl_file,
                                frame prm_spent_frames,
                                angvelo prm_angvelo_rzry_mv = (D90ANG/9),
                                int prm_turn_way = TURN_CLOSE_TO,
                                bool prm_turn_optimaize = false );

    /**
     * RXgN^ .
     * @param prm_pCurveSrc XvCWIuWFNg
     * @param prm_spent_frames n_(AN^[̌Wł͂Ȃ)`ŏIn_܂ł̃t[
     * @param prm_angvelo_rzry_mv AN^[̐px
     * @param prm_turn_way AN^[̐@ (ftHg TURN_CLOSE_TO)
     * @param prm_turn_optimaize AN^[̐̍œKIvV(ftHg false)
     */
    FixedFrameCurveManufacture(CurveSource* prm_pCurve,
                               frame prm_spent_frames,
                               angvelo prm_angvelo_rzry_mv = (D90ANG/9),
                               int prm_turn_way = TURN_CLOSE_TO,
                               bool prm_turn_optimaize = false );
    /**
     * ivZj .
     * vpeBύXꍇAe[uXV邽߂
     * xsKv܂B
     */
    void calculate() override;

    /**
     * ŏIn_܂ł̃t[擾 .
     * @return
     */
    frame getSpentFrames() {
        return _spent_frames;
    }
    /**
     * ŏIn_܂ł̃t[w肵AČvZ .
     * @param prm_spent_frames
     */
    void recalculateBySpentFrame(frame prm_spent_frames);

    /**
     * DriverLeader IuWFNg̐ .
     * CX^X FixedFrameCurveManufacture łB
     * @param prm_pVecDriver J[uړ邽߂̑삷IuWFNg
     * @return DriverLeader IuWFNg
     */
    DriverLeader* createVecDriverLeader(GgafDx::VecDriver* prm_pVecDriver) override;

    DriverLeader* createGeoDriverLeader(GgafDx::GeoDriver* prm_pGeoDriver) override;

    virtual ~FixedFrameCurveManufacture();
};

}
#endif /*GGAF_DX_FIXEDFRAMECURVEMANUFACTURE_H_*/
