#ifndef GGAF_DX_DRIVERLEADER_H_
#define GGAF_DX_DRIVERLEADER_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/Object.h"

namespace GgafDx {

enum SplinTraceOption {
    ABSOLUTE_COORD,     //΍Wړ
    RELATIVE_COORD,     //XvCW(0,0,0)AAN^[̌WƂ΍WŌvZ
    RELATIVE_COORD_DIRECTION, //XvCW(0,0,0)AAN^[̌WƂ΍WƂAAN^[݂̌̌i_rx > _rz > _ry)ŃXvCWQ[hϊB
};

/**
 * XvCȐړs邽߂̃IuWFNg .
 * ͎ԂɎwoĈړ擱܂B
 * @version 1.00
 * @since 2009/10/27
 * @author Masatoshi Tsuge
 */
class DriverLeader : public GgafCore::Object {

public:
    /** XvCZbg */
    CurveManufacture* _pManufacture;
    /** 擱Jnǂ */
    bool _was_started;
    /** ݐ擱ł邩ǂ */
    bool _is_leading;
    /** W𑀍삷ΏۂƂȂAN^[ */
    GgafDx::GeometricActor* _pActor_target;
    /**
     * [r]IvV
     * ABSOLUTE_COORD     : ΍WړB
     * RELATIVE_COORD     : n_WƂAXvCWQ͑ΈړŌvZB
     * RELATIVE_COORD_DIRECTION : n_WƂAɌ݂̌i_pVecDriver  _rz_mv, _ry_mv)ŃXvCWQ[hϊB
     */
    SplinTraceOption _option;
    /** [r] [vJE^ */
    int _cnt_loop;
    /** [r] ݒ胋[vB-1 Ŗ */
    int _max_loop;

    /** [r]̃[vł̎n_XW */
    coord _x_start_in_loop;
    /** [r]̃[vł̎n_YW */
    coord _y_start_in_loop;
    /** [r]̃[vł̎n_ZW */
    coord _z_start_in_loop;

    coord _offset_x;
    coord _offset_y;
    coord _offset_z;

    int _flip_x;
    int _flip_y;
    int _flip_z;
    /** [r]AN^[݈̌ʒuXvCn_܂ł̋Bstart()_ōXVB */
    int _distance_to_begin;
    /** [r]n_WŒ肷BiŒ肵Ȃꍇ͎͗Ԃ̃AN^[̍WɂȂj */
    bool _is_force_start_pos;
    bool _is_force_start_ang;
    bool _is_fix_pos;
//    bool _is_loop_ang_by_face;

    float _sinRx_begin;
    float _cosRx_begin;
    float _sinRz_begin;
    float _cosRz_begin;
    float _sinRy_begin;
    float _cosRy_begin;

    bool _turn_smooth;

public:
    /**
     * RXgN^ .
     * @param prm_pManufacture
     * @param prm_pVecDriver
     */
    DriverLeader(CurveManufacture* prm_pManufacture,  GgafDx::GeometricActor* prm_pActor_target);

    /**
     * e⊮_ǂݍݎAXAYAZꂼɉZ(sړ)A␳܂ .
     * ftHg adjustCoordOffset(0, 0, 0) ƂȂ܂B<BR>
     * <b>[]</b><BR>
     * ŁAadjustAxisXFlip() adjustAxisYFlip() adjustAxisZFlip() lA
     *  Manufacture XYZ̕␳悶ꂽAԍŌ
     * adjustCoordOffset()  lꍷZ܂B<BR>
     * @param prm_offset_x X␳
     * @param prm_offset_y Y␳
     * @param prm_offset_z Z␳
     */
    virtual void adjustCoordOffset(coord prm_offset_x, coord prm_offset_y, coord prm_offset_z);

    /**
     * XvC̊eW_AX]܂B
     */
    virtual void adjustAxisXFlip() {
        _flip_x = -_flip_x;
    }

    /**
     * XvC̊eW_AY]܂B
     */
    virtual void adjustAxisYFlip() {
        _flip_y = -_flip_y;
    }

    /**
     * XvC̊eW_AZ]܂B
     */
    virtual void adjustAxisZFlip() {
        _flip_z = -_flip_z;
    }

    /**
     * ΏۃAN^[(_pActor_target)̍WAXvC̈ԍŏ̐_WŐݒ肷 .
     * start(ABSOLUTE_COORD) ̏ꍇA܂u΍WړXvCv̏ꍇA
     * LȐݒƂȂ肤ł傤B<BR>
     */
    void setAbsoluteBeginCoord();

    /**
     * ォXvCIuWFNgݒB
     * @param prm_pManufacture
     */
    virtual void setManufacture(CurveManufacture* prm_pManufacture);

    /**
     * XvCȐ̕⊮_ړ擱Jn .
     * @param prm_option ABSOLUTE_COORD     ΍Wړ
     *                   RELATIVE_COORD     XvCW(0,0,0)AΏ͎ۗԂ̃AN^[̌WƂA΍WŌvZ
     *                   RELATIVE_COORD_DIRECTION XvCW(0,0,0)AΏ͎ۗԂ̃AN^[̌WƂA΍WŌvZB̌Ǎ݂i_rx > _rz > _ry)ŃXvCWQ[hϊB
     * @param prm_max_loop JԂ񐔁Aȗ͂P[vB
     */
    virtual void start(SplinTraceOption prm_option, int prm_max_loop = 1);

    virtual void restart();

    /**
     * XvCȐ̕⊮_ړ擱߂iFAN^[~킯ł͂Ȃj .
     */
    virtual void stop();

    /**
     * ړs\bh .
     * ړs߂ɁA͎Ԃ̏ԂXV܂B
     * start() st[ɎsƂƂ͕svB<BR>
     * start() sŏbehave()́A݂̍W`|Cg[0] Ă΂̈ړA
     * A݂̍Wƃ|Cg[0]dȂĂ΁A݂̍W`|Cg[1]ւ̈ړƂȂ܂B<BR>
     * ͎(GgafDx::VecDriver)behave();ɎsĉB
     */
    virtual void behave() = 0;

    /**
     * ͎Ԃ擱ۂ .
     * @return true:擱 / false:擱IĂ
     */
    inline bool isLeading() {
        return _is_leading;
    }

    /**
     * ͎Ԃ擱IۂB .
     * @return true:擱IĂ / false:܂JnĂȂA擱
     */
    inline bool isFinished() {
        if (_was_started) {
            return _is_leading ? false : true;
        } else {
            return false;
        }
    }

    /**
     * XvC̕⊮_ƕ⊮_̊Ԃ̋擾B
     * CurveManufacture::adjustAxisRate(double,double,double);<BR>
     * ɂ␳ς݂̕⊮_ԋ擾B<BR>
     * CfbNX=0 start() sɎ擾o悤ɂȂB<BR>
     * <pre>
     *
     *   X:_
     *   o:_Ԃ̕⊮_iXvCȐʉߓ_j
     *
     *        getSegmentDistance(0)
     *            ||
     *            ||    getSegmentDistance(1)   getSegmentDistance(5)   getSegmentDistance(8)
     *            ||         ||                     ||                         ||
     *        <-----------> <--->                <------->                  <------->
     *    @EEEEEE X----o----o----o-----X--------o---------o--------o-------X
     *                    n_
     *                    [0]  [1]  [2]  [3]   [4]      [5]       [6]      [7]     [8]
     *
     *  </pre>
     * @param prm_index CfbNXi0=AN^[Wn_Ԃ̋B1=n_n_+1̕⊮_ԋEEEj
     * @return ̃ZOg̋
     */
    coord getSegmentDistance(int prm_index);

    /**
     * ݂̍W`n_[0]`I_Ԃ̋擾B
     * @return v
     */
    coord getTotalDistance();

    /**
     * XvC̕⊮_(_܂)̐ԂB
     * <pre>
     *
     *   X:_
     *   o:_Ԃ̕⊮_iXvCȐʉߓ_j
     *
     *        getSegmentDistance(0)
     *            ||
     *            ||    getSegmentDistance(1)   getSegmentDistance(5)   getSegmentDistance(8)
     *            ||         ||                     ||                         ||
     *        <-----------> <--->                <------->                  <------->
     *    @EEEEEE X----o----o----o-----X--------o---------o--------o-------X
     *                    n_
     *                    [0]  [1]  [2]  [3]   [4]      [5]       [6]      [7]     [8]
     *
     * </pre>
     *  }̏ꍇ ⊮_CfbNXO`ŴXȂ̂ŁA߂l9ƂȂB
     * @return ⊮_(_܂)̐
     */
    int getPointNum();

    /**
     * ⊮_̍W擾B
     * @param prm_index ⊮_CfbNX(0`) <BR>
     *                  Jn_CfbNXF0 ` ŏI_CfbNXFgetPointNum()-1
     * @param out_x ߂lXW
     * @param out_y ߂lYW
     * @param out_z ߂lZW
     */
    virtual void getPointCoord(int prm_index, coord& out_x, coord& out_y, coord& out_z);

    /**
     * XvC̊JnW̍WɌŒݒB
     * {\bhsȂꍇAXvCJnẂA<BR>
     * uXvCJnW  start()̗͎Ԃ̃AN^[̍WvƂȂ̂A<BR>
     * s킸ɁAXvCJnWACӂ̍W̃X^[gɐݒsB
     * zgp@́A{\bhsŊJnWݒ肵A<BR>
     * ۂ̈ړAN^[̍W͕ʂ̏ꏊɐݒ肵āAJ[uړJnA<BR>
     * ƃXvCȐOɏXɍ悤Ȍʂo邱ƂłB<BR>
     * @param prm_x
     * @param prm_y
     * @param prm_z
     */
    void setPositionFix(coord prm_x, coord prm_y, coord prm_z) {
        setStartPosition(prm_x, prm_y, prm_z);
        _is_fix_pos = true;
    }

    /**
     * ԍŏ̃XvC̊JnW̍WɐݒB
     * AAstart()AJ[uړJԂݒ(QTȏ)sꍇAQڈȍ~ɂ͓KpȂB<BR>
     * QTڈȍ~́AJnẂAO̘_ŏIWAJnWɐݒ肳B
     * AQTڂɓOɍēxݒ肵ꍇAQTڃXvC̊JnW̍WɐݒB
     * @param prm_x
     * @param prm_y
     * @param prm_z
     */
    void setStartPosition(coord prm_x, coord prm_y, coord prm_z) {
        _is_force_start_pos = true;
        _x_start_in_loop = prm_x;
        _y_start_in_loop = prm_y;
        _z_start_in_loop = prm_z;
    }

    /**
     * XvC̊JnړŒɐݒB
     * {\bhsȂꍇAXvCJñXvĆA<BR>
     * uXvCJn  start()̑ΏۃAN^[̗͎Ԃ̌̕(_rz, _ryjvƂȂ̂A<BR>
     * s킸ɁAXvCJnACӂ̃XvC̃X^[gɐݒsB<BR>
     * start()AJ[uړJԂݒ(QTȏ)sꍇA
     * QTڈȍ~́AJnړ͂̂܂܂ŁA̒l̂܂܈p邱ƂɂȂB<BR>
     * AQTڂɓOɍēxݒ肵ꍇAQTڃXvC̊Jnړ̕ɐݒB
     * XvC̐ݒ́ARELATIVE_COORD_DIRECTION ̏ꍇ݈̂ӖB
     * ӁFrx > ry > rz ̈I(rz > rył͂Ȃ)
     * @param prm_rx
     * @param prm_rz
     * @param prm_ry
     */
    void setStartAngle(angle prm_rx, angle prm_ry, angle prm_rz);

//    /**
//     * J[uړ̊JnAĂɑ΂ĊJn (ftHg).
//     * start()̑ΏۃAN^[̌̕(_rz, _ry)ɍWϊāAXvC̋OՂ\zB
//     */
//    void setLoopAngleByFaceAng() {
//        _is_loop_ang_by_face = true;
//    }
//
//    /**
//     * J[uړ̊JnAړĂɑ΂ĊJn .
//     * start()̑ΏۃAN^[͎Ԃ̈ړ(getVecDriver()->_rz_mv, getVecDriver()->_ry_mvj
//     * ɍWϊāAXvC̋OՂ\zB
//     */
//    void setLoopAngleByMvAng() {
//        _is_loop_ang_by_face = false;
//    }



//    void linkedStartPosition() {
//        unsetStartPosition();
//        _is_linked_start_pos = true;
//    }
//
//    void unlinkedStartPosition() {
//        _is_linked_start_pos = false;
//    }
//
//    void linkedStartAngle() {
//        unsetStartAngle();
//        _is_linked_start_ang = true;
//    }
//
//    void unlinkedStartAngle() {
//        _is_linked_start_ang = false;
//    }

    virtual ~DriverLeader();
};

}
#endif /*GGAF_DX_DRIVERLEADER_H_*/
