#ifndef GGAF_DX_CURVEMANUFACTURE_H_
#define GGAF_DX_CURVEMANUFACTURE_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/Object.h"

#include <string>

namespace GgafDx {

/**
 * XvCȐړ̂߂̏Zbg .
 * SẴAN^[ɋʂXvC̏͂ɏWB<BR>
 * IuWFNg̊֌W<BR>
 * DriverLeader       eAN^[ɐB
 *                    AN^[ɑ΂AXvCȐ݂̌̕⊮_̈ʒuEԁE̊ǗsA
 *                    ͎(VecDriver)ɎwoăAN^[ړB
 *                    P CurveManufacture IuWFNgɑ΂ N  DriverLeader IuWFNgQƂĂB
 *                    XvC̍W_Ԃ̋ɉe̖̓RRŕێB
 *                    ܂XvCȐ̍W_̎sړItZbgA
 *                    X,Y,Z̐ւBiTODO:́A]RRɁj
 *
 * CurveManufacture   XvCȐ̓IҏWigkȂǁjAړNXiDriverLeaderj̏񓙂ێB
 *                    gkɂAe⊮_̋̏\ߌvZĕێĂB
 *                    gkύXꍇ́ÃIuWFNg̃tB[hČvZKvƂȂB
 *                    P CurveSource IuWFNgɑ΂ N  CurveSourceIuWFNgQƂĂB
 *                    (ldrt@C̏ɑB)
 *
 * CurveSource        XvCȐ̍W_Zbg̏ێIuWFNgB
 *                    CurveSource ͐ƓɁÃt@C̊Ot@Cǂݍ݁A
 *                    W̕⊮_vZAێB
 *                    (datt@C̏ɑB)
 *
 * @version 1.00
 * @since 2011/08/05
 * @author Masatoshi Tsuge
 */
class CurveManufacture : public GgafCore::Object {

public:

    enum MoveMethod {
        FixedVelocity = 1,
        FixedFrame,
        SteppedCoord,
    };

    enum MoveDriver {
        GeoDriver = 1,
        VecDriver,
    };


    CurveSourceConnection* _pCurveSrcCon;
    /** [r]W(datt@Cɑ)*/
    CurveSource* _pCurve;
    /** [r]XvCWt@C(ldrt@C) */
    std::string _ldr_file;
    /** X␳ */
    double _rate_x;
    /** Y␳ */
    double _rate_y;
    /** Z␳ */
    double _rate_z;
    /** [r]̕⊮_܂ł̋̃e[u */
    coord* _paDistance_to;
    /** [r]̍v _paDistance_to[0] ` _paDistance_to[n]  */
    coord _total_distance;
    /** [r]vZς݂ł邩ǂ */
    bool _is_calculated;


    MoveMethod _move_method;
    MoveDriver _move_driver;
public:
    /**
     * RXgN^ .
     * @param prm_coord_spl_file XvCWt@C(splt@C)
     */
    explicit CurveManufacture(const char* prm_coord_spl_file);
    /**
     * RXgN^ .
     * @param prm_pCurveSrc XvCWIuWFNg
     */
    CurveManufacture(CurveSource* prm_pCurve);

    /**
     * e⊮_AXAYAZꂼɊ悶A␳܂ .
     * ftHg adjustAxisRate(1.0, 1.0, 1.0) ƂȂ܂B<BR>
     * <b>[]</b><BR>
     * ̃\bhsꍇA_̓_̋ς邽߁A<BR>
     * ʃNX̎ɂẮAێe[uXV邽߂ɁA<BR>
     * calculate() sȂƔf܂B
     * @param prm_rate_x X␳
     * @param prm_rate_y Y␳
     * @param prm_rate_z Z␳
     */
    virtual void adjustAxisRate(double prm_rate_x, double prm_rate_y, double prm_rate_z);

    /**
     * ivZj .
     * _paDistance_to[]  _total_distance vZ܂B<BR>
     * vpeBύXꍇAe[uXV邽߂
     * xsKv܂B
     * ʂŌĂяoĉB
     */
    virtual void calculate();


    virtual DriverLeader* createDriverLeader(GgafDx::GeometricActor* prm_pActor);

    /**
     * DriverLeader IuWFNg̐ .
     * ݒ肵͎ԂA삵܂̂ŒӂĉB<br>
     * {\bhō쐬 DriverLeader ́AĂь deleteKv܂B<br>
     * @param prm_pVecDriver Ώۂ̃AN^[̗͎
     * @return
     */
    virtual DriverLeader* createVecDriverLeader(GgafDx::VecDriver* prm_pVecDriver);

    virtual DriverLeader* createGeoDriverLeader(GgafDx::GeoDriver* prm_pGeoDriver);

    void setMoveMethod(MoveMethod prm_move_method) {
        _move_method = prm_move_method;
    }

    void setMoveDriver(MoveDriver prm_move_driver) {
        _move_driver = prm_move_driver;
    }

    virtual ~CurveManufacture();
};

}
#endif /*GGAF_DX_CURVEMANUFACTURE_H_*/
