#ifndef GGAF_DX_BGM_H_
#define GGAF_DX_BGM_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/Object.h"

#include <string>

namespace GgafDx {

/**
 * Bgm(OggtH[}bg)NX .
 */
class Bgm : public GgafCore::Object {
    static std::string getOggFileName(std::string prm_file);

public:
    char* _bgm_key;
//    /** [r]BGM  BMP */
//    int _bpm;
//    /** [r]BGM  ^Cg */
//    std::string _title;
    /** [r]BGM  oggt@C(pX) */
    std::string _ogg_file_name;
    /** [r]PCMPlayer */
    IkdLib::PCMPlayer* _pPcmPlayer;
    IkdLib::OggVorbisFile* _pOggResource;
    IkdLib::OggDecoder* _pOggDecoder;
    /** [r]݂̉ʒl(0 ` 1000) */
    int _volume;
    /** [r]݂̃pl(left:-1.0 ` center:0 ` right:1.0) */
    float _pan;

public:
    /**
     * RXgN^ .
     * vpeBt@C玟̃L[̒l擾܂B
     * @ prm_bgm_key         EEE lFBGMƂȂ oggt@C
     * A prm_bgm_key+"_BPM"  EEE lFݖgp(:TODO)
     * B prm_bgm_key+"_TITLE"EEE lFݖgp(:TODO)
     * ɁA@̂̒lBGMƂȂ oggt@C vpeBt@C
     * DIR_OGG[0] ̐ݒlzTăI[vAĐs܂B
     * @param prm_bgm_key vpeBt@Ckey
     * @return
     */
    explicit Bgm(const char* prm_bgm_key);


    virtual char* getKeyName() {
        return _bgm_key;
    }

    virtual std::string getFileName() {
        return _ogg_file_name;
    }

    /**
     * BGMĐ .
     * @param prm_is_looping true:[vĐ
     */
    virtual void play(bool prm_is_looping = true);

    /**
     * ꎞ~ .
     * Đ pause() ƁATEhobt@~邪A
     * TEhobt@̓o͍sꖳB<BR>
     * ꎞ~ pause() ĂȂB<BR>
     * ~ pause() ĂȂB<BR>
     */
    virtual void pause();

    /**
     * ꎞ~ .
     * ꎞ~ unpause() ƁATEhobt@ĐB
     * [v̐ݒ͈pB<BR>
     * Đ unpause() ĂȂB<BR>
     * ~ unpause() ĂȂB<BR>
     */
    virtual void unpause();

    /**
     * BGM̒~ .
     * ǂ̗lȏԂłATEhobt@~ATEhobt@̓osB
     */
    virtual void stop();

    /**
     * BGM̃{[ݒ .
     * AŎۂɐݒ肳鉹ʂ́ABGM}X^[ʗ悶ꂽlƂȂ܂B
     * @param volume 0`1000
     */
    void setVolume(int volume);

    /**
     * BGM̃{[擾 .
     * 擾鉹ʂ́ABGM}X^[ʗlO̒lB
     * ܂A{NXsetVolume(int) Őݒ肵l̂܂܎擾܂B
     * @return BGM̃{[(0`1000)
     */
    virtual int getVolume() {
        return _volume;
    }

    /**
     * BGM̃pݒ .
     * @param pan  -1.0 ` 0 ` 1.0 E
     */
    void setPan(float pan);

    virtual int getPan() {
        return _pan;
    }

    /**
     * ĐXbh~ATEhobt@ .
     */
    virtual void clear();

    /**
     * ĐǂԂ
     * @return
     */
    virtual bool isPlaying();

    virtual bool isPause();

    virtual bool isStopping();

    virtual ~Bgm();
};

}
#endif /*GGAF_DX_BGM_H_*/
