#ifndef GGAF_DX_SPRITESETMODEL_H_
#define GGAF_DX_SPRITESETMODEL_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dx/model/Model.h"

namespace GgafDx {

/**
 * SpriteSetActorpfNX.
 * @version 1.00
 * @since 2009/07/14
 * @author Masatoshi Tsuge
 */
class SpriteSetModel : public Model {
    friend class ModelManager;

public:
    struct INDEXPARAM {
        UINT MaterialNo;
        INT BaseVertexIndex;
        UINT MinIndex;
        UINT NumVertices;
        UINT StartIndex;
        UINT PrimitiveCount;
    };

    /** _\ */
    struct VERTEX : public Model::VERTEX_3D_BASE {
        float index;      // psizeł͂ȂĂ͂ȂĒ_ԍ𖄂ߍށBVF[_[ŉZbgڂ𔻒f邽߂ɎgpB
        float tu, tv;     // _̃eNX`W
    };

    /** _obt@̊eZbg */
    LPDIRECT3DVERTEXBUFFER9 _pVertexBuffer;
    /** CfbNXobt@ */
    LPDIRECT3DINDEXBUFFER9 _pIndexBuffer;
    /** _FVF */
    static DWORD FVF;
    VERTEX* _pVertexBuffer_data;
    WORD* _pIndexBuffer_data;
    /** `̒_ṽTCY */
    UINT _size_vertices;
    /** 1_̃TCY */
    UINT _size_vertex_unit;
    INDEXPARAM* _paIndexParam;

    float _model_width_px;
    float _model_height_px;
    int _row_texture_split;
    int _col_texture_split;

public:
    /**
     * RXgN^<BR>
     * @param prm_model_name XvCg`̎ʖB".x"ǉƒ`Xt@CɂȂB
     */
    SpriteSetModel(const char* prm_model_name);


    virtual HRESULT draw(FigureActor* prm_pActor_target, int prm_draw_set_num = 1, void* prm_pPrm = nullptr) override;

    virtual void restore() override;

    virtual void onDeviceLost() override;

    void release() override;

    /**
     * fXgN^<BR>
     */
    virtual ~SpriteSetModel(); //fXgN^
};

}
#endif /*GGAF_DX_SPRITESETMODEL_H_*/
