#ifndef GGAF_DX_REGULARPOLYGONSPRITEMODEL_H_
#define GGAF_DX_REGULARPOLYGONSPRITEMODEL_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dx/model/Model.h"

namespace GgafDx {

/**
 * RegularPolygonSpriteActorpfNX.
 * @version 1.00
 * @since 2018/10/18
 * @author Masatoshi Tsuge
 */
class RegularPolygonSpriteModel : public Model {
    friend class ModelManager;

public:
    /** _\ */
    struct VERTEX : public VERTEX_3D_BASE {
        DWORD color;      // _Fiݖgpj
        float tu, tv;     // _̃eNX`W
    };

    /** _obt@ */
    LPDIRECT3DVERTEXBUFFER9 _pVertexBuffer;
    /** _FVF */
    static DWORD FVF;
    /** `̒_ṽTCY */
    UINT _size_vertices;
    /** 1_̃TCY */
    UINT _size_vertex_unit;
    VERTEX* _pVertexBuffer_data;
    float _model_width_px;
    float _model_height_px;
    int _row_texture_split;
    int _col_texture_split;
    /** FAN`揇 1:v/1ȊO:v */
    int _drawing_order;
    /** p` */
    int _angle_num;
    /** ŏ̒_ u W */
    float _u_center;
    /** ŏ̒_ v W */
    float _v_center;

public:
    /**
     * RXgN^<BR>
     * @param prm_model_name XvCg`̎ʖB".x"ǉƒ`Xt@CɂȂB
     */
    RegularPolygonSpriteModel(const char* prm_model_name);

    virtual HRESULT draw(FigureActor* prm_pActor_target, int prm_draw_set_num = 1, void* prm_pPrm = nullptr) override;

    virtual void restore() override;

    virtual void onDeviceLost() override;

    void release() override;

    /**
     * FAN`揇擾B
     * @return 1:v/1ȊO:v
     */
    int getDrawingOrder() {
        return _drawing_order;
    }

    /**
     * p`̕`悩Ԃ
     * @return p`̕`悩(=FAN̐)
     */
    int getAngleNum() {
        return _angle_num;
    }

    /**
     * fXgN^<BR>
     */
    virtual ~RegularPolygonSpriteModel(); //fXgN^
};

}
#endif /*GGAF_DX_REGULARPOLYGONSPRITEMODEL_H_*/
