#ifndef GGAF_DX_REGULARPOLYGONBOARDMODEL_H_
#define GGAF_DX_REGULARPOLYGONBOARDMODEL_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dx/model/Model.h"

namespace GgafDx {

/**
 * RegularPolygonBoardActorpfNX.
 * @version 1.00
 * @since 2009/03/10
 * @author Masatoshi Tsuge
 */
class RegularPolygonBoardModel : public Model {
    friend class ModelManager;
    friend class RegularPolygonBoardActor;

public:
    struct VERTEX {
        float x, y, z; // _W
        float tu, tv; // eNX`W
    };

    /** _FVF */
    static DWORD FVF;
    /** _obt@ */
    LPDIRECT3DVERTEXBUFFER9 _pVertexBuffer;
    /** `̒_ṽTCY */
    UINT _size_vertices;
    /** 1_̃TCY */
    UINT _size_vertex_unit;
    VERTEX* _pVertexBuffer_data;
    float _model_width_px;
    float _model_height_px;
    int _row_texture_split;
    int _col_texture_split;

    /** FAN`揇 1:v/1ȊO:v */
    int _drawing_order;
    /** p` */
    int _angle_num;
    /** ŏ̒_ x W */
    float _y_center;
    /** ŏ̒_ y W */
    float _x_center;
    /** ŏ̒_ u W */
    float _u_center;
    /** ŏ̒_ v W */
    float _v_center;
public:
    /**
     * RXgN^<BR>
     * @param prm_model_name XvCg`̎ʖB".x"ǉƒ`Xt@CɂȂB
     */
    RegularPolygonBoardModel(const char* prm_model_name);

    virtual HRESULT draw(FigureActor* prm_pActor_target, int prm_draw_set_num = 1, void* prm_pPrm = nullptr) override;

    virtual void restore() override;

    virtual void onDeviceLost() override;

    void release() override;

    /**
     * fXgN^<BR>
     * deletêRegularPolygonBoardModelManagerł<BR>
     */
    virtual ~RegularPolygonBoardModel(); //fXgN^

};

}
#endif /*GGAF_DX_REGULARPOLYGONBOARDMODEL_H_*/
