#ifndef GGAF_DX_POINTSPRITESETMODEL_H_
#define GGAF_DX_POINTSPRITESETMODEL_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dx/model/Model.h"

namespace GgafDx {

/**
 * @version 1.00
 * @since 2016/06/09
 * @author Masatoshi Tsuge
 */
class PointSpriteSetModel : public Model {
    friend class ModelManager;

public:
    struct VERTEX {
        float x, y, z;    // _W
        float psize;      // |CgTCY
        DWORD color;      // _̐F
        float ini_ptn_no, index;     //
    };

    /** _FVF */
    static DWORD FVF;
    /** _obt@iLj */
    LPDIRECT3DVERTEXBUFFER9 _pVertexBuffer;

    /** IuWFNĝPӂ̃TCY(px) */
    float _square_size_px;
    /** eNX`̂Pӂ̒(px) */
    float _texture_size_px;
    /** eNX`(PŕBQłSp^[ARłXp^[) */
    int _texture_split_rowcol;

    float _inv_texture_split_rowcol;
    /** P_̃TCY */
    UINT _size_vertex_unit;
    /** {fiPLj_TCYv */
    UINT _size_vertices;
    /** {fiPLj_ */
    UINT _nVertices;

    VERTEX* _paVtxBuffer_data;

public:
    /**
     * RXgN^<BR>
     * @param prm_model_name XvCg`̎ʖB".x"ǉƒ`Xt@CɂȂB
     */
    PointSpriteSetModel(const char* prm_model_name);

    virtual HRESULT draw(FigureActor* prm_pActor_target, int prm_draw_set_num = 1, void* prm_pPrm = nullptr) override;

    virtual void restore() override;

    virtual void onDeviceLost() override;

    void release() override;

    /**
     * fXgN^<BR>
     */
    virtual ~PointSpriteSetModel(); //fXgN^
};

}
#endif /*GGAF_DX_POINTSPRITESETMODEL_H_*/
