#ifndef GGAF_DX_MASSMODEL_H_
#define GGAF_DX_MASSMODEL_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dx/model/Model.h"

namespace GgafDx {

#define GGAFDXMASS_MAX_INSTANCE_NUM 512

/**
 * MassfNX .
 * @version 1.00
 * @since 2016/02/26
 * @author Masatoshi Tsuge
 */
class MassModel : public Model {
    friend class ModelManager;

public:
    /**
     * _CAEgiCX^Xj
     */
    class VertexInstanceDataInfo {
    public:
        /** CX^Xf[^̒_CAEgz */
        D3DVERTEXELEMENT9* paElement;
        /** CX^Xf[^̒_CAEg̗vf */
        int element_num;
        /** CX^Xf[^̂P_̃TCY */
        UINT size_vertex_unit_instancedata;
        /** foCXɗރCX^Xf[^݂擪AhX */
        void* pInstancedata;
        VertexInstanceDataInfo() {
            paElement = nullptr;
            element_num = 0;
            size_vertex_unit_instancedata = 0;
            pInstancedata = nullptr;
        }
        ~VertexInstanceDataInfo() {
            GGAF_DELETEARR_NULLABLE(paElement);
        }
    };

    /**
     * _CAEgifj
     */
    class VertexModelInfo {
    public:
        /** f_CAEg */
        D3DVERTEXELEMENT9* paElement;
        /** f_CAEg̗vf */
        int element_num;
        VertexModelInfo() {
            paElement = nullptr;
            element_num = 0;
        }
        ~VertexModelInfo() {
            GGAF_DELETEARR_NULLABLE(paElement);
        }
    };

    /** foCX̒_obt@ifj */
    LPDIRECT3DVERTEXBUFFER9 _pVertexBuffer_model;
    /** foCX̒_obt@iCX^XF[hϊsA}eAJ[j */
    LPDIRECT3DVERTEXBUFFER9 _pVertexBuffer_instancedata;
    /** foCX̃CfbNXobt@ */
    LPDIRECT3DINDEXBUFFER9 _pIndexBuffer;
    /** foCX̃VF[_[͒_tH[}bg */
    LPDIRECT3DVERTEXDECLARATION9 _pVertexDeclaration;

    /** P_̃TCYifj */
    UINT _size_vertex_unit_model;
    /** P_̃TCYiCX^Xj */
    UINT _size_vertex_unit_instancedata;
    /** Pf_TCYv */
    UINT _size_vertices_model;
    /** f_ */
    UINT _nVertices;
    /** fʂ̐ */
    UINT _nFaces;
    /** _obt@iCX^Xf[^jɗރf[^z̐擪AhX */
    void* _pInstancedata;
    /**
     * _CAEgifj擾R[obN֐ .
     * @param prm Ȃɂ̃p[^
     * @param out_info _CAEgifj񂪐ݒ肳
     */
    void (*_pFunc_getVertexModel)(void* prm, VertexModelInfo* out_info);
    /**
     * _CAEgiCX^Xf[^j擾R[obN֐ .
     * @param prm Ȃɂ̃p[^
     * @param out_info _CAEgiCX^Xj񂪐ݒ肳
     */
    void (*_pFunc_getVertexInstanceData)(void* prm, VertexInstanceDataInfo* out_info);

public:
    /**
     * RXgN^ .
     * @param prm_model_name XvCg`̎ʖB".x"ǉƒ`Xt@CɂȂB
     */
    MassModel(const char* prm_model_name);

    /**
     * _CAEgiCX^Xf[^j擾R[obN֐o^ .
     * ModelNX̃RXgN^ŌĂяoAo^ĂB
     * @param prm_pFunc_getVertexInstanceData _CAEgiCX^Xf[^j擾R[obN֐
     */
    inline void registerCallback_VertexInstanceDataInfo(void (*prm_pFunc_getVertexInstanceData)(void*, VertexInstanceDataInfo*)) {
#ifdef MY_DEBUG
        if (_pFunc_getVertexInstanceData && _pFunc_getVertexInstanceData != prm_pFunc_getVertexInstanceData) {
            throwCriticalException("ɒ_CAEg͍쐬ς݂ɂ炸Aʂ̒`֐ݒ肵悤Ƃ܂B(1)");
        }
#endif
        _pFunc_getVertexInstanceData = prm_pFunc_getVertexInstanceData;
        if (_pFunc_getVertexInstanceData && _pFunc_getVertexModel) {
            if (_pVertexBuffer_instancedata == nullptr) {
                createVertexElements();
            }
        }
    }
    /**
     * _CAEgifj擾R[obN֐o^ .
     * ActorNX̃RXgN^ŌĂяoAo^ĂB
     * @param prm_pFunc_getVertexModel  _CAEgiff[^j擾R[obN֐
     */
    inline void registerCallback_VertexModelInfo(void (*prm_pFunc_getVertexModel)(void*, VertexModelInfo*)) {
#ifdef MY_DEBUG
        if (_pFunc_getVertexModel && _pFunc_getVertexModel != prm_pFunc_getVertexModel) {
            throwCriticalException("ɒ_CAEg͍쐬ς݂ɂ炸Aʂ̒`֐ݒ肵悤Ƃ܂B(2)");
        }
#endif
        _pFunc_getVertexModel = prm_pFunc_getVertexModel;
        if (_pFunc_getVertexInstanceData && _pFunc_getVertexModel) {
            if (_pVertexBuffer_instancedata == nullptr) {
                createVertexElements();
            }
        }
    }

    /**
     * f̒_CAEgA_CX^Xf[^̍쐬 .
     */
    void createVertexElements();

    virtual void resetStreamSourceFreq();

    virtual void onDeviceLost() override;

    virtual void release() override;


    /**
     * fXgN^<BR>
     */
    virtual ~MassModel(); //fXgN^
};

}
#endif /*GGAF_DX_MESHSETMODEL_H_*/
