#ifndef GGAF_DX_MODELMANAGER_H_
#define GGAF_DX_MODELMANAGER_H_
#include "GgafDxCommonHeader.h"

#include "jp/ggaf/core/util/ResourceManager.hpp"

#include "jp/ggaf/dx/model/Model.h"
#include "jp/ggaf/dx/util/XFile/framework/Frm_Mesh.h"
#include "jp/ggaf/dx/util/XFile/ToolBox/IOModel_X.h"

#define connectToModelTextureManager(X) ((GgafDx::TextureConnection*)pGOD->_pModelManager->_pModelTextureManager->connect((X), this))

#define TYPE_D3DXMESH_MODEL               'D'
#define TYPE_DYNAD3DXMESH_MODEL           'd'
#define TYPE_D3DXANIMESH_MODEL            'A'
#define TYPE_MESH_MODEL                   'X'
#define TYPE_MESHSET_MODEL                'x'
#define TYPE_MASSMESH_MODEL               't'
#define TYPE_CUBEMAPMESH_MODEL            'G'
#define TYPE_CUBEMAPMESHSET_MODEL         'g'
#define TYPE_MORPHMESH_MODEL              'M'
#define TYPE_MASSMORPHMESH_MODEL          'm'
#define TYPE_CUBEMAPMORPHMESH_MODEL       'H'
#define TYPE_WORLDBOUND_MODEL             'W'
#define TYPE_SPRITE_MODEL                 'S'
#define TYPE_SPRITESET_MODEL              's'
#define TYPE_MASSSPRITE_MODEL             'z'
#define TYPE_BOARD_MODEL                  'B'
#define TYPE_BOARDSET_MODEL               'b'
#define TYPE_MASSBOARD_MODEL              'w'
#define TYPE_CUBE_MODEL                   'C'
#define TYPE_POINTSPRITE_MODEL            'P'
#define TYPE_MASSPOINTSPRITE_MODEL        'p'
#define TYPE_POINTSPRITESET_MODEL         'o'
#define TYPE_FRAMEDBOARD_MODEL            'E'
#define TYPE_REGULARPOLYGONSPRITE_MODEL   'R'
#define TYPE_REGULARPOLYGONBOARD_MODEL    'r'
#define TYPE_BONEANIMESH_MODEL            '1'
#define TYPE_SKINANIMESH_MODEL            '2'

namespace GgafDx {

/**
 * fCX^XǗ.
 * ɁAfXgɂێAfvꂽ<BR>
 * 邩A邢͐ςԂ𔻒f܂B<BR>
 * TODO:jƂNXŔ剻͂ȂAȂB
 * @version 1.00
 * @since 2009/02/01
 * @author Masatoshi Tsuge
 */
class ModelManager : public GgafCore::ResourceManager<Model> {

private:
    template <typename T> T* createModel(const char* prm_model_name);
    D3DXMeshModel*     createD3DXMeshModel(const char* prm_model_name, DWORD prm_dwOptions);
public:

    struct SpriteXFileFmt {
        FLOAT width;
        FLOAT height;
        char texture_file[256];
        DWORD row_texture_split;
        DWORD col_texture_split;
    };

    class PointSpriteXFileFmt {
    public:
        FLOAT SquareSize;
        char TextureFile[256];
        DWORD TextureSplitRowCol;
        DWORD VerticesNum;
        D3DVECTOR* paD3DVECTOR_Vertices;
        D3DCOLORVALUE* paD3DVECTOR_VertexColors;
        DWORD* paInt_InitUvPtnNo;
        FLOAT* paFLOAT_InitScale;
        PointSpriteXFileFmt() {
            SquareSize = 1;
            TextureSplitRowCol = 1;
            VerticesNum = 1;
            paD3DVECTOR_Vertices = nullptr;
            paD3DVECTOR_VertexColors = nullptr;
            paInt_InitUvPtnNo = nullptr;
            paFLOAT_InitScale = nullptr;
        }
        ~PointSpriteXFileFmt() {
            GGAF_DELETE_NULLABLE(paD3DVECTOR_Vertices);
            GGAF_DELETE_NULLABLE(paD3DVECTOR_VertexColors);
            GGAF_DELETE_NULLABLE(paInt_InitUvPtnNo);
            GGAF_DELETE_NULLABLE(paFLOAT_InitScale);
        }
    };

    TextureManager* _pModelTextureManager;
    /** JX^ev[gXt@Cǂݍݗp ID3DXFile ̃|C^ */
    ID3DXFile* _pID3DXFile_sprx;
    ID3DXFile* _pID3DXFile_psprx;
    static std::string getMeshFileName(std::string prm_model_name);
    static std::string getSpriteFileName(std::string prm_model_name, std::string prm_ext);
    void obtainSpriteInfo(SpriteXFileFmt* prm_pSpriteFmt_out, std::string prm_sprite_x_filename);
    void obtainPointSpriteInfo(PointSpriteXFileFmt* pPointSpriteFmt_out, std::string prm_point_sprite_x_filename);
public:
    /**
     * RXgN^
     * @param prm_manager_name }l[W(eK{)
     */
    ModelManager(const char* prm_manager_name);

    /**
     * fIDɂAfIuWFNg𐶐 .
     * <pre>
     * fIĎ`
     * wf^Cv  + "," + f`xƂȂĂB
     *  "D,MyShip"   --> D3DXMeshModel ̃fBǂݍރt@C "MyShip.x"
     *  "d,MyShip"   --> D3DXMeshModel ̃fBǂݍރt@C "MyShip.x"iD3DXMESH_DYNAMIC IvVقȂj
     *  "A,Hone"     --> D3DXAniMeshModel ̃fBǂݍރt@C "Hone.x"
     *  "X,Enemy"    --> MeshModel ̃fBǂݍރt@C "Enemy.x"
     *  "x,12,Enemy"- -> MeshSetModel ̃fBǂݍރt@C "Enemy.x"B`IuWFNg 12 Zbg
     *  "x,Enemy"    --> MeshSetModel ̃f(Zbgȗ\L)Bǂݍރt@C "Enemy.x"BZbgȗ͍ő 15 Zbg
     *  "t,12,Enemy"- -> MassMeshModel ̃fBǂݍރt@C "Enemy.x"B`IuWFNg 12 Zbg
     *  "t,Enemy"    --> MassMeshModel ̃f(Zbgȗ\L)Bǂݍރt@C "Enemy.x"BZbgȗ͍ő 15 Zbg
     *  "M,MyShip_3" --> MorphMeshModel ̃fBǂݍރt@C "MyShip_0.x", "MyShip_1.x", "MyShip_2.x", "MyShip_3.x"BlȗsB
     *                   vC}f"MyShip_0.x"A[t^[Qbg1`3"MyShip_1.x", "MyShip_2.x", "MyShip_3.x"
     *  "S,Bomb"     --> SpriteModel ̃fBǂݍރt@C "Bomb.sprx"B
     *  "s,5,Bomb"   --> SpriteSetModel ̃fBǂݍރt@C "Bomb.sprx"B`IuWFNg 5 Zbg
     *  "s,Bomb"     --> SpriteSetModel ̃f(Zbgȗ\L)Bǂݍރt@C "Bomb.sprx"BZbgȗ͍ő 18 Zbg
     *  "B,Font"     --> BoardModel ̃fBǂݍރt@C "Font.sprx"B
     *  "b,10,Font"  --> BoardSetModel ̃fBǂݍރt@C "Font.sprx"B`IuWFNg 10 Zbg
     *  "b,Font"     --> BoardSetModel ̃fBǂݍރt@C "Font.sprx"BZbgȗ͍ő 28 Zbg
     *  "P,Star"     --> PointSpriteModel ̃fBǂݍރt@C "Star.psprx"B`Zbg8
     *  "C"          --> D3DXMeshModel ̃fBǂݍރt@C "cube.x"
     *  </pre>
     * @param prm_idstr fID
     * @param prm_p Rp[^Aݖgp
     * @return fIuWFNg
     */
    Model* processCreateResource(const char* prm_idstr, void* prm_pConnector) override;

    /**
     * I[o[Ch
     */
    GgafCore::ResourceConnection<Model>* processCreateConnection(const char* prm_idstr, Model* prm_pResource) override;

    /**
     * fIuWFNgXg̊eCX^X̓eč\zB .
     * foCXXg̕AɌĂяo<BR>
     */
    void restoreAll();

    void onDeviceLostAll();

    void releaseAll();


    /** O`Model */
    static Model* _pModelLastDraw;

    /**
     * f}l[W[Ǘ郂fXg̐擪擾
     * @return 擪̃f
     */
    ModelConnection* getFirstConnection() const {
        return (ModelConnection*)_pConn_first;
    }

    virtual ~ModelManager();
};

}
#endif /*GGAF_DX_MODELMANAGER_H_*/
