#ifndef GGAF_DX_UVFLIPPER_H_
#define GGAF_DX_UVFLIPPER_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/Object.h"

namespace GgafDx {

/**
 * eNX`UVtbp[.
 * eNX`ppAj@؂ւ鎖ȒPɍs߂
 * 쐬NXB
 * @version 1.00
 * @since 2010/02/16
 * @author Masatoshi Tsuge
 */
class UvFlipper : public GgafCore::Object {
private:

    /** Ajt[pJE^ */
    frame _frame_counter_uvflip;

public:

    struct UV {
        float _u;
        float _v;
    };

    /** [r]Ajp^[eNX` */
    Texture* const _pTexture;
    /** [r/w]Ajp^[0Ԃ̍UW(0.0`1.0) */
    float _base_u;
    /** [r/w]Ajp^[0Ԃ̍VW(0.0`1.0) */
    float _base_v;
    /** [r/w]P̃Ajp^[̕(0.0`1.0) */
    float _one_ptn_tex_width;
    /** [r/w]P̃Ajp^[̍(0.0`1.0) */
    float _one_ptn_tex_height;
    /** [r]Ajp^[̃J(ɕԃp^[) */
    int _ptn_col_num;
    /** [r]Ajp^[̍s(cɕԃp^[) */
    int _ptn_row_num;

    /** [r/w]ݕ\̃Ajp^[ԍ(0`) */
    int _pattno_uvflip_now;
    /** [r/w]őAjp^[ԍ */
    int _pattno_uvflip_max;
    /** [r/w]Ajp^[ԍ̏ԍ */
    int _pattno_uvflip_top;
    /** [r/w]Ajp^[ԍ̉ԍ */
    int _pattno_uvflip_bottom;
    /** [r/w]p^[ƃp^[̊Ԋut[ */
    frame _uvflip_interval_frames;
    /** [r]Aj */
    UvFlippingMethod _uvflip_method;
    /** [r]FLIP_OSCILLATE_LOOPp݂̌̃Aj */
    bool _is_reverse_order_in_oscillate_animation_flg;

    int* _pa_ptn_offset_customized;
    int _ptn_customized;
    int _cnt_customized;
    /** [r]UVz */
    UV* _paUV;

public:
    explicit UvFlipper(Texture* prm_pTexture);

    virtual ~UvFlipper();

    void copyStatesFrom(UvFlipper* prm_pUvFlipper_other) {
        _one_ptn_tex_width      = prm_pUvFlipper_other->_one_ptn_tex_width;
        _one_ptn_tex_height     = prm_pUvFlipper_other->_one_ptn_tex_height;
        _ptn_col_num            = prm_pUvFlipper_other->_ptn_col_num;
        _pattno_uvflip_now      = prm_pUvFlipper_other->_pattno_uvflip_now;
        _pattno_uvflip_top      = prm_pUvFlipper_other->_pattno_uvflip_top;
        _pattno_uvflip_bottom   = prm_pUvFlipper_other->_pattno_uvflip_bottom;
        _pattno_uvflip_max      = prm_pUvFlipper_other->_pattno_uvflip_max;
        _uvflip_interval_frames = prm_pUvFlipper_other->_uvflip_interval_frames;
        _uvflip_method          = prm_pUvFlipper_other->_uvflip_method;
        _is_reverse_order_in_oscillate_animation_flg =
                prm_pUvFlipper_other->_is_reverse_order_in_oscillate_animation_flg;
    }

    /**
     * eNX`̃tbsOp^[̔ԍɑΉUVW̃YItZbg`B .
     * <pre>
     * ၄
     *
     *   _pUvFlipper->locatePatternNo(0, 0, 1.0/5, 1.0/4, 3, 10);
     *   _pUvFlipper->setActivePtn(5);
     *
     * s̃p^[TO}
     *
     *          3 = prm_ptn_col_num
     *     <-------->
     *     1.0/5 = 0.2 = prm_one_ptn_tex_width
     *     <-->
     * (0,0)              (1,0)
     *     +--+--+--+--+--+  ^
     *     | 0| 1| 2|  |  |  | 1.0/4 = 0.25 = prm_one_ptn_tex_height
     *     +--+--+--+--+--+  v
     *     | 3| 4|!5|  |  |
     *     +--+--+--+--+--+
     *     | 6| 7| 8|  |  |
     *     +--+--+--+--+--+
     *     | 9|  |  |  |  |
     *     +--+--+--+--+--+
     * (1,0)              (1,1)
     *  u,v
     *
     * ("!" ͌݃ANeBuȃp^[ԍ)
     *
     * O`X̓p^[ԍƌĂԂƂƂB(prm_num_of_max_patterns Ŕԍ܂)
     * p^[ԍ̕я͍ォEցAsčĂщEւ̏ŌŒB
     * AAƂȂ鍶̍WAs܂ł̃p^[͐ݒ肪\B
     * `掞A_obt@̊e_UVWɁA
     * ANeBuȃp^[̍UVWItZbgƂĉZ邱Ƃz肵Ė{\bh쐬B
     * ̐}̗ł́Ap^[ԍ5ANeBuȂ̂ł̏Ԃ
     *
     *   float u, v;
     *   _pUvFlipper->getUV(u, v);
     *
     * sƃp^[ԍ5Ԃ̍UVW
     *
     *   u = 0.4, v = 0.25
     *
     * B
     * {\bhɂp^[ݒ́A getUV() \bȟʂɂ̂݉e^B
     * getUV()gpȂ̂ł΁A{\bhɂݒ͖ӖłB
     *
     * y⑫z
     * UvFlipper ̓t[[N̕`揈ɖߍ܂ĂAN^[NX݂B
     * o _pUvFlipper ݂ĂNXłB
     *
     * ESpriteActor
     *   SpriteSetActor
     *   BoardActor
     *   BoardSetActor
     *   PointSpriteActor ɂāEEE
     *       RXgN^ňȉ̏sĂB
     *       ----------------------------------------------------------
     *       _pUvFlipper = NEW UvFlipper(this);
     *       _pUvFlipper->locatePatternNo(c, );
     *       _pUvFlipper->setActivePtn(0);
     *       _pUvFlipper->exec(NOT_ANIMATED, 1);
     *       ----------------------------------------------------------
     *       c, ̓XvCg`t@C(.sprx)擾B
     *
     * ESpriteMeshActor
     *   SpriteMeshSetActor  ɂāEEE
     *       RXgN^ňȉ̏sĂBKvɉĉʎNX locatePatternNo() Ďs\B
     *       ----------------------------------------------------------
     *       _pUvFlipper = NEW UvFlipper(this);
     *       _pUvFlipper->locatePatternNo(1, 1);
     *       _pUvFlipper->setActivePtn(0);
     *       _pUvFlipper->exec(NOT_ANIMATED, 1);
     *       ----------------------------------------------------------
     *
     * Ȇ̃AN^[NXɂāEEE
     *       NX UvFlipper ͑gݍ܂ĂȂB
     *
     * </pre>
     * @param prm_base_u UW(0.0f`1.0f)
     * @param prm_base_v VW(0.0f`1.0f)
     * @param prm_one_ptn_tex_width Pp^[̕(0.0f`1.0f)
     * @param prm_one_ptn_tex_height Pp^[̍(0.0f`1.0f)
     * @param prm_ptn_col_num p^[̃J(ɕԃp^[)
     * @param prm_num_of_max_patterns őp^[ (1`)
     */
    virtual void locatePatternNo(float prm_base_u, float prm_base_v,
                                 float prm_one_ptn_tex_width, float prm_one_ptn_tex_height,
                                 int prm_ptn_col_num, int prm_num_of_max_patterns);

    /**
     * eNX`̃tbsOp^[̔ԍɑΉUVW̃YItZbg`B .
     * locatePatternNo(float, float, float, float, int, int); <BR>
     * ̊ȈՐݒŁBő̈̒lvZĎsB <BR>
     * locatePatternNo(5, 4); Ƃꍇȉ̂悤ɂȂB <BR>
     * <pre>
     *     prm_base_u = 0
     *     prm_base_v = 0
     *
     *              5 = prm_ptn_col_num
     *     <-------------->
     *     1.0/5 = 0.2 = prm_one_ptn_tex_width
     *     <-->
     * (0,0)              (1,0)
     *     +--+--+--+--+--+  ^
     *     | 0| 1| 2| 3| 4|  | 1.0/4 = 0.25 = prm_one_ptn_tex_height
     *     +--+--+--+--+--+  v
     *     | 5| 6| 7| 8| 9|
     *     +--+--+--+--+--+
     *     |10|11|12|13|14|
     *     +--+--+--+--+--+
     *     |15|16|17|18|19|
     *     +--+--+--+--+--+
     * (1,0)              (1,1)
     *
     *  prm_pattno_uvflip_max = 20 ͈ɖAvZ
     *
     *  </pre>
     * @param prm_ptn_col_num eNX`c
     * @param prm_ptn_row_num eNX`
     */
    virtual void locatePatternNo(int prm_ptn_col_num, int prm_ptn_row_num);

    void remapPatternNoUv(int prm_ptn_num, ...);

    virtual void setBaseUv(float prm_base_u, float prm_base_v) {
        _base_u = prm_base_u;
        _base_v = prm_base_v;
    }

    /**
     * Aj[V1t[is .
     * {\bhAprocessBehavior() Ŗt[ĂяoKv܂B<BR>
     * ĂяoƂŁAexec()Őݒ肵@ɉ<BR>
     * ANeBuȃp^[ԍ(_pattno_uvflip_now)Ő؂ւ܂B<BR>
     */
    virtual void behave();

    /**
     * ݂̃Aj[Vp^[ԍ(_pattno_uvflip_now)ɑΉ鍶UVW擾B .
     * O locatePatternNo() ̌ĂяosĂKvB
     * @param out_u[out] WU
     * @param out_v[out] WV
     */
    virtual void getUV(float& out_u, float& out_v);

    /**
     * ̃Aj[Vp^[ԍɑΉ鍶UVW擾B .
     * @param prm_pattno_uvflip Aj[Vp^[ԍ
     * @param out_u[out] Aj[Vp^[ԍ̍WU
     * @param out_v[out] Aj[Vp^[ԍWV
     */
    virtual void getUV(int prm_pattno_uvflip, float& out_u, float& out_v);

    /**
     * ݂̃Aj[Vp^[ݒ肷 .
     * setFlipPtnRange(int, int) ͈̔͊OłȂݒo܂B
     * @param prm_pattno_uvflip Aj[Vp^[ԍ
     */
    void setActivePtn(int prm_pattno_uvflip);

    /**
     * ݂̃Aj[Vp^[擾 .
     * @return ݂̃Aj[Vp^[ԍ
     */
    inline int getActivePtn() {
        return _pattno_uvflip_now;
    }

    /**
     * tbvAj[Vp^[̏̉̃p^[ԍݒ .
     * ܂ŁAtbv̏łÃ݂p^[ԍ𐧌̂ł͂܂B<BR>
     * setActivePtn(int) Ŕ͈͊OŃp^[ԍȂݒo܂B
     * @param prm_top ̃Aj[Vp^[ԍ(Ⴂ̔ԍ)
     * @param prm_bottom ̃Aj[Vp^[ԍ(Â̔ԍBႢԍ̔ΌČÂԍȂ̂낤G)
     */
    void setFlipPtnRange(int prm_top, int prm_bottom);

    /**
     * p^[ԍiłႢԍj擾 .
     */
    int getTopPtnno() {
        return _pattno_uvflip_top;
    }

    /**
     * p^[ԍiłÂԍj擾 .
     */
    int getBottomPtnno() {
        return _pattno_uvflip_bottom;
    }

    /**
     * Aj[Vp^[p^[ԍiłႢԍjɐݒ肷 .
     */
    void setActivePtnToTop() {
        setActivePtn(_pattno_uvflip_top);
    }

    /**
     * Aj[Vp^[p^[ԍiłÂԍjɐݒ肷 .
     */
    void setActivePtnToBottom() {
        setActivePtn(_pattno_uvflip_bottom);
    }

    /**
     * ݂̃Aj[Vp^[ԍp^[ԍ()ԍŐݒ肷 .
     * @param prm_pattno_uvflip_from_top p^[ԍ̃p^[ԍ
     */
    void setActivePtnFromTop(int prm_pattno_uvflip_from_top) {
        setActivePtn(_pattno_uvflip_top + prm_pattno_uvflip_from_top);
    }

    /**
     * FLIP_CUSTOMIZED_LOOPAFLIP_CUSTOMIZED_NOLOOP̃p^[`BTODO:eXgB .
     * @param prm_aPtnOffset
     * @param prm_num
     */
    void customizePtnOrder(int prm_aPtnOffset[], int prm_num);

    /**
     * Aj[V@ݒ肷 .
     * <pre>
     * ၄setFlipPtnRange(0,5) ݒς݂ƂꍇB
     * FLIP_ORDER_LOOP     : 0,1,2,3,4,5,0,1,2,3,4,5,...
     * FLIP_REVERSE_LOOP   : 5,4,3,2,1,0,5,4,3,2,1,0,5,4...
     * FLIP_ORDER_NOLOOP   : 0,1,2,3,4,5,5,5,5,5,5,5...
     * FLIP_REVERSE_NOLOOP : 5,4,3,2,1,0,0,0,0,0,0...
     * FLIP_OSCILLATE_LOOP : 0,1,2,3,4,5,4,3,2,1,0,1,2,3,4,5,...
     * NOT_ANIMATED        : 3,3,3,3,3,3,3... iȂj
     *
     * 傱ƓȎg
     * yPz
     * setActivePtn(0);
     * setFlipPtnRange(3,5);
     * exec(FLIP_ORDER_LOOP); ƂꍇA
     * p^[ԍ: 0,1,2,3,4,5,3,4,5,3,4,5,...
     *
     * yQz
     * setActivePtn(5);
     * setFlipPtnRange(0,3);
     * exec(FLIP_REVERSE_LOOP); ƂꍇA
     * p^[ԍ: 5,4,3,2,1,0,3,2,1,0,3,2,1,0,...
     *
     * </pre>
     * @param prm_method tbv̕@
     * @param prm_interval tbvԊut[idefault=1)
     */
    void exec(UvFlippingMethod prm_method, int prm_interval = 1);

    /**
     * Aj[V~ .
     */
    void stop() {
        exec(NOT_ANIMATED);
    }

    /**
     * Aj[Vł邩 .
     * @return true : Aj[V / false : Aj[Vł͂Ȃ
     */
    bool isFlipping() {
        return _uvflip_method == NOT_ANIMATED ? false : true;
    }

};

}
#endif /*GGAF_DX_SPRITEMESHACTOR_H_*/
