#ifndef GGAF_DX_MESHACTOR_H_
#define GGAF_DX_MESHACTOR_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dx/actor/FigureActor.h"
#include "jp/ggaf/dx/actor/interface/IBumpMapActor.h"

namespace GgafDx {

/**
 * bVAN^[.
 * FigureActor pAƎXt@C`̃bV\@\<BR>
 * ǉAN^[łB<BR>
 * @version 1.00
 * @since 2009/02/26
 * @author Masatoshi Tsuge
 */
class MeshActor : public FigureActor, public IBumpMapActor {

public:
    /** [r]f */
    MeshModel* const _pMeshModel;
    /** [r]GtFNg */
    MeshEffect* const _pMeshEffect;

    float _far_rate;

    float _lambert_flg;//1.0:Half Lambert/ -1.0:Lambert
public:
    /**
     * RXgN^
     * @param prm_name f́ifobOOŕ\AȂłǂj
     * @param prm_model_id f`B ".x" Xt@CɂȂ邱ƁB
     * @param prm_effect_id GtFNg`B ".fx" ăGtFNgt@CɂȂ邱ƁB
     * @param prm_technique GtFNg̃eNjbN
     * @param prm_pChecker gp`FbJ[IuWFNgi`FbJ[gpnullptrł悢j
     */
    MeshActor(const char* prm_name,
              const char* prm_model_id,
              const char* prm_effect_id,
              const char* prm_technique,
              Checker* prm_pChecker );

    /**
     * ʌppRXgN^
     * @param prm_name AN^[́iCӁj
     * @param prm_model_id f`
     * @param prm_model_type f^Cv
     * @param prm_effect_id GtFNg`
     * @param prm_effect_type GtFNg^Cv
     * @param prm_technique GtFNg̃eNjbN
     * @param prm_pChecker gp`FbJ[IuWFNgi`FbJ[gpnullptrł悢j
     * @return
     */
    MeshActor(const char* prm_name,
              const char* prm_model_id,
              const char prm_model_type,
              const char* prm_effect_id,
              const char prm_effect_type,
              const char* prm_technique,
              Checker* prm_pChecker);

    virtual void processDraw() override;

    /**
     * ̍Wł\ .
     * @param prm_b
     */
    void drawAnyFar(bool prm_b) {
        if (prm_b) {
            _far_rate = 0.999f;
        } else {
            _far_rate = -1.0f;
        }
    }

    void effectBumpMapping(const char* prm_cubemap_tex, frame prm_frame = MAX_FRAME);

    virtual ~MeshActor(); //fXgN^
};

}
#endif /*GGAF_DX_MESHACTOR_H_*/
