#include "jp/ggaf/core/util/LinearQuadtree.h"

#include "jp/ggaf/core/exception/CriticalException.h"
#include "jp/ggaf/core/util/TreeSpace.hpp"
#include "jp/ggaf/core/util/Util.h"

using namespace GgafCore;

const uint32_t LinearQuadtree::_POW4[(MAX_QUADTREE_LEVEL+1)+1] =
    {1, 4, 16, 64, 256, 1024, 4096, 16384, 65536, 262144, 1048576, 4194304, 16777216, 67108864, 268435456, 1073741824};

LinearQuadtree::LinearQuadtree(uint32_t prm_level,
                                       int x1, int y1,
                                       int x2, int y2) : Object(),
_top_space_level(prm_level),
_root_x1(x1),
_root_y1(y1),
_root_x2(x2),
_root_y2(y2),
_top_level_dx( ((_root_x2-_root_x1) / ((float)(1<<_top_space_level))) + 1 ),
_top_level_dy( ((_root_y2-_root_y1) / ((float)(1<<_top_space_level))) + 1 ), //+1͋ԐI[o[Ȃ悤ɗ]T邽
_r_top_level_dx(1.0 / _top_level_dx),
_r_top_level_dy(1.0 / _top_level_dy),
_num_space((uint32_t)((_POW4[_top_space_level+1] -1) / 3))
{
    //`lؔz쐬
    _TRACE_("LinearQuadtree::LinearQuadtree("<<prm_level<<") `l؋Ԕzvf _num_space="<<_num_space);
    _paQuadrant = NEW TreeSpace<2u>[_num_space];
    for (uint32_t i = 0; i < _num_space; i++) {
        _paQuadrant[i]._my_index = i;
    }
    _pRegElemFirst = nullptr;
    _TRACE_(FUNC_NAME<<" l؃[gx(level=0)̋Ԉʒu=(" << _root_x1 << "," << _root_y1 << ")-(" << _root_x2 << "," << _root_y2 << ")");
    _TRACE_(FUNC_NAME<<" l؃[gx(level=0)̋Ԃ̍L=" << _root_x2-_root_x1 << "x" << _root_y2-_root_y1 );
    _TRACE_(FUNC_NAME<<" lؖ[x(level="<<_top_space_level<<")̋Ԃ̍L=" << _top_level_dx << "x" << _top_level_dy );
}


void LinearQuadtree::registerElem(TreeElem<2u>* const prm_pElem,
                                      int tx1, int ty1,
                                      int tx2, int ty2 ) {

    //͂ݏoꍇ͕␳
    if (tx1 <= _root_x1)  { tx1 = _root_x1; }
    if (tx2 >= _root_x2)  { tx2 = _root_x2; }
    if (ty1 <= _root_y1)  { ty1 = _root_y1; }
    if (ty2 >= _root_y2)  { ty2 = _root_y2; }
    //W̑召ԂꍇA܂Level0OALevel0Ŝ傫ꍇ͖
    if (tx1 >= tx2 || ty1 >= ty2) {
        return; //ԊO͓o^Ȃ
    }

    //tx1,ty1,tx2,ty2 AԔԍ ߂遄
    //Rect(vf)̈WԔzvfԍi`lؔz̗vfԍjZo .
    //܂ARect(vf)̏ Level ƁA̋Level̃[gʂԔԍ
    //[gʂԔԍvZĔz index ߂B


    //Rect(vf)̍XYW_Ԃ́Aő僌xԂŃ[gʂԔԍ͉Ԃ擾
    const uint32_t minnum_in_toplevel = LinearQuadtree::getMortonOrderNumFromXYindex(
                                            (uint32_t)((tx1 - _root_x1) * _r_top_level_dx),
                                            (uint32_t)((ty1 - _root_y1) * _r_top_level_dy)
                                        );

    //Rect(vf)̉EXYW_Ԃ́Aő僌xԂŃ[gʂԔԍ͉Ԃ擾
    const uint32_t maxnum_in_toplevel = LinearQuadtree::getMortonOrderNumFromXYindex(
                                            (uint32_t)((tx2 - _root_x1) * _r_top_level_dx),
                                            (uint32_t)((ty2 - _root_y1) * _r_top_level_dy)
                                        );                 //_root_x2,_root_y2 ƊԈႦĂ܂B


    //Rect(vf)́Aǂ̃x̋ԂɏiĂjĂ̂Aő̃xԂ擾
    const uint32_t differ_bit_pos = maxnum_in_toplevel ^ minnum_in_toplevel;
    uint32_t shift_num = 0;
    for (uint32_t i = 0; i < _top_space_level; i++) {
        if (((differ_bit_pos>>(i*2)) & 0x3) != 0 ) {
            shift_num = i+1;
        }
    }
    //xordiffer_bit_pos  E2rbgVtgA}XN &B11(&H3) ANDA&B000 
    //ȂȂĂꍇAshift_numɒlB
    //܂肱 differ_bit_pos  ܂2rbgɋ؂A2rbgHĂӏ̂A
    //łʒuׂĂB
    //HႤ2rbg̈ʒúÃx̃g[ʒuHĂ邱ƂӖB
    //čł2rbgHĂӏ(Vtg񐔁shift_num)菊ԃx킩
    //őԕ Level = 5 ƂāAオ804ԁAE877ԂɏĂRect(vf)ɂ
    //
    //                                         L0 L1 L2 L3 L4 L5 EEEexԂ̃[gʒu
    //     804 = 00 00 00 00 00 00 00 00 00 00 00 11 01 00 10 00
    // XOR)877 = 00 00 00 00 00 00 00 00 00 00 00 11 01 10 11 01
    // ------------------------------------------------------------
    //      37 = 00 00 00 00 00 00 00 00 00 00 00 00 00 10 01 01
    //
    //                                                        11 EEE }XN
    //                                                     11
    //                                                  11
    //                                               11
    //  AND)                                      11     <--- ܂ōsāAł3rbgHĂӏ3ڂƂ
    // -------------------------------------------------------------
    //                                            00 00 10 01 01     <--- ̃}XNʂ  00 ŁAꂪAA804Ԃ877Ԃ̃[gʒułi=ԂɏjӖ
    //                                            f  f  t  t  t      if (differ_bit_pos>>(i*2)) & 0x3 != 0 ) ̔
    //                                            5  4  3  2  1  0   shift_num(Vtg)
    //                                            o  o  x(ȍ~x)      ԂɖقĂ锻i݂j
    //
    //   LA804Ԃ877Ԃ͋ԃx1Ax2 ܂ł͓ԃxɑĂA
    //   ԃx3烂[gʒuقȂĂ܂ƂBāA
    //   uԁiMAXjxvLv2ԂłƊmłB𒲂ׂ邽߂
    //   XOR0ȊOɂȂō̃Vtg  shift_num = 3 ߂B
    //   ߂邽߂ɂ́AE3rbgVtg 0x3  AND𒲂ׂ邱ƂJԂKvƂƂB
    //   Level = 5̏ꍇA5JԂAv shift_num ̃Vtg񐔂𒲂ׂ΁AԃxI

    //XORʂ
    // 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 11 ̏ꍇȂ shift_num=1
    //
    //őԕLevel=5 ̏ꍇ͏ԃx4(=ԃx5ŐHႤ)
    //őԕLevel=8 ̏ꍇ͏ԃx7(=ԃx8ŐHႤ)

    // 00 00 00 00 00 00 00 00 00 00 00 11 10 00 10 00 ̏ꍇ shift_num=5
    //
    //őԕLevel=5 ̏ꍇ͏ԃx0 ܂胋[gԃx
    //őԕLevel=8 ̏ꍇ͏ԃx4

    //܂Ƃ߂
    //őԕLevel = 5 ̏ꍇ
    //shift_num   = 0 1 2 3 4 5
    //Level = 5 4 3 2 1 0
    //őԕLevel=8 ̏ꍇ
    //shift_num   = 0 1 2 3 4 5 6 7 8
    //Level = 8 7 6 5 4 3 2 1 0

    //Ԃ̃[g̒ʂԔԍ߂
    const uint32_t morton_order_space_num = minnum_in_toplevel>>(shift_num*2);
    //s̉ʂ̃rbg2rbgPʂŏÃ[gԍ߂
    //
    // minnum_in_toplevel>>(shift_num*2); ɂāA
    // minnum_in_toplevel=804 ł 877łǂł悭
    //       L0 L1 L2 L3 L4 L5          L0 L1 L2
    // 804 = 00 11 01 00 10 00   -->    00 11 01 = 13
    // 877 = 00 11 01 10 11 01   -->    00 11 01 = 13
    //                ^^ ^^ ^^
    //                  (shift_num*2 rbg)
    //
    // ̂悤ɕs̃rbgEփVtgĂ
    // ŁAオ804ԁAE877ԂƂRect(vf)́ALv2̏ꍇ́A[gʂԔԍ13(0Ԃ琔)łƂ킩B
    // Ƃ͂zIndexɕϊ̂

    //(Vtg)Ƃ̋Ԃ̃[gʂԔԍ`lؔz̗vfԍ߂
    const uint32_t index = morton_order_space_num + (_POW4[_top_space_level-shift_num]-1)/3;
    //(_POW4[_top_space_level-shift_num]-1)/7;
    //́A`l؋ԔźAԃx̍ŏ̋Ԃ̗vfԍ킷B
    //䐔̘a
    // r^k = r^0 + r^1 + r^2 + ... + r^n
    // r^k = (1 - r^(n+1)) / (1 - r)
    //
    //`4؂̔zvf̋ԃx܂ł̍v֐ r=4 
    //(1 - 4^(n+1)) / (1-4)  =  (1-4^(n+1)) / -3  =  (4^(n+1) - 1) / 3 ƂȂ
    //ŁAԂ̍ŏ̋ԗvf߂邽߁A n = ԃx-1 ̌vZlieԃx܂ł̗vfj́A
    //̗̎vfԃx̐擪̗vfɂȂ͂IBƂߕB
    //čŌɒl +1 ̂قlł邪Az0Ԃn܂邽߁A+1 -1 = 0 ŁAȗĂ܂B
    //̗ł shift_num = 3 ŁAőԕLevel(_top_space_level) = 5 ł̂
    // 5 - 3 = 2 ŏԃx 2
    // n = 2 - 1 = 1   (4^(1+1) - 1) / 3 = 5 
    //Ԃ̃x2e̋ԃxłAԃx1܂ł̔zvfv5Ƃ킩B
    //]̏ԃx 2̍ŏ̋Ԃ͔z 5+1 6Ԗڂn܂B
    //z6ԖڂƂ́Azvfԍ-15ɂȂB
    //+1  -1 ̂ŌǁAԃxx̍ŏ̔zvfԍ  (4^x - 1) / 3 ƂȂ


#ifdef MY_DEBUG
    if (index > _num_space-1) {

        _TRACE_(
           "LinearQuadtree::registerElem() ԃI[o[ !. \n"
           "Root=("<<_root_x1<<","<<_root_y1<<")-("<<_root_x2<<","<<_root_y2<<")\n"
           "Elem=("<<tx1<<","<<ty1<<")-("<<tx2<<","<<ty2<<")\n"
           "_top_level_dx="<<_top_level_dx<<" _top_level_dy="<<_top_level_dy<<"\n"
           "minnum_in_toplevel="<<minnum_in_toplevel<<" maxnum_in_toplevel="<<maxnum_in_toplevel<<"\n"
           "differ_bit_pos="<<differ_bit_pos<<" shift_num="<<shift_num<<" morton_order_space_num="<<morton_order_space_num<<"\n"
           "index="<<index<<" _num_space="<<_num_space
        );
        _TRACE_("Min_x_index="<<((uint32_t)((tx1 - _root_x1) / _top_level_dx)));
        _TRACE_("Min_y_index="<<((uint32_t)((ty1 - _root_y1) / _top_level_dy)));
        _TRACE_("Man_x_index="<<((uint32_t)((tx2 - _root_x1) / _top_level_dx)));
        _TRACE_("Man_y_index="<<((uint32_t)((ty2 - _root_y1) / _top_level_dy)));
    }
#endif

    //o^ElemXgɒǉĕێĂB
    //ŔA clearAllElem() ĂɃNAׁB̎dg݂͍œK̗]nB
    //ႦΓo^ς݂̋Index݂̂zŕێČclearAllElem() BAXg葬̂ł́B
    //TODO:ŌɑSvfl؂NAǂ@܂ł́A̕@ňUێEEEȂ񂩂Ȃ
    if (prm_pElem->_pSpace_current == nullptr) {
        if (_pRegElemFirst == nullptr) {
            prm_pElem->_pRegLinkNext = nullptr;
            _pRegElemFirst = prm_pElem;
        } else {
            prm_pElem->_pRegLinkNext = _pRegElemFirst;
            _pRegElemFirst = prm_pElem;
        }
    } else {
#ifdef MY_DEBUG
        throwCriticalException("o^悤Ƃvf́A̋ԂɏԂłB"
                                   "NAȂĂȂAQdo^Ă܂BԃCfbNX="<<(prm_pElem->_pSpace_current->_my_index)<<"  vfΏۃIuWFNg="<<(prm_pElem->_pObject));
#endif
    }
    //vf`l؋Ԃɓo^()
    _paQuadrant[index].registerElem(prm_pElem);
}

void LinearQuadtree::clearAllElem() {
    //o^ς݂̗vfXggpāAl؂NA
    TreeElem<2u>* pElem = _pRegElemFirst;
    while (pElem) {
//        pElem->clear();
        if(pElem->_pSpace_current == nullptr) {
            //X[
        } else {
            uint32_t index = pElem->_pSpace_current->_my_index;
            while (true) {
                if (_paQuadrant[index]._kind_bit_field == 0 ) {
                    break;
                } else {
                    _paQuadrant[index]._kind_bit_field = 0;
                    _paQuadrant[index]._pElem_first = nullptr;
                    _paQuadrant[index]._pElem_last = nullptr;
                }
                if (index == 0) {
                    break;
                }
                // eԗvfԍŌJԂ
                index = (index-1)>>2;
            }
            pElem->_pNext = nullptr;
            pElem->_pPrev = nullptr;
            pElem->_pSpace_current = nullptr;
        }
        pElem = pElem->_pRegLinkNext;
    }
    _pRegElemFirst = nullptr;
}

LinearQuadtree::~LinearQuadtree() {
    GGAF_DELETEARR(_paQuadrant);
}

void LinearQuadtree::putTree(uint32_t prm_index, int prm_lv, int prm_pos) {
    int space_no = prm_index;
    if (_paQuadrant[prm_index]._kind_bit_field != 0) {
        for (int i = 0; i < prm_lv; i++) {
            space_no -= _POW4[i];
            _TRACE_N_("  ");
        }
        UTIL::strbin(_paQuadrant[prm_index]._kind_bit_field, _aChar_strbit);
        _TRACE_N_("LV"<<prm_lv<<"-"<<space_no<<"(POS:"<<prm_pos<<")["<<prm_index<<"]="<<_aChar_strbit<<" /TreeElem->");
        _paQuadrant[prm_index].dump();
        _TRACE_N_("\n");
    }
    uint32_t lower_level_index = (prm_index<<2) + 1;
    if ( lower_level_index >= _num_space) {
        //vfI[o[A܂胊[t
        return; //eԂ֖߂
    } else {
        //
        for (int i = 0; i < (1<<2); i++) {
            putTree(lower_level_index+i, prm_lv+1, i);
        }
        return; //eԂ֖߂
    }
}

void LinearQuadtree::putTree() {
    putTree(0);
}


