#include "jp/ggaf/core/util/LinearOctree.h"

#include "jp/ggaf/core/exception/CriticalException.h"
#include "jp/ggaf/core/util/Util.h"


using namespace GgafCore;

const uint32_t LinearOctree::_POW8[(MAX_OCTREE_LEVEL+1)+1] = {1, 8, 64, 512, 4096, 32768, 262144, 2097152, 16777216, 134217728};

LinearOctree::LinearOctree(uint32_t prm_level,
                           int x1, int y1, int z1,
                           int x2, int y2, int z2) : Object(),
_top_space_level(prm_level),
_root_x1(x1),
_root_y1(y1),
_root_z1(z1),
_root_x2(x2),
_root_y2(y2),
_root_z2(z2),
_top_level_dx( ((_root_x2-_root_x1) / ((double)(1<<_top_space_level))) + 1 ),
_top_level_dy( ((_root_y2-_root_y1) / ((double)(1<<_top_space_level))) + 1 ),
_top_level_dz( ((_root_z2-_root_z1) / ((double)(1<<_top_space_level))) + 1 ), //+1͋ԐI[o[Ȃ悤ɗ]T邽
_r_top_level_dx(1.0 / _top_level_dx),
_r_top_level_dy(1.0 / _top_level_dy),
_r_top_level_dz(1.0 / _top_level_dz),
_num_space((uint32_t)((_POW8[_top_space_level+1] -1) / 7))
{
    //`ؔz쐬
    _TRACE_("LinearOctree::LinearOctree("<<prm_level<<") `؋Ԕzvf _num_space="<<_num_space);
    _paOctant = NEW TreeSpace<3u>[_num_space];
    for (uint32_t i = 0; i < _num_space; i++) {
        _paOctant[i]._my_index = i;
    }
    _pRegElemFirst = nullptr;
    _TRACE_(FUNC_NAME<<" ؃[gx(level=0)̋Ԉʒu=(" << _root_x1 << "," << _root_y1 << "," << _root_z1 << ")-(" << _root_x2 << "," << _root_y2 << "," << _root_z2 << ")");
    _TRACE_(FUNC_NAME<<" ؃[gx(level=0)̋Ԃ̍L=" << _root_x2-_root_x1 << "x" << _root_y2-_root_y1 << "x" << _root_z2-_root_z1);
    _TRACE_(FUNC_NAME<<" ؖ[x(level="<<_top_space_level<<")̋Ԃ̍L=" << _top_level_dx << "x" << _top_level_dy << "x" << _top_level_dz);

}

void LinearOctree::registerElem(TreeElem<3u>* const prm_pElem,
                                    int tx1, int ty1, int tz1,
                                    int tx2, int ty2, int tz2) {

    //͂ݏoꍇ͕␳
    if (tx1 <= _root_x1)  { tx1 = _root_x1; }
    if (tx2 >= _root_x2)  { tx2 = _root_x2; }
    if (ty1 <= _root_y1)  { ty1 = _root_y1; }
    if (ty2 >= _root_y2)  { ty2 = _root_y2; }
    if (tz1 <= _root_z1)  { tz1 = _root_z1; }
    if (tz2 >= _root_z2)  { tz2 = _root_z2; }
    //W̑召ԂꍇA܂Level0OALevel0Ŝ傫ꍇ͖
    if (tx1 >= tx2 || ty1 >= ty2 || tz1 >= tz2) {
        return; //ԊO͓o^Ȃ
    }

    //tx1,ty1,tz1,tx2,ty2,tz2 AԔԍ ߂遄
    //BOẌWԔzvfԍi`ؔz̗vfԍjZo .
    //܂ABOX̏ Level ƁA̋Level̃[gʂԔԍ
    //[gʂԔԍvZĔz index ߂B


    //BOX̍OXYZW_Ԃ́Aő僌xԂŃ[gʂԔԍ͉Ԃ擾
    const uint32_t minnum_in_toplevel = LinearOctree::getMortonOrderNumFromXYZindex(
                                            (uint32_t)((tx1 - _root_x1) * _r_top_level_dx),
                                            (uint32_t)((ty1 - _root_y1) * _r_top_level_dy),
                                            (uint32_t)((tz1 - _root_z1) * _r_top_level_dz)
                                        );

    //BOX̉E㉜XYZW_Ԃ́Aő僌xԂŃ[gʂԔԍ͉Ԃ擾
    const uint32_t maxnum_in_toplevel = LinearOctree::getMortonOrderNumFromXYZindex(
                                            (uint32_t)((tx2 - _root_x1) * _r_top_level_dx),
                                            (uint32_t)((ty2 - _root_y1) * _r_top_level_dy),
                                            (uint32_t)((tz2 - _root_z1) * _r_top_level_dz)
                                        );                 //_root_x2,_root_y2,_root_z2 ƊԈႦĂ܂B


    //BOX́Aǂ̃x̋ԂɏĂ̂擾
    const uint32_t differ_bit_pos = maxnum_in_toplevel ^ minnum_in_toplevel;
    uint32_t shift_num = 0;
    for (uint32_t i = 0; i < _top_space_level; i++) {
        if (((differ_bit_pos>>(i*3)) & 0x7) != 0 ) {
            shift_num = i+1;
        }
    }
    //xordiffer_bit_pos  E3rbgVtgA}XN &B111(&H7) ANDA&B000 
    //ȂȂĂꍇAshift_numɒlB
    //܂肱 differ_bit_pos  ܂ Rrbgɋ؂A3rbgHĂӏ̂A
    //łʒuׂĂB
    //HႤ3rbg̈ʒúÃx̃g[ʒuHĂ邱ƂӖB
    //čł3rbgHĂӏ(Vtg񐔁shift_num)菊ԃx킩
    //őԕLevel = 5ƂāAO6001ԁAE㉜6041ԂɏĂBOXɂ
    //
    //                               lv0 lv1 lv2 lv3 lv4 lv5 exԂ̃[gʒu
    //     6001 = 00 000 000 000 000 000 001 011 101 110 001
    // XOR)6041 = 00 000 000 000 000 000 001 011 110 011 001
    // -----------------------------------------------------
    //      232 = 00 000 000 000 000 000 000 000 011 101 000
    //
    //                                                   111 EEE }XN
    //                                               111
    //                                           111
    //                                       111
    //  AND)                             111     <--- ܂ōsāAł3rbgHĂӏ3ڂƂ
    // ------------------------------------------------------
    //                                   000 000 011 101 000     <--- ̃}XNʂ  000 ŁAꂪA6001Ԃ6041Ԃ̃[gʒułi=ԂɏjӖ
    //                                    f   f   t   t   f      if (differ_bit_pos>>(i*3)) & 0x7 != 0 ) ̔
    //                                    5   4   3   2   1   0  shift_num(Vtg)
    //                                    o   o   x(ȍ~x)        ԂɖقĂ锻i݂j
    //
    //   LA6001Ԃ6041Ԃ͋ԃx1Ax2 ܂ł͓ԃxɑĂA
    //   ԃx3烂[gʒuقȂĂ܂ƂBāA
    //   uԃxvLv2ԂłƊmłB𒲂ׂ邽߂
    //   XOR0ȊOɂȂō̃Vtg  shift_num = 3 ߂B
    //   ߂邽߂ɂ́AE3rbgVtg 0x7  AND𒲂ׂ邱ƂJԂKvƂƂB
    //   Level = 5̏ꍇA5JԂAv shift_num ̃Vtg񐔂𒲂ׂ΁AԃxI

    //XORʂ
    // 00 000 000 000 000 000 000 000 000 111 ̏ꍇȂ shift_num=1
    //
    //őԕLevel=5 ̏ꍇ͏ԃx4(=ԃx5ŐHႤ)
    //őԕLevel=8 ̏ꍇ͏ԃx7(=ԃx8ŐHႤ)

    // 00 000 000 000 000 111 110 000 101 111 Ȃǂ̏ꍇ shift_num=5
    //
    //őԕLevel=5 ̏ꍇ͏ԃx0 ܂胋[gԃx
    //őԕLevel=8 ̏ꍇ͏ԃx4

    //܂Ƃ߂
    //őԕLevel = 5 ̏ꍇ
    //shift_num   = 0 1 2 3 4 5
    //Level = 5 4 3 2 1 0
    //őԕLevel=8 ̏ꍇ
    //shift_num   = 0 1 2 3 4 5 6 7 8
    //Level = 8 7 6 5 4 3 2 1 0

    //Ԃ̃[g̒ʂԔԍ߂
    const uint32_t morton_order_space_num = minnum_in_toplevel>>(shift_num*3);
    //s̉ʂ̃rbg3rbgPʂŏÃ[gԍ߂
    //
    // minnum_in_toplevel>>(shift_num*3); ɂāA
    // minnum_in_toplevel=6001 ł 6041łǂł悭
    //        lv0 lv1 lv2 lv3 lv4 lv5          lv0 lv1 lv2
    // 6001 = 000 001 011 101 110 001   -->    000 001 011 = 11
    // 6041 = 000 001 011 110 011 001   -->    000 001 011 = 11
    //                    ^^^ ^^^ ^^^
    //                  (shift_num*3 rbg)
    //
    // ̂悤ɕs̃rbgEփVtgĂ
    // ŁAO6001ԁAE㉜6041ԂƂBOX́ALv2̏ꍇ́A[gʂԔԍ11(0Ԃ琔)łƂ킩B
    // Ƃ͂zIndexɕϊ̂

    //(Vtg)Ƃ̋Ԃ̃[gʂԔԍ`ؔz̗vfԍ߂
    const uint32_t index = morton_order_space_num + (_POW8[_top_space_level-shift_num]-1)/7;
    //(_POW8[_top_space_level-shift_num]-1)/7;
    //́A`؋ԔźAԃx̍ŏ̋Ԃ̗vfԍ킷B
    //䐔̘a
    // r^k = r^0 + r^1 + r^2 + ... + r^n
    // r^k = (1 - r^(n+1)) / (1 - r)
    //
    //`8؂̔zvf̋ԃx܂ł̍v֐ r=8 
    //(1 - 8^(n+1)) / (1-8)  =  (1-8^(n+1)) / -7  =  (8^(n+1) - 1) / 7 ƂȂ
    //ŁAԂ̍ŏ̋ԗvf߂邽߁A n = ԃx-1 ̌vZlieԃx܂ł̗vfj́A
    //̗̎vfԃx̐擪̗vfɂȂ͂IBƂߕB
    //čŌɒl +1 ̂قlł邪Az0Ԃn܂邽߁A+1 -1 = 0 ŁAȗĂ܂B
    //̗ł shift_num = 3 ŁAőԕLevel(_top_space_level) = 5 ł̂
    // 5 - 3 = 2 ŏԃx 2
    // n = 2 - 1 = 1   (8^(1+1) - 1) / 7 = 9 
    //Ԃ̃x2e̋ԃxłAԃx1܂ł̔zvfv9Ƃ킩B
    //]̏ԃx 2̍ŏ̋Ԃ͔z 9+1 10Ԗڂn܂B
    //z10ԖڂƂ́Azvfԍ-19ɂȂB
    //+1  -1 ̂ŌǁAԃxx̍ŏ̔zvfԍ  (8^x - 1) / 7 ƂȂ


#ifdef MY_DEBUG
    if (index > _num_space-1) {

        _TRACE_(
           "LinearOctree::registerElem() ԃI[o[ !. \n"
           "Root=("<<_root_x1<<","<<_root_y1<<","<<_root_z1<<")-("<<_root_x2<<","<<_root_y2<<","<<_root_z2<<")\n"
           "Elem=("<<tx1<<","<<ty1<<","<<tz1<<")-("<<tx2<<","<<ty2<<","<<tz2<<")\n"
           "_top_level_dx="<<_top_level_dx<<" _top_level_dy="<<_top_level_dy<<" _top_level_dz="<<_top_level_dz<<"\n"
           "minnum_in_toplevel="<<minnum_in_toplevel<<" maxnum_in_toplevel="<<maxnum_in_toplevel<<"\n"
           "differ_bit_pos="<<differ_bit_pos<<" shift_num="<<shift_num<<" morton_order_space_num="<<morton_order_space_num<<"\n"
           "index="<<index<<" _num_space="<<_num_space
        );
        _TRACE_("Min_x_index="<<((uint32_t)((tx1 - _root_x1) / _top_level_dx)));
        _TRACE_("Min_y_index="<<((uint32_t)((ty1 - _root_y1) / _top_level_dy)));
        _TRACE_("Min_z_index="<<((uint32_t)((tz1 - _root_z1) / _top_level_dz)));
        _TRACE_("Man_x_index="<<((uint32_t)((tx2 - _root_x1) / _top_level_dx)));
        _TRACE_("Man_y_index="<<((uint32_t)((ty2 - _root_y1) / _top_level_dy)));
        _TRACE_("Man_z_index="<<((uint32_t)((tz2 - _root_z1) / _top_level_dz)));
    }
#endif

    //o^ElemXgɒǉĕێĂB
    //ŔA clearAllElem() ĂɃNAׁB̎dg݂͍œK̗]nB
    //ႦΓo^ς݂̋Index݂̂zŕێČclearAllElem() BAXg葬̂ł́B
    //TODO:ŌɑSvf𔪕؂NAǂ@܂ł́A̕@ňUێEEEȂ񂩂Ȃ
    if (prm_pElem->_pSpace_current == nullptr) {
        if (_pRegElemFirst == nullptr) {
            prm_pElem->_pRegLinkNext = nullptr;
            _pRegElemFirst = prm_pElem;
        } else {
            prm_pElem->_pRegLinkNext = _pRegElemFirst;
            _pRegElemFirst = prm_pElem;
        }
    } else {
#ifdef MY_DEBUG
        throwCriticalException("o^悤Ƃvf́A̋ԂɏԂłB"
                                   "NAȂĂȂAQdo^Ă܂BԃCfbNX="<<(prm_pElem->_pSpace_current->_my_index)<<"  vfΏۃIuWFNg="<<(prm_pElem->_pObject));
#endif
    }
    //vf`؋Ԃɓo^()
    _paOctant[index].registerElem(prm_pElem);
}

void LinearOctree::clearAllElem() {
    //o^ς݂̗vfXggpāA؂NA
    TreeElem<3u>* pElem = _pRegElemFirst;
    while (pElem) {

        //pElem->clear();

        if(pElem->_pSpace_current == nullptr) {
            //X[
        } else {
            uint32_t index = pElem->_pSpace_current->_my_index;
            while (true) {
                if (_paOctant[index]._kind_bit_field == 0 ) {
                    break;
                } else {
                    _paOctant[index]._kind_bit_field = 0;
                    _paOctant[index]._pElem_first = nullptr;
                    _paOctant[index]._pElem_last = nullptr;
                }
                if (index == 0) {
                    break;
                }
                // eԗvfԍŌJԂ
                index = (index-1)>>3;
            }
            pElem->_pNext = nullptr;
            pElem->_pPrev = nullptr;
            pElem->_pSpace_current = nullptr;
        }
        pElem = pElem->_pRegLinkNext;
    }
    _pRegElemFirst = nullptr;
}

LinearOctree::~LinearOctree() {
    GGAF_DELETEARR(_paOctant);
}

void LinearOctree::putTree(uint32_t prm_index, int prm_lv, int prm_pos) {
    int space_no = prm_index;
    if (_paOctant[prm_index]._kind_bit_field != 0) {
        for (int i = 0; i < prm_lv; i++) {
            space_no -= _POW8[i];
            _TRACE_N_("  ");
        }
        UTIL::strbin(_paOctant[prm_index]._kind_bit_field, _aChar_strbit);
        _TRACE_N_("LV"<<prm_lv<<"-"<<space_no<<"(POS:"<<prm_pos<<")["<<prm_index<<"]="<<_aChar_strbit<<" /TreeElem->");
        _paOctant[prm_index].dump();
        _TRACE_N_("\n");
    }
    uint32_t lower_level_index = (prm_index<<3) + 1;
    if ( lower_level_index >= _num_space) {
        //vfI[o[A܂胊[t
        return; //eԂ֖߂
    } else {
        //
        for (int i = 0; i < (1<<3); i++) {
            putTree(lower_level_index+i, prm_lv+1, i);
        }
        return; //eԂ֖߂
    }
}

void LinearOctree::putTree() {
    putTree(0);
}


