#include "jp/ggaf/core/actor/ex/ActorDepositoryStore.h"
#include "jp/ggaf/core/util/Status.h"

using namespace GgafCore;

ActorDepositoryStore::ActorDepositoryStore(const char* prm_name) : ActorDepository(prm_name) {
    _class_name = "ActorDepositoryStore";
    setHitAble(false);
}

void ActorDepositoryStore::put(Actor* prm_pChild) {
#ifdef MY_DEBUG
    if (prm_pChild->instanceOf(Obj_ggaf_ActorDepository)) {
        //OK
    } else {
        throwCriticalException("this="<<getName()<<"  prm_pChild("<<prm_pChild->getName()<<")  f|WgłȂ΂܂");
    }
    if (_pChildFirst == nullptr) {
        if (prm_pChild->getDefaultKind() == 0U) {
            _TRACE_("x ActorDepositoryStore::appendChild  this="<<getName()<<" prm_pChild("<<prm_pChild->getName()<<")  ̎ʂ0łӐ}Ă܂H");
        }
    }
#endif
    ActorDepository::put(prm_pChild);
}

void ActorDepositoryStore::processFinal() {
    Actor* pChildDepository = getChildFirst(); //q̓f|Wĝ͂
    while (pChildDepository) {
        if (pChildDepository->_is_active_flg && !(pChildDepository->willInactivateAfter())) {
            bool is_inactive_all = false; //So[񊈓̏ꍇtrue
            Actor* pActor = pChildDepository->getChildFirst()->getPrev(); //K猩(ANeBu͌ɉ񂳂Ă邽߃uCNmj
            while (true) {
                if (pActor->_is_active_flg || pActor->willActivateAfter()) {
                    //dispatch 
                    //if (pActor->_is_active_flg == false && pActor->_will_activate_after_flg == false) {
                    //̑΋̏Ŕ肷邱ƁB
                    break;
                }
                if (pActor->_is_first_flg) {
                    is_inactive_all = true;
                    break;
                }
                pActor = pActor->getPrev();
            }

            if (is_inactive_all) {
                pChildDepository->inactivate();
            }
        }
        if (pChildDepository->_is_last_flg) {
            break;
        }
        pChildDepository = pChildDepository->getNext();
    }
}

