#ifndef GGAF_CORE_XPM_H_
#define GGAF_CORE_XPM_H_
#include "jp/ggaf/core/Object.h"

#include <map>
#include <vector>

namespace GgafCore {

/**
 * ȈXPM(Pixmap)xNX .
 * @version 1.00
 * @since 2013/07/16
 * @author Masatoshi Tsuge
 */
class Xpm : public Object {
public:
    /** [r]sNZ */
    int _width;
    /** [r]sNZ */
    int _height;
    /** [r]F */
    int _colors;
    /** [r]Fł͖sNZ̐ */
    int _num_color_pixels;
    /** [r]sNZ̕ */
    char _c_px_non;

    int _char_on_pixel;

    /** [r]sNZF̔̕z */
    std::vector<char> _vecColorChar;
    /** [r]sNZF̕ɑΉAۂRGBl */
    std::map<char, Rgb*> _mapCharRgb;
    char** _pixels;
public:
    /**
     * RXgN^ .
     * @param prm_xpm Pixmapւ̃|C^BlێȂ̂ŃXR[vɒӁB(static Ȃǂz)
     */
    Xpm(const char** prm_xpm);

    /**
     * Pixmap̗񐔂擾 .
     * @return 
     */
    inline int getWidth() {
        return _width;
    }

    /**
     * Pixmap̍s擾 .
     * @return s
     */
    inline int getHeight() {
        return _height;
    }

    /**
     * Pixmap̂ĂF̐擾 .
     * @return F̐
     */
    inline int getColorNum() {
        return _colors;
    }

    /**
     * Pixmap̃sNZ̐(F)擾 .
     * @return
     */
    inline int getPixelNum() {
        return _num_color_pixels;
    }

    /**
     * Pixmap̎w̃sNZ̐F擾 .
     * @param prm_row_idx sڂw(0`)
     * @param prm_col_idx ڂw(0`)
     * @return F
     */
    inline Rgb* getColor(int prm_row_idx, int prm_col_idx) {
        Rgb* r = nullptr;
        if (prm_row_idx < _height && prm_col_idx < _width) {
            //͈͓
            r = _mapCharRgb[_pixels[prm_row_idx][prm_col_idx]];
        } else {
            //͈͊O
            r = _mapCharRgb['\0'];
        }
        return r;
    }

    /**
     * Pixmap̎w̃sNZ̐FFۂ擾 .
     * @param prm_row_idx sڂw(0`)
     * @param prm_col_idx ڂw(0`)
     * @return true:F / false:FȊO
     */
    inline bool isNonColor(int prm_row_idx, int prm_col_idx) {
        if (prm_row_idx < _height && prm_col_idx < _width) {
            //͈͓
            if (_pixels[prm_row_idx][prm_col_idx] == _c_px_non) {
                return true;
            } else {
                return false;
            }
        } else {
            //͈͊O
            return true;
        }
    }

    virtual ~Xpm();
};
}
#endif /*GGAF_CORE_XPM_H_*/
