#ifndef GGAF_CORE_VALUEENVELOPER_H_
#define GGAF_CORE_VALUEENVELOPER_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/Object.h"

#include "jp/ggaf/core/util/Util.h"

namespace GgafCore {

/**
 * l̑Jڃwp[ .
 * IɔŐʉB
 * @tparam VAL_TYPE Jڒl̃f[^^
 * @tparam N CfbNX()̐
 * @version 1.00
 * @since 2014/02/19
 * @author Masatoshi Tsuge
 */
template<class VAL_TYPE, int N>
class ValueEnveloper : public Object {

public:
    enum TransitionMethod {
        NO_TRANSITION,
        TARGET_LINEAR_UNTIL,
        TARGET_LINEAR_STEP,
        BEAT_LINEAR,
        BEAT_TRIANGLEWAVE,
        R_BEAT_TRIANGLEWAVE,
        BEAT_TRIGONOMETRIC,
        TARGET_ACCELERATION_UNTIL,
        TARGET_ACCELERATION_UNTIL_VELO,
    };

    struct Parameter {
        /** [r/w]ڕW̑J */
        VAL_TYPE _target;
        /** [r/w]Jڏ */
        VAL_TYPE _top;
        /** [r/w]Jډ */
        VAL_TYPE _bottom;
        /** [r/w]t[̑Jڂ̑ */
        VAL_TYPE _velo;
        /** [r/w]t[̑Jڂ̑̑ */
        VAL_TYPE _acce;
        /** [r]lJڕ@ */
        TransitionMethod _method;
        /** [r]r[gA`g̃A^bNĨt[ */
        frame _beat_frame_of_attack_finish;
        /** [r]r[gA`g̈ێĨt[ */
        frame _beat_frame_of_sustain_finish;
        /** [r]r[gA`ǧ(]C)Ĩt[ */
        frame _beat_frame_of_release_finish;
        /** [r]r[gA`g̔g`ł̂P̃t[ */
        frame _beat_cycle_frames;
        /** [r]r[gAlJڂɔ₷t[ */
        frame _beat_target_frames;
        /** [r]r[gA[vJE^[ */
        frame _beat_frame_count_in_roop;
        /** [r]r[gAJE^[ */
        frame _beat_frame_count;
    };
    Parameter _parameter[N];

public:
    /**
     * l擾ivj .
     * @param idx CfbNX
     * @return l
     */
    virtual VAL_TYPE getValue(int idx) = 0;

    /**
     * lݒ肷ivj .
     * @param idx CfbNX
     * @param value l
     */
    virtual void setValue(int idx, VAL_TYPE value) = 0;

public:
    /**
     * RXgN^<BR>
     */
    ValueEnveloper() : Object() {
        Parameter* p = _parameter;
        for (int i = 0; i < N; i++) {
            p->_velo = 0;
            p->_acce = 0;
            p->_target = 0;
            p->_top = 0;
            p->_bottom = 0;
            p->_beat_frame_of_attack_finish = 0;
            p->_beat_frame_of_sustain_finish = 0;
            p->_beat_frame_of_release_finish = 0;
            p->_beat_cycle_frames = 0;
            p->_beat_target_frames = 0;
            p->_beat_frame_count_in_roop = 0;
            p->_beat_frame_count = 0;
            p->_method = NO_TRANSITION;
            ++p;
        }
    }

    /**
     * lJڂ̏ݒiSΏۃCfbNXwj .
     * ̑召͋Cɂn(Ŏ)
     * @param prm1 Jڒl1
     * @param prm2 Jڒl2
     */
    virtual void setRange(VAL_TYPE prm1, VAL_TYPE prm2) {
        for (int i = 0; i < N; i++) {
            setRange(i, prm1, prm2);
        }
    }

    /**
     * lJڂ̏lݒiΏۃCfbNXPʂŎwj .
     * @param prm_idx ΏۃCfbNX
     * @param prm1 Jڒl1
     * @param prm2 Jڒl2
     */
    virtual void setRange(int prm_idx, VAL_TYPE prm1, VAL_TYPE prm2) {
        if (prm1 < prm2) {
            setBottom(prm_idx, prm1);
            setTop(prm_idx, prm2);
        } else {
            setBottom(prm_idx, prm2);
            setTop(prm_idx, prm1);
        }
    }

    /**
     * lݒiΏۃCfbNXPʂŎwj .
     * @param prm_idx ΏۃCfbNX
     * @param prm_top l
     */
    virtual void setTop(int prm_idx, VAL_TYPE prm_top) {
        _parameter[prm_idx]._top = prm_top;
    }

    /**
     * lݒiΏۃCfbNXPʂŎwj .
     * @param prm_bottom l
     */
    virtual void setBottom(int prm_idx, VAL_TYPE prm_bottom) {
        _parameter[prm_idx]._bottom = prm_bottom;
    }

    /**
     * lݒiSΏۃCfbNXwj .
     * @param prm_top l
     */
    virtual void setTop(VAL_TYPE prm_top) {
        for (int i = 0; i < N; i++) {
            setTop(i, prm_top);
        }
    }

    /**
     * lݒiSΏۃCfbNXwj .
     * @param prm_bottom l
     */
    virtual void setBottom(VAL_TYPE prm_bottom) {
        for (int i = 0; i < N; i++) {
            setBottom(i, prm_bottom);
        }
    }

    /**
     * lJڂ̏l擾 .
     * @param prm_idx ΏۃCfbNX
     * @return l
     */
    virtual VAL_TYPE getTop(int prm_idx) const {
        return _parameter[prm_idx]._top;
    }

    /**
     * lJڂ̉l擾 .
     * @param prm_idx ΏۃCfbNX
     * @return
     */
    virtual VAL_TYPE getBottom(int prm_idx) const {
        return _parameter[prm_idx]._bottom;
    }

    /**
     * lJڂ̏l擾 .
     * ΏۃCfbNXQȏ̏ꍇASl̒ōŏԂB
     * @return l
     */
    virtual VAL_TYPE getTop() const {
        //_top̍ŏlԂ
        if (N == 1) {
            return _parameter[0]._top;
        } else {
            VAL_TYPE minv = _parameter[0]._top;
            const Parameter* p = &_parameter[1];
            for (int i = 1; i < N; i++) {
                if (minv > p->_top) {
                    minv = p->_top;
                }
                ++p;
            }
            return minv;
        }
    }

    /**
     * lJڂ̉l擾 .
     * ΏۃCfbNXQȏ̏ꍇASl̒ōőԂB
     * @return l
     */
    virtual VAL_TYPE getBottom() const {
        //_bottom̍őlԂ
        if (N == 1) {
            return _parameter[0]._bottom;
        } else {
            VAL_TYPE maxv = _parameter[0]._bottom;
            const Parameter* p = &_parameter[1];
            for (int i = 1; i < N; i++) {
                if (maxv > p->_bottom) {
                    maxv = p->_bottom;
                }
                ++p;
            }
            return maxv;
        }
    }

    /**
     * lJڂ~BiSΏۃCfbNXwj .
     */
    virtual void stop() {
        for (int i = 0; i < N; i++) {
            stop(i);
        }
    }

    /**
     * lJڂ~B iΏۃCfbNXPʂŎwj.
     * @param prm_idx CfbNX
     */
    virtual void stop(int prm_idx) {
        Parameter* p = &_parameter[prm_idx];
        p->_velo = 0;
        p->_acce = 0;
        p->_method = NO_TRANSITION;
    }

    /**
     * ГlJځiSCfbNXΏہEt[wj .
     * ڕW̑Jڂֈ葬xŒlJڂ
     * @param prm_target_T JږڕWl
     * @param prm_spend_frame ₷t[
     */
    virtual void transitionLinearUntil(VAL_TYPE prm_target, frame prm_spend_frame) {
        for (int i = 0; i < N; i++) {
            transitionLinearUntil(i, prm_target, prm_spend_frame);
        }
    }

    /**
     * ГlJځiΏۃCfbNXPʁEt[wj .
     * ڕW̑Jڂֈ葬xŒlJڂB
     * @param prm_idx ΏۃCfbNX
     * @param prm_target_T JږڕWl
     * @param prm_spend_frame ₷t[
     */
    virtual void transitionLinearUntil(int prm_idx, VAL_TYPE prm_target, frame prm_spend_frame) {
        Parameter* p = &_parameter[prm_idx];
        p->_beat_frame_count = 0;
        p->_beat_target_frames = prm_spend_frame;
        p->_target = prm_target;
        p->_method = TARGET_LINEAR_UNTIL;
        //ŏ̃A^bN܂ł̑x
        const VAL_TYPE val = getValue(prm_idx);
        if (p->_beat_target_frames > 0 ) {
            p->_velo = (VAL_TYPE)( ((double)(p->_target - val)) / ((double)(p->_beat_target_frames)) );
        } else if (p->_beat_target_frames == 0 ) {
            p->_velo = p->_target - val;
        }
    }

    /**
     * Jڂ֕ГlJځiSCfbNXΏہEt[wj .
     * @param prm_spend_frame ₷t[
     */
    virtual void transitionLinearToTop(frame prm_spend_frame) {
        transitionLinearUntil(getTop(), prm_spend_frame);
    }

    /**
     * Jڂ֕ГlJځiSCfbNXΏہEt[wj .
     * @param prm_spend_frame ₷t[
     */
    virtual void transitionLinearToBottom(frame prm_spend_frame) {
        transitionLinearUntil(getBottom(), prm_spend_frame);
    }

    /**
     * ГlJځiSCfbNXΏہEJڑxwj .
     * ڕW̑Jڂֈ葬xŒlJڂ
     * @param prm_target JږڕWl
     * @param prm_velo t[ZJڍ(>0.0)B̑Jڂw肷鎖BZZ͎fB
     */
    virtual void transitionLinearStep(VAL_TYPE prm_target, VAL_TYPE prm_velo) {
        for (int i = 0; i < N; i++) {
            transitionLinearStep(i, prm_target, prm_velo);
        }
    }

    /**
     * ГlJځiΏۃCfbNXPʁEJڑxwj .
     * ڕW̑Jڂֈ葬xŒlJڂiJڍwj .
     * @param prm_idx ΏۃCfbNX
     * @param prm_target JږڕWl
     * @param prm_velo t[ZJڍ(>0.0)B̑Jڂw肷鎖BZZ͎fB
     */
    virtual void transitionLinearStep(int prm_idx, VAL_TYPE prm_target, VAL_TYPE prm_velo) {
        Parameter* p = &_parameter[prm_idx];
        p->_method = TARGET_LINEAR_STEP;
        p->_velo = prm_velo;
        p->_target = prm_target;
        p->_beat_frame_count = 0;
        p->_beat_target_frames = MAX_FRAME;
    }

    /**
     * ГlJځiSCfbNXΏہEJږڕWlwj .
     * ڕW̑Jڂ։wŒlJڂB
     * Jډx0Ɏw肷 transitionLinearStep ƂقړӖɂȂB
     * transitionLinearStep ̑R͐Cɂ邱ƖA{\bh͐̎͂ȂiłȂjB
     * Jڑx̏ꍇAJږڕWl𒴂ƒlJڏIB
     * Jڑx̏ꍇAJږڕWlƒlJڏIB
     * JږڕWlɓBOɁAx̐t]ƁAԂiɓBłȂ̂ŒӁB
     * @param prm_target_T JږڕWl
     * @param prm_init_velo Jڑx
     * @param prm_acce_T Jډx
     */
    virtual void transitionAcceUntil(VAL_TYPE prm_target, VAL_TYPE prm_init_velo, VAL_TYPE prm_acce) {
        for (int i = 0; i < N; i++) {
            transitionAcceUntil(i, prm_target, prm_init_velo, prm_acce);
        }
    }

    /**
     * ГlJځiΏۃCfbNXPʁEJږڕWlwj .
     * ڕW̑Jڂ։wŒlJڂB
     * Jډx0Ɏw肷 transitionLinearStep ƂقړӖɂȂB
     * transitionLinearStep ̑R͐Cɂ邱ƖA{\bh͐̎͂ȂiłȂjB
     * Jڑx̏ꍇAJږڕWl𒴂ƒlJڏIB
     * Jڑx̏ꍇAJږڕWlƒlJڏIB
     * JږڕWlɓBOɁAx̐t]ƁAԂiɓBłȂ̂ŒӁB
     * @param prm_idx ΏۃCfbNX
     * @param prm_target JږڕWl
     * @param prm_init_velo Jڑx
     * @param prm_acce Jډx
     */
    virtual void transitionAcceUntil(int prm_idx, VAL_TYPE prm_target, VAL_TYPE prm_init_velo, VAL_TYPE prm_acce) {
        Parameter* p = &_parameter[prm_idx];
        p->_method = TARGET_ACCELERATION_UNTIL;
        p->_target = prm_target;
        p->_velo = prm_init_velo;
        p->_acce = prm_acce;
        p->_beat_frame_count = 0;
        p->_beat_target_frames = MAX_FRAME;
    }

    /**
     * ГlJځiΏۃCfbNXPʁEڕWxlwj .
     * ڕWxɂȂ܂ł։wŒlJڂ܂B
     * ڕWxɓBƒ~܂B
     * x̏ꍇAx^[Qbgx傫ȂΏI
     * x̏ꍇAx^[Qbgx菬ȂΏI
     * Jډx0Ɏw肷 iɏIȂ̂ŒӁB
     * @param prm_idx  ΏۃCfbNX
     * @param prm_target_velo  ڕWx
     * @param prm_init_velo  x
     * @param prm_acce   x
     */
    virtual void transitionAcceUntilVelo(int prm_idx, VAL_TYPE prm_target_velo, VAL_TYPE prm_init_velo, VAL_TYPE prm_acce) {
        Parameter* p = &_parameter[prm_idx];
        p->_method = TARGET_ACCELERATION_UNTIL_VELO;
        p->_target = prm_target_velo;
        p->_velo = prm_init_velo;
        p->_acce = prm_acce;
        p->_beat_frame_count = 0;
        p->_beat_target_frames = MAX_FRAME;
    }

    /**
     * ГlJځiSCfbNXΏہEڕWxlwj .
     * ڕWxɂȂ܂ł։wŒlJڂ܂B
     * ڕWxɓBƒ~܂B
     * x̏ꍇAx^[Qbgx傫ȂΏI
     * x̏ꍇAx^[Qbgx菬ȂΏI
     * Jډx0Ɏw肷 iɏIȂ̂ŒӁB
     * @param prm_target_velo  ڕWx
     * @param prm_init_velo  x
     * @param prm_acce   x
     */
    virtual void transitionAcceUntilVelo(VAL_TYPE prm_target_velo, VAL_TYPE prm_init_velo, VAL_TYPE prm_acce) {
        for (int i = 0; i < N; i++) {
            transitionAcceUntilVelo(i, prm_target_velo, prm_init_velo, prm_acce);
        }
    }

    /**
     * lJځiSCfbNXΏہEt[wj .
     * Jڂֈ葬xŒlJڂA葬xŉJڂ֖߂B[vw肷BiP[ṽt[wj .
     * @param prm_cycle_frames P[v(ωČɖ߂܂)ɔ₷t[
     * @param prm_beat_num [v(1.2ȂǏŎw\A-1 łقږ[v)
     * @param prm_is_to_top true:߂TOPɑJڂ^false:߂BOTTOMɑJ
     */
    void transitionLinearLoop(frame prm_cycle_frames, double prm_beat_num, bool prm_is_to_top) {
        for (int i = 0; i < N; i++) {
            transitionLinearLoop(i, prm_cycle_frames, prm_beat_num, prm_is_to_top);
        }
    }

    /**
     * lJځiΏۃCfbNXPʁEt[wj
     * Jڂֈ葬xŒlJڂA葬xŉJڂ֖߂B
     * [vw肷BiP[ṽt[wj .
     * @param prm_idx ΏۃCfbNX
     * @param prm_cycle_frames P[v(ωČɖ߂܂)ɔ₷t[
     * @param prm_beat_num [v(1.2ȂǏŎw\A-1 łقږ[v)
     * @param prm_is_to_top true:߂TOPɑJڂ^false:߂BOTTOMɑJ
     */
    virtual void transitionLinearLoop(int prm_idx, frame prm_cycle_frames, double prm_beat_num, bool prm_is_to_top) {
        Parameter* p = &_parameter[prm_idx];
        const VAL_TYPE val = getValue(prm_idx);
        p->_method = BEAT_LINEAR;
        p->_beat_frame_count = 0;
        p->_beat_frame_count_in_roop = 0;
        p->_beat_cycle_frames = prm_cycle_frames;
        if (prm_beat_num < 0) {
            p->_beat_target_frames = MAX_FRAME;
        } else {
            p->_beat_target_frames = (frame)(prm_cycle_frames * prm_beat_num);
        }
        if (prm_is_to_top) {
            p->_velo = (VAL_TYPE)(1.0*(p->_top - val) / ((int)prm_cycle_frames * 0.5));
            if (ZEROd_EQ(p->_velo)) {
                p->_velo = 1; //ł΂悢
            }
        } else {
            p->_velo = (VAL_TYPE)(1.0*(p->_bottom - val) / ((int)prm_cycle_frames * 0.5));
            if (ZEROd_EQ(p->_velo)) {
                p->_velo = -1; //ł΂悢
            }
        }
    }

    /**
     * `g̔g`ŒlJڂBiSΏۃCfbNXwj.
     * <PRE>
     * D  _ _ _   QQQ   _ _ _ _ _ _ _ _ _    QQQ   _ _ _ _ _ _ _ _ _
     *            /:    :_                     /      _
     *           / :    :  _                  /         _
     *          /  :    :    _               /            _
     *         /   :    :      _            /               _
     *        /    :    :        _         /                  _
     * EQQ/  _ _:_ _ : _ _ _ _  _QQQ/  _ _ _ _ _ _ _ _ _  _QQQ/
     *       @
     *       ABC
     * </PRE>
     * KvȐݒl<BR>
     * @ P[v(ωČɖ߂܂)ɔ₷t[<BR>
     * A A^bN܂ł̃t[<BR>
     * B ێt[<BR>
     * C (]C)t[<BR>
     * D Jڏ(_top[ΏۃCfbNX] z񂪕ێ)<BR>
     * E Jډ(_bottom[ΏۃCfbNX] z񂪕ێ)<BR>
     * ̓ @`CŐݒADEsetRange()̐ݒlgpB<BR>
     * @param prm_cycle_frames }Ň@̃t[
     * @param prm_attack_frames }ŇÃt[
     * @param prm_sustain_frames }ŇB̃t[
     * @param prm_release_frames }ŇC̃t[
     * @param prm_beat_num [v(-1Ŗ)
     */
    virtual void beat(frame prm_cycle_frames,
                      frame prm_attack_frames,
                      frame prm_sustain_frames,
                      frame prm_release_frames,
                      double prm_beat_num) {
        for (int i = 0; i < N; i++) {
            beat(i, prm_cycle_frames, prm_attack_frames, prm_sustain_frames, prm_release_frames, prm_beat_num);
        }
    }

    /**
     * `g̔g`ŒlJڂBiΏۃCfbNXʎwj.
     * <PRE>
     * D  _ _ _   QQQ   _ _ _ _ _ _ _ _ _    QQQ   _ _ _ _ _ _ _ _ _
     *            /:    :_                     /      _
     *           / :    :  _                  /         _
     *          /  :    :    _               /            _
     *         /   :    :      _            /               _
     *        /    :    :        _         /                  _
     * EQQ/  _ _:_ _ : _ _ _ _  _QQQ/  _ _ _ _ _ _ _ _ _  _QQQ/
     *       @
     *       ABC
     * </PRE>
     * KvȐݒl<BR>
     * @ P(ωČɖ߂܂)ɔ₷t[<BR>
     * A A^bN܂ł̃t[<BR>
     * B ێt[<BR>
     * C (]C)t[<BR>
     * D Jڏ(_top[ΏۃCfbNX] z񂪕ێ)<BR>
     * E Jډ(_bottom[ΏۃCfbNX] z񂪕ێ)<BR>
     * ̓ @`CŐݒADEsetRange()̐ݒlgpB<BR>
     * @param prm_idx ΏۃCfbNX
     * @param prm_cycle_frames }Ň@̃t[
     * @param prm_attack_frames }ŇÃt[
     * @param prm_sustain_frames }ŇB̃t[
     * @param prm_release_frames }ŇC̃t[
     * @param prm_beat_num [v(-1Ŗ)
     */
    virtual void beat(int prm_idx,
                      frame prm_cycle_frames,
                      frame prm_attack_frames,
                      frame prm_sustain_frames,
                      frame prm_release_frames,
                      double prm_beat_num) {
        Parameter* p = &_parameter[prm_idx];
        p->_method = BEAT_TRIANGLEWAVE;
        p->_beat_frame_count = 0;
        p->_beat_frame_count_in_roop = 0;
        p->_beat_frame_of_attack_finish = prm_attack_frames;
        p->_beat_frame_of_sustain_finish = p->_beat_frame_of_attack_finish + prm_sustain_frames;
        p->_beat_frame_of_release_finish = p->_beat_frame_of_sustain_finish + prm_release_frames;
        p->_beat_cycle_frames = prm_cycle_frames; //
        if (prm_beat_num < 0) {
            p->_beat_target_frames = MAX_FRAME;
        } else {
            p->_beat_target_frames = (frame)(p->_beat_cycle_frames * prm_beat_num);
        }
        //ŏ̃A^bN܂ł̑x
        const VAL_TYPE val = getValue(prm_idx);
        if (p->_beat_frame_of_attack_finish > 0 ) {
            p->_velo = (VAL_TYPE)( ((double)(p->_top - val)) / ((double)(p->_beat_frame_of_attack_finish)) );
        } else if (p->_beat_frame_of_attack_finish == 0 ) {
            p->_velo = p->_top - val;
        }
    }



    /**
     * `g̔g`ŒlJڂBiSΏۃCfbNXwj.
     * <PRE>
     * D  QQ _ _ _ _ _ _ _ _ _ _ _  QQQ _ _ _ _ _ _ _ _ _ _ _  QQQ
     *        :_                     /:    :_                     /:
     *        :  _                  / :    :  _                  / :
     *        :    _               /  :    :    _               /  :
     *        :      _            /   :    :      _            /   :
     *        :        _         /    :    :        _         /    :
     * E  _ _:_ _ _ _ _ _QQQ/  _ _:_ _ :_ _ _ _ _ _QQQ/  _ _:_ _
     *         @
     *         ABA
     * </PRE>
     * KvȐݒl<BR>
     * @ P(ωČɖ߂܂)ɔ₷t[<BR>
     * A A^bN()܂ł̃t[<BR>
     * B ێt[<BR>
     * C At[<BR>
     * D Jڏ(_top[ΏۃCfbNX] z񂪕ێ)<BR>
     * E Jډ(_bottom[ΏۃCfbNX] z񂪕ێ)<BR>
     * ̓ @`CŐݒADEsetRange()̐ݒlgpB<BR>
     * @param prm_cycle_frames }Ň@̃t[
     * @param prm_attack_frames }ŇÃt[
     * @param prm_sustain_frames }ŇB̃t[
     * @param prm_release_frames }ŇC̃t[
     * @param prm_beat_num [v(-1Ŗ)
     */
    virtual void rbeat(frame prm_cycle_frames,
                       frame prm_attack_frames,
                       frame prm_sustain_frames,
                       frame prm_release_frames,
                       double prm_beat_num) {
        for (int i = 0; i < N; i++) {
            rbeat(i, prm_cycle_frames, prm_attack_frames, prm_sustain_frames, prm_release_frames, prm_beat_num);
        }
    }


    /**
     * `g̔g`ŒlJڂBiΏۃCfbNXʎwj.
     * <PRE>
     * D  QQ _ _ _ _ _ _ _ _ _ _ _  QQQ _ _ _ _ _ _ _ _ _ _ _  QQQ
     *        :_                     /:    :_                     /:
     *        :  _                  / :    :  _                  / :
     *        :    _               /  :    :    _               /  :
     *        :      _            /   :    :      _            /   :
     *        :        _         /    :    :        _         /    :
     * E  _ _:_ _ _ _ _ _QQQ/  _ _:_ _ :_ _ _ _ _ _QQQ/  _ _:_ _
     *         @
     *         ABA
     * </PRE>
     * KvȐݒl<BR>
     * @ P(ωČɖ߂܂)ɔ₷t[<BR>
     * A A^bN()܂ł̃t[<BR>
     * B ێt[<BR>
     * C At[<BR>
     * D Jڏ(_top[ΏۃCfbNX] z񂪕ێ)<BR>
     * E Jډ(_bottom[ΏۃCfbNX] z񂪕ێ)<BR>
     * ̓ @`CŐݒADEsetRange()̐ݒlgpB<BR>
     * @param prm_idx ΏۃCfbNX
     * @param prm_cycle_frames }Ň@̃t[
     * @param prm_attack_frames }ŇÃt[
     * @param prm_sustain_frames }ŇB̃t[
     * @param prm_release_frames }ŇC̃t[
     * @param prm_beat_num [v(-1Ŗ)
     */
    virtual void rbeat(int prm_idx,
                       frame prm_cycle_frames,
                       frame prm_attack_frames,
                       frame prm_sustain_frames,
                       frame prm_release_frames,
                       double prm_beat_num) {
        Parameter* p = &_parameter[prm_idx];
        p->_method = R_BEAT_TRIANGLEWAVE;
        p->_beat_frame_count = 0;
        p->_beat_frame_count_in_roop = 0;
        p->_beat_frame_of_attack_finish = prm_attack_frames;
        p->_beat_frame_of_sustain_finish = p->_beat_frame_of_attack_finish + prm_sustain_frames;
        p->_beat_frame_of_release_finish = p->_beat_frame_of_sustain_finish + prm_release_frames;
        p->_beat_cycle_frames = prm_cycle_frames; //
        if (prm_beat_num < 0) {
            p->_beat_target_frames = MAX_FRAME;
        } else {
            p->_beat_target_frames = (frame)(p->_beat_cycle_frames * prm_beat_num);
        }
        //ŏ̃A^bN܂ł̑x
        const VAL_TYPE val = getValue(prm_idx);
        if (p->_beat_frame_of_attack_finish > 0 ) {
            p->_velo = (VAL_TYPE)( ((double)(p->_bottom - val)) / ((double)(p->_beat_frame_of_attack_finish)) );
        } else if (p->_beat_frame_of_attack_finish == 0 ) {
            p->_velo = p->_bottom - val;
        }
    }

    /**
     * lJڒǂׂ .
     * @param prm_idx ΏۃCfbNX
     * @return true/false
     */
    virtual bool isTransitioning(int prm_idx) const {
        if (_parameter[prm_idx]._method == NO_TRANSITION) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * lJڒǂׂ .
     * @return true/false
     */
    virtual bool isTransitioning() const {
        for (int i = 0; i < N; i++) {
            if (isTransitioning(i)) {
                return true;
            }
        }
        return false;
    }

    virtual void reset() {
        Parameter* p = _parameter;
        for (int i = 0; i < N; i++) {
            p->_velo = 0;
            p->_acce = 0;
            p->_target = 0;
            p->_top = 0;
            p->_bottom = 1;
            p->_beat_frame_of_attack_finish = 0;
            p->_beat_frame_of_sustain_finish = 0;
            p->_beat_frame_of_release_finish = 0;
            p->_beat_cycle_frames = 0;
            p->_beat_target_frames = 0;
            p->_beat_frame_count_in_roop = 0;
            p->_beat_frame_count = 0;
            p->_method = NO_TRANSITION;
            ++p;
        }
    }

    /**
     * t[̐U镑\bhB<BR>
     * {NX̋@\𗘗pꍇ́Ã\bh<BR>
     * t[s邱ƂKvB
     * @param s KpJnCfbNX
     * @param n KpCfbNX
     */
    virtual void behave(int s = 0, int n = N) {
        Parameter* p = &_parameter[s];
        for (int i = s; i < s+n; i++) {
            const TransitionMethod method = p->_method;
            VAL_TYPE val = getValue(i);
            const VAL_TYPE top = p->_top;
            const VAL_TYPE bottom = p->_bottom;
            p->_beat_frame_count++;
            p->_velo += p->_acce;
            val += p->_velo;

            switch (method) {
                case NO_TRANSITION: {
                    //Ȃ
                    break;
                }
                case TARGET_LINEAR_UNTIL: {
                    if (p->_beat_frame_count >= p->_beat_target_frames) {
                        val = p->_target;
                        stop(i);//I
                    }
                    break;
                }
                case TARGET_LINEAR_STEP: {
                    if ((p->_velo > 0  && val >= p->_target) || (p->_velo < 0  && val <= p->_target)) {
                        val = p->_target;
                        stop(i);//I
                    }
                    break;
                }
                case TARGET_ACCELERATION_UNTIL: {
                    if ((p->_velo > 0  && val >= p->_target) || (p->_velo < 0  && val <= p->_target)) {
                        val = p->_target;
                        stop(i);//I
                    }
                    break;
                }
                case TARGET_ACCELERATION_UNTIL_VELO: {
                    if ((p->_acce > 0  && p->_velo >= p->_target) || (p->_acce < 0  && p->_velo <= p->_target)) {
                       //x̏ꍇAx^[Qbgx傫ȂΏI
                       //x̏ꍇAx^[Qbgx菬ȂΏI
                       val -= p->_velo;
                       p->_velo = p->_target;
                       val += p->_velo;
                       stop(i);//I
                    }
                    break;
                }
                case BEAT_LINEAR: {
                    p->_beat_frame_count_in_roop++;
                    const frame cnt = p->_beat_frame_count_in_roop;
                    const frame beat_cycle_frames = p->_beat_cycle_frames;
                    if (cnt == beat_cycle_frames/2) {
                        //܂Ԃ
                        if (p->_velo > 0) { //R
                            val = top;
                            p->_velo = (VAL_TYPE)( (2.0*(bottom-top)) / ((double)beat_cycle_frames) ); //̑x
                        } else if (p->_velo < 0) { //J
                            val = bottom;
                            p->_velo = (VAL_TYPE)( (2.0*(top-bottom)) / ((double)beat_cycle_frames) ); //̑x
                        }
                    }
                    if (cnt == beat_cycle_frames) {
                        //P[vI
                        if (p->_velo > 0) { //R
                            val = top;
                            p->_velo = (VAL_TYPE)( (2.0*(bottom-top)) / ((double)beat_cycle_frames) ); //̑x
                        } else if (p->_velo < 0) { //J
                            val = bottom;
                            p->_velo = (VAL_TYPE)( (2.0*(top-bottom)) / ((double)beat_cycle_frames) ); //̑x
                        }
                        p->_beat_frame_count_in_roop = 0;
                    }
                    break;
                }
                case BEAT_TRIANGLEWAVE: {
                    p->_beat_frame_count_in_roop++;
                    const frame cnt = p->_beat_frame_count_in_roop;
                    const frame beat_frame_of_attack_finish = p->_beat_frame_of_attack_finish;
                    //A^bNI
                    if (cnt == beat_frame_of_attack_finish) {
                        val = top;
                        p->_velo = 0;
                    }
                    //ێI
                    if (cnt == p->_beat_frame_of_sustain_finish) {
                        val = top;
                        frame attenuate_frames = p->_beat_frame_of_release_finish - p->_beat_frame_of_sustain_finish; //(]C)
                        //܂ł̌(]C)xݒ
                        if (attenuate_frames > 0)  {
                            p->_velo = (VAL_TYPE)( (double)(bottom-top) / ((double)attenuate_frames) );
                        } else {
                            p->_velo = bottom-top;
                        }
                    }
                    //(]C)I
                    if (cnt == p->_beat_frame_of_release_finish) {
                        val = bottom;
                        p->_velo = 0;
                    }
                    //xeI
                    if (cnt == p->_beat_cycle_frames) {
                        val = bottom;
                        p->_beat_frame_count_in_roop = 0;
                        //̃A^bNւ̑xݒ
                        if (beat_frame_of_attack_finish > 0 ) {
                            p->_velo = (VAL_TYPE)( ((double)(top - val)) / ((double)beat_frame_of_attack_finish) );
                        } else if (beat_frame_of_attack_finish == 0 ) {
                            p->_velo = top - val;
                        }
                    }
                    break;
                }
                case R_BEAT_TRIANGLEWAVE: {
                    p->_beat_frame_count_in_roop++;
                    const frame cnt = p->_beat_frame_count_in_roop;
                    const frame beat_frame_of_attack_finish = p->_beat_frame_of_attack_finish;
                    //A^bNI
                    if (cnt == beat_frame_of_attack_finish) {
                        val = bottom;
                        p->_velo = 0;
                    }
                    //ێ()I
                    if (cnt == p->_beat_frame_of_sustain_finish) {
                        val = bottom;
                        frame attenuate_frames = p->_beat_frame_of_release_finish - p->_beat_frame_of_sustain_finish; //A
                        //܂ł̕Axݒ
                        if (attenuate_frames > 0)  {
                            p->_velo = (VAL_TYPE)( (double)(top - bottom) / ((double)attenuate_frames) );
                        } else {
                            p->_velo = top - bottom;
                        }
                    }
                    //AI
                    if (cnt == p->_beat_frame_of_release_finish) {
                        val = top;
                        p->_velo = 0;
                    }
                    //xeI
                    if (cnt == p->_beat_cycle_frames) {
                        val = top;
                        p->_beat_frame_count_in_roop = 0;
                        //̃A^bNւ̑xݒ
                        if (beat_frame_of_attack_finish > 0 ) {
                            p->_velo = (VAL_TYPE)( ((double)(bottom - val)) / ((double)beat_frame_of_attack_finish) );
                        } else if (beat_frame_of_attack_finish == 0 ) {
                            p->_velo = bottom - val;
                        }
                    }
                    break;
                }

                default:
                    break;
            }

            if (top < val) {
                val = top;
            } else if (bottom > val) {
                val = bottom;
            }

            setValue(i, val); //f

            if (p->_beat_frame_count >= p->_beat_target_frames) {
                stop(i);//I
            }

            ++p;
        }
    }

    virtual ~ValueEnveloper() {
    }
};

}

#endif /*GGAF_CORE_VALUEENVELOPER_H_*/

