#ifndef GGAF_CORE_UTIL_H_
#define GGAF_CORE_UTIL_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/util/CmRandomNumberGenerator.h"

#include <map>
#include <string>
#include <vector>
#include <iostream>
#include <sstream>
#include <limits.h>
#include <iomanip>
#include "jp/ggaf/core/exception/CriticalException.h"

#define DECLARE_HASHVAL(X) const static hashval X = GgafCore::Util::easy_hash(#X)
#define HASHVAL(X) GgafCore::Util::easy_hash(#X)

#define XTOS(X) (GgafCore::Util::_xtos_(X))
#define STOI(X) (GgafCore::Util::_stoi_(X))
#define ABS(X) (GgafCore::Util::_abs_(X))
#define SGN(X) (GgafCore::Util::_sgn_(X))
#define MAX3(a,b,c) (GgafCore::Util::_max3_((a),(b),(c)))
#define MIN3(a,b,c) (GgafCore::Util::_min3_((a),(b),(c)))

#define ZEROf_EQ(X) (GgafCore::Util::_zerof_eq_(X))
#define ONEf_EQ(X) (GgafCore::Util::_zerof_eq_((X)-1.0f))
#define ZEROd_EQ(X) (GgafCore::Util::_zerod_eq_(X))
#define ONEd_EQ(X) (GgafCore::Util::_zerod_eq_((X)-1.0))

/**
 * ͈͒̂lɂāA͈͂ϊꍇ̑Βl擾 .
 * ͈ MIN_A__ ` MAX_A__  A__ ̒lA͈ MIN_B__ ` MAX_B__ ɕϊꍇ A__ ɑΉl𓾂<br>
 */
#define RCNV(MIN_A__,MAX_A__,A__,MIN_B__,MAX_B__) (GgafCore::Util::_rcnv_((double)(MIN_A__),(double)(MAX_A__),(double)(A__),(double)(MIN_B__),(double)(MAX_B__)))
/**
 * 0 ` 1 ͈̔͂̂lɂāA͈͂ϊꍇ̑Βl擾 .
 * ͈ 0 ` 1  X ̒lA͈ MIN_B__ ` MAX_B__ ɕϊꍇ̒l𓾂<br>
 * y = ( (max_b-min_b)*x + min_b)
 */
#define RCNV_0_to_1(X,MIN_B__,MAX_B__) (GgafCore::Util::_rcnv_0_to_1_((double)(X),(double)(MIN_B__),(double)(MAX_B__)))

/**
 * ̗𓾂 .
 * RND(3, 20)
 *  3`20̗𓾂 ߂ int32_t ^
 */
#define RND(FROM__,TO__) (GgafCore::Util::_rnd_int32_((int32_t)(FROM__),(int32_t)(TO__)))

/**
 * 鐮̎ӂ̗𓾂 .
 * RND_ABOUT(15, 4)   ӖF15 ́}4͈̗̔͂
 *  11 ` 19 ̗ɂȂ
 */
#define RND_ABOUT(BASE_VALUE__, MARGIN__) (RND(((int)(BASE_VALUE__) - (int)(MARGIN__)), (BASE_VALUE__ + MARGIN__)))

#define dRND(FROM__,TO__) (GgafCore::Util::_rnd_double_((FROM__),(TO__)))

typedef std::map<std::string, std::string> StrMap;

#ifdef UTIL
    #undef UTIL
#endif
#define UTIL GgafCore::Util

namespace GgafCore {

/**
 * [eBeBNX .
 * ėpIȐÓI֐͂ł邾ɋLqB
 * @version 1.00
 * @since 2007/12/11
 * @author Masatoshi Tsuge
 */
class Util {
public:
    static uint32_t _timex;

public:
    static uint32_t getSystemTime();

    /**
     * t@Cǂݍ .
     * ߂l͌Ăь delete[] Kv܂B
     * @param prm_filename
     * @return
     */
    static char* getFileText(std::string prm_filename);

    /**
     * f~^ŕ .
     * 󕶎vf͔΂B
     * <pre>
     * yz
     * std::vector<std::string> data = split("\taaa\tbbb\t\t\tcccc\tddd\teeee\t\t", "\t");
     * ʁ
     * data[0] = aaa
     * data[1] = bbb
     * data[2] = cccc
     * data[3] = ddd
     * data[4] = eeee
     * </pre>
     * @param str 
     * @param delim 
     * @return ꂽvector
     */
    static inline std::vector<std::string> split(std::string str, std::string delim) {
        std::vector<std::string> r;
        size_t cutAt;
        while ((cutAt = str.find_first_of(delim)) != str.npos) {
            if (cutAt > 0) {
                r.push_back(str.substr(0, cutAt));
            }
            str = str.substr(cutAt + 1);
        }
        if (str.length() > 0) {
            r.push_back(str);
        }
        return r;
    }
    /**
     * f~^ŕ .
     * @param str 
     * @param delim 
     * @param split_number_of_times 
     * @return
     */
    static inline std::vector<std::string> split(std::string str, std::string delim, int split_number_of_times) {
        std::vector<std::string> r;
        size_t cutAt;
        int cnt = 0;
        while ((cutAt = str.find_first_of(delim)) != str.npos) {
            if (cutAt > 0) {
                r.push_back(str.substr(0, cutAt));
            }
            str = str.substr(cutAt + 1);
            cnt++;
            if (split_number_of_times <= cnt) {
                break;
            }
        }
        if (str.length() > 0) {
            r.push_back(str);
        }
        return r;
    }

    /**
     * ړxAu~ړvu_̑xvɂ苁߂ .
     * <pre><code>
     *
     *    x(v)
     *     ^       a:x    EEE񋁂߂l
     *     |       D:ړ    EEE
     *     |      V0:_̑xEEE
     *   V0|      Te:~t[EEE߂܂
     *     |_
     *     |  _
     *     |    _ Εӂ̌Xa
     *     |   D  _
     *     |        _
     *   --+----------_-----> (t)
     *   0 |          Te
     * </code></pre>
     * }̂悤ȏԂz肵A̋(D)Ax(a)vZݒ肵ĂB<BR>
     * ~܂ł̃t[(Te)  (D) ɂω邽ߎwsB<BR>
     * @param D  vڕWBxɒB܂łɔ₷(D)
     * @param V0 _̑x(V0)
     * @return Kvȉx(a)
     */
    static inline double getAcceToStop(double D, double V0) {
#ifdef MY_DEBUG
        if (ZEROd_EQ(D)) {
            throwCriticalException("DZEROłBD="<<D);
        }
#endif
        // D = (1/2) V0 Te  EEE@
        // a = -V0 / Te     EEEA
        // @
        // Te = 2D / V0
        // A֑
        // a = -V0 / (2D / V0)
        //  a = -(V0^2) / 2D
        return -(V0*V0) / (2.0*D);
    }

    /**
     * ړxAuړvu_̑xvuڕWBxvɂ苁߂ .
     * <pre><code>
     *    x(v)
     *     ^        a:x      EEE񋁂߂l
     *     |        D:ړ    EEE
     *     |       V0:_̑xEEE
     *     |       Vt:ڕWBxEEE
     *     |       Te:ڕWBxɒB̎ԁEEE߂܂
     *   Vt|........
     *     |      ^|
     *     |    ^  |
     *     |  ^    |   Εӂ̌Xa
     *     |^      |
     *   V0|    D   |
     *     |        |
     *   --+--------+---> (t)
     *   0 |        Te
     *
     * </code></pre>
     * }̂悤ȏԂz肵AڕWBx(Vt)ƁAړ(D)Ax(a)vZݒ肵ĂB<BR>
     * ڕWB܂ŕKvȃt[(Te) ̓p[^ɂω邽ߎwsB<BR>
     * @param D  vڕWBxɒB܂łɔ₷(D)
     * @param V0 _̑x(V0)
     * @param Vt ڕWBx(Vt)
     * @return Kvȉx(a)
     */
    static inline double getAcceByVd(double V0, double Vt, double D) {
#ifdef MY_DEBUG
        if (ZEROd_EQ(D)) {
            throwCriticalException("DZEROłBD="<<D);
        }
#endif
        //D = (1/2) (V0 + Vt) Te   EEE@
        //a = (Vt - V0) / Te       EEEA
        //A Te = (Vt - V0) / a
        //@֑
        //D = (Vt^2 - V0^2) / 2a
        // a = (Vt^2 - V0^2) / 2D
        return ((Vt*Vt) - (V0*V0)) / (2.0*D);
    }

//    static inline double getTimeByD(double D, double V0, double Vt) {
//
//
//    }
    /**
     * ړxAu₷ԁvu_̑xvuڕWBxvɂ苁߂ .
     * <pre><code>
     *    x(v)
     *     ^        a:x      EEE񋁂߂l
     *     |        D:ړ    EEE߂܂
     *     |       V0:_̑xEEE
     *     |       Vt:ڕWBxEEE
     *     |       Te:ڕWBxɒB̎ԁEEE
     *   Vt|........
     *     |      ^|
     *     |    ^  |
     *     |  ^    |   Εӂ̌Xa
     *     |^      |
     *   V0|    D   |
     *     |        |
     *   --+--------+---> (tt[)
     *   0 |        Te
     *
     * </code></pre>
     * }̂悤ȏԂz肵AڕWBx(Vt)ƁA̓B(Te) Ax(a)vZݒ肵ĂB<BR>
     * ړ(D)́Ap[^ɂω邽ߎwsB<BR>
     * @param Te ₷(Te)
     * @param V0 _̑x(V0)
     * @param Vt ڕWBx(Vt)
     * @return Kvȉx(a)
     */
    static inline double getAcceByTv(double Te, double V0, double Vt) {
#ifdef MY_DEBUG
        if (ZEROd_EQ(Te)) {
            throwCriticalException("TeZEROłBTe="<<Te);
        }
#endif
        //a = (Vt-V0) / Te
        return (Vt - V0) / Te;
    }


    /**
     * float p 0 ۂ̂ǂ .
     * @param val 肵l
     * @param epsilon 0ۂ͈
     * @return true:0ۂ / false:0ۂȂ
     */
    static inline bool _zerof_eq_(float val, float epsilon = 1e-5f ) {
        return (-epsilon < val && val < epsilon);
    }

    /**
     * double p 0 ۂ̂ǂ .
     * @param val 肵l
     * @param epsilon 0ۂ͈
     * @return true:0ۂ / false:0ۂȂ
     */
    static inline bool _zerod_eq_(double val, double epsilon = 1e-13) {
        return (-epsilon < val && val < epsilon);
    }

    /**
     * 낢Ȍ^̒l𕶎ɕϊ .
     * @param prm_x
     * @return 
     */
    template<typename T>
    static inline std::string _xtos_(T prm_x) {
        std::ostringstream oss;
        oss << prm_x;
        return oss.str();
    }

    /**
     * 낢Ȍ^̒l𕶎ɕϊ bool ꉻ .
     * @param prm_x
     * @return
     */
    template<typename T>
    static inline std::string _xtos_(bool prm_x) {
        if (prm_x) {
            return "true";
        } else {
            return "false";
        }
    }

    /**
     *  int ɕϊ .
     * @param prm_s
     * @return
     */
    static inline int _stoi_(std::string& prm_s) {
        int n;
        std::istringstream istr(prm_s);
        istr >> n;
        return n;
    }

    /**
     * 10i-->2iϊ֐
     * @param prm_decimal
     * @param out_binstr 2i  char[33]  [out]
     * @param bitnum ]̂Qirbg
     */
    static inline void strbin(uint32_t prm_decimal, char* out_binstr, int bitnum = 32) {
        /* 10i-->2iϊ */
        int i, k;
        for (i = 0, k = bitnum - 1; k >= 0; i++, k--) {
            if ((prm_decimal >> i) & 1) {
                out_binstr[k] = '1';
            } else {
                out_binstr[k] = '0';
            }
        }
        out_binstr[i] = '\0';

        /* ϊʂ̗00011001ɂAʌ000폜鏈 */
//        for (i = 0; i < BITS_DIGIT; i++) {
//            if (BinaryString[0] == '0') memmove(BinaryString, BinaryString + 1, BITS_DIGIT);
//            else break;
//        }
    }

//    static inline const hashval easy_hash(const char* str) {
//        hashval hash = 5381;
//        char c;
//        while ((c = *str++) > 0) { //str\0܂Ń[v iZq "==" ƊԈႦĂ܂j
//            hash = ((hash << 5) + hash) + c; // hash * 33 + c  33{Ă܂
//        }
//        return hash;
//    }
//
//    static inline const hashval easy_hash(char* str) {
//        hashval hash = 5381;
//        char c;
//        while ((c = *str++) > 0) { //str\0܂Ń[v iZq "==" ƊԈႦĂ܂j
//            hash = ((hash << 5) + hash) + c; // hash * 33 + c  33{Ă܂
//        }
//        return hash;
//    }

    static inline const hashval easy_hash(const char* str) {
        //APHash
        hashval hash = 0xAAAAAAAA;
        char c;
        for (std::size_t i = 0; (c = *str++) > 0; i++) {
            hash ^= ((i & 1) == 0) ? (  (hash <<  7) ^ c * (hash >> 3)) :
                                     (~((hash << 11) + (c ^ (hash >> 5))));
        }
        return hash;
    }

    /**
     * .
     * @param x
     * @return
     */
    template<typename T>
    static inline int _sgn_(T x) {
        return x < 0 ? -1 : x > 0;
    }

    /**
     * Βl߂
     * @param x
     * @return
     */
    template<typename T>
    static inline T _abs_(T x) {
        return x < 0 ? -x : x;
    }

    static inline int _abs_(int x) {
        return (x == INT_MIN) ? INT_MAX : (x < 0 ? -x : x);
    }

    template<typename T>
    static inline T _max2_(T a, T b) {
        return ( ((a) > (b) ? (a) : (b))   );
    }

    template<typename T>
    static inline T _max3_(T a, T b, T c) {
        return ( (a)>(b) ? ((a)>(c)?(a):(c)) : ((b)>(c)?(b):(c)) );
    }

    template<typename T>
    static inline T _min3_(T a, T b, T c) {
        return ( (a) < ((b)<(c)?(b):(c)) ? (a) : ((b)<(c)?(b):(c)) );
    }

    static inline size_t hex2dec(const std::string &prm_hex) {
        std::istringstream iss(prm_hex);
        size_t val;
        iss >> std::hex >> val;
        return val;
    }
    static inline const std::string dec2hex(size_t prm_dec) {
        std::ostringstream oss;
        oss << std::hex << std::uppercase << prm_dec;
        return oss.str();
    }
    static inline const std::string dec2hex(size_t prm_dec, int prm_keta) {
        std::ostringstream oss;
        oss << std::setw(prm_keta) << std::hex << std::setfill('0') << std::uppercase << prm_dec;
        return oss.str();
    }

    static inline char m_hex(int nibble) {
        static const char *digits = "0123456789ABCDEF";
        return digits[(nibble & 0xf)];
    }

    static inline std::string trim(std::string& str) {
        str.erase(0, str.find_first_not_of(' '));
        str.erase(str.find_last_not_of(' ')+1);
        return str;
    }

    /**
     * ͈͒̂lɂāA͈͂ϊꍇ̑Βl擾 .
     * ͈ min_a ` max_a  a ̒lA͈ min_b ` max_b ɕϊꍇ a ɑΉl(b) 𓾂<br>
     */
    static inline double _rcnv_(double min_a, double max_a, double a, double min_b, double max_b) {
        return ( (min_b-max_b)*a - (max_a*min_b) + (max_b*min_a) ) / (min_a-max_a);
    }

    static inline double _rcnv_0_to_1_(double x, double min_b, double max_b) {
        return ( (max_b-min_b)*x + min_b);
    }
    /**
     * R捪߂ .
     * @param x
     * @return
     */
    static double _cbrt_(double x);
    /**
     * int32_t_֐ .
     * prm_from  prm_to t]Ă͂Ȃ(%ŹAVC++ł͕̓ŝ)
     * @param prm_from
     * @param prm_to
     * @return
     */
    static int32_t _rnd_int32_(int32_t prm_from, int32_t prm_to);

    static double _rnd_double_(double prm_from, double prm_to);

    static bool cnvBool(std::string& prm_str);

    static std::string getFileBaseNameWithoutExt(const char* prm_filepath);
    static std::string getFileBaseName(const char* prm_filepath);
    static std::string getFileDirName(const char* prm_filepath);
    static std::string getFileExt(const char* prm_filepath);

    static char* reverseStr(char* str);
    static void strReplace(std::string& str, const std::string& from, const std::string& to);

    /**
     * l[ߕɕϊ .
     * ľ prm_total_keta 葽ꍇ́A
     * prm_data_num ̕񂪕ԂB
     * @param prm_data_num    l
     * @param prm_total_keta  Ŝ̕
     * @return [߂ꂽ
     */
    static std::string padZeroStr(int prm_data_num, int prm_total_keta);

    static std::string getSystemDateTimeStr();
};

}
#endif /*GGAF_CORE_UTIL_H_*/

//printf("01  [%s]\n", GgafCore::Util::getFileBaseNameWithoutExt("c:\\cview_gamen_all.pdf").c_str());
//printf("02  [%s]\n", GgafCore::Util::getFileBaseNameWithoutExt("c:\\cview_gamen.all.pdf").c_str());
//printf("03  [%s]\n", GgafCore::Util::getFileBaseNameWithoutExt("c:\\c.all.pdf").c_str());
//printf("04  [%s]\n", GgafCore::Util::getFileBaseNameWithoutExt("c:\\.cproj").c_str());
//printf("05  [%s]\n", GgafCore::Util::getFileBaseNameWithoutExt("c:\\cview_gamen_all\\").c_str());
//printf("06  [%s]\n", GgafCore::Util::getFileBaseNameWithoutExt("/www/htdocs/index.html").c_str());
//printf("07  [%s]\n", GgafCore::Util::getFileBaseNameWithoutExt("/www/htdocs/app").c_str());
//printf("08  [%s]\n", GgafCore::Util::getFileBaseNameWithoutExt("/www/htdocs/app/").c_str());
//printf("09  [%s]\n", GgafCore::Util::getFileBaseNameWithoutExt("").c_str());
//printf("10  [%s]\n", GgafCore::Util::getFileBaseName("c:\\cview_gamen_all.pdf").c_str());
//printf("11  [%s]\n", GgafCore::Util::getFileBaseName("c:\\cview_gamen_all\\").c_str());
//printf("12  [%s]\n", GgafCore::Util::getFileBaseName("/www/htdocs/index.html").c_str());
//printf("13  [%s]\n", GgafCore::Util::getFileBaseName("/www/htdocs/app").c_str());
//printf("14  [%s]\n", GgafCore::Util::getFileBaseName("/www/htdocs/app/").c_str());
//printf("15  [%s]\n", GgafCore::Util::getFileBaseName("").c_str());
//printf("16  [%s]\n", GgafCore::Util::getFileDirName("c:\\www\\htdocs\\index.html").c_str());
//printf("17  [%s]\n", GgafCore::Util::getFileDirName("/www/htdocs/app").c_str());
//printf("18  [%s]\n", GgafCore::Util::getFileDirName("/www/htdocs/app/").c_str());
//printf("19  [%s]\n", GgafCore::Util::getFileDirName("").c_str());
//printf("20  [%s]\n", GgafCore::Util::getFileExt("/www/htdocs/index.html").c_str());
//printf("21  [%s]\n", GgafCore::Util::getFileExt("/www/htdocs/index.php").c_str());
//printf("22  [%s]\n", GgafCore::Util::getFileExt("/www/htdocs/lamda").c_str());
//printf("23  [%s]\n", GgafCore::Util::getFileExt("").c_str());
//sʁ
//01  [cview_gamen_all]
//02  [cview_gamen]
//03  [c]
//04  []
//05  [cview_gamen_all]
//06  [index]
//07  [app]
//08  [app]
//09  []
//10  [cview_gamen_all.pdf]
//11  [cview_gamen_all]
//12  [index.html]
//13  [app]
//14  [app]
//15  []
//16  [c:\www\htdocs]
//17  [/www/htdocs]
//18  [/www/htdocs]
//19  []
//20  [html]
//21  [php]
//22  []
//23  []

