#ifndef GGAF_CORE_LINEARTREEROUNDER_H_
#define GGAF_CORE_LINEARTREEROUNDER_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/Object.h"

#include "jp/ggaf/core/util/LinearOctree.h"
#include "jp/ggaf/core/util/TreeSpace.hpp"

namespace GgafCore {

#define MAX_COLLISIONSTACK_ACTOR_NUM (2000)
/**
 * TvfƂ蔻@\ǉ`N؂܂͎l؂̊evfɏs .
 * @version 1.00
 * @since 2009/11/23
 * @author Masatoshi Tsuge
 */
template<class T, uint32_t DIMENSION>
class LinearTreeRounder : public Object {

    uint32_t _num_space;

public:
    /**
     * 蔻AN^[ێX^bN .
     * ̎lĂȂ댯ȃX^bN
     */
    class TStack {
    public:
        /** [r]̋ԂɃX^bNAN^[̔zBgp̂[0]`[MAX_COLLISIONSTACK_ACTOR_NUM-1]B+1́AŌ̗vfԕɂĂ */
        T* _apT[MAX_COLLISIONSTACK_ACTOR_NUM+1]; //Ō̗vf(+1)͔ԕ
        /** [r]J[\|C^(PUSHovfwĂ)  */
        T** _papCur;
        /** [r]ɃX^bN̐擪vfwĂ */
        T** _papFirst;
        /** [r]ɃX^bN̍Ō̗vf̎wĂ */
        T** _papBanpei;
    public:
        /**
         * RXgN^
         * @return
         */
        TStack() {
            _papFirst = &_apT[0];
            _papBanpei = &_apT[MAX_COLLISIONSTACK_ACTOR_NUM];
            _papCur = _papFirst;
        }
        /**
         * X^bNɐς .
         * @param prm_pT ςރAN^[
         */
        inline void push(T* prm_pObject) {
            if (_papCur == _papBanpei) {
                _TRACE_("x LinearTreeRounder::push("<<prm_pObject<<") X^bNg؂܂B܂Bӏɓ蔻肪߂łB");
                return;
            }
            (*_papCur) = prm_pObject;
            ++_papCur;
        }

        /**
         * X^bNo .
         * @return oꂽAN^[
         */
        inline T* pop() {
            if (_papCur == _papFirst) {
                return nullptr;
            } else {
                --_papCur;
                return (*_papCur);
            }
        }

        inline bool isExist() {
            return _papCur == _papFirst ? false : true;
        }

        /**
         * ̃X^bNSĎo(pop)Ao莩g̃X^bNɐς(push) .
         * ̃X^bŃAKɂȂB
         * @param prm_pTStack
         */
        inline void popush(TStack* prm_pTStack) {
            if (_papCur == _papBanpei) {
                _TRACE_("x LinearTreeRounder::popush("<<prm_pTStack<<") X^bNg؂Ă܂B܂Bӏɓ蔻肪߂łB");
                prm_pTStack->clear();
                return;
            }
            while ((*_papCur) = prm_pTStack->pop()) { //BpopoȂ nullptrB I know "=" , not "=="
                 ++_papCur;
                 if (_papCur == _papBanpei) {
                    _TRACE_("x LinearTreeRounder::popush("<<prm_pTStack<<") X^bNg؂܂B܂Bӏɓ蔻肪߂łB");
                    prm_pTStack->clear();
                    break;
                }
            }
        }
        /**
         * ς񂾃X^bNȂɂB .
         */
        inline void clear() {
            _papCur = _papFirst;
        }
        ~TStack() {
            clear();
        }
    };

    TreeSpace<DIMENSION>* _paTargetSpace;
    /** [r]SԂ̓蔻莞A݂̋ԂɏAN^[AO[ṽX^bN */
    TStack _stackGroupA_Current;
    /** [r]SԂ̓蔻莞A݂̋ԂɏAN^[BO[ṽX^bN */
    TStack _stackGroupB_Current;
    /** [r]Ԃ̓蔻莞AeԂɏSAN^[AO[ṽX^bN */
    TStack _stackGroupA;
    /** [r]Ԃ̓蔻莞AeԂɏSAN^[BO[ṽX^bN */
    TStack _stackGroupB;

    /** [r]񓖂蔻sAN^[A */
    kind_t _kind_groupA;
    /** [r]񓖂蔻sAN^[B */
    kind_t _kind_groupB;
    /** [r]sT̃o֐ */
    void (T::*_pFunc)(T*);

public:
    /**
     * RXgN^
     * @param prm_level 쐬N؋ԃx
     */
    LinearTreeRounder(TreeSpace<DIMENSION>* prm_paTargetSpace, int prm_num_space, void (T::*prm_pFunc)(T*)) {
        _paTargetSpace = prm_paTargetSpace;
        _num_space = prm_num_space;
        _pFunc = prm_pFunc;
        _kind_groupA = 0;
        _kind_groupB = 0;
    }

    /**
     * N؏́uAN^[AO[v  AN^[BO[vvs  .
     * Av͖{\bhĂԂł悢B<BR>
     *  executeAllHitChk  processJudgement() ŌĂԕKvB<BR>
     * @param prm_kind_groupA AN^[AO[v
     * @param prm_kind_groupB AN^[BO[v
     */
    void executeAll(kind_t prm_kind_groupA, kind_t prm_kind_groupB) {
        _kind_groupA = prm_kind_groupA;
        _kind_groupB = prm_kind_groupB;
        kind_t k_bit = _paTargetSpace[0]._kind_bit_field;
        if ( (k_bit & prm_kind_groupA) && (k_bit & prm_kind_groupB) ) {
            //łN؂闷֍sĂႢ
            execute(0); //Ă܂
            //͂AȂB
            _stackGroupA.clear();
            _stackGroupB.clear();
        }
    }

    /**
     * ̋Ԃ̓蔻s  .
     * executeAllHitChk gpB
     * @param prm_index `Nؔz̔zvfԍ
     */
    void execute(uint32_t prm_index) {
        TreeSpace<DIMENSION>* pOctant_this_level = &(_paTargetSpace[prm_index]);
        TreeElem<DIMENSION>* pElem = pOctant_this_level->_pElem_first;
        const kind_t kind_groupA = _kind_groupA;
        const kind_t kind_groupB = _kind_groupB;
        if (pElem) {
            TreeElem<DIMENSION>* pElem_last = pOctant_this_level->_pElem_last;
            while (true) {
                kind_t kind = pElem->_kind;
                T* pObject = (T*)(pElem->_pObject);
                if (kind & kind_groupA) {
                    _stackGroupA_Current.push(pObject);
                }
                if (kind & kind_groupB) {
                    _stackGroupB_Current.push(pObject);
                }
                if (pElem == pElem_last) {
                    break;
                }
                pElem = pElem->_pNext;
            }
            //݂̋Ԃ̃O[vAƃO[vB
            executeRoundRobin(&_stackGroupA_Current, &_stackGroupB_Current);
            //݂̋Ԃ̃O[vAƐeԏ̃O[vB
            executeRoundRobin(&_stackGroupA_Current, &_stackGroupB );
            //eԏ̃O[vAƌ݂̋Ԃ̃O[vB
            executeRoundRobin(&_stackGroupA , &_stackGroupB_Current);
        }
        const uint32_t lower_level_index = (prm_index<<DIMENSION) + 1; //_papOctant[prm_index] Ԃ̎qԂ̃[gʒu0Ԃ̔zvfԍ
        if ( lower_level_index >= _num_space) {
            //vfI[o[A܂胊[t
            _stackGroupA_Current.clear();
            _stackGroupB_Current.clear();
            return; //eԂ֖߂
        } else {

            //BȂOɌԃAN^[eԃAN^[̃X^bN֒ǉB
            //Ԃ猩ꍇ̐eԃAN^[݌vĂĂB
            //(ɌԃX^bNJ)
            T** temp_stackGroupA = _stackGroupA._papCur; //X^bN|C^ۑ(̃ZbgɎgp)
            T** temp_stackGroupB = _stackGroupB._papCur; //X^bN|C^ۑ(̃ZbgɎgp)
            _stackGroupA.popush(&_stackGroupA_Current); //Current  Parent ɒǉBCurrent̓NAB
            _stackGroupB.popush(&_stackGroupB_Current); //Current  Parent ɒǉBCurrent̓NAB
            bool isExistGroupA = _stackGroupA.isExist();
            bool isExistGroupB = _stackGroupB.isExist();

            //qbg`FbNsɁAq(W)֐ɍs`B
            //̃x̋ԂɎABo^ĂΐB
            //́Ãx̋ԂɎAAXgbNɎBΐB
            //́Ãx̋ԂɎBAXgbNɎAΐB
            //ȊO͐Ȃ
            TreeSpace<DIMENSION>* pOctant_lower_level = &(_paTargetSpace[lower_level_index]);
            kind_t kind_bit_field_lower_level = pOctant_lower_level->_kind_bit_field;
            if (kind_bit_field_lower_level & kind_groupA) {
                if (isExistGroupB || (kind_bit_field_lower_level & kind_groupB)) {
                    execute(lower_level_index);
                }
            } else if (kind_bit_field_lower_level & kind_groupB) {
                if (isExistGroupA) {
                    execute(lower_level_index);
                }
            }

            for (int i = 1; i < (1<<DIMENSION); i++) {
                kind_bit_field_lower_level = (++pOctant_lower_level)->_kind_bit_field;
                if (kind_bit_field_lower_level & kind_groupA) {
                    if (isExistGroupB || (kind_bit_field_lower_level & kind_groupB)) {
                        execute(lower_level_index+i);
                    }
                } else if (kind_bit_field_lower_level & kind_groupB) {
                    if (isExistGroupA) {
                        execute(lower_level_index+i);
                    }
                }
            }

            //AȂ
            //X^bN̉ipushAɖ߂j
            _stackGroupA._papCur = temp_stackGroupA;
            _stackGroupB._papCur = temp_stackGroupB;
            return; //eԂ֖߂
        }
    }
    /**
     * AN^[AO[ṽX^bNƁAAN^[BO[ṽX^bN̑̓蔻s  .
     * executeHitChk gpB
     * @param prm_pStackA AN^[AO[ṽX^bN
     * @param prm_pStackB AN^[BO[ṽX^bN
     */
    void executeRoundRobin(TStack* prm_pStackA, TStack* prm_pStackB) {
        //LinearTreeRounderł́Avf̎w(Object*)CX^X TO
        if (prm_pStackA->isExist() && prm_pStackB->isExist()) {
            void (T::*pFunc)(T*) = _pFunc;
            T** papStackT_A_Cur = prm_pStackA->_papCur;
            T** papStackT_B_Cur = prm_pStackB->_papCur;
            T** papStackT_A = prm_pStackA->_papFirst;
            while (papStackT_A != papStackT_A_Cur) {
                T** papStackT_B = prm_pStackB->_papFirst;
                while (papStackT_B != papStackT_B_Cur) {
                    ((*papStackT_A)->*pFunc)(*papStackT_B);
                    ++papStackT_B;
                }
                ++papStackT_A;
            }
        }
    }

    virtual ~LinearTreeRounder() {
    }
};

}
#endif /*GGAF_CORE_LINEARTREEROUNDER_H_*/

