#ifndef GGAF_CORE_PROPERTIES_H_
#define GGAF_CORE_PROPERTIES_H_
#include "GgafCommonHeader.h"

#include "jp/ggaf/core/util/Util.h"
#include "jp/ggaf/core/util/Rgb.h"

namespace GgafCore {

/**
 * vpeBNX .
 * Ot@C烍[hAAv̊ϐƂĕێ܂B
 * @version 1.00
 * @since 2008/07/22
 * @author Masatoshi Tsuge
 */
class Properties : public Object {


public:
    /** [r] ێvpeB */
    StrMap _mapProperties;

public:
    Properties();

    Properties(std::string prm_properties_filename);

    /**
     * OvpeBt@C疢[hȂ烍[hĕێvpeB֐ݒAoϐɔf .
     * @param prm_properties_filename vpeBt@C
     */
    void read(std::string prm_properties_filename);

    void read(std::istream& is);

    /**
     * ێvpeBAOvpeBt@C֕ۑ .
     * @param prm_properties_filename vpeBt@C
     */
    void write(std::string prm_properties_filename, const char *header = nullptr);

    void write(std::ostream &os, const char *header = nullptr);

    void print(std::ostream &os);


    /**
     * ێvpeBɃL[݂邩ׂ .
     * @param prm_key L[
     * @return true:L[ / false:݂Ȃ
     */
    bool isExistKey(std::string prm_key);

    /**
     * L[ɑ΂vpeBl string Ŏ擾 .
     * @param prm_key L[
     * @return vpeBl(string)
     */
    std::string getStr(std::string prm_key);

    /**
     * L[ɑ΂vpeBlboolŎ擾 .
     * true, on, yes ̏̕ꍇ true Ƃ݂ȂAȊO falseB
     * @param prm_key L[
     * @return vpeBl(bool)
     */
    bool getBool(std::string prm_key);

    /**
     * L[ɑ΂vpeBl float Ŏ擾 .
     *  atof() gpB
     * @param prm_key L[
     * @return vpeBl(float)
     */
    float getFloat(std::string prm_key);

    /**
     * L[ɑ΂vpeBl int Ŏ擾 .
     *  atoi() gpB
     * @param prm_key L[
     * @return vpeBl(int)
     */
    int getInt(std::string prm_key);

    /**
     * L[ɑ΂vpeBl uint32_t Ŏ擾 .
     *  _atoi64() āAuint32_tɃLXg
     * @param prm_key L[
     * @return vpeBl(uint32_t)
     */
    uint32_t getUInt(std::string prm_key);

    /**
     * L[ɑ΂vpeBl double Ŏ擾 .
     * @param prm_key L[
     * @return vpeBl(double)
     */
    double getDouble(std::string prm_key);

    /**
     * L[ɑ΂vpeBl Rgb Ŏ擾 .
     * Rgb ́A"#FFFFFF"i#ȗj`̕񂩂ARlAGlABlɕϊĕێ܂B
     * @param prm_key L[
     * @return vpeBl(Rgb)
     */
    Rgb getRGB(std::string prm_key);

    /**
     * ێvpeBɒlݒB
     * ݒ肵Ăoɂ͂܂f܂B
     * @param prm_key
     * @param prm_value
     */
    void setValue(std::string prm_key, int prm_value);

    /**
     * ێvpeBɒlݒB
     * ݒ肵Ăoɂ͂܂f܂B
     * @param prm_key
     * @param prm_value
     */
    void setValue(std::string prm_key, uint32_t prm_value);

    /**
     * ێvpeBɒlݒB
     * ݒ肵Ăoɂ͂܂f܂B
     * @param prm_key
     * @param prm_value
     */
    void setValue(std::string prm_key, std::string prm_value);

    /**
     * ێvpeBɒlݒB
     * ݒ肵Ăoɂ͂܂f܂B
     * @param prm_key
     * @param prm_value
     */
    void setValue(std::string prm_key, float prm_value);

    /**
     * ێvpeBɒlݒB
     * ݒ肵Ăoɂ͂܂f܂B
     * @param prm_key
     * @param prm_value
     */
    void setValue(std::string prm_key, double prm_value);

    /**
     * ێvpeBɒlݒB
     * ݒ肵Ăoɂ͂܂f܂B
     * @param prm_key
     * @param prm_value
     */
    void setValue(std::string prm_key, bool prm_value);

    /**
     * ێvpeBɒlݒB
     * ݒ肵Ăoɂ͂܂f܂B
     * @param prm_key
     * @param prm_value
     */
    void setValue(std::string prm_key, Rgb prm_value);

};

}
#endif /*GGAF_CORE_PROPERTIES_H_*/

