#ifndef GGAF_CORE_GOD_H_
#define GGAF_CORE_GOD_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/Object.h"

#include <windows.h>
#ifdef __GNUG__
    #undef __in
    #undef __out
#endif

#ifndef _MSC_VER
    #include <atomic>
#endif

#define ORDER_ID_MAX     (0xffffffffffffffffULL)

#undef pGOD
#define pGOD (GgafCore::God::ask())

namespace GgafCore {

#define  BEGIN_SYNCHRONIZED1   ::EnterCriticalSection(&(GgafCore::God::CS1))
#define  END_SYNCHRONIZED1     ::LeaveCriticalSection(&(GgafCore::God::CS1))
#define  BEGIN_SYNCHRONIZED2   ::EnterCriticalSection(&(GgafCore::God::CS2))
#define  END_SYNCHRONIZED2     ::LeaveCriticalSection(&(GgafCore::God::CS2))
#define  SLOWDOWN_MODE_DEFAULT 0
#define  SLOWDOWN_MODE_40FPS 1
#define  SLOWDOWN_MODE_30FPS 2
/**
 * _NX.
 * ɂ̐(Spacetime)Ǘ삷邱ƂړIƂNXłBԂԂ炢B<BR>
 * {NX be() \bhĂё邱ƂŁA̐ƂɂȂAƂ݌vB<BR>
 * CX^X͂PłB<BR>
 * TODO:O[oȎQƂێ֗NXɂȂGB<BR>
 * TODO:ŏIIɂ _Q new āA݂ be() s΁AQ[Qs삷悤ɂ悤ȁB
 * (:GdxfwWorldNX)
 * @version 1.00
 * @since 2007/11/26
 * @author Masatoshi Tsuge
 */
class God : public Object {

private:
    /** behavestO */
    bool _is_behaved_flg;
    /** materializestO */
    bool _is_materialized_flg;

public:
    /** [r] NeBJZNV̂P */
    static CRITICAL_SECTION CS1;
    /** [r] NeBJZNV̂Q */
    static CRITICAL_SECTION CS2;
    /** [r] g */
    static God* _pGod;
    /** [r] ɂ̐鎞Ԃ̃ItZbg */
    //static DWORD _aaTime_offset_of_next_view[3][60];
    //static double _aTime_offset_of_next_view[3];

    //WORD _base_fps;
    DWORD* _apaTime_offset_of_next_view[3];
    double _aTime_offset_of_next_view[3];

    /** [r] _(ʃXbh)̃G[ԁBnullptrғ^not nullptrُ픭 */
    CriticalException* _pException_god;


    /** [r] GgafCore::God::love Xbhnh  */
    HANDLE _handle_god_love01;
    /** [r] GgafCore::God::love XbhID  */
    unsigned int _th_id01;
    /** [r] _̃t[JnVXe */
    DWORD _time_at_beginning_frame;
    /** [r] ɂ̐VXe */
    DWORD _time_of_next_view;
    /** [r] _ãt[ */
    frame _frame_of_God;
    int _cnt_frame;

    /** [r] ̐ołȂiXLbvj */
    int _skip_count_of_frame;
    /** [r] ̐ */
    Spacetime* _pSpacetime;
    /** [r] fpsli1000msɌvZj */
    double _fps;

    DWORD _time_calc_fps_next;
    /** [r] `t[JE^ */
    frame _visualize_frames;
    /** [r] OfpsvZ̕`t[JEgl */
    frame _prev_visualize_frames;
#ifdef MY_DEBUG
    /** [r] 1t[̕` */
    static unsigned int _num_drawing;
#endif
    /** [r] 1t[̊AN^[ */
    static unsigned int _num_active_actor;

    /** [r] `揈AōXLbvt[ */
    int _max_skip_frames;
    /** [r] ݂̏[h 0:60fps 1:40fps 2:30fpsB_aaTime_offset_of_next_vieẅڂ̗vf */
    int _slowdown_mode;
    /** [r] Ԃƃt[̓[htrue */
    bool _sync_frame_time;
    bool _was_cleaned;


public:
    /**
     * RXgN^ .
     * ʃXbhŐ_ғ܂B
     */
    God();

    /**
     * u݂vƂ\bh .
     * _݂AȂ킿A̐(Spacetime)AAvis܂B<BR>
     * ĂяoA̐(Spacetime)쐬܂B<BR>
     * AvP[V́AŏԒPʂł̃\bhЂĂёĂB<BR>
     */
    void be();

    /**
     * ̐FPSݒ肷 .
     * ݒ̏ꍇ̓ftHg 60 FPS
     * @param prm_fps FPSl
     */
    void setSpacetimeFps(int prm_fps);

    /**
     * ̐́AƂŏԒPʂ̏uԂn .
     */
    virtual void presentSpacetimeMoment();

    /**
     * ̐́AnꂽŏԒPʂ̏uԂɂĐRi`FbNj .
     */
    virtual void executeSpacetimeJudge();

    /**
     * ̐́AnꂽŏԒPʂ̏uԂ .
     */
    virtual void makeSpacetimeMaterialize();

    /**
     * ̐ɕ`AيE̐lԋɂFiڎjł悤ɕ\ʉ .
     */
    virtual void presentSpacetimeVisualize();

    /**
     * ̐̎̍ŏԒPʂ̏uԂn邽߂̏An .
     */
    virtual void finalizeSpacetime();

    /**
     * ̐擾 .
     * ʂŃI[o[Ch\B<BR>
     * @return ̐
     */
    virtual Spacetime* getSpacetime() {
        return _pSpacetime;
    }

    /**
     * ̐n .
     * ʂł̐̑n@ĂB<BR>
     * @return ̐
     */
    virtual Spacetime* createSpacetime() = 0;

    /**
     * `ꎞ~At[ƎԂ̓s
     */
    void syncTimeFrame() {
        _sync_frame_time = true;
    }

    virtual void clean();

    /**
     * _u܂`Iv .
     * OɃR[obN܂B
     */
    virtual void oops() {
        _TRACE_("(-_-;) {Oops!");
    }

    /**
     * y .
     * @return 
     */
    static God* ask() {
        return GgafCore::God::_pGod;
    }

    virtual ~God();


private:

    DWORD* getArrTimeOffset(DWORD sec, DWORD fps);

    /**
     * _ɂ肩siCXbhgpj .
     * @param prm_cradle_no	肩ԍ
     * @param prm_pFunc	ۂɏjs֐̃|C^
     * @param prm_pWisher ]񂾐l
     * @param prm_pReceiver 󂯎\
     * @param prm_pArg1	js֐ւ̈1
     * @param prm_pArg2	js֐ւ̈2
     * @param prm_pArg3	js֐ւ̈3
     */
    void createCradle(uint64_t prm_cradle_no,
                      Object* (*prm_pFunc)(void*, void*, void*),
                      Object* prm_pWisher,
                      Object* prm_pReceiver,
                      void* prm_pArg1,
                      void* prm_pArg2,
                      void* prm_pArg3);

    /**
     * ]񂾖󂯎iCXbhgpj .
     * jꍇAj܂ő҂B<BR>
     * @param   prm_cradle_no	肩ԍ
     * @param   prm_pReceiver	l
     * @return	̃|C^
     */
    void* receive(uint64_t prm_cradle_no, Object* prm_pReceiver);

public:
    /** 擪̂肩 */
    Cradle* _pCradleRoot;
    /** ݏĵ肩 */
    Cradle* _pCradleBlessing;
    //_pCradleBlessing ́ASďjς݂̏ꍇAŏI肩wÂ
    //Sďjς݂A肩SĈꂽꍇ nullptr ɂȂB
    //_is_last_cradle_flg == false ɔ肵AŏI肩łȂȂiVK肩΁jA
    //jsĎɐi߂B _is_last_cradle_flg == false ɂȂ܂ŏjÂ
    // ܂A擪Ɩ̂肩|C^łȂĂ()

    //      _pCradleRoot
    //        
    //      pCradle <-> pCradle <-> pCradle <-> pCradle <-> pCradle <-> pCradle
    //     (j)     (j)   ijj   ()    ()    ()
    //                                                                 _is_last_cradle_flg == true
    //                           _pCradleBlessing
    //                      jIƉEɓ  ===>
    //
    //prev <------Â肩----------------------------------V肩-----> next
    //                                               肩͖ɂĂ
#ifdef _MSC_VER
    //x86nȂ΃Ag~bNEEEEEEEEB
    /** [r]ĂtO */
    volatile bool _is_loving_flg;
    /** [r]xރtO */
    volatile bool _have_to_rest_flg;
    /** [r]xłtO */
    volatile bool _is_resting_flg;
    /** [r]̂ */
    volatile bool _was_finished_flg;
#else
    /** [r]ĂtO */
    volatile std::atomic<bool> _is_loving_flg;
    /** [r]xރtO */
    volatile std::atomic<bool> _have_to_rest_flg;
    /** [r]xłtO */
    volatile std::atomic<bool> _is_resting_flg;
    /** [r]̂ */
    volatile std::atomic<bool> _was_finished_flg;
#endif
public:
    /**
     * _ɃAN^[jĂ炤߂́A肩iCXbhgpj .
     * @tparam X 肩AN^[̌^
     * @param prm_cradle_no 肩ԍ
     * @param prm_pFunc ۂɏjs֐̃|C^
     * @param prm_pWisher 肩
     * @param prm_pReceiver l
     * @param prm_pArg1 js֐ւ̈1
     * @param prm_pArg2 js֐ւ̈2
     * @param prm_pArg3 js֐ւ̈3
     */
    template<class X>
    void createActorCradle(uint64_t prm_cradle_no,
                           X* (*prm_pFunc)(void*, void*, void*),
                           Object* prm_pWisher,
                           Object* prm_pReceiver,
                           void* prm_pArg1,
                           void* prm_pArg2,
                           void* prm_pArg3) {
        createCradle(prm_cradle_no, (Object* (*)(void*, void*, void*))prm_pFunc, prm_pWisher, prm_pReceiver, prm_pArg1, prm_pArg2, prm_pArg3);
    }

    /**
     * _ɃV[쐬ijjĂ炤߂́A肩iCXbhgpj .
     * @tparam X 肩V[̌^
     * @param prm_cradle_no 肩ԍ
     * @param prm_pFunc	ۂɏjs֐̃|C^
     * @param prm_pWisher 肩
     * @param prm_pReceiver l
     * @param prm_pArg1	js֐ւ̈1
     * @param prm_pArg2	js֐ւ̈2
     * @param prm_pArg3	js֐ւ̈3
     */
    template<class X>
    void createSceneCradle(uint64_t prm_cradle_no,
                           X* (*prm_pFunc)(void*, void*, void*),
                           Object* prm_pWisher,
                           Object* prm_pReceiver,
                           void* prm_pArg1,
                           void* prm_pArg2,
                           void* prm_pArg3) {
        createCradle(prm_cradle_no, (Object* (*)(void*, void*, void*))prm_pFunc, prm_pWisher, prm_pReceiver, prm_pArg1, prm_pArg2, prm_pArg3);
    }

    /**
     * ]񂾃AN^[󂯎BiCXbhgpj .
     * CĂяo܂B<BR>
     * jꍇAj܂ő҂B<BR>
     * @param   prm_cradle_no 肩ԍ
     * @param   prm_pReceiver l
     * @return	ꂽAN^[̃|C^
     */
    MainActor* receive_Actor(uint64_t prm_cradle_no, Object* prm_pReceiver);

    /**
     * ]񂾃V[󂯎BiCXbhgpj .
     * CĂяo܂B<BR>
     * jꍇAj܂ő҂B<BR>
     * @param   prm_cradle_no 肩ԍ
     * @param   prm_pReceiver l
     * @return	ꂽV[̃|C^
     */
    MainScene* receive_Scene(uint64_t prm_cradle_no, Object* prm_pReceiver);

    /**
     * ]ŁAj܂ő҂āAɎ󂯎B
     * @tparam X 肩̌^
     * @param prm_pFunc
     * @param prm_pWisher
     * @param prm_pReceiver
     * @param prm_pArg1
     * @param prm_pArg2
     * @param prm_pArg3
     * @param prm_org
     * @return oオ
     */
    template<class X>
    X* makeObject(X* (*prm_pFunc)(void*, void*, void*),
                         Object* prm_pWisher,
                         Object* prm_pReceiver,
                         void* prm_pArg1,
                         void* prm_pArg2,
                         void* prm_pArg3,
                         Object* prm_org) {
        createCradle(ORDER_ID_MAX, (Object* (*)(void*, void*, void*))prm_pFunc, prm_pWisher, prm_pReceiver, prm_pArg1, prm_pArg2, prm_pArg3);
        return (X*)(receive(ORDER_ID_MAX, prm_org));
    }

    template<class X>
    X* makeActor(X* (*prm_pFunc)(void*, void*, void*),
                         Object* prm_pWisher,
                         Object* prm_pReceiver,
                         void* prm_pArg1,
                         void* prm_pArg2,
                         void* prm_pArg3,
                         Object* prm_org) {
        createActorCradle(ORDER_ID_MAX, (Object* (*)(void*, void*, void*))prm_pFunc, prm_pWisher, prm_pReceiver, prm_pArg1, prm_pArg2, prm_pArg3);
        return (X*)(receive_Actor(ORDER_ID_MAX, prm_org));
    }

    template<class X>
    X* makeScene(X* (*prm_pFunc)(void*, void*, void*),
                         Object* prm_pWisher,
                         Object* prm_pReceiver,
                         void* prm_pArg1,
                         void* prm_pArg2,
                         void* prm_pArg3,
                         Object* prm_org) {
        createSceneCradle(ORDER_ID_MAX, (Object* (*)(void*, void*, void*))prm_pFunc, prm_pWisher, prm_pReceiver, prm_pArg1, prm_pArg2, prm_pArg3);
        return (X*)(receive_Scene(ORDER_ID_MAX, prm_org));
    }

    /**
     * ]񂾖oオĂ邩ׂBiCXbhgpj .
     * @param prm_cradle_no   肩ԍ
     * @return 肩ԍ̖̐i(-2:_ĂȂ/-1:肩̂/0:肩͍݂邪j/1:j/2:jς݁j
     */
    int chkCradle(uint64_t prm_cradle_no);

    /**
     * ^ .
     * 肩|iCXbhgpj .
     * C̐_Ăяo܂B<BR>
     * _pCradleRoot wĂ肩̘AXgSĉ<BR>
     * ӁFKȉ̂悤ɃNeBJZNVň͂ŌĂяoĂIB<BR>
     * R[h၄ <BR>
     *     BEGIN_SYNCHRONIZED1; // ----->rJn<BR>
     * GgafCore::God::clean();<BR>
     *     END_SYNCHRONIZED1; // <----- rI<BR>
     */
    void flood();

    /**
     * e͂ .
     * @param prm_pReceiver 󂯎͂l
     */
    void repent(Object* prm_pReceiver);

    /**
     *  .
     * _iGodjݒ莞ɕʃXbhňxs܂B<BR>
     * _ʂ܂ŁiAvI܂ŁjiɈ܂B<BR>
     */
    static unsigned __stdcall love(void* prm_arg);

    /**
     * ï .
     * 肩tďja܂B
     * @param prm_arg
     */
    unsigned loveEternal(void* prm_arg);

    /**
     * _ꎞx~w iCXbhgpj .
     * ĂяoĂɋx~ԂɂȂƂ͌܂B<BR>
     * isResting() ŊSx~܂Œׂ鑱Kv܂B<BR>
     */
    void beginRest();
    /**
     * _̏Ԃ擾iCXbhgpj .
     * @return true=x~/false=ғ
     */
    bool isResting();

    /**
     * _x~̉w iCXbhgpj .
     */
    void finishRest();

    /**
     * j(͂P) .
     * @tparam X ̌^
     * @param p1 ׂ̈̈1 (gp)
     * @param p2 ׂ̈̈2 ()
     * @param p3 ׂ̈̈3 ()
     * @return ꂽ
     */
    template<class X>
    static X* bless(void* p1, void* p2, void* p3) {
        //p1 : 
        X* p = NEW X((const char*)p1);
        return p;
    }

    /**
     * j(͂Q) .
     * @tparam X ̌^
     * @param p1 ׂ̈̈1 (gp)
     * @param p2 ׂ̈̈2 (gp)
     * @param p3 ׂ̈̈3 ()
     * @return ꂽ
     */
    template<class X>
    static X* bless2(void* p1, void* p2, void* p3) {
        //p1 : 
        X* p = NEW X((const char*)p1, (const char*)p2);
        return p;
    }
    template<class X>
    static X* bless3(void* p1, void* p2, void* p3) {
        //p1 : 
        X* p = NEW X((const char*)p1, (const char*)p2, (const char*)p3);
        return p;
    }

    void debuginfo();

};


#define requestActor1(ID, CLASS)                   (GgafCore::God::_pGod->createActorCradle<CLASS>((ID),GgafCore::God::bless, this, this, (void*)(#CLASS "_" #ID),(void*)(nullptr),(void*)(nullptr)))
#define requestActor2(ID, CLASS, NAME)             (GgafCore::God::_pGod->createActorCradle<CLASS>((ID),GgafCore::God::bless, this, this, (void*)(NAME),(void*)(nullptr),(void*)(nullptr)))
#define requestActor3(ID, CLASS, NAME, ARG1)       (GgafCore::God::_pGod->createActorCradle<CLASS>((ID),GgafCore::God::bless2, this, this, (void*)(NAME),(void*)(ARG1),(void*)(nullptr)))
#define requestActor4(ID, CLASS, NAME, ARG1, ARG2) (GgafCore::God::_pGod->createActorCradle<CLASS>((ID),GgafCore::God::bless3, this, this, (void*)(NAME),(void*)(ARG1),(void*)(ARG2)))
#define selectRequestActorMacro(_1,_2,_3,_4,MACRO,...) MACRO

#define requestScene1(ID, CLASS)                   (GgafCore::God::_pGod->createSceneCradle<CLASS>((ID),GgafCore::God::bless, this, this, (void*)(#CLASS "_" #ID),(void*)(nullptr),(void*)(nullptr)))
#define requestScene2(ID, CLASS, NAME)             (GgafCore::God::_pGod->createSceneCradle<CLASS>((ID),GgafCore::God::bless, this, this, (void*)(NAME),(void*)(nullptr),(void*)(nullptr)))
#define requestScene3(ID, CLASS, NAME, ARG1)       (GgafCore::God::_pGod->createSceneCradle<CLASS>((ID),GgafCore::God::bless2, this, this, (void*)(NAME),(void*)(ARG1),(void*)(nullptr)))
#define requestScene4(ID, CLASS, NAME, ARG1, ARG2) (GgafCore::God::_pGod->createSceneCradle<CLASS>((ID),GgafCore::God::bless3, this, this, (void*)(NAME),(void*)(ARG1),(void*)(ARG2)))
#define selectRequestSceneMacro(_1,_2,_3,_4,MACRO,...) MACRO

#define desireActor1(CLASS)                   (GgafCore::God::_pGod->makeActor<CLASS>(GgafCore::God::bless, this, this, (void*)(#CLASS),(void*)(nullptr),(void*)(nullptr),this))
#define desireActor2(CLASS, NAME)             (GgafCore::God::_pGod->makeActor<CLASS>(GgafCore::God::bless, this, this, (void*)(NAME),(void*)(nullptr),(void*)(nullptr),this))
#define desireActor3(CLASS, NAME, ARG1)       (GgafCore::God::_pGod->makeActor<CLASS>(GgafCore::God::bless2, this, this, (void*)(NAME),(void*)(ARG1),(void*)(nullptr),this))
#define desireActor4(CLASS, NAME, ARG1, ARG2) (GgafCore::God::_pGod->makeActor<CLASS>(GgafCore::God::bless3, this, this, (void*)(NAME),(void*)(ARG1),(void*)(ARG2),this))
#define selectDesireActorMacro(_1,_2,_3,_4,MACRO,...) MACRO

#define desireScene1(CLASS)                   (GgafCore::God::_pGod->makeScene<CLASS>(GgafCore::God::bless, this, this, (void*)(#CLASS),(void*)(nullptr),(void*)(nullptr),this))
#define desireScene2(CLASS, NAME)             (GgafCore::God::_pGod->makeScene<CLASS>(GgafCore::God::bless, this, this, (void*)(NAME),(void*)(nullptr),(void*)(nullptr),this))
#define desireScene3(CLASS, NAME, ARG1)       (GgafCore::God::_pGod->makeScene<CLASS>(GgafCore::God::bless2, this, this, (void*)(NAME),(void*)(ARG1),(void*)(nullptr),this))
#define desireScene4(CLASS, NAME, ARG1, ARG2) (GgafCore::God::_pGod->makeScene<CLASS>(GgafCore::God::bless3, this, this, (void*)(NAME),(void*)(ARG1),(void*)(ARG2),this))
#define selectDesireSceneMacro(_1,_2,_3,_4,MACRO,...) MACRO

#ifdef _MSC_VER
    //MSVC̏ꍇ
    #define ___EXPAND( X ) X
    /** AN^[_ɖ] */
    #define requestActor(ID,...) ___EXPAND( selectRequestActorMacro(__VA_ARGS__,requestActor4,requestActor3,requestActor2,requestActor1)(ID,__VA_ARGS__) )
    /** V[_ɖ] */
    #define requestScene(ID,...) ___EXPAND( selectRequestSceneMacro(__VA_ARGS__,requestScene4,requestScene3,requestScene2,requestScene1)(ID,__VA_ARGS__) )
    /** V[_ɖ]݁AjA󂯎܂ŋ~ɑ҂ */
    #define desireActor(...) ___EXPAND( selectDesireActorMacro(__VA_ARGS__,desireActor4,desireActor3,desireActor2,desireActor1)(__VA_ARGS__) )
    /** V[_ɖ]݁AjA󂯎܂ŋ~ɑ҂ */
    #define desireScene(...) ___EXPAND( selectDesireSceneMacro(__VA_ARGS__,desireScene4,desireScene3,desireScene2,desireScene1)(__VA_ARGS__) )
#else
    //GCC̏ꍇ
    /** AN^[_ɖ] */
    #define requestActor(ID,...) selectRequestActorMacro(__VA_ARGS__,requestActor4,requestActor3,requestActor2,requestActor1)(ID,__VA_ARGS__)
    /** V[_ɖ] */
    #define requestScene(ID,...) selectRequestSceneMacro(__VA_ARGS__,requestScene4,requestScene3,requestScene2,requestScene1)(ID,__VA_ARGS__)
    /** V[_ɖ]݁AjA󂯎܂ŋ~ɑ҂ */
    #define desireActor(...) selectDesireActorMacro(__VA_ARGS__,desireActor4,desireActor3,desireActor2,desireActor1)(__VA_ARGS__)
    /** V[_ɖ]݁AjA󂯎܂ŋ~ɑ҂ */
    #define desireScene(...) selectDesireSceneMacro(__VA_ARGS__,desireScene4,desireScene3,desireScene2,desireScene1)(__VA_ARGS__)
#endif

/** ]܂jꂽAN^[󂯎 */
#define receiveActor(ID) (GgafCore::God::_pGod->receive_Actor((ID),this))
/** ]܂jꂽV[󂯎 */
#define receiveScene(ID) (GgafCore::God::_pGod->receive_Scene((ID),this))
}
#endif /*GGAF_CORE_GOD_H_*/
