#ifndef GGAF_CORE_ELEMENT_H_
#define GGAF_CORE_ELEMENT_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/Node.hpp"

#include "jp/ggaf/core/Progress.h"
#include "jp/ggaf/core/GarbageBox.h"
#include "jp/ggaf/core/exception/CriticalException.h"

namespace GgafCore {

/**
 * m[h(Node<T>)ɁAlXȏԊǗ@\ǉNX .
 * ^XNVXeɕKvȏԑJڋ@\ĂB<BR>
 * t[A_(God)́A̐(Spacetime)ɁÃ\bhɌĂяodg݂ɂȂĂB<BR>
 * nextFrame() > behave() > settleBehavior() > judge() > [preDraw() > draw() > afterDraw()] > doFinally() <BR>
 * AvP[Vɓoꂷm[h͑SāAu̐ṽc[ɏ邽߁ASm[hɑ΂ďL̏sB
 * L̓AnextFrame() ̂ݖt[KsB<BR>
 * behave(), settleBehavior(), judge(), doFinally() ́AԃtO(_is_active_in_the_tree_flg) trueAA
 * ꎞ~tO(_was_paused_flg) false ̏ꍇsB<BR>
 * preDraw(), draw(), afterDraw() ́At[܂ł̎cԂɗ]TꍇAsB<BR>
 * t[܂ł̎cԂɗ]TꍇA_͂3\bhXLbvB
 * AAXLbvƂĂAMAX_SKIP_FRAME t[ɂP͕KsB<BR>
 * L nextFrame() ` doFinally() ̏ʂŃI[o[Ch΁A^XNVXe̊łB<BR>
 * A\bh̒ڃI[o[Ch͔񐄏łBI[o[ChpɊe\bhŃR[obN<BR>
 * z֐(processXxxxxx()) pӂĂ̂ŁÃ\bhI[o[ChĉB<BR>
 * initialize() ́AL nextFrame() ` doFinally() ꂩĂяoOɃCX^XƂɂP񂾂Ă΂dg݂ɂȂĂB<BR>
 * tO(_can_live_flg)falsȅꍇ́AnextFrame() ` doFinally() ͑SĎsȂB<BR>
 * (NXFactor)
 * @tparam T Ǘvf̌^ǐ^̃|C^^ŊǗBj
 * @version 1.00
 * @since 2008/08/21
 * @author Masatoshi Tsuge
 */
template<class T>
class Element : public Node<T> {

private:
    /**
     * c[̔zm[hSĂɁAċAĂяosB
     * @param pFunc ċAĂяo郁\bh
     */
    inline void callRecursive(void (Element<T>::*pFunc)()) const {
        T* pElementTemp = Node<T>::_pChildFirst;
        while (pElementTemp) {
            (pElementTemp->*pFunc)(); //s
            if (pElementTemp->_is_last_flg) {
                break;
            } else {
                pElementTemp = pElementTemp->_pNext;
            }
        }
    }

    /**
     * c[̔zm[hSĂɁAċAĂяosB
     * @param pFunc ċAĂяo郁\bh(frame L)
     * @param prm_frame pFunc̈łframe
     */
    inline void callRecursive(void (Element<T>::*pFunc)(frame), frame prm_frame) const {
        T* pElementTemp = Node<T>::_pChildFirst;
        while (pElementTemp) {
            (pElementTemp->*pFunc)(prm_frame); //s
            if (pElementTemp->_is_last_flg) {
                break;
            } else {
                pElementTemp = pElementTemp->_pNext;
            }
        }
    }


public:
    /** [r]_ւ̋ߓ */
    God* _pGod;
    /** [r]initializesꂽǂ̃tO(true=sꂽ) */
    bool _was_initialize_flg;
    /** [r]m[ha(appendChildꂽj̃t[v(AA_was_paused_flg = true ͉Zꖳ) */
    frame _frame_of_life;
    /** [r]m[ha(appendChildꂽjAUt[v(AA_was_paused_flg = true  _is_active_flg = false ͉Zꖳ) */
    frame _frame_of_behaving;
    /** [r]m[hJn(onActive())̐Ut[v(AA_was_paused_flg = true  _is_active_flg = false ͉Zꖳ) */
    frame _frame_of_behaving_since_onActive;

    /** [r]m[htO */
    bool _is_active_flg;
    /** [r]m[htO(c[l) */
    bool _is_active_in_the_tree_flg;
    /** [r]ꎞ~tO */
    bool _was_paused_flg;
    /** [r]m[htO */
    bool _can_live_flg;

    /** [r]t[̈ꎞ~tOAt[̃t[Z _was_paused_flg ɔf */
    bool _was_paused_flg_in_next_frame;
    /** [r]I\ _frame_of_life */
    frame _frame_of_life_when_end;
    /** [r]Jn\ _frame_of_life */
    frame _frame_of_life_when_activation;
    /** [r]I\ _frame_of_life */
    frame _frame_of_life_when_inactivation;
    /** [r]ԕύX̃tOB0:R[obNȂ / 1:onInactive() / 2:onActive() */
    int _on_change_to;
    /** [r]Jgt[ňxłZbgstrueBt[ false ɍXV */
    bool _is_already_reset;
    /** [r]ԐiǗIuWFNg */
    Progress* _pProg;

public:
    /**
     * RXgN^
     * @param prm_name m[h́ij[Nɂĉj
     */
    explicit Element(const char* prm_name);

    /**
     * fXgN^Bc[m[hB .
     */
    virtual ~Element();

    /**
     * |(sΏہFzm[hSāAgdelete܂) .
     * _Ԃɗ]TłƂɁA_ĂтB<BR>
     * zm[h̒Ƀm[htO(_can_live_flg) false ɂȂĂm[h
     * prm_num_cleaning  delete B<BR>
     * @param prm_num_cleaning IuWFNg
     */
    virtual void clean(int prm_num_cleaning);

    /**
     * m[h(sΏہFthiŝ) .
     * CX^XAꂩĂяoOɁAŏɕKP񂾂ĂяoB<BR>
     * RXgN^initialize()̎gɂā<BR>
     * ERXgN^͈ŐɌĂяo邪Ainitialize() ̓c[ɑAJn钼OɌĂ΂B
     * Einitialize()  RXgN^ł͕sȁAz֐ĂׂƂbgB<BR>
     * Einitialize() ́APȂ֐Ȃ̂ŁACӂ̉ӏŖIɉxłĂяoƂ\B<BR>
     * ⑫Finitialize()ĂяoꂽAreset() ĂяoB
     */
    virtual void initialize() = 0;

    /**
     * m[h̃t[ZƁAt[JnɂĂ̂낢ȏ(sΏہFc[S) .
     * t[KsAɗlXȏԃtO̍XVsB <BR>
     * _is_active_flg_in_next_frame _was_paused_flg_in_next_frame _can_live_flg_in_next_frame <BR>
     * _is_active_flg _was_paused_flg _can_live_flg ɔfiRs[jB<BR>
     * ܂A_will_mv_first_in_next_frame_flg, _will_mv_last_in_next_frame_flg  true ̏ꍇ́A<BR>
     * ꂼAm[h̐擪m[hւ̈ړAm[hւ̈ړsB<BR>
     * ̌Azm[hSĂ nextFrame() ċAIɎsB<BR>
     * _(God)s郁\bhłAʏ͉ʃWbNł͎gpȂ͂łB<BR>
     * _(God)́A̐(Spacetime)ɑ΂ nextFrame() sA behave() s邱ƂɂȂB<BR>
     * ̂悤ȍ\̏ꍇAs͇@`L̏ƂȂB pre-order B<BR>
     * m[hԂŎQƊ֌Wꍇ́AӂKvB<BR>
     * <pre>
     * (o)̇@o(o)
     *         
     * (d)̇A`̇EȧJḃKċLd(`)
     *             
     *                                       
     * (g)̇BėCḟDg(e)    (k)̇FḣGi̇Hj̇Ik(h)
     *
     * {͐擪̏AAq݂ΐɎsA݂ȂΎ()sB
     * </pre>
     * \bhɁw(sΏہFc[S)xƋLqĂꍇ́ASďL̏ŎsB
     */
    virtual void nextFrame();

    /**
     * m[h̃t[̐U镑(sΏہFc[S) .
     * ̏ł́ASm[hWړsƂƂB<BR>
     * p processBehavior() R[obN邽߂̃tȌ́A<BR>
     * tOZbgAꎞ~tOAZbg<BR>
     * i _is_active_in_the_tree_flg && !_was_paused_flg j̏ꍇłB <BR>
     * behave()  z֐ processBehavior() R[Az̃m[hSĂɂ behave() ċAIɎsB<BR>
     * _(God)s郁\bhłAʏ͉ʃWbNŖ{\bh𒼐ڌĂяosȂƂƂB<BR>
     * ʃNXł̓R[ processBehavior() I[o[Chċ̓IȍWړWbNB <BR>
     * _(God)́A̐(Spacetime)ɑ΂ behave() sA settleBehavior() s邱ƂɂȂB<BR>
     */
    virtual void behave();

    /**
     * m[h̃t[̐U镑㏈(sΏہFc[S) .
     * ̏ł́ASm[hWړĂ邱Ƃۏ؂ꂽ̏sƂ݌vB<BR>
     * XVW񂩂Aɔ̗lXȃXe[^X̍XVōsړIƂ<BR>
     * p processSettlementBehavior() R[obN邽߂̃tȌ́A<BR>
     * ꎞ~tȌԂƖ֌WɎs_ behave() ƈقȂB<BR>
     * settleBehavior()́Az֐ processSettlementBehavior() R[Az̃m[hSĂɂ settleBehavior() ċAIɎsB<BR>
     * _(God)s郁\bhłAʏ͉ʃWbNŖ{\bh𒼐ڌĂяosȂƂƂB<BR>
     * ʃNXł̓R[ processSettlementBehavior() I[o[ChăWbN邱ƂƂB <BR>
     * _(God)́A̐(Spacetime)ɑ΂ settleBehavior() sA judge() s邱ƂɂȂB<BR>
     */
    virtual void settleBehavior();


    virtual void preJudge();
    /**
     * m[h̃t[̔菈(sΏہFc[S) .
     * ̏ł́Am[hԂ̗lXȔ菈sƂ݌vB<BR>
     * Sm[hWړƔȂXe[^Xނ̍XVSɊĂOƂ鏈sB<BR>
     * p processJudgement() R[obN邽߂̃tȌ́Abehave()ƓA<BR>
     * tOZbgAꎞ~tOAZbg<BR>
     * ܂ ( _is_active_in_the_tree_flg && !_was_paused_flg )̏ꍇ <BR>
     * judge()  z֐ processJudgement() R[Az̃m[hSĂɂ judge() ċAIɎsB<BR>
     * _(God)s郁\bhłAʏ͉ʃWbNŖ{\bh𒼐ڌĂяosȂƂƂB<BR>
     * ʃNXł̓R[ processJudgement() I[o[ChăWbN <BR>
     * _(God)́A̐(Spacetime)ɑ΂ judge() sA<BR>
     * _(God)͂̌At[܂ł̎cԂɗ]T preDraw()  doFinally() s邱ƂɂȂB<BR>
     */
    virtual void judge();

    /**
     * m[h̃t[̕`掖O(sΏہFc[S)it[XLbvČĂяoȂꍇBj .
     * p processPreDraw() R[obŃAtOZbg<BR>
     * ( _is_active_in_the_tree_flg )̏ꍇłB <BR>
     * processPreDraw() R[Az̃m[hSĂɂ preDraw() ċAIɎsB<BR>
     * _(God)s郁\bhłAʏ͉ʃWbNł͎gpȂ͂łB<BR>
     * ʃNXł̓R[ processPreDraw() I[o[ChăWbN <BR>
     * _(God)́A̐(Spacetime)ɑ΂ preDraw() sA draw() s邱ƂɂȂB<BR>
     */
    virtual void preDraw();

    /**
     * m[h̃t[̕`{(sΏہFc[S)it[XLbvČĂяoȂꍇBj .
     * p processDraw() R[obŃAtOZbg<BR>
     * (_is_active_in_the_tree_flg)̏ꍇłB <BR>
     * processDraw() R[Az̃m[hSĂɂ draw() ċAIɎsB<BR>
     * _(God)s郁\bhłAʏ͉ʃWbNł͎gpȂ͂łB<BR>
     * ʃNXł̓R[ processDraw() I[o[ChăWbN <BR>
     * _(God)́A̐(Spacetime)ɑ΂ draw() sA afterDraw() s邱ƂɂȂB<BR>
     */
    virtual void draw();

    /**
     * m[h̃t[̕`掖㏈(sΏہFc[S)it[XLbvČĂяoȂꍇBj .
     * p processAfterDraw() R[obŃAtOZbg<BR>
     * (_is_active_in_the_tree_flg)̏ꍇłB <BR>
     * processAfterDraw() R[Az̃m[hSĂɂ afterDraw() ċAIɎsB<BR>
     * _(God)s郁\bhłAʏ͉ʃWbNł͎gpȂ͂łB<BR>
     * ʃNXł̓R[ processAfterDraw() I[o[ChăWbN <BR>
     * _(God)́A̐(Spacetime)ɑ΂ afterDraw() sA doFinally() s邱ƂɂȂB<BR>
     */
    virtual void afterDraw();

    /**
     * m[h̃t[̍ŏI(sΏہFc[S) .
     * WړA菈A`揈IɁAŌɍsnsƂ݌vB<BR>
     * p processFinal() R[obŃA
     * tOZbgAꎞ~tOAZbg<BR>
     * i_is_active_in_the_tree_flg && !_was_paused_flgj̏ꍇłB <BR>
     * processFinal() R[Az̃m[hSĂɂ doFinally() ċAIɎsB<BR>
     * _(God)s郁\bhłAʏ͉ʃWbNł͎gpȂ͂łB<BR>
     * ʃNXł̓R[ processFinal() I[o[ChăWbN <BR>
     * _(God)́A̐(Spacetime)ɑ΂ doFinally() sA<BR>
     * t[܂ł̎cԂɗ]T clean() sB<BR>
     * ̌ nextFrame() s邱ƂɂȂB<BR>
     */
    virtual void doFinally();

    /**
     * 񊈓ɐ؂ւ̃R[obN([U[p) .
     * 񊈓Ԃ犈ԂɕωƂɁA behave() OɂPR[obNB<BR>
     * KvɉăI[o[ChB<BR>
     * R[^C~Oڍׁ
     * @񊈓ɐ؂ւ
     * nextFrame() AOt[̏ԃtOu񊈓ԁvŁAt[̏ԃtOuԁvƂȂꍇA
     * nextFrame() ŁAt[̏ԃtOuԁvɂAt[Z R[obN
     * AAPt[ڂ̎
     * ۂɂ݂͑ȂOt[(0t[)̏ԃtOȀlŁu񊈓ԁvƂĂׁB
     * A߂ nextFrame() ꍇAnextFrame() ŃR[obN邱ƂɂȂB
     */
    virtual void onActive() {
    }

    /**
     * 񊈓ɐ؂ւ̃R[obN([U[p) .
     * Ԃ񊈓ԂɕωƂɂPR[obNB<BR>
     * Ăяo^C~O̓t[ZłBʏ behave() OɎsB<BR>
     * KvɉăI[o[ChB<BR>
     */
    virtual void onInactive() {
    }

    /**
     * t[̌ʐU镑B([U[p) .
     * behave() ̏擪ŃR[obNB<BR>
     * ̃o֐ʃNXŃI[o[ChāAm[hʂ̐U镑B<BR>
     * z肵ĂU镑Ƃ́AɍWvZƈړłB<BR>
     * {o֐R[obNƌ́ASm[h΂āAnextFrame() sς݂ł邱Ƃۏ؂B<BR>
     */
    virtual void processBehavior() = 0;

    /**
     * t[̌ʐU镑㏈B(t[[Np) .
     */
    virtual void processSettlementBehavior() {}


    virtual void processPreJudgement() {}
    /**
     * t[̌ʔfB([U[p) .
     * judge() ̏擪ŃR[obNB<BR>
     * ̃o֐I[o[ChāAm[hʔfLqB<BR>
     * {o֐R[obNƌ́ASm[h΂ĂāAprocessBehavior() sς݂ł邱Ƃۏ؂B<BR>
     * {o֐݈̑Ӑ}ƂāAprocessBehavior() ōWړSĊA
     * {o֐œ蔻菈Ƃgz肵ĂB<BR>
     */
    virtual void processJudgement() = 0;

    /**
     * m[h̃t[̌ʕ`掖OB({t[[Np) .
     * preDraw() ̏擪ŃR[obNB AA_(God)`XLbvꍇAt[ŌĂяo܂B<BR>
     * ̃o֐I[o[ChāAm[hʕ`掖OB<BR>
     * ʕ`掖OƂ́Aɓwi`ȂǂłB<BR>
     * {o֐R[obNƌ́ASm[h΂āAprocessJudgement() sς݂ł邱Ƃۏ؂B<BR>
     * ɁA{o֐sAprocessDraw()AprocessAfterDraw() Ăяo邱Ƃۏ؂B
     */
    virtual void processPreDraw() {};

    /**
     * m[h̃t[̌ʕ`{B({t[[Np^[U[p) .
     * draw() ̏擪ŃR[obNB AApreDraw() Ɠlɐ_(God)`XLbvꂽꍇ́At[ŌĂяo܂B<BR>
     * ̃o֐I[o[ChāAm[hʕ`{B<BR>
     * ʕ`{Ƃ͎ɃLN^Awi̕`z肵ĂB
     * {o֐R[obNƌ́ASm[h΂āAprocessPreDraw() sς݂ł邱Ƃۏ؂B<BR>
     */
    virtual void processDraw() = 0;

    /**
     * m[h̃t[̌ʕ\㏈LqB({t[[Np) .
     * afterDraw() ̏擪ŃR[obNB AApreDraw() Ɠlɐ_(God)`XLbvꂽꍇ́At[ŌĂяo܂B<BR>
     * ̃o֐I[o[ChāAm[hʕ\㏈B<BR>
     * ʕ\㏈Ƃ́AőOʃC[ŎtF[hGtFNgAɍőOʂɕ\\ȂǂłB<BR>
     * {oR[obNƌ́ASm[h΂āAprocessDraw() sς݂ł邱Ƃۏ؂B<BR>
     */
    virtual void processAfterDraw() {};

    /**
     * m[h̃t[̌ʏI[B({t[[Np) .
     * doFinally() ̏擪ŃR[obNB<BR>
     * ̃o֐ʃNXŃI[o[ChāAm[hʂ̏I[B<BR>
     * I[Ƃ́AtOǗ̎sȂǂłB<BR>
     * z肵ĂU镑Ƃ́AɍWvZƈړłB̑ȂłǂłB<BR>
     * {o֐R[obNƌ́ASm[h΂āAprocessJudgement() sς݂ `揈͏IĂ邱Ƃۏ؂B<BR>
     */
    virtual void processFinal() {};

    /**
     * m[hƎm[heɂm[hSĂɃCxgbZ[Wʒm(ʒmΏہFc[S) .
     * AAm[h͐c[̈łȂΒʒm܂B<BR>
     * c[̈Ƃ́A_can_live_flg  _was_initialize_flg  true ł鎖łB<BR>
     * Cxg󂯎鑤́AonCatchEvent(hashval, void) KvłB<BR>
     * g onCatchEvent(hashval, void) ɂʒm̂ŒӂĉB<BR>
     * @param prm_no CxgbZ[Wԍ
     * @param prm_pSource  Cxgpėp|C^
     */
    virtual void throwEventUpperTree(hashval prm_no, void* prm_pSource);

    /**
     * m[hƎm[heɂm[hSĂɃCxgbZ[Wʒm(ʒmΏہFc[S) .
     * AAm[h͐c[̈łȂΒʒm܂B<BR>
     * c[̈Ƃ́A_can_live_flg  _was_initialize_flg  true ł鎖łB<BR>
     * Cxg󂯎鑤́AonCatchEvent(hashval, void) KvłB<BR>
     * g onCatchEvent(hashval, void) ɂʒm̂ŒӂĉB<BR>
     * ėp void* ɂ́Athis ݒ肳܂B<BR>
     * @param prm_no CxgbZ[Wԍ
     */
    virtual void throwEventUpperTree(hashval prm_no) {
        throwEventUpperTree(prm_no, this);
    }


    /**
     * m[hƂ̔zm[hSĂɃCxgbZ[Wʒm܂(ʒmΏہF̐eS) .
     * Cxg󂯎鑤́AonCatchEvent(hashval, void) KvłB<BR>
     * g onCatchEvent(hashval, void) ɂʒm̂ŒӂĉB<BR>
     * @param prm_no CxgbZ[Wԍ
     * @param prm_pSource  Cxgpėp|C^
     */
    virtual void throwEventLowerTree(hashval prm_no, void* prm_pSource);

    /**
     * m[hƂ̔zm[hSĂɃCxgbZ[Wʒm܂(ʒmΏہF̐eS) .
     * Cxg󂯎鑤́AonCatchEvent(hashval, void) KvłB<BR>
     * g onCatchEvent(hashval, void) ɂʒm̂ŒӂĉB<BR>
     * ėp void* ɂ́Athis ݒ肳܂B<BR>
     * @param prm_no CxgbZ[Wԍ
     */
    virtual void throwEventLowerTree(hashval prm_no) {
        throwEventLowerTree(prm_no, this);
    }

    /**
     * Cxg̃R[obN .
     * throwEventUpperTree() throwEventLowerTree() ŔꍇR[obN܂B<BR>
     * @param prm_no CxgbZ[Wԍ
     * @param prm_pSource  Cxgpėp|C^
     */
    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) {}


    virtual bool isDisappear();
    /**
     * _ɉy .
     * @return  Ă΂ďoĂ_
     */
    virtual God* askGod() = 0;

    //==================ԑJڃ\bhS==================>
    /**
     * Ԃɂ(sΏہFthis ̂) .
     * mɂ́Am[ht[犈Ԃɂ\tO𗧂ĂB<BR>
     * āAt[擪(nextFrame())ŁA߂ł(_is_active_flg = true)ɂȂB<BR>
     * ȌԂ񊈓Ȃ΁A擪 onActive() ̃R[obNsB<BR>
     * āA{\bhsĂwt[x͊Ԃ̕ω͖ѐ͕ۂB<BR>
     * zm[hɂ͉e܂B<BR>
     *  inactivateDelay() sς݂̏ꍇ́Aactivate()LɂȂB<BR>
     *  activateDelay() sς݂̏ꍇ́AwZt[1(activate() = activateDelay(1))㏑B<BR>
     * <B>[⑫]</B><BR>
     * m[h̓ftHgŊԂƂȂĂ邽߁Aŏ activate() svB<BR>
     * <B>yӁz</B><BR>
     * processBehavior()  g activate() ĂяoR[h͒ʏӖB<BR>
     * ^XNVXe̎dgݏ processBehavior() ͊Ԃɂ̂ݎŝŁAiɎsȂɂȂB<BR>
     */
    virtual void activate();

    /**
     * Ԃɂ(sΏہFc[S) .
     * gƔzm[hSĂɂčċAI activate() sB<BR>
     */
    virtual void activateTree();

    /**
     * xĂ犈Ԃɂ(sΏہFthis ̂) .
     * ̃t[x activate() sB<BR>
     * activateDelay(1) ́Aactivate() ƓӖɂȂB<BR>
     * @param prm_offset_frames xt[(1`)
     */
    virtual void activateDelay(frame prm_offset_frames = 1);

    /**
     * xĂ犈Ԃɂ(sΏہFc[S) .
     * gƔzm[hSĂɂčċAI activateDelay(frame) sB<BR>
     * activateTreeDelay(1) ́AactivateTree() ƓӖɂȂB<BR>
     * @param prm_offset_frames xt[(1`)
     */
    virtual void activateTreeDelay(frame prm_offset_frames = 1);

    /**
     * 莞ԂԂɂ(sΏہFthis ̂) .
     * ԂɂÃt[o߂ƁA񊈓ԂɂȂB
     * activateWhile(10); 
     * activate(); inactivateDelay(10); ̎sƓ̌ʂłB
     * @param prm_frames t[
     */
    virtual void activateWhile(frame prm_frames = 1);

    /**
     * ɊԂɂ(sΏہFthis ̂) .
     * ɏԃtOXV(_is_active_flg = true)B<BR>
     * onActive() R[obN͎sȂBȊOŖ{\bh̎gp͔񐄏B<BR>
     * ȉ̓_𗯈ӂĎgpۂ͒ӂKvłB<BR>
     * wt[xłĂAɏꂽm[hƖ̃m[hŁAقȂԂɂȂĂ܂B<BR>
     * ŁAũm[hԂȂ΁EEEvȀԁitOjɂ蕪򂵂ĂꍇA<BR>
     * t[̏ʂ̐鋰ꂪB<BR>
     * m[h̉eAc[\ǂlĎgp邱ƁB<BR>
     */
    virtual void activateImmed();

    /**
     * ɊԂɂ(sΏہFc[S) .
     * gƔzm[hSĂɂčċAI activateImmed() sB<BR>
     * activateImmed() ̐vQƁB<BR>
     * gpƂ́Am[h̉eǂlĒӂĎgp邱ƁB<BR>
     */
    virtual void activateTreeImmed();
    //===================

    /**
     * 񊈓Ԃɂ(sΏہFthis ̂) .
     * mɂ́Am[ht[񊈓Ԃɂ\tO𗧂ĂB<BR>
     * āAt[擪(nextFrame())ŁA{̔񊈓(_is_active_flg = false)ɂȂB<BR>
     * ȌԂԂȂ΁A擪 onInactive() ̃R[obNsB<BR>
     * āA{\bhsĂwt[x͊Ԃ̕ω͖ѐ͕ۂB<BR>
     * zm[hɂ͉e܂B<BR>
     */
    virtual void inactivate();

    /**
     * 񊈓Ԃɂ
     * gƔzm[hSĂɂčċAI inactivate() sB<BR>
     */
    virtual void inactivateTree();

    /**
     * xĂ񊈓Ԃɂ(sΏہFthis ̂) .
     * ̃t[x inactivate() sB<BR>
     * inactivateDelay(1) ́Ainactivate() ƓӖɂȂB<BR>
     * @param prm_offset_frames xt[(1`)
     */
    virtual void inactivateDelay(frame prm_offset_frames = 1);


    /**
     * xĂ犈Ԃɂ(sΏہFc[S) .
     * gƔzm[hSĂɂčċAI inactivateDelay(frame) sB<BR>
     * inactivateDelay(1) ́AinactivateTree() ƓӖɂȂB<BR>
     * @param prm_offset_frames xt[(1`)
     */
    virtual void inactivateTreeDelay(frame prm_offset_frames = 1);

    /**
     * ɔ񊈓Ԃɂ(sΏہFthis ̂) .
     * ɏԃtOXV(_is_active_flg = false)B<BR>
     * onInactive() R[obN͎sȂBȊOŖ{\bh̎gp͔񐄏B<BR>
     * ȉ̓_𗯈ӂĎgpۂ͒ӂKvłB<BR>
     * wt[xłĂAɏꂽm[hƖ̃m[hŁAقȂԂɂȂĂ܂B<BR>
     * ŁAũm[h񊈓ԂȂ΁EEEvȀԁitOjɂ蕪򂵂ĂꍇA<BR>
     * t[̏ʂ̐鋰ꂪB<BR>
     * m[h̉eAc[\ǂlĎgp邱ƁB<BR>
     */
    virtual void inactivateImmed();

    /**
     * ɔ񊈓Ԃɂ(sΏہFc[S) .
     * gƔzm[hSĂɂčċAI inactivateImmed() sB<BR>
     * inactivateImmed() ̐vQƁB<BR>
     * gpƂ́Am[h̉eǂlĒӂĎgp邱ƁB<BR>
     */
    virtual void inactivateTreeImmed();

    //===================
    /**
     * ꎞ~Ԃɂ(sΏہFthis ̂) .
     * mɂ́Am[ht[ꎞ~ɂ\tO𗧂ĂB<BR>
     * āAt[擪(nextFrame())ŁA߂łꎞ~(_was_paused_flg = true)ɂȂB<BR>
     * āA{\bhsĂwt[x͈ꎞ~Ԃ̕ω͖ѐ͕ۂB<BR>
     * zm[hɂ͉e܂B<BR>
     */
    virtual void pause();

    /**
     * ꎞ~Ԃɂ(sΏہFc[S) .
     * gƔzm[hSĂɂčċAI pause() sB<BR>
     */
    virtual void pauseTree();



    //===================
    /**
     * ꎞ~Ԃ(sΏہFthis ̂) .
     * mɂ́Am[ht[ꎞ~Ԃ\tO𗧂ĂB<BR>
     * āAt[擪(nextFrame())ŁA߂łꎞ~ԉ(_was_paused_flg = false)ɂȂB<BR>
     * āA{\bhsĂwt[x͈ꎞ~Ԃ̕ω͖ѐ͕ۂB<BR>
     * zm[hɂ͉e܂B<BR>
     */
    virtual void unpause();

    /**
     * ꎞ~Ԃ(sΏہFc[S) .
     * gƔzm[hSĂɂčċAI unpause() sB<BR>
     */
    virtual void unpauseTree();




    //===================
    /**
     * ԂZbg邽߂̏ł onReset() R[obNB(sΏہFthiŝ) .
     * ̂悤ȓwxɍs܂B<BR>
     * t[̐擪( nextFrame() )ł͂܂B<BR>
     * t[ŉx reset() ĂяoĂAPt[ onReset() ͂P񂵂Ă΂Ȃ
     * 悤ɂ邽߂̃\bhłB̂悤ɓ삷B<BR>
     * @ t[ŁA߂Ă̌Ăяoł邩`FbN<BR>
     *   E߂Ă̌ĂяołB   A<BR>
     *   EQȏĂяoĂB Ȃreturn<BR>
     * A ʎ onReset() R[obNB<BR>
     * ⑫: initialize() ĂяoɁAP񂾂 reset() ͎IɌĂяoB<BR>
     */
    virtual void reset();
    //  initialize(), onReset(), onActive() ̎gɂā
    // ԂZbǵAǂɎׂH
    // initialize() EEE Aŏ̂P񂾂OɃR[obNBɎgp邱ƂzB
    // onReset()    EEE Ainitialize() ̌AP񂾂ŃR[B
    //                     ̌ACӂ̃^C~O reset() sŃR[obNB
    // onActive()   EEE Ainitialize() ̌̊Ԏ Pt[ڂ behave() OɃR[B
    //                     ̌ 񊈓ԂɂȂAIɃR[obNB
    // m[h(AN^[V[)̏TCNɂĎgB
    // AN^[ÃRXgN^ŉȂꍇAŏ nextFrame() 
    // initialize()  onReset() onActive() ̏Ɏs邱ƂɂȂB
    //
    // EPTCNȃm[h(AN^[V[)̏ꍇ
    // A߂ẮuIvƂԂ}ۂɁÂ܂܉ƂȂꍇB܂ACX^Xg܂킳ȂꍇB
    // initialize(), onReset(), onActive() ͎OɊePŝŁAǂɏԂZbgĂق͖͂B
    // ̒ʏ̃AN^[AꎞIȒZV[͂ɊYƗ\zB
    // ǂɎĂǂAinitialize() Ŏ𓝈ꂵقÃIuWFNg瑀삵₷B
    //
    // EonActive() gpׂꍇ
    // ꂽm[hɁAu\()vu\(񊈓)vƂԂ݂Axg܂킷ꍇB
    // \() ` \(񊈓) Am[ĥPTCN̂ƈvꍇB
    // initialize() EEE A
    // onActive()   EEE ԃZbg
    // ƎgċLqB inacivate()Aactive() ŏԃZbgsB
    // Ȃ onReset() ɏԃZbgLqAreset()R[ł͂Ȃ̂ƂƁA
    // ̒Sł processBehavior() \bh́A\(񊈓) ̓R[Ȃ߁A
    // g̃IuWFNg̏ reset() LqĂs邱ƂƂԂɊׂB
    // ÃIuWFNgA\(񊈓)\() `FbNAreset() sĂ
    // ȂAZbĝAǂȂƕȂ悤ɂȂƂfbĝł͂Ȃ낤B
    // onActive() R[ĂAgetBehaveingFrame() ́uZbgȂvA
    // getActiveFrame()́uZbgv鎖ɒӁB
    // ɓGeȂǔėpIȃAN^[́AɊYƗ\zB
    //
    // EonReset() gpׂꍇ
    // ꂽm[hɁAu\()vu\(񊈓)vƂTOB\()ςȂB
    // ATCNiZbgj̊TOm[hꍇ
    // initialize() EEE A
    // onReset()    EEE ԃZbg
    // ƎgċLqB reset() ŏԃZbgsB
    // onReset() R[obŃAt[JE^́uZbgvɒӁB
    // ɃV[ƁAꕔ̃AN^[́AɊYƗ\zB
    //
    // EonActive() onReset() ĎgpׂꍇB
    // \() ` \(񊈓) Am[ĥPTCNƈvȂꍇA
    // initialize() EEE A
    // onActive()   EEE ʕ`掞
    // onReset()    EEE ԃZbg
    // ƎgċLqB inacivate()Aactivate()  reset() R[B
    // reset() ŏԃZbgsB
    // @͂ɊYƗ\zB
    //
    // Einitialize() onActive() onReset() ǂł悢ꍇB
    // \() ` \(񊈓) Am[h̐`ɈvꍇB
    // ܂胊ZbgƂg񂷊TOȂIuWFNǵAIuWFNg̏
    // initialize() onActive() onReset() ̉ɋLqĂقڈӖ͓łB
    // A\()܂łɃ^CO݂Ȃ΁AonActive() onReset() ̂ǂ炩
    // LqׂB


    /**
     * ԂZbg(sΏہFc[S) .
     * c[SẴIuWFNgɑ΂ reset() wxsB
     * reset() ̐vQƁB
     */
    virtual void resetTree();

    /**
     * ۂ̏ԂZbg鏈([U[p) .
     * reset() ́AresetTree() s邱ƂŃR[obNB
     * ʂ̂̏ԃZbgAʃNXŃI[o[ChĂB
     */
    virtual void onReset() {}


    /**
     * I錾B(sΏہFc[S) .
     * m[h̃t[ɁuIvԂɂ邱Ƃ錾BiI\tO𗧂Ăj <BR>
     * gƔzm[hSĂɂčċAI end(frame) sꐶI錾sB<br>
     * em[hI΁Aqm[hI𓾂ȂłB<BR>
     * ItO͈xĂƌɂǂ܂Bȍ~ end(frame) d˂ČĂяoĂA<BR>
     * ̗P\t[́Ãt[ɐIƂȂxt[łB<BR>
     * uIvƂ͋̓Iɂ́AU镑tO(_is_active_flg)AtO(_can_live_flg) A
     * AZbg\tO𗧂Ă邱ƎŁAP\t[̐擪( nextFrame() )ŎۂɃtOXV
     * {̏IԂɂȂB<BR>
     * _can_live_flg AZbg邱ƂɂAIɃc[؂藣S~(GarbageBox) zɁA
     * 邱ƂɂȂB̌A_(God)]T̂鎞 (FPSƂ) v炢 clean() \bhɂA<BR>
     * GarbageBox ɏzm[h delete 邵A[B<BR>
     * <b>yӁz</b><BR>
     * {\bhsĈ̗P\t[ɂȂĂA
     * GarbageBox zɈڂ邾ŁAɂ deleteƂ͌Ȃ߁A
     * s|C^ɂݓIoONBאS̒ӂ͂炨`iA߂j<BR>
     * @param prm_offset_frames IP\t[(1`)
     */
    virtual void end(frame prm_offset_frames = 1);

    /**
     * S~ɕ荞܂钼OɌĂяoR[obN(t[[Np) .
     * end(frame) sAS~(GarbageBox) Ɏ荞܂钼OɌĂяoB<BR>
     * ܂A_can_live_flg  false  true ɂȂɌĂяoB<BR>
     * łA܂c[ɏĂAg̃m[h̍͂܂؂ĂȂԂłB<BR>
     * őŁAend(frame) Ŏw肵t[ + GGAF_END_DELAY ɔB<BR>
     * ƁAȏ̐̃t[ŔB<BR>
     * OɏKvȏꍇ́AI[o[ChĎ\B<BR>
     */
    virtual void onEnd() {
    }

    /**
     * m[h񊈓犈Ԃɐ؂ւǂׂ .
     * onActive() Ă΂ꂽt[̂ true ɂȂB
     * onActive() I[o[ChŎꍇ́A̕Lqł͂B<BR>
     * ̃m[h̏ԕωm肽̂߂ɁA{\bh܂B<BR>
     * @return  bool true:񊈓犈Ԑ؂ւ^false:؂ւĂȂ
     */
    inline bool hasJustChangedToActive() const {
        return _on_change_to == 2 ? true : false;
    }

    /**
     * m[hԂ񊈓ɐ؂ւǂׂ .
     * onInctive() Ă΂ꂽt[̂ true ɂȂB
     * onInctive() I[o[ChŎꍇ́A̕Lqł͂B<BR>
     * ̃m[h̏ԕωm肽̂߂ɁA{\bh܂B<BR>
     * @return  bool true:Ԃ񊈓ɐ؂ւ^false:؂ւĂȂ
     */
    inline bool hasJustChangedToInactive() const {
        return _on_change_to == 1 ? true : false;
    }

    /**
     * \Ԃׂ
     * @return  bool true:\ԁ^false:s
     */
    inline bool canLive() const {
        return _can_live_flg;
    }

    /**
     * ׂ .
     * gtȌԂŊǂf
     * @return  bool true:^false:񊈓
     */
    inline bool isActive() const {
        return (_can_live_flg && _is_active_flg) ? true : false;
    }

    /**
     * c[Ŋǂf <BR>
     * Ƃ΁AgtȌԂŊłAełȂꍇA
     * g͊oȂBlŁA{ɊǂsB
     * @return true:c[Ŋ^false:c[Ŕ񊈓
     */
    inline bool isActiveInTheTree() const {
        return (_is_active_in_the_tree_flg && _can_live_flg) ? true : false;
    }

    /**
     * ꎞ~Ԃǂf
     * @return true:ꎞ~ԁ^false:ꎞ~Ԃł͖
     */
    inline bool wasPaused() const {
        return _was_paused_flg;
    }

    /**
     * I錾ǂ .
     * end(frame) sς݂ǂׂ܂B
     * @return true:I錾ς݁^false:܂I錾ĂȂ
     */
    inline bool wasDeclaredEnd() const {
        return (_frame_of_life_when_end > _frame_of_life || _can_live_flg == false) ? true : false;
    }

    /**
     * U镑ԎɉZt[擾 .
     * uU镑ԁvƂ́AcanBehave()  true ̏̎ӖB<BR>
     * 0 FrameԂ͊{݂A1 Frame ` ̒lɂȂBAOI<BR>
     * RXgN^AсAŏ initialize() ł 0 Frame ԂB<BR>
     * s onActive()AprocessBehavior()AprocessJudgement() ̒ 1 ɂȂĂB<BR>
     * ȍ~AU镑ԎɃt[ZB<BR>
     * @return U镑t[v
     */
    inline frame getBehaveingFrame() const {
        return _frame_of_behaving;
    }

    /**
     * ߂ onActive() JnU镑Ԃ͉t[ڂԂB .
     * ėpIuWFNgȂǁAxĎg܂킷(deleteȂ)ꍇA<BR>
     *  inactivate() Ao activate() JԂƂz肳B<BR>
     * ̂悤ȏꍇɁAt[ڂ擾ۂɓsǂ\bhB<BR>
     * onActive() R[obNɃZbg(0)AonActive() ł́A 0 ԂB<BR>
     * getBehaveingFrame() Ɠ^C~OŉZBprocessBehavior()ł́A1 ` ԂB<BR>
     * @return onActive() ̐U镑t[
     */
    inline frame getActiveFrame() const {
        return _frame_of_behaving_since_onActive;
    }

    /**
     * gƔzSẴIuWFNgɑ΂Ďẘ֐s .
     * zIuWFNgiAN^[V[j̃|C^A֐|C^ pFunc̑PɓnĂB<BR>
     * ֐|C^ pFunc ̑Qɂ́AexecuteFuncLowerTree Ăяo prm1(P)̃|C^nĂB<BR>
     * ֐|C^ pFunc ̑Rɂ́AexecuteFuncLowerTree Ăяo prm2(Q)̃|C^nĂB<BR>
     * ֐|C^ pFunc ̑Sɂ́AexecuteFuncLowerTree Ăяo prm3(R)̃|C^nĂB<BR>
     * z̃IuWFNgł̂ĂŎgpȂƊ댯łB<BR>
     *
     * gp၄<BR>
     * XXXXActor z̃IuWFNgSẴAN^[(AGgafDx::GeometricActor)̃oϐ _x ɁA
     * XXXXActoroϐ _velo ̒lZB<BR>
     * XXXXActor NX̎TvȉɋL<BR>
     * <code><pre>
     *
     * class XXXXActor : public GgafDx::GeometricActor {
     * public :
     *     int velo_;
     *
     *     static void addX(Object* pThat, void* p1, void* p2, void* p3) {
     *         if (pThat->instanceOf(Obj_GgafDx_GeometricActor)) { //GeometricActorȂ
     *             GgafDx::GeometricActor* pActor = (GgafDx::GeometricActor*)pThat;
     *             pActor->_x += (*((int*)p1));  //_x ZBp1 ɂ velo_ ւ̃|C^nĂ
     *         }
     *     }
     *
     *     void processBehavior() {
     *         //zAN^[SĂaddXs
     *         velo_ = 1000;
     *         executeFuncLowerTree(XXXXActor::addX, &velo_, nullptr, nullptr);
     *     }
     * }
     *
     * </pre></code>
     * @param pFunc IuWFNgɎs֐Bp[^(Object*, void*, void*, void*) ŒB
     * @param prm1 n̂P
     * @param prm2 n̂Q
     * @param prm3 n̂R
     */
    virtual void executeFuncLowerTree(void (*pFunc)(Object*, void*, void*, void*), void* prm1, void* prm2, void* prm3);

    /**
     * iǗIuWFNg(Progress) 擾B
     * @return iǗIuWFNg
     */
    inline virtual Progress* getProgress() const {
        return _pProg;
    }

    /**
     * {IuWFNg _frame_of_behaving Ɋ֘AAiǗIuWFNg(Progress) 𐶐擾 .
     * Ői̍XV͍sȂ̂ŁAĂяo updatesĂB
     * @param prm_num ȉꍇ̐
     * @return ViǗIuWFNg
     */
    virtual Progress* createProgress() {
        return NEW Progress(&_frame_of_behaving);
    }

    /**
     * c[lm[htO()
     */
    virtual void updateActiveInTheTree() = 0;

    /**
     * \肩ۂԂ .
     * @return
     */
    inline bool willActivateAfter() {
        if (_frame_of_life_when_activation > _frame_of_life) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 񊈓\肩ۂԂ .
     * @return
     */
    inline bool willInactivateAfter() {
        if (0 < _frame_of_life_when_inactivation &&
                _frame_of_life_when_inactivation > _frame_of_life) {
            return true;
        } else {
            return false;
        }
    }
};

///////////////////////////////////////////////////////////////// ͎

template<class T>
Element<T>::Element(const char* prm_name) :
    Node<T>(prm_name),
    _pGod(nullptr),
    _was_initialize_flg(false),
    _frame_of_life(0),
    _frame_of_behaving(0),
    _frame_of_behaving_since_onActive(0),
    _is_active_flg(false),             //falseł邪AȂƏnextFrame()ŃANeBuɂȂ\
    _is_active_in_the_tree_flg(false),
    _was_paused_flg(false),
    _can_live_flg(true),
    _was_paused_flg_in_next_frame(false),
    _frame_of_life_when_end(0),
    _frame_of_life_when_activation(1), //t[ɃANeBuɂȂ邽߂1
    _frame_of_life_when_inactivation(0),
    _on_change_to(0),
    _is_already_reset(false),
    _pProg(nullptr)
{
}

template<class T>
void Element<T>::nextFrame() {
    _was_paused_flg = _was_paused_flg_in_next_frame;
    if (!_was_paused_flg) {
        const frame frame_of_life = (++_frame_of_life);
        _is_already_reset = false;
        if (frame_of_life == _frame_of_life_when_end) {
            _can_live_flg = false; //I̎
        } else {
            if (_is_active_flg) {  //activate
                if (frame_of_life == _frame_of_life_when_inactivation) { // activate AinactivateɂȂ鎞
                    _on_change_to = 1;
                    _is_active_flg = false; //tOOFF
                    _is_active_in_the_tree_flg = false;
                    onInactive(); //R[obN
                } else {
                    _on_change_to = 0;
                    updateActiveInTheTree();     //_is_active_in_the_tree_flg XV
                    if (_is_active_in_the_tree_flg) {
                        _frame_of_behaving++;
                        if (_pProg) {  _pProg->update();  } // i𔽉f
                        _frame_of_behaving_since_onActive++;
                    }
                }

            } else { //inactivate
                if(frame_of_life == _frame_of_life_when_activation) { //inactivate AactivateɂȂ鎞
                    _on_change_to = 2;      //onActive
                    _is_active_flg = true;  //tOON
                    updateActiveInTheTree();     //_is_active_in_the_tree_flg XV
                    if (_is_active_in_the_tree_flg) {
                        _frame_of_behaving++;
                        if (_pProg) {  _pProg->update();  } // i𔽉f
                        _frame_of_behaving_since_onActive++;
                    }
                    if (!_was_initialize_flg) {
                        initialize();       //
                        _was_initialize_flg = true;
                        reset(); //Zbg
                    }
                    _frame_of_behaving_since_onActive = 0; //Zbg
                    onActive();   //R[obN
                    _frame_of_behaving_since_onActive = 1;
                } else {
                    _on_change_to = 0;
                    _is_active_in_the_tree_flg = false;
                }
            }
        }
    }
    //ċA
    //z̑Sm[hɍċAInextFrame()s
    T* p = Node<T>::_pChildFirst; //z̐擪m[hBꍇ͐ɐB
    if (p) {
        while (!p->_is_last_flg) {
            //z̐擪 ` -1 m[h nextFrame()
            p->nextFrame();  //ċA
            if (p->_can_live_flg) {
                p = p->_pNext;
            } else {
                p->onEnd();
                p = p->_pNext; //Ɉi܂đޔĂ
                GarbageBox::_pGarbageBox->add(p->_pPrev); //OS~(A؂)
            }
        }
        //z̍Ō̖m[h nextFrame()
        p->nextFrame(); //ċA
        if (p->_can_live_flg) {
            //OK ͖em[h̏
        } else {
            p->onEnd();
            GarbageBox::_pGarbageBox->add(p); //S~
        }
    }
}

template<class T>
void Element<T>::behave() {
    if (_is_active_in_the_tree_flg && !_was_paused_flg) {
        processBehavior();    //[U[p
        callRecursive(&Element<T>::behave); //ċA
    }
}

template<class T>
void Element<T>::settleBehavior() {
    if (_is_active_in_the_tree_flg) { //_was_paused_flg ͖YĂ܂
        processSettlementBehavior(); //t[[Np
        callRecursive(&Element<T>::settleBehavior); //ċA
    }
}

template<class T>
void Element<T>::preJudge() {
    if (_is_active_in_the_tree_flg) { //_was_paused_flg ͖YĂ܂
        processPreJudgement();    //t[[Np
        callRecursive(&Element<T>::preJudge); //ċA
    }
}

template<class T>
void Element<T>::judge() {
    if (_is_active_in_the_tree_flg && !_was_paused_flg) {
        processJudgement();    //[U[p
        callRecursive(&Element<T>::judge); //ċA
    }
}

template<class T>
void Element<T>::preDraw() {
    if (_is_active_in_the_tree_flg) {
        processPreDraw();
        callRecursive(&Element<T>::preDraw); //ċA
    }
}

template<class T>
void Element<T>::draw() {
    if (_is_active_in_the_tree_flg) {
        processDraw();
        callRecursive(&Element<T>::draw); //ċA
    }
}

template<class T>
void Element<T>::afterDraw() {
    if (_is_active_in_the_tree_flg) {
        processAfterDraw();
        callRecursive(&Element<T>::afterDraw); //ċA
    }
}

template<class T>
void Element<T>::doFinally() {
    if (_is_active_in_the_tree_flg && !_was_paused_flg) {
        processFinal();
        callRecursive(&Element<T>::doFinally); //ċA
    }
}

template<class T>
void Element<T>::reset() {
    if (_can_live_flg) {
        if(_was_initialize_flg == false) {
            initialize();       //
            _was_initialize_flg = true;
        }
        if (_is_already_reset == false) {
            onReset();
            _is_already_reset = true;
        }
    }
}

template<class T>
void Element<T>::resetTree() {
    if (_can_live_flg) {
        if(_was_initialize_flg == false) {
            initialize();       //
            _was_initialize_flg = true;
        }
        if (_is_already_reset == false) {
            onReset();
            _is_already_reset = true;
        }
        callRecursive(&Element<T>::resetTree); //ċA
    }
}

template<class T>
void Element<T>::activate() {
    if (_can_live_flg) {
        activateDelay(1);
    }
}

template<class T>
void Element<T>::activateTree() {
    if (_can_live_flg) {
        activateDelay(1);
        callRecursive(&Element<T>::activateTree); //ċA
    }
}

template<class T>
void Element<T>::activateImmed() {
    if (_can_live_flg) {
        if (!_was_initialize_flg) {
            initialize();       //
            _was_initialize_flg = true;
            reset(); //Zbg
        }
        _is_active_flg = true;
        _frame_of_life_when_activation = _frame_of_life;
        updateActiveInTheTree();
    }
}

template<class T>
void Element<T>::activateTreeImmed() {
    if (_can_live_flg) {
        activateImmed();
        callRecursive(&Element<T>::activateTreeImmed); //ċA
    }
}

template<class T>
void Element<T>::activateDelay(frame prm_offset_frames) {
#ifdef MY_DEBUG
    if (prm_offset_frames == 0) {
        throwCriticalException("activateDelay(0) ͖ӖłB܂ł activate() ܂IIIBӐ}Ă܂H name="<<Node<T>::_name<<" this="<<this);
    }
    if (prm_offset_frames >= 60*60*60) { //PԌ
        throwCriticalException("activateDelay("<<prm_offset_frames<<") Ēx񂿂ႤHB܂ł activate() ܂IIIB̐ɂȂ̂ƂHB name="<<Node<T>::_name<<" this="<<this);
    }
#endif
    if (_can_live_flg) {
#ifdef MY_DEBUG
        if (_is_active_flg) {
            _TRACE_("xactivateDelay("<<prm_offset_frames<<") ܂ǁAɊԂłBӐ}Ă܂H name="<<Node<T>::_name<<" this="<<this);
        }
#endif
        //inactivateDelay()sς݂̏ꍇ
        //inactivateDelay()͖B
        //
        //inactivate();
        //activate();
        //̏ɎsƁAactivate() ŏ
        //activate();
        //inactivate();
        //̏ɎsƁAinactivate() 
        //activateDelay()sς݂̏ꍇ́AwZt[ŏ㏑i㏟jB
        //(inactivateDelay() ƗD̍lႤߒ)
        _frame_of_life_when_inactivation = 0;
        _frame_of_life_when_activation = _frame_of_life + prm_offset_frames;
    }
}

template<class T>
void Element<T>::activateWhile(frame prm_frames) {
#ifdef MY_DEBUG
    if (prm_frames == 0) {
        throwCriticalException("activateWhile(0) ͖ӖłB܂ł activate() ܂IIIBӐ}Ă܂H name="<<Node<T>::_name<<" this="<<this);
    }
    if (prm_frames >= 60*60*60) { //PԌ
        throwCriticalException("activateWhile("<<prm_frames<<") Ēx񂿂ႤHB܂ł activate() ܂I̐ɂȂ̂ƂHB name="<<Node<T>::_name<<" this="<<this);
    }
#endif
    if (_can_live_flg) {
        _frame_of_life_when_activation = _frame_of_life + 1;
        _frame_of_life_when_inactivation = _frame_of_life + prm_frames;
    }
}

template<class T>
void Element<T>::activateTreeDelay(frame prm_offset_frames) {
#ifdef MY_DEBUG
    if (prm_offset_frames == 0) {
        throwCriticalException("activateTreeDelay(0) ͖ӖłB܂ł activate() ܂IIIBӐ}Ă܂H name="<<Node<T>::_name<<" this="<<this);
    }
    if (prm_offset_frames >= 60*60*60) { //PԌ
        throwCriticalException("activateTreeDelay("<<prm_offset_frames<<") Ēx񂿂ႤHB܂ł activate() ܂I̐ɂȂ̂ƂH name="<<Node<T>::_name<<" this="<<this);
    }
#endif
    if (_can_live_flg) {
        activateDelay(prm_offset_frames);
        callRecursive(&Element<T>::activateTreeDelay, prm_offset_frames); //ċA
    }
}

template<class T>
void Element<T>::inactivate() {
    if (_can_live_flg) {
        inactivateDelay(1);
    }
}

template<class T>
void Element<T>::inactivateTree() {
    if (_can_live_flg) {
        inactivateDelay(1);
        callRecursive(&Element<T>::inactivateTree); //ċA
    }
}

template<class T>
void Element<T>::inactivateDelay(frame prm_offset_frames) {
#ifdef MY_DEBUG
    if (prm_offset_frames == 0) {
        throwCriticalException("inactivateDelay(0) ͖ӖłB܂ł inactivate() ܂IIIBӐ}Ă܂H name="<<Node<T>::_name<<" this="<<this);
    }
    if (prm_offset_frames >= 60*60*60) { //PԌ
        throwCriticalException("inactivateDelay("<<prm_offset_frames<<") Ēx񂿂ႤHB܂ł inactivate() ܂I̐ɂȂ̂ƂH name="<<Node<T>::_name<<" this="<<this);
    }
#endif
    if (_can_live_flg) {


        if (_frame_of_life_when_activation >= _frame_of_life + prm_offset_frames) {
            //inactive Ɠt[A܂ inactive \ active \Ȃ΁A
            //(activeɂ͂ȂȂ悤ɂ邽)ɂB
            //activate();
            //inactivate();
            //̏ɎsƁAinactivate() 
            _frame_of_life_when_activation = 0;
        }

        //inactivateDelay()sς݂̏ꍇA̎w肪A
        //葁 inactivate wȂΏ㏑邪A
        //x inactivate wȂ΁Aߋinactivate D
        if (0 < _frame_of_life_when_inactivation &&
                _frame_of_life_when_inactivation < _frame_of_life + prm_offset_frames) {
            //wZt[̕xꍇ͖B
            return;
        } else {
            //inactivate\
            _frame_of_life_when_inactivation = _frame_of_life + prm_offset_frames;
        }
    }
}

template<class T>
void Element<T>::inactivateTreeDelay(frame prm_offset_frames) {
#ifdef MY_DEBUG
    if (prm_offset_frames == 0) {
        throwCriticalException("inactivateTreeDelay(0) ͖ӖłB܂ł inactivate() ܂IIIBӐ}Ă܂H name="<<Node<T>::_name<<" this="<<this);
    }
    if (prm_offset_frames >= 60*60*60) { //PԌ
        throwCriticalException("inactivateTreeDelay("<<prm_offset_frames<<") Ēx񂿂ႤHB܂ł inactivate() ܂I̐ɂȂ̂ƂH name="<<Node<T>::_name<<" this="<<this);
    }
#endif
    if (_can_live_flg) {
        inactivateDelay(prm_offset_frames);
        callRecursive(&Element<T>::inactivateTreeDelay, prm_offset_frames); //ċA
    }
}

template<class T>
void Element<T>::inactivateImmed() {
#ifdef MY_DEBUG
    if (_frame_of_life == 0) {
        throwCriticalException("inactivateImmed() AN^[シinactivateImmed()邱Ƃ͖ӖłBinactivate()ŗǂȂłH name="<<Node<T>::_name<<" this="<<this);
    }
#endif
    if (_can_live_flg) {
        _is_active_flg = false;
        _frame_of_life_when_inactivation = _frame_of_life;
        updateActiveInTheTree();
    }
}

template<class T>
void Element<T>::inactivateTreeImmed() {
    if (_can_live_flg) {
        inactivateImmed();
        callRecursive(&Element<T>::inactivateTreeImmed); //ċA
    }
}

template<class T>
void Element<T>::pauseTree() {
    if (_can_live_flg) {
        _was_paused_flg_in_next_frame = true;
        callRecursive(&Element<T>::pauseTree); //ċA
    }
}

template<class T>
void Element<T>::pause() {
    if (_can_live_flg) {
        _was_paused_flg_in_next_frame = true;
    }
}

template<class T>
void Element<T>::unpauseTree() {
    if (_can_live_flg) {
        _was_paused_flg_in_next_frame = false;
        callRecursive(&Element<T>::unpauseTree); //ċA
    }
}

template<class T>
void Element<T>::unpause() {
    if (_can_live_flg) {
        _was_paused_flg_in_next_frame = false;
    }
}

template<class T>
void Element<T>::end(frame prm_offset_frames) {
    if (_frame_of_life < _frame_of_life_when_end &&
                         _frame_of_life_when_end < _frame_of_life + prm_offset_frames + GGAF_END_DELAY) {
        //end()sς݂łAɍŵ _frame_of_life_when_end ɓB邽ߖB
        return;
    }
    _frame_of_life_when_end = _frame_of_life + prm_offset_frames + GGAF_END_DELAY;
    inactivateDelay(prm_offset_frames);
    //wt[ɂ́A܂inactivatesA+GGAF_END_DELAY t[ _can_live_flg = falseɂȂB
    //onEnd() _can_live_flg = false 
    T* pElementTemp = Node<T>::_pChildFirst;
    while (pElementTemp) {
        pElementTemp->end(prm_offset_frames);
        if (pElementTemp->_is_last_flg) {
            break;
        } else {
            pElementTemp = pElementTemp->_pNext;
        }
    }
}

//template<class T>
//T* Element<T>::extract() {
//    if (_can_live_flg) {
//        return extract();
//    } else {
//        //_TRACE_("[Element<"<<_class_name<<">::extract()] x "<<getName()<<"́Ał܂B");
//        return extract();
//    }
//}

template<class T>
void Element<T>::clean(int prm_num_cleaning) {
    if (Node<T>::_pChildFirst == nullptr) {
        return;
    }

    T* pElementTemp = Node<T>::_pChildFirst->_pPrev;
    T* pWk;

    while (GarbageBox::_cnt_cleaned < prm_num_cleaning) {
        if (pElementTemp->_pChildFirst) {
            //q̎q܂̂Ăꍇɂ
            pElementTemp->clean(prm_num_cleaning);
            if (GarbageBox::_cnt_cleaned >= prm_num_cleaning) {
                break;
            }
        }
        if (pElementTemp->_is_first_flg) { //Ō̈
            if (pElementTemp->_pChildFirst) {
                //q̎q܂̂Ăꍇɂ
                pElementTemp->clean(prm_num_cleaning);
                if (GarbageBox::_cnt_cleaned >= prm_num_cleaning) {
                    break;
                }
            }
            GGAF_DELETE(pElementTemp);
            GarbageBox::_cnt_cleaned++;
            if (GarbageBox::_cnt_cleaned >= prm_num_cleaning) {
                break;
            }
            break;
        } else {
            pWk = pElementTemp;
            if (pWk->_pChildFirst) {
                //q̎q܂̂Ăꍇɂ
                pWk->clean(prm_num_cleaning);
                if (GarbageBox::_cnt_cleaned >= prm_num_cleaning) {
                    break;
                }
            }
            pElementTemp = pElementTemp->_pPrev;
            GGAF_DELETE(pWk);
            GarbageBox::_cnt_cleaned++;
            if (GarbageBox::_cnt_cleaned >= prm_num_cleaning) {
                break;
            }
        }
    }
}

template<class T>
void Element<T>::executeFuncLowerTree(void (*pFunc)(Object*, void*, void*, void*), void* prm1, void* prm2, void* prm3) {
    if (_can_live_flg && _is_active_flg) {
        pFunc(this, prm1, prm2, prm3);
        T* pElementTemp = Node<T>::_pChildFirst;
        while (pElementTemp) {
            pElementTemp->executeFuncLowerTree(pFunc, prm1, prm2, prm3);
            if (pElementTemp->_is_last_flg) {
                break;
            } else {
                pElementTemp = pElementTemp->_pNext;
            }
        }
    }
}

template<class T>
void Element<T>::throwEventLowerTree(hashval prm_no, void* prm_pSource) {
    if (_can_live_flg) {
        onCatchEvent(prm_no, prm_pSource);
        T* pElementTemp = Node<T>::_pChildFirst;
        while (pElementTemp) {
            pElementTemp->throwEventLowerTree(prm_no, prm_pSource);
            if (pElementTemp->_is_last_flg) {
                break;
            } else {
                pElementTemp = pElementTemp->_pNext;
            }
        }
    }
}

template<class T>
void Element<T>::throwEventUpperTree(hashval prm_no, void* prm_pSource) {
    if (_can_live_flg) {
        onCatchEvent(prm_no, prm_pSource);
        if (Node<T>::_pParent) {
            T* pElementTemp = Node<T>::_pParent;
            pElementTemp->throwEventUpperTree(prm_no, prm_pSource);
        } else {
            //c[̒_Ȃ̂ŁAċAI
        }
    }
}

template<class T>
bool Element<T>::isDisappear() {
    if (_is_active_in_the_tree_flg == false) {
        return true;
    } else {
        return false;
    }
}

template<class T>
Element<T>::~Element() {
    GGAF_DELETE_NULLABLE(_pProg);
}

}
#endif /*GGAF_CORE_ELEMENT_H_*/
