#ifndef GGAFDXCORE_GGAFDXUTIL_H_
#define GGAFDXCORE_GGAFDXUTIL_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/util/GgafUtil.h"

#include <math.h>

#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dxcore/util/GgafDxSphereRadiusVectors.h"
#include "jp/ggaf/dxcore/util/GgafDxGeoElem.h"
#include "jp/ggaf/dxcore/actor/GgafDxGeometricActor.h"
#include "jp/ggaf/dxcore/actor/GgafDxCamera.h"

#ifdef UTIL
    #undef UTIL
#endif
#define UTIL GgafDxCore::GgafDxUtil

////Cxgp uint32_t l錾
HASHVAL(GGAF_EVENT_ON_DEVICE_LOST);

namespace GgafDxCore {

/**
 * [eBeBNX .
 * ÓIȍWvZ֘A֐̓RRɏW񂵂ĂB
 * @version 1.00
 * @since 2008/09/08
 * @author Masatoshi Tsuge
 */
class GgafDxUtil : public GgafCore::GgafUtil {

    struct AngleSet {
        angle rz[D360SANG+1];
        angle ry[D360SANG+1];
    };

public:

    //static float PARABORA[];
    /**
     * cose[u .
     * vfԍ͈́F0 ~ D360SANG
     * anglel r  cośACOS[r/SANG_RATE]
     */
    static float COS[];
    /**
     * sine[u .
     * vfԍ͈́F0 ~ D360SANG
     * anglel r  sin ́ASIN[r/SANG_RATE]
     */
    static float SIN[];

    /**
     * ʓx@ϊe[u .
     * vfԍ͈́F0 ~ D360SANG
     * anglel r ̃fBÁARAD[r/SANG_RATE]
     */
    static float RAD[];
    /**
     * [X]  anglelϊe[u
     * vfԍ͈́F y = ax X a  10000 {̐xvfԍƂȂB
     *  y = ax ̐p̃AOl SLANT2ANG[(int)a*10000] ƂȂB
     */
    static angle SLANT2ANG[];
    /**
     * ʎˉeɂłȂp  2̉]p  ̕ϊe[u(1-1) .
     * xNgA[XYʂ֎ˉêȂp][XZʂ֎ˉêȂp]  ̕xNgZ]p ̕ϊe[u
     */
    static angle PROJANG_XY_XZ_TO_ROTANG_z[D90SANG+1][D90SANG+1];
    /**
     * ʎˉeɂłȂp  2̉]p  ̕ϊe[u(1-2) .
     * xNgA[XYʂ֎ˉêȂp][XZʂ֎ˉêȂp]  ̕xNgY(t)]p ̕ϊe[u
     */
    static angle PROJANG_XY_XZ_TO_ROTANG_y_REV[D90SANG+1][D90SANG+1];
    /**
     * ʎˉeɂłȂp  2̉]p  ̕ϊe[u(2-1) .
     * xNgA[ZYʂ֎ˉêȂp][ZXʂ֎ˉêȂp]  ̕xNgX(t)]p ̕ϊe[u
     */
    static angle PROJANG_ZY_ZX_TO_ROTANG_x_REV[D90SANG+1][D90SANG+1];
    /**
     * ʎˉeɂłȂp  2̉]p  ̕ϊe[u(2-2) .
     * xNgA[ZYʂ֎ˉêȂp][ZXʂ֎ˉêȂp]  ̕xNgY]p ̕ϊe[u
     */
    static angle PROJANG_ZY_ZX_TO_ROTANG_y[D90SANG+1][D90SANG+1];

    /**
     * v = 1 - cos(2t)
     * ̉e[u
     * yz
     * t:(t[)
     * v:x
     * ʐρړ
     * t = 0.00.51.0 ΂ĂȂ߂炩 v = 0.0`2.0`0.0 ƕωA1.0ړ
     */
    static double SMOOTH_DV[3600+1];

    /**
     * a 1000  1/4 ~̉e[u .
     * <pre><code>
     *      ______________
     * y = (1000^2-x^2)
     * </code></pre>
     *  vf[x] ɑ΂ y
     */
    static float ROOT_1_MINUS_XX[1000];

    /**
     * p .
     * vf[x](0`999)  x Ԗڂ̉pB
     */
    static angle GOLDEN_ANG[1000];

    static uint32_t BITNUM[];

    static GgafDxSphereRadiusVectors _srv;

    static bool _was_inited_flg;

    static GgafDxCamera* _pCam;
public:
    static void init();

    /**
     * ʏ̃xNg(vx, vy) 錴_̂ȂpԂ .
     * @param prm_vx xNg x vf
     * @param prm_vy xNg y vf
     * @return Ȃp̃AOl (0 ` 360000)
     */
    static angle getAngle2D(int prm_vx, int prm_vy) {
        if (prm_vx == 0) {
            if (prm_vy > 0) {
                return D90ANG;
            } else if (prm_vy < 0) {
                return D270ANG;
            } else {
                //_łAsB
                return 0;
            }
        }
        if (prm_vy == 0) {
            if (prm_vx > 0) {
                return 0;
            } else if (prm_vx < 0) {
                return D180ANG;
            } else {
                //_łAsB
                return 0;
            }
        }

        if (prm_vx >= 0 && prm_vy >= 0) { //1ی
            if (prm_vx >= prm_vy) {
                return D0ANG  + SLANT2ANG[(int)(((double)prm_vy)/prm_vx*100000.0)];
            } else {
                return D90ANG - SLANT2ANG[(int)(((double)prm_vx)/prm_vy*100000.0)];
            }
        } else if (prm_vx <= 0 && prm_vy >= 0) { //2ی
            if (-prm_vx <= prm_vy) {
                return D90ANG + SLANT2ANG[(int)(((double)-prm_vx)/prm_vy*100000.0)];
            } else {
                return D180ANG - SLANT2ANG[(int)(((double)prm_vy)/-prm_vx*100000.0)];
            }
        } else if (prm_vx <= 0 && prm_vy <= 0) { //3ی
            if (-prm_vx >= -prm_vy) {
                return D180ANG + SLANT2ANG[(int)(((double)-prm_vy)/-prm_vx*100000.0)];
            } else {
                return D270ANG - SLANT2ANG[(int)(((double)-prm_vx)/-prm_vy*100000.0)];
            }
        } else if (prm_vx >= 0 && prm_vy <= 0) { //4ی
            if (prm_vx <= -prm_vy) {
                return D270ANG + SLANT2ANG[(int)(((double)prm_vx)/-prm_vy*100000.0)];
            } else {
                return D360ANG - SLANT2ANG[(int)(((double)-prm_vy)/prm_vx*100000.0)];
            }
        }
        return 0;
    }

    static angle getAngle2D(double prm_vx, double prm_vy) {
        if (ZEROd_EQ(prm_vx)) {
            if (prm_vy > 0.0) {
                return D90ANG;
            } else if (prm_vy < 0.0) {
                return D270ANG;
            } else {
                //_łAsB
                return 0;
            }
        }
        if (ZEROd_EQ(prm_vy)) {
            if (prm_vx > 0) {
                return 0;
            } else if (prm_vx < 0) {
                return D180ANG;
            } else {
                //_łAsB
                return 0;
            }
        }

        if (prm_vx >= 0.0 && prm_vy >= 0.0) { //1ی
            if (prm_vx >= prm_vy) {
                return D0ANG  + SLANT2ANG[(int)(prm_vy/prm_vx*100000.0)];
            } else {
                return D90ANG - SLANT2ANG[(int)(prm_vx/prm_vy*100000.0)];
            }
        } else if (prm_vx <= 0.0 && prm_vy >= 0.0) { //2ی
            if (-prm_vx <= prm_vy) {
                return D90ANG  + SLANT2ANG[(int)(-prm_vx/prm_vy*100000.0)];
            } else {
                return D180ANG - SLANT2ANG[(int)(prm_vy/-prm_vx*100000.0)];
            }
        } else if (prm_vx <= 0.0 && prm_vy <= 0.0) { //3ی
            if (-prm_vx >= -prm_vy) {
                return D180ANG + SLANT2ANG[(int)(-prm_vy/-prm_vx*100000.0)];
            } else {
                return D270ANG - SLANT2ANG[(int)(-prm_vx/-prm_vy*100000.0)];
            }
        } else if (prm_vx >= 0.0 && prm_vy <= 0.0) { //4ی
            if (prm_vx <= -prm_vy) {
                return D270ANG + SLANT2ANG[(int)(prm_vx/-prm_vy*100000.0)];
            } else {
                return D360ANG - SLANT2ANG[(int)(-prm_vy/prm_vx*100000.0)];
            }
        }
        return 0;
    }

    /**
     * AOl̍ .
     * TURN_CLOSE_TO         EEE ^[Qbg̉]pƋ߂̉]Ŏ擾AŐÁAE̒̕lɂȂB<BR>
     * TURN_ANTICLOSE_TO     EEE ^[Qbg̉]pƋ̉̕]Ŏ擾AŐÁAE̒̕lɂȂB<BR>
     * TURN_COUNTERCLOCKWISE EEE ]ōيp擾A̒lŕԂB<BR>
     * TURN_CLOCKWISE        EEE ]Eōيp擾A̒lŕԂB<BR>
     * @param prm_ang_from
     * @param prm_ang_to
     * @param prm_way TURN_CLOSE_TO/TURN_ANTICLOSE_TO/TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE
     * @return AOl̍iʂ v͐Av͕)
     */
    static angle getAngDiff(angle prm_ang_from, angle prm_ang_to, int prm_way=TURN_CLOSE_TO);

    /**
     * ʏɂāA'N'waye(N=)̎ˏoAOlZbg(z)Ŏ擾 .
     * @param prm_vx_Center     [in] 'N'wayȇŜƂČẮAxNgXvf
     * @param prm_vy_Center     [in] 'N'wayȇŜƂČẮAxNgYvf
     * @param prm_nWay          [in] 'N'waye N
     * @param prm_angClearance  [in] 'N'waye̒eƒeƂ̐pAOlŎw
     * @param out_paAngle       [out] 'N'waye ̃AOlz̃|C^
     */
    static void getWayAngle2D(int prm_vx_Center,
                              int prm_vy_Center,
                              int prm_nWay,
                              angle prm_angClearance,
                              int* out_paAngle);

    /**
     * ʏɂāA'N'waye(N=)̎ˏoAOlZbg(z)Ŏ擾 .
     * @param prm_angCenter     [in] 'N'wayȇŜƂČẴAOl
     * @param prm_nWay          [in] 'N'waye N
     * @param prm_angClearance  [in] 'N'waye̒eƒeƂ̐pAOlŎw
     * @param out_paAngle       [out] 'N'waye ̃AOlz̃|C^
     */
    static void getWayAngle2D(angle prm_angCenter, int prm_nWay, angle prm_angClearance, angle* out_paAngle);

    /**
     * ʏɂāAˏS'N'waye(N=)̃AOlzŎ擾 .
     * eƒeƂ̐p ϓɂȂ邱ƂƂB
     * ႦΑS4wayȅꍇAeƒeƂ̐p͒p(90000)ɂȂB
     * @param prm_angStart  ˏ̑S'N'wayêPڂ̒ẽAOl
     * @param prm_nWay  [in] 'N'waye NB
     * @param out_paAngle   [out] 'N'waye ̃AOlz̃|C^
     */
    static void getRadialAngle2D(angle prm_angStart, int prm_nWay, angle* out_paAngle);

    static void convRzRyToRyRz(angle prm_Rz, angle prm_Ry, angle& out_Ry, angle& out_Rz);

//    static void getWayAngle_LinedRzLongitude(angle prm_angCenterRz, angle prm_angCenterRy,
//                                           int prm_nWay, angle prm_angClearance,
//                                           angle* out_paAngleRz, angle* out_paAngleRy);

//    static void getMoveRzRyWayShot3D_XZ(int prm_nWay, angle prm_angClearance, coord prm_tx, coord prm_ty, coord prm_tz,
//                                        angle& out_angFaceZ, angle* out_paAngRotY);


    /**
     * AOl̉Z .
     * D360ANG 𒴂ꍇA 0 ꍇłA
     * 0`D360ANG ɕWB
     * @param prm_angNow AOlP
     * @param prm_angOffset AOlQ
     * @return Wꂽ AOlP + AOlQ ̃AOl
     */
    static angle addAng(angle prm_angNow, angle prm_angOffset);

    /**
     *
     * @param prm_x
     * @param prm_y
     * @param prm_ang
     * @param out_x
     * @param out_y
     */
    static void rotxy(coord prm_x, coord prm_y, angle prm_ang, coord& out_x, coord& out_y);

    /**
     * vZ(2D) .
     * @param x1
     * @param y1
     * @param x2
     * @param y2
     * @return
     */
    static int getDistance(coord x1, coord y1, coord x2, coord y2);

    /**
     * vZ(3D) .
     * @param x1
     * @param y1
     * @param z1
     * @param x2
     * @param y2
     * @param z2
     * @return
     */
    template<typename T>
    static T getDistance(T x1, T y1, T z1, T x2, T y2, T z2) {
        return (T)( sqrt(
                      (
                        ((double)(x2 - x1)) * ((double)(x2 - x1))
                      ) + (
                        ((double)(y2 - y1)) * ((double)(y2 - y1))
                      ) + (
                        ((double)(z2 - z1)) * ((double)(z2 - z1))
                      )
                    )
                 );
    }

    static double getDistance(GgafDxCore::GgafDxGeometricActor* pA1, GgafDxCore::GgafDxGeometricActor* pA2) {
        return sqrt(
                      (
                        ((double)(pA2->_x - pA1->_x)) * ((double)(pA2->_x - pA1->_x))
                      ) + (
                        ((double)(pA2->_y - pA1->_y)) * ((double)(pA2->_y - pA1->_y))
                      ) + (
                        ((double)(pA2->_z - pA1->_z)) * ((double)(pA2->_z - pA1->_z))
                      )
                    );
    }

    static double getDistance(GgafDxCore::GgafDxGeometricActor* pA1, GgafDxCore::GgafDxGeoElem* pA2) {
        return sqrt(
                      (
                        ((double)(pA2->x - pA1->_x)) * ((double)(pA2->x - pA1->_x))
                      ) + (
                        ((double)(pA2->y - pA1->_y)) * ((double)(pA2->y - pA1->_y))
                      ) + (
                        ((double)(pA2->z - pA1->_z)) * ((double)(pA2->z - pA1->_z))
                      )
                    );
    }

    static double getDistance(GgafDxCore::GgafDxGeoElem* pA1, GgafDxCore::GgafDxGeometricActor* pA2) {
        return sqrt(
                      (
                        ((double)(pA2->_x - pA1->x)) * ((double)(pA2->_x - pA1->x))
                      ) + (
                        ((double)(pA2->_y - pA1->y)) * ((double)(pA2->_y - pA1->y))
                      ) + (
                        ((double)(pA2->_z - pA1->z)) * ((double)(pA2->_z - pA1->z))
                      )
                    );
    }

    static double getDistance(GgafDxCore::GgafDxGeoElem* pA1 ,GgafDxCore::GgafDxGeoElem* pA2) {
        return sqrt(
                      (
                        ((double)(pA2->x - pA1->x)) * ((double)(pA2->x - pA1->x))
                      ) + (
                        ((double)(pA2->y - pA1->y)) * ((double)(pA2->y - pA1->y))
                      ) + (
                        ((double)(pA2->z - pA1->z)) * ((double)(pA2->z - pA1->z))
                      )
                    );
    }

    /**
     * _p[^WxNǵAZ]AOlY]AOl擾 .
     * ܂ŒPʕxNgQbgłB<BR>
     * Z]AOlY]AOl擾ߒŁA<BR>
     * xNg̐KsȂȂ΂ȂȂ߁AȂ̂Ŗ߂lɁB<BR>
     * @param x [in]XW
     * @param y [in]YW
     * @param z [in]ZW
     * @param out_nvx [out]PʃxNgXvf
     * @param out_nvy [out]PʃxNgYvf
     * @param out_nvz [out]PʃxNgZvf
     * @param out_angRz [out]Z]AOl
     * @param out_angRy [out]Y]AOl
     */
    static void convVectorToRzRy(coord x,
                                 coord y,
                                 coord z,
                                 float& out_nvx,
                                 float& out_nvy,
                                 float& out_nvz,
                                 angle& out_angRz,
                                 angle& out_angRy);

    /**
     * _(0,0,0) p[^W(vx,vy,vz) xNgɑΉuZ]̃AOlvƁuY]̃AOlv擾 .
     * {NX̒jƂׂ\bĥP<BR>
     * xNg -> ZY]p ̕ϊ<BR>
     * @param vx [in]XW
     * @param vy [in]YW
     * @param vz [in]ZW
     * @param out_angRz [out]Z]AOl
     * @param out_angRy [out]Y]AOl
     */
    static void convVectorToRzRy(coord vx, coord vy, coord vz, angle& out_angRz, angle& out_angRy);

    /**
     * _(0,0,0) p[^WxNg(PʃxNg)ɑΉuZ]̃AOlvƁuY]̃AOlv擾 .
     * {NX̒jƂׂ\bĥP<BR>
     * xNg -> ZY]p ̕ϊB<BR>
     * vZɃe[uQƂōɍsB<BR>
     * ŁAxNg̐KsȂ̂ <BR>
     * convVectorToRzRy(int, int, int , angle&, angle&);
     * ⍂BPʃxNg܂ĂƂ͂gp܂傤B<BR>
     * @param nvx [in]PʃxNgXvf
     * @param nvy [in]PʃxNgYvf
     * @param nvz [in]PʃxNgZvf
     * @param out_angRz [out]Z]AOl
     * @param out_angRy [out]Y]AOl
     */
    static void convVectorToRzRy(double nvx, double nvy, double nvz, angle& out_angRz, angle& out_angRy) {
        convVectorToRzRy((int)(nvx*100000),
                         (int)(nvy*100000),
                         (int)(nvz*100000),
                         out_angRz,
                         out_angRy );
    }

    static void convVectorToRzRy(float nvx, float nvy, float nvz, angle& out_angRz, angle& out_angRy) {
        convVectorToRzRy((int)(nvx*100000),
                         (int)(nvy*100000),
                         (int)(nvz*100000),
                         out_angRz,
                         out_angRy );
    }


    /**
     * Z]+Y]lPʕxNg擾
     * {NX̒jƂׂ\bh2<BR>
     * ZY]p -> xNg ̕ϊ<BR>
     * vZɃe[uQƂōɍsB<BR>
     * @param prm_ang_rz [in]Z]AOl
     * @param prm_ang_ry [in]Y]AOl
     * @param out_nvx [out]PʃxNgXvf
     * @param out_nvy [out]PʃxNgYvf
     * @param out_nvz [out]PʃxNgZvf
     */
    static void convRzRyToVector(angle prm_ang_rz,
                                 angle prm_ang_ry,
                                 float& out_nvx,
                                 float& out_nvy,
                                 float& out_nvz);
    /**
     * xNgK .
     * @param x
     * @param y
     * @param z
     * @param out_nvx
     * @param out_nvy
     * @param out_nvz
     */
    static void getNormalizeVector(dxcoord x,
                                   dxcoord y,
                                   dxcoord z,
                                   float& out_nvx,
                                   float& out_nvy,
                                   float& out_nvz);

    /**
     * xNgK .
     * @param x
     * @param y
     * @param z
     * @param out_nvx
     * @param out_nvy
     * @param out_nvz
     */
    static void getNormalizeVector(coord x,
                                   coord y,
                                   coord z,
                                   float& out_nvx,
                                   float& out_nvy,
                                   float& out_nvz);

    /**
     * ςAZ]+Y]̑gݍ킹ԂB
     * @param rz1
     * @param ry1
     */
    static void anotherRzRy(angle& rz1, angle& ry1) {
        int rz2 = 0;
        int ry2 = 0;
        if (0 <= rz1 && rz1 < D90ANG) {
            rz2 = D180ANG - rz1;

            if (0 <= ry1 && ry1 < D180ANG) {
                ry2 = ry1 + D180ANG;
            } else {
                ry2 = ry1 - D180ANG;
            }
        } else if (D90ANG <= rz1 && rz1 < D180ANG) {
            rz2 = D180ANG - rz1;
            if (0 <= ry1 && ry1 < D180ANG) {
                ry2 = ry1 + D180ANG;
            } else {
                ry2 = ry1 - D180ANG;
            }
        } else if (D180ANG <= rz1 && rz1 < D270ANG) {
            rz2 = D180ANG + (D360ANG - rz1);
            if (0 <= ry1 && ry1 < D180ANG) {
                ry2 = ry1 + D180ANG;
            } else {
                ry2 = ry1 - D180ANG;
            }
        } else if (D270ANG <= rz1 && rz1 <= D360ANG) {
            rz2 = D180ANG + (D360ANG - rz1);
            if (0 <= ry1 && ry1 < D180ANG) {
                ry2 = ry1 + D180ANG;
            } else {
                ry2 = ry1 - D180ANG;
            }
        }
        rz1 = rz2;
        ry1 = ry2;
    }

//    /**
//     * RzRy̍œK݂B
//     * ςAZ]+Y]̑gݍ킹ƔrB
//     * @param rz1
//     * @param ry1
//     */
//    static void optimizeRzRy(angle& rz1, angle& ry1) {
//        int rz2 = 0;
//        int ry2 = 0;
//        if (0 <= rz1 && rz1 < D90ANG) {
//            rz2 = D180ANG - rz1;
//
//            if (0 <= ry1 && ry1 < D180ANG) {
//                ry2 = ry1 + D180ANG;
//            } else {
//                ry2 = ry1 - D180ANG;
//            }
//        } else if (D90ANG <= rz1 && rz1 < D180ANG) {
//            rz2 = D180ANG - rz1;
//            if (0 <= ry1 && ry1 < D180ANG) {
//                ry2 = ry1 + D180ANG;
//            } else {
//                ry2 = ry1 - D180ANG;
//            }
//        } else if (D180ANG <= rz1 && rz1 < D270ANG) {
//            rz2 = D180ANG + (D360ANG - rz1);
//            if (0 <= ry1 && ry1 < D180ANG) {
//                ry2 = ry1 + D180ANG;
//            } else {
//                ry2 = ry1 - D180ANG;
//            }
//        } else if (D270ANG <= rz1 && rz1 <= D360ANG) {
//            rz2 = D180ANG + (D360ANG - rz1);
//            if (0 <= ry1 && ry1 < D180ANG) {
//                ry2 = ry1 + D180ANG;
//            } else {
//                ry2 = ry1 - D180ANG;
//            }
//        }
//        rz1 = rz2;
//        ry1 = ry2;
//    }
//

    static inline angle simplifyAng(angle prm_ang) {
        if (0 <= prm_ang && prm_ang < D360ANG) {
            return prm_ang;
        }
        while (prm_ang >= D360ANG) {
            prm_ang -= D360ANG;
        }
        while (prm_ang < 0) {
            prm_ang += D360ANG;
        }
        return prm_ang;
    }


    /**
     * ̓蔻<BR>
     * @param x11
     * @param y11
     * @param x12
     * @param y12
     * @param x21
     * @param y21
     * @param x22
     * @param y22
     * @return true:qbg/false:qbgĂȂ
     */
    static bool chk2DLineCrossing(coord x11, coord y11, coord x12, coord y12, coord x21, coord y21, coord x22, coord y22);


    /**
     * worldϊsݒ .
     * gk ~ X] ~ Z] ~ Y] ~ sړ ̕ϊsݒ<BR>
     * XYZ̏łȂƂɒ<BR>
     * @param prm_pActor [in]ΏۃAN^[
     * @param out_matWorld [out]worldϊs
     */
    static void setWorldMatrix_ScRxRzRyMv(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& out_matWorld);




    static void setWorldMatrix_ScRzRyMv(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& out_matWorld);
    static void setWorldMatrix_RzRy(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& out_matWorld);
    static void setWorldMatrix_RxRzRy(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& out_matWorld);

    static void setWorldMatrix_RxRzRy(angle prm_rx, angle prm_rz, angle prm_ry, D3DXMATRIX& out_matWorld);
    static void setWorldMatrix_RzRy(angle prm_Rz, angle prm_Ry, D3DXMATRIX& out_matWorld);


    /**
     * worldϊsݒ .
     * X] ~ Z] ~ Y] ~ gk ~ sړ ̕ϊsݒ<BR>
     * XYZ̏łȂƂɒ<BR>
     * @param prm_pActor [in]ΏۃAN^[
     * @param out_matWorld [out]worldϊs
     */
    static void setWorldMatrix_RxRzRyScMv(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& out_matWorld);

    /**
     * worldϊsݒ .
     * X] ~ Y] ~ Z] ~ gk ~ sړ ̕ϊsݒ<BR>
     * @param prm_pActor [in]ΏۃAN^[
     * @param out_matWorld [out]worldϊs
     */
    static void setWorldMatrix_RxRyRzScMv(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& out_matWorld);

    /**
     * worldϊsݒ .
     * X] ~ Z] ~ X] ~ gk ~ sړ ̕ϊsݒ<BR>
     * Y]܂B_ry͂QڂX]ƂȂ<BR>
     * @param prm_pActor [in]ΏۃAN^[
     * @param out_matWorld [out]worldϊs
     */
    static void setWorldMatrix_RxRzRxScMv(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& out_matWorld);


    static void updateWorldMatrix_Mv(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& out_matWorld);

    /**
     * worldϊsݒ .
     * Pʍs ~ Z] ~ sړ ̕ϊsݒ<BR>
     * @param prm_pActor [in]ΏۃAN^[
     * @param out_matWorld [out]worldϊs
     */
    static void setWorldMatrix_RzMv(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& out_matWorld);

    /**
     * worldϊsݒ .
     * Pʍs ~ gk ~ Z] ~ sړ ̕ϊsݒ<BR>
     * @param prm_pActor [in]ΏۃAN^[
     * @param out_matWorld [out]worldϊs
     */
    static void setWorldMatrix_ScRzMv(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& out_matWorld);

    /**
     * worldϊsݒ .
     * r{[hX] ~ r{[hY] ~ r{[hZ]  ~ gk ~ sړ@̕ϊs쐬foCXɐݒ <BR>
     * @param prm_pActor [in]ΏۃAN^[
     * @param out_matWorld [out]worldϊs
     */
    static void setWorldMatrix_BxyzScMv(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& out_matWorld);
    static void setWorldMatrix_ScRzBxyzMv(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& out_matWorld);
    static void setWorldMatrix_ScMvRxRzRy(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& out_matWorld);


    static void mulWorldMatrix_ScRxRzRyMv(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& inout_matWorld);

    static void mulWorldMatrix_RzRyScMv(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& inout_matWorld);


    static void setWorldMatrix_RzBxyzMv(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& out_matWorld);

    static void setWorldMatrix_BxyzMv(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& out_matWorld);

    static void setWorldMatrix_ScMv(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& out_matWorld);

    inline static void setWorldMatrix_RxRzRyMv(GgafDxGeometricActor* prm_pActor, D3DXMATRIX& out_matWorld) {
        //ł悭pWorldϊ
        //X] ~ Z] ~ Y] ~ sړ ̕ϊsݒ<BR>
        //XYZ̏łȂƂɒ
        // | cosRz*cosRy                        , sinRz       , cosRz*-sinRy                        , 0 |
        // | (cosRx*-sinRz*cosRy + sinRx*sinRy) , cosRx*cosRz , (cosRx*-sinRz*-sinRy + sinRx*cosRy) , 0 |
        // | (-sinRx*-sinRz*cosRy + cosRx*sinRy), -sinRx*cosRz, (-sinRx*-sinRz*-sinRy + cosRx*cosRy), 0 |
        // | dx                                 , dy          , dz                                  , 1 |
        float sinRx = ANG_SIN(prm_pActor->_rx);
        float cosRx = ANG_COS(prm_pActor->_rx);
        float sinRy = ANG_SIN(prm_pActor->_ry);
        float cosRy = ANG_COS(prm_pActor->_ry);
        float sinRz = ANG_SIN(prm_pActor->_rz);
        float cosRz = ANG_COS(prm_pActor->_rz);

        out_matWorld._11 = cosRz*cosRy;
        out_matWorld._12 = sinRz;
        out_matWorld._13 = cosRz*-sinRy;
        out_matWorld._14 = 0.0f;

        out_matWorld._21 = (cosRx*-sinRz*cosRy + sinRx*sinRy);
        out_matWorld._22 = cosRx*cosRz;
        out_matWorld._23 = (cosRx*-sinRz*-sinRy + sinRx*cosRy);
        out_matWorld._24 = 0.0f;

        out_matWorld._31 = (-sinRx*-sinRz*cosRy + cosRx*sinRy);
        out_matWorld._32 = -sinRx*cosRz;
        out_matWorld._33 = (-sinRx*-sinRz*-sinRy + cosRx*cosRy);
        out_matWorld._34 = 0.0f;

        out_matWorld._41 = prm_pActor->_fX;
        out_matWorld._42 = prm_pActor->_fY;
        out_matWorld._43 = prm_pActor->_fZ;
        out_matWorld._44 = 1.0f;
    }
};

}
#endif /*GGAFDXCORE_GGAFDXUTIL_H_*/

