#ifndef GGAFDXCORE_GGAFDXSPHERERADIUSVECTORS_H_
#define GGAFDXCORE_GGAFDXSPHERERADIUSVECTORS_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"

namespace GgafDxCore {

/**
 * PʋƁAPʃxNg̍W̊֌WێNXłB .
 * xNgZ]pY]pAtZ]pY]pxNg̑ݕϊ\Ƃ邽߂ɐ݌vB<BR>
 * AێĂ͈͂͒Pʋ́Ax0 y0 z0 ͈̔͂̕xNgłBi1/8̂݁j<BR>
 * y⑫z<BR>
 * ێĂxNg̊ev(X,Y,Z)̒P(uint16_t)́A1  10000 ɑ鐮ɂȂĂ܂B<BR>
 * px̒Pʁis_angj́A1x  10 ɑ܂Bp 900 ɂȂ܂Banglel(1x1000)ƍ݂Ȃ悤ɒ<BR>
 */
class GgafDxSphereRadiusVectors : public GgafCore::GgafObject {
public:
    /**
     * \[g\xNgNX.
     * SR_VECTOR(xNg)ɑ召̒lAr\ɂoNXB<BR>
     * 召̒l̋́Ayvf  zvf  xvf ̏łB<BR>
     */
    class COMPARE_ABLE_SR_VECTOR : public GgafCore::GgafObject {
    public:
        /**
         * COMPARE_ABLE_SR_VECTORp̕xNg\.
         * evf̒Pʂ́A1000000{̐ŕێ܂B<BR>
         * ၄<BR>
         * PʃxNg(0.658301, 0.1132, 0.744) <BR>
         * SR_VECTORł́A(658301, 113200, 744000) ł<BR>
         */
        struct SR_VECTOR {
            uint32_t x;
            uint32_t z;
            uint32_t y;
        };


        uint64_t num_yzx;
        SR_VECTOR vec;
    public:
        COMPARE_ABLE_SR_VECTOR() : GgafObject() , num_yzx(0) {
        }
        /**
         * PʃxNgݒ肷B<BR>
         * @param prm_x PʕxNgXvfi1  1000000)
         * @param prm_y PʕxNgYvfi1  1000000)
         * @param prm_z PʕxNgZvfi1  1000000)
         */
        void set(uint32_t prm_x, uint32_t prm_y, uint32_t prm_z) {
            vec.x = prm_x;
            vec.y = prm_y;
            vec.z = prm_z;
            num_yzx = (prm_y * 1000000LL * 1000000LL ) +
            (prm_z * 1000000LL ) +
            (prm_x );

            //_TRACE_(prm_x<<","<<prm_y<<","<<prm_z<<"  num_yzx="<<(num_yzx));
            //1048575LL = &b11111111111111111111 (20bit)
        }
    };

    /** 쐬ړI 1/8̃\[g\xNgz(vf900*900) */
    COMPARE_ABLE_SR_VECTOR _sr[(D90SANG + 1) * (D90SANG + 1)];

public:
    GgafDxSphereRadiusVectors();

    /**
     * X,Y,ZxNgAZ]Y]̋ߎ߂B
     * AAX,Y,Z ͑SĐłȂĂ͂ȂȂ
     * @param prm_x PʕxNgXvfi1  1000000) > 0
     * @param prm_y PʕxNgYvfi1  1000000) > 0
     * @param prm_z PʕxNgZvfi1  1000000) > 0
     * @param out_angFaceZ Z]li ]l0́AxNg(1,0,0)BxNg(0,0,1)ĔvBjiPs_angj
     * @param out_angFaceY_rev vY]li]l0́AxNg(1,0,0)BxNg(0,1,0)ĎvjiPs_angj
     * @param s vZ񐔁ixjB񐔂قǐmɂȂB
     */
    void getFaceAngClosely(uint32_t prm_x,
                           uint32_t prm_y,
                           uint32_t prm_z,
                           s_ang& out_angFaceZ,
                           s_ang& out_angFaceY_rev,
                           int s = 25);

    /**
     * Z]Y]̒lAPʕxNg̋ߎ߂ .
     * AAʂ̕xNg̊evf(X,Y,Z)̒lɂȂ悤Ȉ󂯕tȂB<BR>
     * ߂luint32_tŕ̂߁AintƉZ鎞͋C<BR>
     * @param prm_angFaceY_rev Z]li ]l0́AxNg(1,0,0)BxNg(0,0,1)ĔvBjiPs_angj
     * @param prm_angFaceZ vY]li]l0́AxNg(1,0,0)BxNg(0,1,0)ĎvjiPs_angj
     * @param out_x PʕxNgXvfi1  1000000) > 0
     * @param out_y PʕxNgYvfi1  1000000) > 0
     * @param out_z PʕxNgZvfi1  1000000) > 0
     */
    inline void getVectorClosely(s_ang prm_angFaceY_rev,
                                 s_ang prm_angFaceZ,
                                 uint32_t& out_x,
                                 uint32_t& out_y,
                                 uint32_t& out_z ) {
        COMPARE_ABLE_SR_VECTOR::SR_VECTOR& V = _sr[(int)(prm_angFaceZ*(D90SANG+1)+prm_angFaceY_rev)].vec;
        out_x = V.x;
        out_y = V.y;
        out_z = V.z;
    }


    virtual ~GgafDxSphereRadiusVectors();
};




}
#endif /*GGAFDXCORE_GGAFDXSPHERERADIUSVECTORS_H_*/

