#ifndef GGAFDXCORE_GGAFDXMORPHERHELPERA_H_
#define GGAFDXCORE_GGAFDXMORPHERHELPERA_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"
#include "jp/ggaf/core/util/GgafValueAccelerator.hpp"

namespace GgafDxCore {

/**
 * [t@[̏A .
 * @version 1.00
 * @since 2013/12/06
 * @author Masatoshi Tsuge
 */
class GgafDxMorpherAssistantA : public GgafCore::GgafObject {

public:
    /** [r]t */
    GgafDxMorpher* _pMaster;
    /** [r]d݉ */
    GgafCore::GgafValueAccelerator<float>* _pa_smthMph;
    /** [r][t^[Qbg(ppx̂ŁAfRs[ĕێ) */
    int _target_num;

public:
    /**
     * RXgN^<BR>
     * @param   prm_pMaster  t
     */
    explicit GgafDxMorpherAssistantA(GgafDxMorpher* prm_pMaster);


    /**
     * ]p炩ɉ]V[NGXs(pwAԎwApxϓ) .
     * p]ړɔ₳鎞(Te)3̃ZNVɕÂ悤ȊpxIɍsB<BR>
     * E 0     `  p1*Te ܂ EEE ݂̊pxgbvpx܂ŉ]x<BR>
     * E p1*Te `  p2*Te ܂ EEE gbvXs[hœpxœ]<BR>
     * E p2*Te `  Te    ܂ EEE gbvXs[hŏIpx։]x<BR>
     * }Q<BR>
     * <pre>
     *
     *    px()
     *     ^
     *     |                         :ڕWړpij    EEE prm_angular_distance
     *     |                        0:_̊px        EEE_angvelo_face[prm_axis]
     *     |                        t:gbvpx          EEEϓAvZ
     *     |                        e:ŏIx              EEE prm_end_angvelo
     *  t|....___________          Te:ڕWԁit[jEEE prm_target_frames
     *     |   /:         :_        p1:gbvpxɒB鎞ƂȂ悤ȁATeɑ΂銄EEE prm_p1
     *  e|../.:.........:.._      p2:]̌Jn鎞ƂȂ悤ȁATeɑ΂銄EEE prm_p2
     *     | /  :         :    |
     *     |/   :         :    |
     *  0|    :       :    |
     *     |    :         :    |
     *   --+----+---------+----+-----> (t:t[)
     *   0 |  p1*Te     p2*Te  Te
     *
     * </pre>
     * @param prm_axis ]p(AXIS_X or AXIS_Y or AXIS_Z)
     * @param prm_angular_distance ڕWp()iɂ]LBFTURN_COUNTERCLOCKWISEAFTURN_CLOCKWISEj
     * @param prm_target_frames ₷(Te)(t[wA͕̐s)
     * @param prm_p1 gbvXs[hɒB鎞ƂȂ悤ȁATeɑ΂銄(p1)
     * @param prm_p2 JnƂȂ悤ȁATeɑ΂銄(p2)
     * @param prm_end_angvelo ڕWB̍ŏIpx(e) iŐprm_angular_distance̐ɍ킹j
     * @param prm_endacc_flg true:ڕWړɒBۂɊpxOɋݒ/false:px͂̂܂܂ɂĂ
     */
    void morphByDt(int prm_target_mesh_no,
                   float prm_target_distance, int prm_target_frames,
                   float prm_p1, float prm_p2, float prm_end_velo,
                   bool prm_endacc_flg = true);
   /**
     * ڕW̎]p(Z)֊炩ɉ]V[NGXs(xEwAԕϓ) .
     * ړ3̃ZNV(1,2,3)ɕÂ悤ȊpxIɍsB<BR>
     * Ep 0       ` p 1         ܂ EEE ݂̃ƑxgbvXs[h܂Ŋp(or)]<BR>
     * Ep 1     ` p 1+2     ܂ EEE gbvXs[hœp]<BR>
     * Ep 1+2 ` p 1+2+3 ܂ EEE gbvXs[hŏIXs[h֊p(or)]<BR>
     * }Q<BR>
     * <pre>
     *    px()
     *     ^
     *     |                        0:_̊px
     *     |                        t:gbvpx
     *     |                        e:ŏIpx
     *     |       =1+2+3    :ڕW]p
     *  t|....___________          p1:gbvpxɒBpƂȂ悤ȁAƂɑ΂銄
     *     |   /|         |_            ܂     1 = *p1 ƂȂ悤 p1 (0.0`1.0)
     *  e|../.|.........|.._      p2:JnƂȂ悤ȁAƑ΂銄
     *     | /  |         |    |         ܂ 1+2 = *p2 ƂȂ悤 p2 (0.0`1.0)
     *     |/   |         |    |     Te:₳Kvԁit[j
     *  0|1 |   2   |3 |
     *     |    |         |    |
     *   --+----+---------+----+-----> (t:t[)
     *   0 |                  Te
     *
     * </pre>
     * gbvXs[h(t)AŏIXs[h(e)AڕW]p()Ay p1, p2 w肷B<BR>
     * ₳鎞(Te)͓Ŏv肳B<BR>
     * <BR>
     * @param prm_axis ]p(AXIS_X or AXIS_Y or AXIS_Z)
     * @param prm_top_angvelo gbvpx(t)
     * @param prm_angular_distance ڕWp()iɂ]LBFTURN_COUNTERCLOCKWISEAFTURN_CLOCKWISEj
     * @param prm_p1 gbvXs[hɒB鋗ƂȂ悤ȁA]p()ɑ΂銄B(1 = *prm_p1)
     * @param prm_p2 p]̌JnpƂȂ悤ȁA]p()ɑ΂銄 (1+2 = *p2)
     * @param prm_end_angvelo ŏIpx(e)
     * @param prm_endacc_flg true:ڕWԂɒBۂɊpxOɋݒ/false:px͂̂܂܂ɂĂ
     */
    void morphByVd(int prm_target_mesh_no,
                   float prm_top_velo, float prm_target_distance,
                   float prm_p1, float prm_p2, float prm_end_velo,
                   bool prm_endacc_flg = true);


   /**
     * [t@[̏肪U镑 .
     * 肪Atɂ낢ݒs܂̂ŁAtU镑(behave())OɎs܂傤B
     */
    virtual void behave();

    virtual ~GgafDxMorpherAssistantA();
};

}
#endif /*GGAFDXCORE_GGAFDXMORPHERHELPERA_H_*/

