#ifndef GGAFDXCORE_GGAFDXCAMERAACTOR_H_
#define GGAFDXCORE_GGAFDXCAMERAACTOR_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dxcore/actor/GgafDxGeometricActor.h"

namespace GgafDxCore {

/**
 * JAN^[.
 * GgafDxGeometricActor pAJ\AN^[łB<BR>
 * {NX͐_(GgafDxGod)ƘAĂ܂Bo𑀍삷ƁA̒ʂɃJ̈ʒuƒ_ł܂B<BR>
 * processPreDraw \bhĂA̒Ő_(GgafDxGod)̃JɍW㏑܂B<BR>
 * <BR>
 * _x,_y,_z             EEE J̈ʒu <BR>
 * <BR>
 * g<BR>
 * pAprocessBehavior()  I[o[ChčDɍW𓮂悢<BR>
 * <BR>
 * @version 1.00
 * @since 2009/02/12
 * @author Masatoshi Tsuge
 */
class GgafDxCamera : public GgafDxGeometricActor {

public:
    D3DVIEWPORT9 _viewport;

    // 6̖ʂ̒_W
    /** [r]ʁAO̎lp`̒_(ǂݍݐpAt[XV) */
    D3DXVECTOR3 _vecNear[4];
    /** [r]ʁA̎lp`̒_(ǂݍݐpAt[XV) */
    D3DXVECTOR3 _vecFar[4];

    D3DXVECTOR3 _vecVerticalCenter[4];

    // 6̖
    /** [r]ʁA(ǂݍݐpAt[XV) */
    D3DXPLANE _plnTop;
    /** [r]ʁA(ǂݍݐpAt[XV) */
    D3DXPLANE _plnBottom;
    /** [r]ʁA(ǂݍݐpAt[XV) */
    D3DXPLANE _plnLeft;
    /** [r]ʁAE(ǂݍݐpAt[XV) */
    D3DXPLANE _plnRight;
    /** [r]ʁAO(ǂݍݐpAt[XV) */
    D3DXPLANE _plnFront;
    /** [r]ʁA(ǂݍݐpAt[XV) */
    D3DXPLANE _plnBack;
    /** [r]Eɕ鐂ʁAĚʉ̃pɎgp(ǂݍݐpAt[XV) */
    D3DXPLANE _plnVerticalCenter;

    /** [r]ˉeϊs */
    D3DXMATRIX _matProj;
    /** [r]ˉeϊs */
    D3DXMATRIX _vMatrixOrthoProj;

    /** [r]J̈ʒu(t[XV) */
    D3DXVECTOR3* _pVecCamFromPoint;
    /** [r]J̒_(t[XV) */
    D3DXVECTOR3* _pVecCamLookatPoint;
    /** [r]J̏xNg(t[XV) */
    D3DXVECTOR3* _pVecCamUp;
    /** [r]VIEWϊs(t[XV) */
    D3DXMATRIX _matView;
    /** [r]pXWA */
    double _rad_fovX;
    /** [r]pXWA̔ */
    double _rad_half_fovX;
    /** [r]pYWA */
    double _rad_fovY;
    /** [r]pYWA̔ */
    double _rad_half_fovY;
    /** [r]JZW */
    dxcoord _cameraZ;
    /** [r]JZWʒu */
    dxcoord _cameraZ_org;
    /** [r]AXyNg */
    double _screen_aspect;
    /** [r]pY^WFg̔ */
    double _tan_half_fovY;
    /** [r]pX^WFg̔ */
    double _tan_half_fovX;
    /** [r]J߂̃Nbvʂ܂ł̋(ǂ̋\Ώۂj0 */
    dxcoord _zn;
    /** [r]J牓̃Nbvʂ܂ł̋(ǂ܂ł̋\Ώۂj> zn */
    dxcoord _zf;
    /** [r][i_cameraZ_org̉{)  */
    double _dep;
    /** [r/w]_ **/
    GgafDxCameraViewPoint* _pViewPoint;

    coord _x_prev, _y_prev, _z_prev;

    coord _x_buffer_left;
    coord _x_buffer_right;
    coord _y_buffer_top;
    coord _y_buffer_bottom;

public:
    /**
     * RXgN^ .
     * pƕ\[ݒ肷B
     * pɂāAJ̏Zʒu肷B
     * ̃J̏ZʒúA_t߂DirctX̒1ĩIuWFNgj
     * ʏ10sNZŕ\ʒuփJ悤ɎvZBi_cameraZ_orgɕێ)
     * ̌_ÃJZʒu܂ł1.0ƂāA\͈͂̐[̔{ prm_dep Őݒ肷B
     * prm_dep=1.0ƂꍇB\͈͂ _𒆐SƂAaJZʒű̋ƂȂB
     * ܂A\͈́{AAN^[B̃Q[ł̉͈͂ƂȂ悤ɐ݌vĂ邽߁AJ̏ݒl
     * ɏdvłB
     * ʏ펋p߂΃Y[Abv̌ʂ邪A{Cuł́A
     * L̏Zʒu܂ŃJň߁ApύXĂAN^[̕\̑傫͉ʏςȂB
     * p΁ÃJLт邱ƂɂȂAʂƂ
     * E̕\͈͂g傷ʂ邱ƂłB
     * tɎpL΁AJ̏Zʒu͌_ɋ߂ȂA͐E̕\͈͂͋ȂB
     *
     * @param prm_name O(fobNŕ\Bł悢)
     * @param prm_rad_fovX E̎piWAj
     * @param prm_dep [i_cameraZ_org̉{)
     * @return
     */
    GgafDxCamera(const char* prm_name, double prm_rad_fovX, double prm_dep);

    virtual void initialize() override;

    virtual void processBehavior() override;

    virtual void processJudgement() override;

    virtual void processPreDraw() override {
    }

    virtual void processDraw() override {
    }

    virtual void processAfterDraw() override {
    }

    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) override {
    }

    virtual void processFinal() override {
    }

    virtual void onHit(GgafCore::GgafActor* prm_pOtherActor) override {
    }

    virtual void setDefaultPosition();

    virtual void setVecCamUp(float prm_up_x, float prm_up_y, float prm_up_z);

    virtual GgafDxCameraViewPoint* getViewPoint();

    virtual GgafDxCameraViewPoint* createViewPoint();

    bool isMoving();

    virtual ~GgafDxCamera(); //fXgN^
};

}
#endif /*GGAFDXCORE_GGAFDXCAMERAACTOR_H_*/
