#include "jp/ggaf/dxcore/actor/GgafDxGeometricActor.h"

#include "jp/ggaf/core/util/GgafStatus.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxChecker.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxAxesMover.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/scene/GgafDxUniverse.h"
#include "jp/ggaf/dxcore/util/GgafDxUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;

GgafDxGeometricActor::GgafDxGeometricActor(const char* prm_name,
                                           GgafStatus* prm_pStat,
                                           GgafDxChecker* prm_pChecker) : GgafDxBaseActor(prm_name, prm_pStat),
    _pKuroko(new GgafDxKuroko(this)),
    _pSeTx(new GgafDxSeTransmitterForActor(this)),
    _is_2D(false),
    _offscreen_kind(-1),
    _x(0), _y(0), _z(0),
    _rx(0), _ry(0), _rz(0),
    _sx(R_SC(1.0)), _sy(R_SC(1.0)), _sz(R_SC(1.0)),
    _pChecker(prm_pChecker),
    _bounding_sphere_radius(0),
    _rate_of_bounding_sphere_radius(1.0f),
    _fX(C_DX(_x)), _fY(C_DX(_y)), _fZ(C_DX(_z)),
    _dest_from_vppln_top(0.0f),
    _dest_from_vppln_bottom(0.0f),
    _dest_from_vppln_left(0.0f),
    _dest_from_vppln_right(0.0f),
    _dest_from_vppln_front(0.0f),
    _dest_from_vppln_back(0.0f),
    _pFunc_calc_rot_mv_world_matrix(nullptr),
    _matWorld(),
    _matWorldRotMv(),
    _matInvWorldRotMv(),
    _was_calculated_matInvWorldRotMv(false),
    _pActor_base(nullptr),
    _x_local(_x), _y_local(_y), _z_local(_z),
    _rx_local(_rx), _ry_local(_ry), _rz_local(_rz),
    _x_final(_x), _y_final(_y), _z_final(_z),
    _rx_final(_rx), _ry_final(_ry), _rz_final(_rz),
    _is_local(false)
{
    _obj_class |= Obj_GgafDxGeometricActor;
    _class_name = "GgafDxGeometricActor";
    _pFormation = nullptr;
}

void GgafDxGeometricActor::processSettlementBehavior() {
    if (_is_2D) {
        return;
    }

    _was_calculated_matInvWorldRotMv = false; //ts񖢌vZɃZbg

    if (_pActor_base) {
        //y䂠莞[JWɈU߂
        changeGeoLocal();
    }

    //DirectX̒PʂɍWϊĂiWorldϊs쐬ɂgp܂j
    _fX = C_DX(_x);
    _fY = C_DX(_y);
    _fZ = C_DX(_z);
    //Worldϊsi_matWorldjXV
    if (_pFunc_calc_rot_mv_world_matrix) {
        //]~ړ̂݌vZ _matWorldRotMv ɕێ
        (*_pFunc_calc_rot_mv_world_matrix)(this, _matWorldRotMv);
        //]~ړ ̑O XP[lāA
        //ŏII _matWorld  s(g~]~ړ)ێ
        if (_sx != LEN_UNIT) {
            float sx = SC_R(_sx);
            _matWorld._11 = sx * _matWorldRotMv._11;
            _matWorld._12 = sx * _matWorldRotMv._12;
            _matWorld._13 = sx * _matWorldRotMv._13;
        } else {
            _matWorld._11 = _matWorldRotMv._11;
            _matWorld._12 = _matWorldRotMv._12;
            _matWorld._13 = _matWorldRotMv._13;
        }
        _matWorld._14 = _matWorldRotMv._14;

        if (_sy != LEN_UNIT) {
            float sy = SC_R(_sy);
            _matWorld._21 = sy * _matWorldRotMv._21;
            _matWorld._22 = sy * _matWorldRotMv._22;
            _matWorld._23 = sy * _matWorldRotMv._23;
        } else {
            _matWorld._21 = _matWorldRotMv._21;
            _matWorld._22 = _matWorldRotMv._22;
            _matWorld._23 = _matWorldRotMv._23;
        }
        _matWorld._24 = _matWorldRotMv._24;

        if (_sz != LEN_UNIT) {
            float sz = SC_R(_sz);
            _matWorld._31 = sz * _matWorldRotMv._31;
            _matWorld._32 = sz * _matWorldRotMv._32;
            _matWorld._33 = sz * _matWorldRotMv._33;
        } else {
            _matWorld._31 = _matWorldRotMv._31;
            _matWorld._32 = _matWorldRotMv._32;
            _matWorld._33 = _matWorldRotMv._33;
        }
        _matWorld._34 = _matWorldRotMv._34;

        _matWorld._41 = _matWorldRotMv._41;
        _matWorld._42 = _matWorldRotMv._42;
        _matWorld._43 = _matWorldRotMv._43;
        _matWorld._44 = _matWorldRotMv._44;
    }

    //ftHgł́A_matWorldRotMv = ]ϊs ~ sړϊs
    //                _matWorld      = gkϊs ~ _matWorldRotMv ƂȂ悤ɂĂB
    //܂ _matWorld = gk]sړ
    //_matWorldRotMv  addSubGroupAsFk() sɎgp邽߂ɍ쐬ĂB
    //] addSubGroupAsFk() ΎgpȂȂ΁A_matWorldRotMv̌vZ͕svB
    //processSettlementBehavior() I[o[ChA
    //ϊs쐬ƒP邱ƂŁAœK\B

    if (_pActor_base) {
        //΍Wɕϊ
        D3DXMatrixMultiply(&_matWorld     , &_matWorld     , &(_pActor_base->_matWorldRotMv)); //
        D3DXMatrixMultiply(&_matWorldRotMv, &_matWorldRotMv, &(_pActor_base->_matWorldRotMv)); //
        changeGeoFinal();
        //[hϊs~y䃏[hϊśu]~ړv݂̂̐ρj畽sړoŏIIȍWƂ
        _fX = _matWorld._41;
        _fY = _matWorld._42;
        _fZ = _matWorld._43;
        _x = DX_C(_fX);
        _y = DX_C(_fY);
        _z = DX_C(_fZ);

        //[Jłfaceς݂̃[hϊśu]~ړv݂̂̐(_matWorldRotMv)̂ŁA
        //xNg(1,0,0)ɍςݕϊs|΍ŏIIface𓾂
        UTIL::convVectorToRzRy(_matWorldRotMv._11, _matWorldRotMv._12, _matWorldRotMv._13, _rz, _ry);
        _rx = _rx_local; //̂܂

        //TODO:΍Wn_rx, _ry, _rz ɕϊ͕ۗ
        //     ݂̍ŏIIȌARzRyŎ擾߂@͈ȉ̒ʂA
        //     t[[Nł _rx, _ry, _rz ͂ǂł悭ϊs񂪂ΗǂB
        //     ČvZXLbvłꍇB
        //     UTIL::convVectorToRzRy() ̌vZׂƑkB
        //
        //
        //xNg̓[hϊs̐ρi_matWorldRotMv)ŕϊA݂̍ŏIIȌɌB
        //匳̕xNg(x_org_,y_org_,z_org_)A
        //[hϊs̉]̐ρi_matWorldRotMv)̐ mat_xxA
        //ŏIIȕxNg(vX, vY, vZ) Ƃ
        //
        //                         | mat_11 mat_12 mat_13 |
        //| x_org_ y_org_ z_org_ | | mat_21 mat_22 mat_23 | = | vX vY vZ |
        //                         | mat_31 mat_32 mat_33 |
        //ƂȂB
        //
        //vX = x_org_*mat_11 + y_org_*mat_21 + z_org_*mat_31
        //vY = x_org_*mat_12 + y_org_*mat_22 + z_org_*mat_32
        //vZ = x_org_*mat_13 + y_org_*mat_23 + z_org_*mat_33
        //
        //ĂŁA匳O̒PʕxNg(1,0,0)̏ꍇ͂ǂȂ邩Hl
        //
        //vX = x_org_*mat_11
        //vY = x_org_*mat_12
        //vZ = x_org_*mat_13
        //
        //ƂȂB{Avł́Af͑S(1,0,0)OƂĂ邽
        //ŏIIȕxNǵix_org_*mat_11, x_org_*mat_12, x_org_*mat_13) ƂȂB
        //̕xNg _rz _ry \ΗǂB
        //vZ₷悤x_org_1ƒu
        //
        //UTIL::convVectorToRzRy(_matWorldRotMv._11, _matWorldRotMv._12, _matWorldRotMv._13, _rz, _ry);
        //ƂȂ
    }

    //XV
    GgafDxCamera* pCam = P_CAM;
    _dest_from_vppln_top    = pCam->_plnTop.a * _fX +
                              pCam->_plnTop.b * _fY +
                              pCam->_plnTop.c * _fZ +
                              pCam->_plnTop.d;

    _dest_from_vppln_bottom = pCam->_plnBottom.a * _fX +
                              pCam->_plnBottom.b * _fY +
                              pCam->_plnBottom.c * _fZ +
                              pCam->_plnBottom.d;

    _dest_from_vppln_left   = pCam->_plnLeft.a * _fX +
                              pCam->_plnLeft.b * _fY +
                              pCam->_plnLeft.c * _fZ +
                              pCam->_plnLeft.d;

    _dest_from_vppln_right  = pCam->_plnRight.a * _fX +
                              pCam->_plnRight.b * _fY +
                              pCam->_plnRight.c * _fZ +
                              pCam->_plnRight.d;

    _dest_from_vppln_front  = pCam->_plnFront.a * _fX +
                              pCam->_plnFront.b * _fY +
                              pCam->_plnFront.c * _fZ +
                              pCam->_plnFront.d;

    _dest_from_vppln_back   = pCam->_plnBack.a * _fX +
                              pCam->_plnBack.b * _fY +
                              pCam->_plnBack.c * _fZ +
                              pCam->_plnBack.d;
    _offscreen_kind = -1;

    //Wؓo^
    if (_pChecker) {
        if (_can_hit_flg) {
            if (_can_hit_out_of_view == false && isOutOfView()) {
                //O蔻薳̏ꍇ͓o^Ȃ
            } else  {
                _pChecker->updateHitArea();
            }
        }
    }
}

//void GgafDxGeometricActor::updateGeoFinalFromLocal() {
//
//}
GgafGroupHead* GgafDxGeometricActor::addSubGroupAsFk(actorkind prm_kind,
                                                     GgafDxGeometricActor* prm_pGeoActor,
                                                     coord prm_x_init_local,
                                                     coord prm_y_init_local,
                                                     coord prm_z_init_local,
                                                     coord prm_rx_init_local,
                                                     coord prm_ry_init_local,
                                                     coord prm_rz_init_local) {
#ifdef MY_DEBUG
    if (_pFunc_calc_rot_mv_world_matrix) {
        //OK
    } else {
        throwGgafCriticalException("GgafDxGeometricActor::addSubGroupAsFk() : "<<
                                   "this=("<<this<<")["<<getName()<<"] ́A_pFunc_calc_rot_mv_world_matrix  nullptrׁ̈AFKx[XƂȂ鎑i܂");
    }
#endif
    GgafGroupHead* pGroupHead = addSubGroup(prm_kind, prm_pGeoActor);
    prm_pGeoActor->_pActor_base = this;
    prm_pGeoActor->changeGeoLocal();
    prm_pGeoActor->_x = prm_x_init_local;
    prm_pGeoActor->_y = prm_y_init_local;
    prm_pGeoActor->_z = prm_z_init_local;
    prm_pGeoActor->_rx = prm_rx_init_local;
    prm_pGeoActor->_ry = prm_ry_init_local;
    prm_pGeoActor->_rz = prm_rz_init_local;
//    prm_pGeoActor->getKuroko()->_ang_rz_mv = prm_rz_init_local;
//    prm_pGeoActor->getKuroko()->_ang_ry_mv = prm_ry_init_local;

    prm_pGeoActor->changeGeoFinal();
    return pGroupHead;
}

GgafGroupHead* GgafDxGeometricActor::addSubGroupAsFk(GgafDxGeometricActor* prm_pGeoActor,
                                                     coord prm_x_init_local,
                                                     coord prm_y_init_local,
                                                     coord prm_z_init_local,
                                                     coord prm_rx_init_local,
                                                     coord prm_ry_init_local,
                                                     coord prm_rz_init_local) {
    return addSubGroupAsFk(prm_pGeoActor->getStatus()->getUint(STAT_DEFAULT_ACTOR_KIND),
                           prm_pGeoActor,
                           prm_x_init_local,
                           prm_y_init_local,
                           prm_z_init_local,
                           prm_rx_init_local,
                           prm_ry_init_local,
                           prm_rz_init_local);
}

bool GgafDxGeometricActor::processHitChkLogic(GgafActor* prm_pOtherActor) {
    if (_can_hit_flg && prm_pOtherActor->_can_hit_flg) {
        //&& prm_pOtherActor->instanceOf(Obj_GgafDxGeometricActor)) { 蔻肪̂GgafDxGeometricActorȏƔf
        //_can_hit_flg && prm_pOtherActor->_can_hit_flg ̃`FbN͂Wؓo^Oɂ`FbNĂ邪
        //łx`FbNقǂB
        //ȂȂ΁Aʂȃqbg`FbNsȂ߁AonHit(GgafActor*)  setHitAble(false) sA
        //Qdqbg`FbNh~sĂ邩ȂB
        if (_pChecker) {
            return _pChecker->isHit(((GgafDxGeometricActor*)prm_pOtherActor)->_pChecker);
        }
    }
    return false;
}

int GgafDxGeometricActor::isOutOfView() {
    //_TRACE_("name="<<getName()<<" _bounding_sphere_radius="<<_bounding_sphere_radius);
    if (_offscreen_kind == -1) {
        dxcoord bound = _bounding_sphere_radius * _rate_of_bounding_sphere_radius*2;//|2͋E傫āAʋẼ`cL}
        if (_dest_from_vppln_top < bound) {
            if (_dest_from_vppln_bottom < bound) {
                if (_dest_from_vppln_left < bound) {
                    if (_dest_from_vppln_right < bound) {
                        if (_dest_from_vppln_front < bound) {
                            if (_dest_from_vppln_back < bound) {
                                //Viewport͈͓
                                _offscreen_kind = 0;
                            } else {
                                //ʂ艜Ŕ͈͊O
                                _offscreen_kind = 6;
                            }
                        } else {
                            //OʂOŔ͈͊O
                            _offscreen_kind = 5;
                        }
                    } else {
                        //EʂEŔ͈͊O
                        _offscreen_kind = 4;
                    }
                } else {
                    //ʂ荶Ŕ͈͊O
                    _offscreen_kind = 3;
                }
            } else {
                //ʂ艺Ŕ͈͊O
                _offscreen_kind = 2;
            }
        } else {
            //㕽ʂŔ͈͊O
            _offscreen_kind = 1;
        }
    }
    return _offscreen_kind;
}

bool GgafDxGeometricActor::isOutOfUniverse() {
    if (GgafDxUniverse::_x_gone_left < _x) {
        if (_x < GgafDxUniverse::_x_gone_right) {
            if (GgafDxUniverse::_y_gone_bottom < _y) {
                if (_y < GgafDxUniverse::_y_gone_top) {
                    if (GgafDxUniverse::_z_gone_near < _z) {
                        if (_z < GgafDxUniverse::_z_gone_far) {
                            return false;
                        }
                    }
                }
            }
        }
    }
    return true;
}

void GgafDxGeometricActor::defineRotMvWorldMatrix(void (*prm_pFunc)(GgafDxGeometricActor*, D3DXMATRIX&)) {
    _pFunc_calc_rot_mv_world_matrix = prm_pFunc;
    (*_pFunc_calc_rot_mv_world_matrix)(this, _matWorldRotMv);
}

void GgafDxGeometricActor::positionAs(GgafDxGeoElem* prm_pGeoElem) {
    _x = prm_pGeoElem->x;
    _y = prm_pGeoElem->y;
    _z = prm_pGeoElem->z;
}
void GgafDxGeometricActor::positionAboutAs(GgafDxGeoElem* prm_pGeoElem, coord margin) {
    _x = RND_AROUND(prm_pGeoElem->x, margin);
    _y = RND_AROUND(prm_pGeoElem->y, margin);
    _z = RND_AROUND(prm_pGeoElem->z, margin);
}
void GgafDxGeometricActor::setFaceAngAs(GgafDxGeometricActor* prm_pActor) {
    _rx = prm_pActor->_rx;
    _ry = prm_pActor->_ry;
    _rz = prm_pActor->_rz;
}
void GgafDxGeometricActor::setFaceAngAs(GgafDxGeoElem* prm_pGeoElem) {
    _rx = prm_pGeoElem->rx;
    _ry = prm_pGeoElem->ry;
    _rz = prm_pGeoElem->rz;
}

//void GgafDxGeometricActor::setFaceAng(axis prm_axis, angle prm_angFace) {
//    _angFace[prm_axis] = UTIL::simplifyAng(prm_angFace);
//}

void GgafDxGeometricActor::setRzFaceAng(angle prm_angFace) {
    _rz = UTIL::simplifyAng(prm_angFace);
}
void GgafDxGeometricActor::setRyFaceAng(angle prm_angFace) {
    _ry = UTIL::simplifyAng(prm_angFace);
}
void GgafDxGeometricActor::setRxFaceAng(angle prm_angFace) {
    _rx = UTIL::simplifyAng(prm_angFace);
}

void GgafDxGeometricActor::setFaceAngTwd(coord prm_tx, coord prm_ty, coord prm_tz) {
    UTIL::convVectorToRzRy(
                   prm_tx - _x,
                   prm_ty - _y,
                   prm_tz - _z,
                   _rz,
                   _ry
                 );
}

void GgafDxGeometricActor::scaleAs(GgafDxGeometricActor* prm_pActor) {
    _sx = prm_pActor->_sx;
    _sy = prm_pActor->_sy;
    _sz = prm_pActor->_sz;
}

void GgafDxGeometricActor::onEnd() {
    GgafDxBaseActor::onEnd();
    _pFormation = nullptr;
}

GgafDxGeometricActor::~GgafDxGeometricActor() {
    delete _pKuroko;
    delete _pSeTx;
}

void GgafDxGeometricActor::dump() {
    _TRACE_("\t\t\t\t\t\t\t\t"<<_class_name<<"("<<this<<")["<<getName()<<"]("<<_x<<","<<_y<<","<<_z<<")"<<DUMP_FLGS);
    GgafActor* pActor_tmp = _pSubFirst;
    while (pActor_tmp) {
        pActor_tmp->dump("\t\t\t\t\t\t\t\tb");
        if (pActor_tmp->getNext()) {
            pActor_tmp = pActor_tmp->getNext();
        } else {
            _TRACE_("yxz"<<_class_name<<"("<<this<<")["<<getName()<<"]nextnullptrĂ܂");
            break;
        }
        if (pActor_tmp->isFirst()) {
            _TRACE_("\t\t\t\t\t\t\t\t");
            break;
        }
    }
}

void GgafDxGeometricActor::dump(std::string prm_parent) {
    _TRACE_(prm_parent << _class_name<<"("<<this<<")["<<getName()<<"]("<<_x<<","<<_y<<","<<_z<<")"<<DUMP_FLGS);
    GgafActor* pActor_tmp = _pSubFirst;
    while (pActor_tmp) {
        pActor_tmp->dump(prm_parent + "b");
        if (pActor_tmp->getNext()) {
            pActor_tmp = pActor_tmp->getNext();
        } else {
            _TRACE_("yxz"<<_class_name<<"("<<this<<")["<<getName()<<"]nextnullptrĂ܂");
            break;
        }
        if (pActor_tmp->isFirst()) {
            _TRACE_(prm_parent+"");
            break;
        }
    }
}

