#include "EnemyRis.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/dxcore/model/supporter/GgafDxTextureBlinker.h"
#include "jp/ggaf/dxcore/util/GgafDxUtil.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/ggaf/lib/util/spline/SplineKurokoLeader.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

EnemyRis::EnemyRis(const char* prm_name)
      : DefaultMeshSetActor(prm_name, "Ris", STATUS(EnemyRis)) {
    _class_name = "EnemyRis";
    iMovePatternNo_ = 0;
    pKurokoLeader_ = nullptr;
    pDepo_shot_ = nullptr;
    pDepo_effect_ = nullptr;
    GgafDxSeTransmitterForActor* pSeTx = getSeTx();
    pSeTx->set(SE_EXPLOSION, "WAVE_EXPLOSION_001");     //
}

void EnemyRis::onCreateModel() {
    GgafDxModel* pModel = getModel();
    pModel->setBlinkPower(0.5, 0.9);
    pModel->getTexBlinker()->forceRange(0.5, 2.0);
    pModel->getTexBlinker()->beat(60, 3, 0, 57, -1);
}

void EnemyRis::initialize() {
    setHitAble(true);
    GgafDxKuroko* pKuroko = getKuroko();
    pKuroko->relateFaceByMvAng(true);
    pKuroko->setFaceAngVelo(AXIS_X, 5000);
    CollisionChecker3D* pChecker = getCollisionChecker();
    pChecker->makeCollision(1);
    pChecker->setColliAAB(0, -30000, -30000, -30000, 30000, 30000, 30000);
}

void EnemyRis::onActive() {
    getStatus()->reset();
    iMovePatternNo_ = 0; //sp^[Zbg
}

void EnemyRis::processBehavior() {
    //ZN|Cg
    UTIL::updateEnemyRankPoint(this);
    GgafDxKuroko* pKuroko = getKuroko();
    switch (iMovePatternNo_) {
        case 0:  //yp^[OFXvCړJnz
            if (pKurokoLeader_) {
                pKurokoLeader_->start(SplineKurokoLeader::ABSOLUTE_COORD); //XvCړJn
            }
            iMovePatternNo_++; //̍sp^[
            break;

        case 1:  //yp^[PFXvCړI҂z
            if (pKurokoLeader_) {
                //XvCړL
                if (pKurokoLeader_->isFinished()) {
                    iMovePatternNo_++; //XvCړI玟̍sp^[
                }
            } else {
                //XvCړ
                iMovePatternNo_++; //Ɏ̍sp^[
            }
            break;

        case 2:  //yp^[QFˏVbg˂Ǝ@֕]z
            if (pDepo_shot_) {
                //ˏVbg
                int way = RF_EnemyRis_ShotWay(G_RANK); //VbgWAY
                UTIL::shotWay004(_x, _y, _z,
                                 D180ANG, D0ANG,
                                 pDepo_shot_,
                                 PX_C(20), way, D_ANG(120),
                                 0, 0,  //Vbgőxݒ
                                 1, 0, 1.0,
                                 nullptr );
                //Vbg˃GtFNg
                if (pDepo_effect_) {
                    GgafDxDrawableActor* pTestActor_Shot = (GgafDxDrawableActor*)pDepo_effect_->dispatch();
                    if (pTestActor_Shot) {
                        pTestActor_Shot->positionAs(this);
                    }
                }
            }
            //@֕]
            pKuroko->turnMvAngTwd(P_MYSHIP,
                                  3000, 0,
                                  TURN_CLOSE_TO, true);
            iMovePatternNo_++; //̍sp^[
            break;

        case 3:  //ysp^[RF@փObƋt]ŕ]Jnz
            if (_z-10000 < P_MYSHIP->_z && P_MYSHIP->_z < _z+10000) {
                //@Zڋ߂ObƋt]ŕ]
                pKuroko->turnMvAngTwd(MyShip::lim_x_behaind_ - 500000 , _y, _z,
                                      10000, 0,
                                      TURN_CLOSE_TO, true);
                pKuroko->setMvAcce(100);
                iMovePatternNo_++;
            } else {
                //@Zڋ߂܂ő҂
            }
            break;
        default:
            break;
    }


    if (pKurokoLeader_) {
        pKurokoLeader_->behave(); //XvCړU镑
    }
    pKuroko->behave();
    //getSeTx()->behave();
}

void EnemyRis::processJudgement() {
    if (isOutOfUniverse()) {
        sayonara();
    }
}

void EnemyRis::onHit(GgafActor* prm_pOtherActor) {
    bool was_destroyed = UTIL::proceedEnemyHit(this, (GgafDxGeometricActor*)prm_pOtherActor);
    if (was_destroyed) {
        //j
        getSeTx()->play3D(SE_EXPLOSION);
    } else {
        //j
    }
}

void EnemyRis::onInactive() {
    sayonara();
}

EnemyRis::~EnemyRis() {
    GGAF_DELETE_NULLABLE(pKurokoLeader_);
}
