#include "GgafEffectConst.fxh"
/**
 * GgafLib::DefaultMeshActor pVF[_[ .
 * ÓIfP`悷WIȃVF[_[B
 * _obt@tH[}bg
 * {
 *     float x, y, z;             // W([JWn)
 *     float nx, ny, nz;          // @xNg([JWn)
 *     DWORD color;               // _J[iݖgpj
 *     float tu, tv;              // eNX`W
 *     float tan_x, tan_y, tan_z; // ڃxNg(uPʃxNg) ([JWn)
 *     float bin_x, bin_y, bin_z; // ]@xNg(vPʃxNg) ([JWn)
 * };
 *
 * FVF = (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE | D3DFVF_TEX3 |
 *                                                        D3DFVF_TEXCOORDSIZE2(0) |     // eNX`W
 *                                                        D3DFVF_TEXCOORDSIZE3(1) |     // ڃxNg
 *                                                        D3DFVF_TEXCOORDSIZE3(2)   )   // ]@xNg
 * AOƂĂ܂B
 * @author Masatoshi Tsuge
 * @since 2009/03/06
 */

/** fWorldϊs */
float4x4 g_matWorld;
/** fViewϊs */
float4x4 g_matView;
/** f̎ˉeϊs */
float4x4 g_matProj;
/** fWorldϊs̋ts */
float4x4 g_matInvWorld;
/** Cg̕xNgiKς݁j */
float3 g_vecLightFrom_World;
/** Ji_j̈ʒuxNg */
float3 g_posCam_World;
/** ̐F */
float4 g_colLightAmbient;
/** Cg̐F(Cg̊gUˎ̃Cgg̐F) */
float4 g_colLightDiffuse;
/** f̃}eAF(CgɂgUˎ̃f̐F) */
float4 g_colMaterialDiffuse;
/** XyL[͈̔́in[txNgE@ςg_specularj */
float g_specular;
/** XyL[̋x */
float g_specular_power;
/** f̃eNX`F_ŋ@\(GgafDxTextureBlinkerQ)̓_ŋx */
float g_tex_blink_power;
/** f̃eNX`F_ŋ@\(GgafDxTextureBlinkerQ)̑ΏۂƂȂRGB̂l(0.0`1.0) */
float g_tex_blink_threshold;
/** tF[hCEAEg@\(GgafDxAlphaCurtainQ)̂߂̃}X^[At@l(0.0`1.0) */
float g_alpha_master;
/** ݂̎ˉeϊsvfzfBJ牓̃Nbvʂ܂ł̋(ǂ܂ł̋\Ώۂj> zn */
float g_zf;
/** -1.0 or 0.999 Bł\ꍇ0.999 B*/
float g_far_rate;

//float4 g_colFog;


/** eNX`̃Tv[(s0 WX^ɃZbgꂽeNX`g) */
sampler MyTextureSampler : register(s0);
/** @}bveNX`̃Tv[(s2 WX^ɃZbgꂽeNX`g) */
sampler BumpMapTextureSampler : register(s2);

/** _VF[_[Ao͍\ */
struct OUT_VS {
    float4 posModel_Proj   : POSITION;    //ŏIIȒ_W([hEr[Eˉeϊς)
    float2 uv              : TEXCOORD0;   //_eNX`UV
    float4 color           : COLOR0;      //_J[
    float3 vecNormal_World : TEXCOORD1;   //_̖@xNg([hWn)
    float3 vecEye_World    : TEXCOORD2;   //_̎(_->_)xNg([hWn)
};

/** ov}bsOp_VF[_[Ao͍\ */
struct OUT_VS_BM {
    float4 posModel_Proj    : POSITION;    //ŏIIȒ_W([hEr[Eˉeϊς)
    float2 uv               : TEXCOORD0;   //_eNX`UV
    float4 color            : COLOR0;      //_J[
    float3 vecNormal_World  : TEXCOORD1;   //_̖@xNg([hWn)
    float3 vecEye_World     : TEXCOORD2;   //_̎(_->_)xNg([hWn)
    float4 vecLight_Tangent : TEXCOORD3;   //_̃CgxNg([J̐ڋԍWn)
    float4 vecHarf_Tangent  : TEXCOORD4;   //_̃n[txNg([J̐ڋԍWn)
};

/**
 * GgafLib::DefaultMeshActor p̕W_VF[_[ .
 * _ World > View > ˉe ϊA
 * f̃}eAFt𒸓_J[̐ݒōsB
 * }eAFtƂ͋̈ʓI
 * gUFAgUːFAFA}X^[At@AtHOA̎B
 * @param prm_posModel_Local  _̃[JW
 * @param prm_vecNormal_Local [J_ł̖@xNg
 * @param prm_uv              _UVW
 */
OUT_VS GgafDxVS_DefaultMesh(
      float4 prm_posModel_Local  : POSITION,
      float3 prm_vecNormal_Local : NORMAL,
      float2 prm_uv              : TEXCOORD0
) {
    OUT_VS out_vs = (OUT_VS)0;

    //_vZ
    float4 posModel_World = mul(prm_posModel_Local, g_matWorld); //Worldϊ
    out_vs.posModel_Proj = mul( mul( posModel_World, g_matView), g_matProj);  //World*View*ˉe

    //UVvZ
    out_vs.uv = prm_uv;  //̂܂

    //_J[vZ
    //@ World ϊĐK
    out_vs.vecNormal_World = normalize(mul(prm_vecNormal_Local, g_matWorld));
    //@ƁAgU̓ς烉Cgˊp߁Aʂɑ΂gǓ߂B
    float power = max(dot(out_vs.vecNormal_World, -g_vecLightFrom_World ), 0);
    //gUFɌ悶AFZAŜ}eAF|B
    out_vs.color = (g_colLightAmbient + (g_colLightDiffuse*power)) * g_colMaterialDiffuse;
    //u_J_vxNgiXyLŎgpj
    out_vs.vecEye_World = normalize(g_posCam_World.xyz - posModel_World.xyz);
    //̓}eAŗDƂi㏑j
    out_vs.color.a = g_colMaterialDiffuse.a;

    //̕\@B
    if (g_far_rate > 0.0) {
        if (out_vs.posModel_Proj.z > g_zf*g_far_rate) {
            out_vs.posModel_Proj.z = g_zf*g_far_rate; //{OZłA`邽 g_zf*0.999 ɏ㏑A
        }
    } else {
        //tHO
        if (out_vs.posModel_Proj.z > 0.666f*g_zf) {   // ŉ̖ 2/3 肳ɉ̏ꍇXɓ
            out_vs.color.a *= (-3.0*(out_vs.posModel_Proj.z/g_zf) + 3.0);
//            float r_fog = (-3.0*(out_vs.posModel_Proj.z/g_zf) + 3.0);    //r_fogg_zfŒx0.0ɂȂB艜͕̐
//            if (1.0f < r_fog) {
//                out_vs.color.rgb = out_vs.color.rgb * (g_colFog.rgb * (1.0-r_fog));
//                out_vs.color.a = out_vs.color.a * (g_colFog.a + r_fog);
//            }
        }
    }
    //}X^[
    out_vs.color.a *= g_alpha_master;

    return out_vs;
}

/**
 * GgafLib::DefaultMeshActor p̕WsNZVF[_[ .
 * @param prm_uv              UVW
 * @param prm_color           Fi_J[ɂj
 * @param prm_vecNormal_World @xNg([hWn)
 * @param prm_vecEye_World    (_ -> _)xNg([hWn)
 */
float4 GgafDxPS_DefaultMesh(
    float2 prm_uv              : TEXCOORD0,
    float4 prm_color           : COLOR0,
    float3 prm_vecNormal_World : TEXCOORD1,
    float3 prm_vecEye_World    : TEXCOORD2
) : COLOR  {
    float s = 0.0f; //XyL
    if (g_specular_power != 0) {
        //n[txNgiu_J_vxNg ƁAu_CgvxNg̐^񒆂̕xNgj
        float3 vecHarf = normalize(prm_vecEye_World + (-g_vecLightFrom_World));
        //n[txNgƖ@̓ςXyLvZ
        s = pow( max(0.0f, dot(prm_vecNormal_World, vecHarf)), g_specular ) * g_specular_power;
    }
    float4 colTex = tex2D( MyTextureSampler, prm_uv);
    //eNX`F
    float4 colOut = colTex * prm_color + s;
    //Blinkerl
    if (colTex.r >= g_tex_blink_threshold || colTex.g >= g_tex_blink_threshold || colTex.b >= g_tex_blink_threshold) {
        colOut *= g_tex_blink_power; //ă{|B_łڗB
    }
    //}X^[
    colOut.a *= g_alpha_master;
    return colOut;
}



/**
 * [Jڋԕϊ sԂ .
 * ڋԂƂ̓bVT[tFCX̂_ɂāA
 * eNX`uxNg, eNX`vxNg, @xNg 
 * Rŕ\Wn̎BR͒ĂB<BR>
 * w}yP[ǂƃRx̋L <BR>
 * http://marupeke296.com/DXPS_S_No5_NormalMap.html<BR>
 * pĒ܂B<BR>
 * @param prm_vecTangent  ڃxNg(uPʃxNg)
 * @param prm_vecBinormal ]@xNg(vPʃxNg)
 * @param prm_vecNormal   @xNg
 **/
float4x4 getInvTangentMatrix(
    float3 prm_vecTangent,
    float3 prm_vecBinormal,
    float3 prm_vecNormal )
{
    float4x4 mat = { float4(prm_vecTangent , 0.0f),
                     float4(prm_vecBinormal, 0.0f),
                     float4(prm_vecNormal  , 0.0f)  ,
                     {  0.0f, 0.0f, 0.0f, 1.0f } };
    return transpose( mat );  // ]u(搳Kn̍s̋ts͓]usŗǂ)
}


/**
 * GgafLib::DefaultMeshActor ov}bsOp̒_VF[_[ .
 * _ World > View > ˉe ϊA
 * f̃}eAFt𒸓_J[̐ݒōsB
 * }eAFtƂ͋̈ʓI
 * gUFAgUːFAFA}X^[At@AtHOA̎B
 * @param prm_posModel_Local    f_([JWn)
 * @param prm_vecNormal_Local   _̖@([JWn)
 * @param prm_uv                _UVW
 * @param prm_vecTangent_Local  _̐ڃxNg(uPʃxNg)([JWn)
 * @param prm_vecBinormal_Local _̏]@xNg(vPʃxNg)([JWn)
 */
OUT_VS_BM GgafDxVS_BumpMapping(
      float4 prm_posModel_Local    : POSITION,
      float3 prm_vecNormal_Local   : NORMAL,
      float2 prm_uv                : TEXCOORD0,
      float3 prm_vecTangent_Local  : TEXCOORD1,
      float3 prm_vecBinormal_Local : TEXCOORD2
) {
    OUT_VS_BM out_vs = (OUT_VS_BM)0;

    //_vZ
    float4 posModel_World = mul(prm_posModel_Local, g_matWorld); //Worldϊ
    out_vs.posModel_Proj = mul( mul( posModel_World, g_matView), g_matProj);  //World*View*ˉe

    //UVvZ
    out_vs.uv = prm_uv;  //̂܂

    // ڋԍs̋tsZo
    float4x4 matTangent = getInvTangentMatrix(prm_vecTangent_Local, prm_vecBinormal_Local, prm_vecNormal_Local );
    // WorldCgxNgڋԂɈڂ
    float3 vecLight_Local = mul(-g_vecLightFrom_World, g_matInvWorld); //[Jɖ߂āiTODO:͗\ߌvZłcj
    out_vs.vecLight_Tangent = mul(vecLight_Local, matTangent);         //ڋԍWn

    if (g_specular_power != 0) {
        //u_J_vxNgiXyLŎgpj
        out_vs.vecEye_World = normalize(g_posCam_World.xyz - posModel_World.xyz);
        //Worldn[txNgiu_J_vxNg ƁAu_CgvxNg̐^񒆂̕xNgj
        float3 vecHarf_World = normalize(out_vs.vecEye_World + (-g_vecLightFrom_World));
        //Worldn[txNgڋԂɈڂ
        float3 vecHarf_Local = mul(vecHarf_World, g_matInvWorld); //[Jɖ߂
        out_vs.vecHarf_Tangent = mul(vecHarf_Local, matTangent ); //ڋԍWn
    }

    //_J[vZ(gUF,}eAF)
    out_vs.color = g_colMaterialDiffuse;

    //̓}eAŗDƂi㏑j
    out_vs.color.a = g_colMaterialDiffuse.a;

    //̕\@B
    if (g_far_rate > 0.0) {
        if (out_vs.posModel_Proj.z > g_zf*g_far_rate) {
            out_vs.posModel_Proj.z = g_zf*g_far_rate; //{OZłA`邽 g_zf*0.999 ɏ㏑A
        }
    } else {
        //tHO
        if (out_vs.posModel_Proj.z > 0.6*g_zf) {   // ŉ̖ 2/3 肳ɉ̏ꍇXɓ
            out_vs.color.a *= (-3.0*(out_vs.posModel_Proj.z/g_zf) + 3.0);
        }
    }
    //}X^[
    out_vs.color.a *= g_alpha_master;

    return out_vs;
}

/**
 * GgafLib::DefaultMeshActor ov}bsOp̃sNZVF[_[ .
 * @param prm_uv               UVW
 * @param prm_color            Fi_J[ɂj
 * @param prm_vecNormal_World  @xNg(WorldWn)
 * @param prm_vecEye_World     (_->_)xNg(WorldWn)
 * @param prm_vecLight_Tangent gUxNg(ڋԍWn)
 * @param prm_vecHarf_Tangent  n[txNg(ڋԍWn)
 */
float4 GgafDxPS_BumpMapping(
    float2 prm_uv               : TEXCOORD0,
    float4 prm_color            : COLOR0,
    float3 prm_vecNormal_World  : TEXCOORD1,
    float3 prm_vecEye_World     : TEXCOORD2,
    float3 prm_vecLight_Tangent : TEXCOORD3,
    float3 prm_vecHarf_Tangent  : TEXCOORD4
) : COLOR  {
    float a = prm_color.a; //ێ

    //@}bv̖@
    float3 vecNormal_Tangent = normalize(2.0f * tex2D( BumpMapTextureSampler, prm_uv ).xyz - 1.0);

    //@(@}bv̖@A܂ڋԍWn̖@ɂȂjƁA
    //gUxNg(_VF[_[ŐڋԍWnɗ\ߕϊς) ̓ς
    //Cgˊp߁Aʂɑ΂gǓ(power)߂
    float power = max(dot(vecNormal_Tangent, normalize(prm_vecLight_Tangent) ), 0);

    float s = 0.0f; //XyL
    if (g_specular_power != 0) {
        //n[txNgiu_J_vxNg ƁAu_CgvxNg̐^񒆂̕xNg
        //ڋԍWnɗ\ߕϊς݁jƖ@(@}bv̖@A܂ڋԍWn̖@)̓ςXyLvZ
        s = pow( max(0.0f, dot(vecNormal_Tangent, prm_vecHarf_Tangent)), g_specular ) * g_specular_power; //@}bv̓ʉlB
    }

    float4 colTex = tex2D( MyTextureSampler, prm_uv); //PUVF擾A܂@}bv̓ʉ͖lB
    //FAeNX`FA_J[AAXyL lF쐬
    //texEmateE(amb + (lightEpow)) + spow
    float4 colOut = colTex * ((g_colLightAmbient + ( g_colLightDiffuse * power)) * prm_color ) + s; //prm_color = g_colMaterialDiffuse
    //Blinkerl
    if (colTex.r >= g_tex_blink_threshold || colTex.g >= g_tex_blink_threshold || colTex.b >= g_tex_blink_threshold) {
        colOut *= g_tex_blink_power; //ă{|B_łڗB
    }
    //}X^[
    colOut.a = a * g_alpha_master;
    return colOut;
}

/**
 * GgafLib::DefaultMeshActor p̑MsNZVF[_[ .
 * eNX`F FLUSH_COLOR {ĐݒB
 * @param prm_uv     sNZłUVW
 * @param prm_color  sNZł̐Fi_J[ɂj
 */
float4 PS_Flush(
    float2 prm_uv  : TEXCOORD0,
    float4 prm_color : COLOR0
) : COLOR  {
    float4 colTex = tex2D( MyTextureSampler, prm_uv);
    float4 colOut = colTex * prm_color * FLUSH_COLOR;
    colOut.a *= g_alpha_master;
    return colOut;
}

/**
 * ʏeNjbN .
 */
technique DefaultMeshTechnique
{
    pass P0 {
        AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
        //BlendOpAlpha = Add;       //default
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMesh();
        PixelShader  = compile PS_VERSION GgafDxPS_DefaultMesh();
    }
}

technique BumpMapping
{
    pass P0 {
        AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
        //BlendOpAlpha = Add;       //default
        VertexShader = compile VS_VERSION GgafDxVS_BumpMapping();
        PixelShader  = compile PS_VERSION GgafDxPS_BumpMapping();
    }
}

/**
 * ZeNjbN .
 */
technique DestBlendOne
{
    pass P0 {
        AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = One; //Z
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
        //BlendOpAlpha = Add;       //default
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMesh();
        PixelShader  = compile PS_VERSION GgafDxPS_DefaultMesh();
    }
}

/**
 * MeNjbN .
 */
technique Flush
{
    pass P0 {
        AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
        //BlendOpAlpha = Add;       //default
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMesh();
        PixelShader  = compile PS_VERSION PS_Flush();
    }
}

