#ifndef IKD_DIX_OGGVORBISRESOURCE_H
#define IKD_DIX_OGGVORBISRESOURCE_H
#include "GgafDxCommonHeader.h"

#define OV_EXCLUDE_STATIC_CALLBACKS

#include <string.h>
#include "vorbis/vorbisfile.h"

namespace IkdLib {

/**
 * OggVorbisResource .
 * {vÓA<BR>
 * u~i܂؂j[ǂƃRv http://marupeke296.com/index.html <BR>
 * TCgRec uOgg Vorbisҁv http://marupeke296.com/OGG_main.html <BR>
 * ̃TvvOIWiłB<BR>
 * ύXĎgpĂ܂B<BR>
 *                                            2009/01/13 Masatoshi Tsuge<BR>
 * @author  IKD
 */
class OggVorbisResource {
public:
    OggVorbisResource() :
            _is_ready(false) {
        memset(&_ogg_vorbis_file, 0, sizeof(OggVorbis_File));
    }

    virtual ~OggVorbisResource() {
        clear();
    }

    // NA
    virtual void clear() {
        ov_clear(&_ogg_vorbis_file);
        memset(&_ogg_vorbis_file, 0, sizeof(OggVorbis_File));
        _is_ready = false;
    }

    // OggVorbis_File\̂擾
    virtual OggVorbis_File& getOggVorbisFile() {
        return _ogg_vorbis_file;
    }

    // SȃN[쐬
    virtual OggVorbisResource* createClone() = 0;

    // łH
    bool isReady() {
        return _is_ready;
    }

protected:
    OggVorbis_File _ogg_vorbis_file; // OggVorbis_File\
    bool _is_ready; // łH
};
}

#endif
