#ifndef GGAFDXCORE_GGAFDXSCENE_H_
#define GGAFDXCORE_GGAFDXSCENE_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/scene/GgafMainScene.h"

namespace GgafDxCore {

#define MAX_BGM_PER_ACTOR 3

/**
 * GgafDxCoreOԁAV[NX.
 * ̋@\V[NXɒǉĂ܂B<BR>
 * EBGMt<BR>
 * EBGMtF[hCEtF[hAEg<BR>
 * EV[̕`IuWFNg̃tF[hCEtF[hAEg<BR>
 * GgafDxCoreOԓł́ÃNXV[Ƃ܂B<BR>
 * @version 1.00
 * @since 2008/01/24
 * @author Masatoshi Tsuge
 */
class GgafDxScene : public GgafCore::GgafMainScene {
private :
    /**
     * ʂŎgp֎~ .
     */
    void processFinal() override {
    }
    /**
     * draw() ̃I[o[Ch֎~ .
     * E(GgafDxUniverse)SĂ̕`sdg݂ɂȂ܂B<BR>
     * āAI[o[ChĂt[[NĂяo邱Ƃ͂܂B<BR>
     * ăI[o[ChȂ߂ private ŎB<BR>
     * GgafDxUniverse::draw() QƂB<BR>
     */
    void draw() override {
    }

public :
    /** [r]J[e */
    GgafDxAlphaCurtain* const _pAlphaCurtain;
    /** [r]BGMt */
    GgafDxBgmPerformerForScene* const _pBgmPerformer;
    /** [r]V[̃ */
    float _master_alpha;

public:
    /**
     * RXgN^ .
     * @param prm_name
     * @return
     */
    GgafDxScene(const char* prm_name);

    /**
     * ʃtF[hABGMtF[h .
     * {NXprocessSettlementBehavior()ŁA GgafDxAlphaCurtainGgafDxBgmPerformer<BR>
     * behave() Ă܂BI[o[ChƁAʃtF[hABGMtF[h܂B<BR>
     * I[o[Chꍇ́AKŏʃ\bhĂяoĉB<BR>
     * tGgafDxAlphaCurtainGgafDxBgmPerformer̋@\gpȂ炩ȃV[́A<BR>
     * I[o[ChĒׂƂɂA͂ɃptH[}XPł邩m܂<BR>
     */
    virtual void processSettlementBehavior() override;


    /**
     * c[V[̃AN^[tF[hC .
     * @param prm_frame_fade At@l 1.0 ɂȂ܂ł̎st[(0`)
     */
    void fadeinSceneTree(int prm_frame_fade);

    /**
     * V[̃AN^[tF[hC .
     * @param prm_frame_fade At@l 1.0 ɂȂ܂ł̎st[(0`)
     */
    void fadeinScene(int prm_frame_fade);

    /**
     * c[V[̃AN^[tF[hAEg .
     * @param prm_frame_fade At@l 0.0 ɂȂ܂ł̎st[(0`)
     */
    void fadeoutSceneTree(int prm_frame_fade);

    /**
      * V[̃AN^[tF[hAEg .
     * @param prm_frame_fade At@l 0.0 ɂȂ܂ł̎st[(0`)
     */
    void fadeoutScene(int prm_frame_fade);

    /**
     * V[̃AN^[tF[hAEgƓɁABGMtF[hAEg .
     * BGḾAV[o[ _pBgmPerformer(GgafDxBgmPerformerForSceneIuWFNg) 
     * tĂ邱ƂOB
     * @param prm_frame_fade tF[hAEgt[
     */
    void fadeoutSceneWithBgm(int prm_frame_fade);

    /**
     * c[V[̃AN^[tF[hAEgƓɁABGMtF[hAEg .
     * BGḾAV[o[ _pBgmPerformer(GgafDxBgmPerformerForSceneIuWFNg) 
     * tĂ邱ƂOB
     * @param prm_frame_fade tF[hAEgt[
     */
    void fadeoutSceneWithBgmTree(int prm_frame_fade);


    inline GgafDxBgmPerformerForScene* getBGMer() {
        return _pBgmPerformer;
    }
    virtual ~GgafDxScene();
};

}
#endif /*GGAFDXCORE_GGAFDXSCENE_H_*/
