#include "jp/ggaf/core/actor/ex/GgafDepositoryFormation.h"

#include "jp/ggaf/core/util/GgafStatus.h"
#include "jp/ggaf/core/actor/ex/GgafActorDepository.h"


using namespace GgafCore;

GgafDepositoryFormation::GgafDepositoryFormation(const char* prm_name, frame prm_offset_frames_end) :
        GgafFormation(prm_name, prm_offset_frames_end)
{
    _class_name = "GgafDepositoryFormation";
    _pDepo = nullptr;
    _can_call_up = true;
}
void GgafDepositoryFormation::setFormationMember(GgafActorDepository* prm_pDepo) {
#ifdef MY_DEBUG
    if (_pDepo) {
        throwGgafCriticalException("GgafDepositoryFormation::setFormationMember Ƀf|Wg͓o^ς("<<_pDepo->getName()<<")łB\n"<<
                                   "this="<<this<<"("<<getName()<<") prm_pDepo="<<prm_pDepo);
    }
    if (prm_pDepo) {
        //OK
    } else {
        throwGgafCriticalException("GgafDepositoryFormation::setFormationMember sȃf|WgłB\n"<<
                                   "this="<<this<<"("<<getName()<<") prm_pDepo="<<prm_pDepo);
    }
    if (prm_pDepo->getSubFirst()) {
        //OK
    } else {
        throwGgafCriticalException("GgafDepositoryFormation::setFormationMember("<<prm_pDepo->getName()<<") f|Wg̃Tu݂܂B\n"<<
                                   "this="<<this<<"("<<getName()<<") prm_pDepo="<<prm_pDepo);
    }
    if (prm_pDepo->getPlatformScene()) {
        //OK
    } else {
        throwGgafCriticalException("GgafDepositoryFormation::setFormationMember("<<prm_pDepo->getName()<<") f|WgV[ɖłB\n"<<
                                   "this="<<this<<"("<<getName()<<") prm_pDepo="<<prm_pDepo);
    }
#endif
    _pDepo = prm_pDepo;
    //cɎʂ𐳂`邽߂Ƀf|Wgʈp
    getStatus()->set(STAT_DEFAULT_ACTOR_KIND, _pDepo->getStatus()->getUint(STAT_DEFAULT_ACTOR_KIND));
}

void GgafDepositoryFormation::processFinal() {
//    _TRACE_("processFinal() "<<getActiveFrame()<<":before----->");
//    for (int i = 0; i < _listFollower.length(); i++) {
//        _TRACE_("processFinal() _listFollower["<<i<<"]="<<_listFollower.getFromFirst(i)->getName()<<"("<<_listFollower.getFromFirst(i)<<")");
//    }
//    _TRACE_("processFinal() "<<getActiveFrame()<<"<-----");
    if (_listFollower.length() > 0) {
        //ґo[󋵃`FbN
        GgafActor* pFollower;
        for (int i = 0; i < _listFollower.length(); i++) { //[v _listFollower.remove() ̂ŁA[JɗƂȂ
            pFollower = _listFollower.getCurrent();
            if (_can_live_flg) {
                if (pFollower->_is_active_flg) {
                    _listFollower.next();
                } else if (pFollower->_will_activate_after_flg && (pFollower->_frame_of_life <= pFollower->_frame_of_life_when_activation)) {
                    //Ɋ\łc
                    _listFollower.next();
                } else {
                    //ґo[O
//                    _TRACE_("i="<<i<<" o["<<_listFollower.length()<<" Ăꂩ"<<_listFollower.getCurrent()->getName()<<"o[O܂I(X)");
                    _listFollower.getCurrent()->_pFormation = nullptr;
                    _listFollower.remove(); //remove() AVȃJgvf next ̗vfɂȂB
                }
            } else {
                //ґo[O
//                 _TRACE_("i="<<i<<" o["<<_listFollower.length()<<" "<<_listFollower.getCurrent()->getName()<<"o[O܂I(A)");
                _listFollower.getCurrent()->_pFormation = nullptr;
                _listFollower.remove();//remove() AVȃJgvf next ̗vfɂȂB
            }
        }
    }

    if (_listFollower.length() == 0) {
        if (_can_call_up == false && _was_all_sayonara == false) {
            //ґo[0A
            //ȏ callUp sŁAonSayonaraAll()R[obNs̏ꍇ
            onSayonaraAll(); //R[obN
            sayonara(_offset_frames_end); //ґ̂ȂB
            _was_all_sayonara = true;
        }
    }
}

GgafActor* GgafDepositoryFormation::callUpMember(int prm_formation_sub_num) {
    if (_can_call_up == false || wasDeclaredEnd() || _will_inactivate_after_flg) {
        //I҂̂
        return nullptr;
    }
#ifdef MY_DEBUG
    if (!_pDepo) {
        throwGgafCriticalException("GgafDepositoryFormation::callUpUntil "<<getName()<<"́ADepositoryw肳Ă܂BsetFormationMemberKvłB"<<
                                   "this="<<getName()<<" _num_formation_member="<<_num_formation_member);
    }
#endif

    if (prm_formation_sub_num <= _num_formation_member) {
        _can_call_up = false;
        return nullptr; //ȏcallUpUntils
    } else {
        GgafMainActor* pActor = _pDepo->dispatch();
        if (pActor) {
            _num_formation_member++;
            _can_call_up = true;
            pActor->_pFormation = this;
            _listFollower.addLast(pActor, false);
            return (GgafActor*)pActor;
        } else {
            _can_call_up = false;
            return nullptr; //ȏcallUpUntils
        }
    }
}

bool GgafDepositoryFormation::canCallUp() {
    return _can_call_up;
}

void GgafDepositoryFormation::onEnd() {
    GgafFormation::onEnd();
    sayonaraFollwer();
}
void GgafDepositoryFormation::sayonaraFollwer() {
    if (_listFollower.length() == 0) {
        return;
    }
    while (_listFollower.length() > 0) {
        if (_listFollower.getCurrent()->_pFormation == this) {
            _listFollower.getCurrent()->sayonara();
            _listFollower.getCurrent()->_pFormation = nullptr;
        } else {
            throwGgafCriticalException("GgafDepositoryFormation::sayonaraFollwer() _listFollowerɎgformationǗł͂Ȃo[܂I\n"<<
                                       " this="<<getName()<<"("<<this<<") \n"<<
                                       " _listFollower.getCurrent()="<<(_listFollower.getCurrent()->getName())<<"("<<(_listFollower.getCurrent())<<") \n"<<
                                       " _listFollower.getCurrent()->_pFormation="<<(_listFollower.getCurrent()->_pFormation->getName())<<"("<<(_listFollower.getCurrent()->_pFormation)<<") ");
        }
        _listFollower.remove();
    }

}

GgafDepositoryFormation::~GgafDepositoryFormation() {

}
