#ifndef GGAFCORE_GGAFACTOR_H_
#define GGAFCORE_GGAFACTOR_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/GgafElement.hpp"

#include "jp/ggaf/core/util/GgafStatus.h"
#define STAT_DEFAULT_ACTOR_KIND 0

namespace GgafCore {

/**
 * AN^[iҁj̊NX .
 * {vOł́wAN^[xƂ́AɃLN^[\B<BR>
 * eV[(GgafScene)ɏA􂷂C[WB<BR>
 * GgafElement ɓ蔻dg݂NXɂȂĂB<BR>
 * {NX͒ۃNXł̂܂ new ͂łȂB<BR>
 * SẴAN^[NX́A{NXpȂƂȉ̏z֐KvB<BR>
 * <BR>
 * PxĂяo鏃z֐<BR>
 * void initialize() EEE <BR>
 * ʏAt[Ăяo鏃z֐<BR>
 * void processBehavior() EEEt[̐U镑iWړj <BR>
 * void processJudgement() EEEt[̗lXȔ菈iSAN^[U镑̏j <BR>
 * void processPreDraw() EEEt[̕`掖O <BR>
 * void processDraw() EEEt[̕`{ <BR>
 * void processAfterDraw() EEEt[̕`掖㏈ <BR>
 * void processFinal() EEEt[̏I[ <BR>
 * t[Ăяo킯ł͂Ȃz֐<BR>
 * void onCatchEvent(hashval prm_no, void* prm_pSource) EEȆ̃Cxg̏ <BR>
 * bool processHitChkLogic(GgafActor* prm_pOtherActor) EEEՓ˔胍WbN <BR>
 * void onHit(GgafActor* prm_pOtherActor) EEEՓ˔胍WbNtruȅꍇ̏ <BR>
 * <BR>
 * ev[gNX GgafNode ƁAGgafElement ̐QƂ̂ƁB<BR>
 * @version 1.00
 * @since 2007/11/14
 * @author Masatoshi Tsuge
 */
class GgafActor : public GgafElement<GgafActor> {

    friend class GgafGod;
    friend class GgafMainActor;
    friend class GgafSceneDirector;
    friend class GgafGroupHead;
    friend class GgafDummyActor;
    friend class GgafScene;
    friend class GgafUniverse;
    friend class GgafGarbageBox;

private:
    /** ݂̏V[ */
    GgafScene* _pScene_platform;

    /**
     * V[ݒ肷B .
     */
    void setPlatformScene(GgafScene* prm_pScene_platform);

public:
    /** [r]f|Wg(nullptr͖) */
    GgafActorDepository* _pDependenceDepository;
    /** [r]tH[[V(nullptr͖) */
    GgafFormation* _pFormation;

    /** [r]AN^[Փ˔LtO */
    bool _can_hit_flg;
    /** [r]true:EOłqbg`FbNs/false:EO̓qbg`FbNsȂȂ */
    bool _can_hit_out_of_view;
    /** [r/w]RXe[^X */
    GgafStatus* _pStatus;

public:
    /**
     * RXgN^ .
     * @param prm_name AN^[̖O
     * @param prm_pStat AN^[̃Xe[^Xinullptȑꍇ͎j
     */
    GgafActor(const char* prm_name, GgafStatus* prm_pStat);

    /**
     * fXgN^ .
     * c[AN^[̉s܂B
     */
    virtual ~GgafActor();

    /**
     * AN^[̏Փ˔Lݒ肷B .
     * @param prm_can_hit_flg  Փ˔L(true:Փ˔L^false:Փ˔薳)
     * @param prm_can_hit_out_of_view_flg  Փ˔L̏ꍇAOՓ˔̗Lݒ(true:ʊOՓ˔L^false:ʊOՓ˔薳)
     */
    void setHitAble(bool prm_can_hit_flg, bool prm_can_hit_out_of_view_flg);
    /**
     * AN^[̏Փ˔Lݒ肷B .
     * OՓ˔̗L͕ωȂB
     * @param prm_can_hit_flg  Փ˔L(true:Փ˔L^false:Փ˔薳)
     */
    void setHitAble(bool prm_can_hit_flg);
    /**
     * c[AN^[̏Փ˔Lݒ肷B .
     * @param prm_can_hit_flg  Փ˔L(true:Փ˔L^false:Փ˔薳)
     * @param prm_can_hit_out_of_view_flg  Փ˔L̏ꍇAOՓ˔̗Lݒ(true:ʊOՓ˔L^false:ʊOՓ˔薳)
     */
    void setHitAbleTree(bool prm_can_hit_flg, bool prm_can_hit_out_of_view_flg);
    void setHitAbleTree(bool prm_can_hit_flg);
    /**
     * ݏՓ˂ł󋵂ǂ .
     * ӁFՓ˔\͂邩ǂł͖B
     * @return	bool true:Փˉ\󋵁^false:Փ˕s\
     */
    inline bool canHit() {
        if (_can_live_flg && _is_active_flg && _can_hit_flg) {
            return true;
        } else {
            return false;
        }
    }


    /**
     * ĂV[擾B .
     * @return	GgafScene*	ĂV[
     */
    virtual GgafScene* getPlatformScene();

    /**
     * AN^[ƑAN^[̂P΂P̓蔻菈sB
     * @param prm_pOtherActor AN^[
     */
    virtual void executeHitChk_MeAnd(GgafActor* prm_pOtherActor) {
        if (prm_pOtherActor == this) {
            return;
        } else {
            //qbgł镨ǂ͎̔Oɂł悤ɂ鎖B
            if (processHitChkLogic(prm_pOtherActor)) { //g̃qbg`FbN
                onHit(prm_pOtherActor); //̃qbg̐U镑
                prm_pOtherActor->onHit(this); //̃qbg̐U镑
            }
        }
    }

    /**
     * AN^[Ɖ̃AN^[ƏՓ˂ǂ肷郍WbNB .
     * executeHitChk_MeAnd(GgafActor*) sꂽꍇɌĂяo邱ƂɂȂB<BR>
     * ʃNXœƎɏՓ˔胍WbNB<BR>
     * ̃\bh͉Ăяo邩͌܂ĂȂBĂяo^C~OʃNXˑB<BR>
     * zƂẮAprocessJudgement() \bhNXA̒Ŗ{\bhĂяôƂĂB<BR>
     * ̂悤ɎꍇAAN^[ processJudgement() ł̃AN^[Ƃ̏Փ˔sƂɂȂ΁A<BR>
     * Փ˔菈d邱ƂɂȂBǁ[悢l邱ƁB<BR>
     * @param	prm_pOtherActor	AN^[
     * @retval	true	Փ˂ĂԂ
     * @retval	false	Փ˂ĂȂԂ
     */
    virtual bool processHitChkLogic(GgafActor* prm_pOtherActor) {
        return false;
    }

    /**
     * AN^[ƏՓ˂̏ .
     * processHitChkLogic(GgafActor*)  true ̏ꍇɌĂяo邱ƂɂȂ܂B<BR>
     * Փ˔̌ʁAՓ˂ꍇ̏ʃNXĂB<BR>
     * @param	prm_pOtherActor	Փ˂Ă鑊̃AN^[iPj
     */
    virtual void onHit(GgafActor* prm_pOtherActor) {}

    /**
     * DepositoryɏĂꍇAԂB
     * ̏ꍇnullptr
     * @return Depository
     */
    GgafActorDepository* getDependenceDepository() {
        return _pDependenceDepository;
    }

    /**
     * gґSŔɗLȔĵŏłÃtH[[Vɒʒm郁\bh .
     * gtH[[VɏĂ(_pFormation != nullptr)ꍇA
     * tH[[V̕ґSŔs߂ɁAgґSłɗLȏŁA܂
     * ʊOAŁAł͖A@ɔj󂳂ꂽꍇA{\bhsāAǗtH[[VɒʒmĉB<BR>
     * ʒmsƂɂAǗĂ Formation IuWFNgA
     * ґSŎɁA
     *
     * Formation::onDestroyAll()
     *
     * ̃R[obNs܂B
     * ґ{[iXAACeȍ GgafDxFormationActor::onDestroyAll() 
     * I[o[ChōsĉB
     * <code><pre>
     * ၄
     * void SampleActor::onHit(GgafActor* prm_pOtherActor) {
     *    //g̑ϋv̓`FbN
     *    if (MyStgUtil::calcSampleStatus(_pStatus, getKind(), pOther->_pStatus, pOther->getKind()) <= 0) {
     *        //Hit̑̃`FbN
     *        if (pOther->getKind() & KIND_MY) {
     *            //Hit͎̑@֘Ai@A@jbgA@˒e)
     *            notifyDestroyedToFormation(); //ґSŔɗLȔjʒm
     *        }
     *    }
     * }
     *
     * </pre></code>
     * gtH[[VɏĂȂ(_pFormation == nullptr)ꍇA{\bh͉N܂B
     */
    virtual void notifyDestroyedToFormation();

    /**
     * g̏̃tH[[VԂ .
     * @return tH[[VB́AĂȂꍇnullptr
     */
    virtual GgafFormation* getFormation();

    /**
     * Ȃ炵܂ .
     * Depository ɏĂꍇ inactiveAfter(prm_offset_frames) <BR>
     * Depository ɏĂȂꍇ end(prm_offset_frames) <BR>
     * As܂B
     * AN^[V[痣Eꍇ͂̃\bhs邱ƁB
     * @param prm_offset_frames P\t[(1`)
     */
    virtual void sayonara(frame prm_offset_frames = 1);

    /**
     * c[\؂藣 .
     * @return
     */
    virtual GgafActor* extract() override;

    /**
     * IuWFNg̃NXR𒲂ׂB
     * _obj_class oϐ Obj_xxxx }N萔ݒ肳Ă邱ƂOB
     * @param prm_Obj_xxxx ׂNX̃}N萔
     * @return
     */
    virtual bool instanceOf(classkind prm_Obj_xxxx) override {
        if ((Obj_SceneBit & prm_Obj_xxxx) == Obj_SceneBit) {
            //V[rbgĂ
            return false;
        } else {
            return GgafElement<GgafActor>::instanceOf(prm_Obj_xxxx);
        }
    }

    inline GgafStatus* getStatus() {
        return _pStatus;
    }

    /**
     * fobOpFc[\\<BR>
     */
    virtual void dump();

    /**
     * fobOpFdump()gp<BR>
     */
    virtual void dump(std::string prm_parent);

};

}
#endif /*GGAFCORE_GGAFACTOR_H_*/
