#ifndef ENEMYSTRAEA_H_
#define ENEMYSTRAEA_H_
#include "jp/ggaf/lib/actor/DefaultMeshActor.h"

namespace VioletVreath {

/**
 * XgGA .
 * @B
 * @version 1.00
 * @since 2009/04/23
 * @author Masatoshi Tsuge
 */
class EnemyStraea : public GgafLib::DefaultMeshActor {

private:
    /** ˍς݃[U[`bv */
    int cnt_laserchip_;

    struct PosLaser {
        int X;
        int Y;
        int Z;
    };

public:
    enum {
        PROG_ENTRY,
        PROG_MOVE ,
        PROG_TURN ,
        PROG_FIRE ,
    };

    enum {
        SE_EXPLOSION,
        SE_FIRE     ,
    };

    /** [UˊԊu(frame) */
    int laser_interval_;
    /** ˃[U[`bv̐i[U[j */
    int laser_length_;
    /** [U[Way(n~n)̈ӂ̖{ */
    int laser_way_;
    /** [U[ƃ[U[̊ԊuJpx */
    angle angClearance_;
    /** ]px */
    angvelo angveloTurn_;
    /** [U[˃[JW */
    PosLaser** papaPosLaser_;

    DepositoryConnection* pConn_RefractionEffectDepository_;

    DepositoryConnection* pConn_LaserChipDepoStore_;

    GgafLib::LaserChipDepository*** papapLaserChipDepo_;

    DepositoryConnection* pConn_ShotDepo2_;
    DepositoryConnection* pConn_ShotDepo3_;

public:
    EnemyStraea(const char* prm_name);

    void onCreateModel() override;

    void initialize() override;

    void onActive() override;

    void processBehavior() override;

    void processJudgement() override;

    void onCatchEvent(hashval prm_no, void* prm_pSource) override {
    }

    void onHit(GgafCore::GgafActor* prm_pOtherActor) override;

    void onInactive() override;

    virtual ~EnemyStraea();
};

}
#endif /*ENEMYSTRAEA_H_*/

