#include "stdafx.h"
#include "VamSysCamWorker.h"

#include "jp/ggaf/dxcore/actor/GgafDxCameraViewPoint.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoB.h"
#include "jp/gecchi/VioletVreath/actor/my/MyOptionController.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/Properties.h"
#include "jp/gecchi/VioletVreath/scene/Universe.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

VamSysCamWorker::VamSysCamWorker(const char* prm_name) : CameraWorker(prm_name) {
    _class_name = "VamSysCamWorker";
    pMyShip_ = nullptr; //MyShipSceneɐݒ肵Ă炤

    //Jړ͈͐
    float revise = 0.7; //΂߂猩̂ŕ␳l|B1.0̏ꍇ͌_ŃhsVB͔JԂ
    lim_CAM_top_     = MyShip::lim_Y_top_     - (PX_C(PROPERTY::GAME_BUFFER_HEIGHT)/2)*revise;
    lim_CAM_bottom_  = MyShip::lim_Y_bottom_  + (PX_C(PROPERTY::GAME_BUFFER_HEIGHT)/2)*revise;
    lim_CAM_front_   = MyShip::lim_X_front_   - (PX_C(PROPERTY::GAME_BUFFER_WIDTH)/2)*revise;
    lim_CAM_behaind_ = MyShip::lim_X_behaind_ + (PX_C(PROPERTY::GAME_BUFFER_WIDTH)/2)*revise;
    lim_CAM_zleft_   = MyShip::lim_Z_left_   - (PX_C(PROPERTY::GAME_BUFFER_WIDTH)/2)*revise;
    lim_CAM_zright_  = MyShip::lim_Z_right_  + (PX_C(PROPERTY::GAME_BUFFER_WIDTH)/2)*revise;

    lim_VP_top_     = MyShip::lim_Y_top_     - (PX_C(PROPERTY::GAME_BUFFER_HEIGHT)/2)*revise;
    lim_VP_bottom_  = MyShip::lim_Y_bottom_  + (PX_C(PROPERTY::GAME_BUFFER_HEIGHT)/2)*revise;
    lim_VP_front_   = MyShip::lim_X_front_   - (PX_C(PROPERTY::GAME_BUFFER_WIDTH)/2)*revise;
    lim_VP_behaind_ = MyShip::lim_X_behaind_ + (PX_C(PROPERTY::GAME_BUFFER_WIDTH)/2)*revise;
    lim_VP_zleft_   = MyShip::lim_Z_left_   - (PX_C(PROPERTY::GAME_BUFFER_WIDTH)/2)*revise;
    lim_VP_zright_  = MyShip::lim_Z_right_  + (PX_C(PROPERTY::GAME_BUFFER_WIDTH)/2)*revise;
    is_cam_pos_option_back_ = false;
}
void VamSysCamWorker::initialize() {
    GgafDxCamera* pCam = P_CAM;
    GgafDxGeometricActor* pVP = pCam->getViewPoint();

    //JZʒu
    dZ_camera_init_ = -DX_C(pCam->_cameraZ_org);


    //ʔwp͈͍
    //wZWdZ_camera_init_/2
    correction_width_ = 0;//(PROPERTY::GAME_BUFFER_WIDTH*LEN_UNIT/2)/4;
    correction_height_ = 0;//(PROPERTY::GAME_BUFFER_HEIGHT*LEN_UNIT/2)/4;

    pos_camera_ = VAM_POS_RIGHT;

    cam_velo_renge_ = 30000;
    pCam->_pKurokoB->forceVxyzMvVeloRange(-cam_velo_renge_, cam_velo_renge_);
    pVP->_pKurokoB->forceVxyzMvVeloRange(-cam_velo_renge_, cam_velo_renge_);

    stop_renge_ = 60000;
    angXY_nowCamUp_ = UTIL::getAngle2D(pCam->_pVecCamUp->x, pCam->_pVecCamUp->y);
    stop_dZ_ = 0;
    stop_dY_ = 0;
    _TRACE_("VamSysCamWorker::initialize() this="<<this);
    dump();
}

void VamSysCamWorker::processBehavior() {
    VirtualButton* pVbPlay = VB_PLAY;
    //DefaultVamSysCamWorker::processBehavior();

    //Q[J[N
    if (pMyShip_ == nullptr) {
        return; //MyShipSceneV[ȂJ[N֎~
    }

    GgafDxCamera* pCam = P_CAM;
    GgafDxGeometricActor* pVP = pCam->getViewPoint();
    MyOptionController* pOptCtrler = P_MYSHIP_SCENE->papOptionCtrler_[0];
    GgafDxKurokoB* const pCamKurokoB = pCam->_pKurokoB;
    GgafDxKurokoB* const pVpKurokoB = pVP->_pKurokoB;

    //Jʒuԍ菈
    is_cam_pos_option_back_ = false;
    if (pVbPlay->isBeingPressed(VB_OPTION)) { //IvV쎞
        if (pVbPlay->isBeingPressed(VB_VIEW)) {
            is_cam_pos_option_back_ = true;
        }
    } else if (pVbPlay->isPushedDown(VB_VIEW)) { //r[{^vbV                              //IvV񑀍쎞iʏ펞j
        _TRACE_("VB_VIEW!! now pos_camera_="<<pos_camera_);
        if (pos_camera_ < VAM_POS_TO_BEHIND) { //wʃr[|Cgł͂ȂꍇA
            pos_camera_ += VAM_POS_TO_BEHIND;  //ꂼ̑Ήwʃr[|Cg
        } else if (pos_camera_ > VAM_POS_TO_BEHIND) {//wʃr[|Cg̏ꍇ
            //͂ɂVȃr[|Cg
            if (pVbPlay->isBeingPressed(VB_RIGHT)) {
                pos_camera_ = VAM_POS_LEFT;
            } else if (pVbPlay->isBeingPressed(VB_LEFT)) {
                pos_camera_ = VAM_POS_RIGHT;
            } else if (pVbPlay->isBeingPressed(VB_UP)) {
                pos_camera_ = VAM_POS_BOTTOM;
            } else if (pVbPlay->isBeingPressed(VB_DOWN)) {
                pos_camera_ = VAM_POS_TOP;
            } else {
                //͂̏ꍇÃr[|Cg
                pos_camera_ -= VAM_POS_TO_BEHIND;
            }
        }
        _TRACE_("VB_VIEW!!  -> pos_camera_="<<pos_camera_);
    }

    //J̈ړڕWW
    coord move_target_X_CAM, move_target_Y_CAM, move_target_Z_CAM;
    //J̃r[|Cg̈ړڕWW
    coord move_target_X_VP, move_target_Y_VP, move_target_Z_VP;
    //J̖ڕWUPAOl
    angle move_target_XY_CAM_UP;

    //J̖ڕWWAr[|Cg̖ڕWWݒ
    static coord Dx = PX_C(PROPERTY::GAME_BUFFER_WIDTH/4);
    static int Ddx_hw = (int)((PROPERTY::GAME_BUFFER_WIDTH*LEN_UNIT/2) - (PROPERTY::GAME_BUFFER_HEIGHT*LEN_UNIT/2));

    if (is_cam_pos_option_back_) {
        //IvV쒆̃IvVwʂɉ
        coord d = dZ_camera_init_*0.6;
        move_target_X_CAM = pOptCtrler->_X + pOptCtrler->_pKurokoA->_vX*-d;
        move_target_Y_CAM = pOptCtrler->_Y + pOptCtrler->_pKurokoA->_vY*-d;
        move_target_Z_CAM = pOptCtrler->_Z + pOptCtrler->_pKurokoA->_vZ*-d;
        move_target_X_VP = pOptCtrler->_X + pOptCtrler->_pKurokoA->_vX*d;
        move_target_Y_VP = pOptCtrler->_Y + pOptCtrler->_pKurokoA->_vY*d;
        move_target_Z_VP = pOptCtrler->_Z + pOptCtrler->_pKurokoA->_vZ*d;
        move_target_XY_CAM_UP = UTIL::simplifyAng(pOptCtrler->_pKurokoA->_angRzMv+D90ANG);

    } else {//ʏ펞VAM
        if (pos_camera_ < VAM_POS_TO_BEHIND) {
            if (pos_camera_ == VAM_POS_RIGHT) {
    //            move_target_X_CAM = 0;
    //            move_target_Y_CAM = 0;
    //            move_target_Z_CAM = -dZ_camera_init_;
    //            move_target_X_VP = 0;
    //            move_target_Y_VP = 0;
    //            move_target_Z_VP = 0;

                move_target_X_CAM = -Dx + (-pMyShip_->_X-200000)*2;
                // -200000 ̓JړʒuA
                //   *2 ͎@ɉ̃J̃pB
                //   ̕ӂ̐l͔[܂ŒJB
                //   TODO:{̓Q[̈̑傫瓮IɌvZłBB
                if (-Dx > move_target_X_CAM) {
                    move_target_X_CAM = -Dx;
                } else if (move_target_X_CAM > Dx/2) {
                    move_target_X_CAM = Dx/2;
                }
                move_target_Y_CAM = pMyShip_->_Y;
                move_target_Z_CAM = pMyShip_->_Z - dZ_camera_init_;

                move_target_X_VP = Dx - (-pMyShip_->_X-200000)*2;
                if (Dx < move_target_X_VP) {
                    move_target_X_VP = Dx;
                } else if ( move_target_X_VP < -Dx/2) {
                    move_target_X_VP = -Dx/2;
                }
                move_target_Y_VP = pMyShip_->_Y;
                move_target_Z_VP = pMyShip_->_Z-100000;
                move_target_XY_CAM_UP = D90ANG;
            } else if (pos_camera_ == VAM_POS_LEFT) {
                move_target_X_CAM = -Dx + (-pMyShip_->_X-200000)*2;
                if (-Dx > move_target_X_CAM) {
                    move_target_X_CAM = -Dx;
                } else if (move_target_X_CAM > Dx/2) {
                    move_target_X_CAM = Dx/2;
                }
                move_target_Y_CAM = pMyShip_->_Y;
                move_target_Z_CAM = pMyShip_->_Z + dZ_camera_init_;
                move_target_X_VP = Dx - (-pMyShip_->_X-200000)*2;
                if (Dx < move_target_X_VP) {
                    move_target_X_VP = Dx;
                } else if ( move_target_X_VP < -Dx/2) {
                    move_target_X_VP = -Dx/2;
                }
                move_target_Y_VP = pMyShip_->_Y;
                move_target_Z_VP = pMyShip_->_Z+100000;
                move_target_XY_CAM_UP = D90ANG;
            } else if (pos_camera_ == VAM_POS_TOP) {
                move_target_X_CAM = -Dx - Ddx_hw + (-pMyShip_->_X-125000)*2;
                if ((-Dx - Ddx_hw) > move_target_X_CAM) {
                    move_target_X_CAM = -Dx - Ddx_hw;
                } else if (move_target_X_CAM > (Dx + Ddx_hw)/2) {
                    move_target_X_CAM = (Dx + Ddx_hw)/2;
                }
                move_target_Y_CAM = pMyShip_->_Y + dZ_camera_init_ + Ddx_hw;
                move_target_Z_CAM = pMyShip_->_Z;
                move_target_X_VP = Dx + Ddx_hw - (-pMyShip_->_X-125000)*2;
                if (Dx + Ddx_hw < move_target_X_VP) {
                    move_target_X_VP = Dx + Ddx_hw;
                } else if ( move_target_X_VP < -(Dx + Ddx_hw)/2) {
                    move_target_X_VP = -(Dx + Ddx_hw)/2;
                }
                move_target_Y_VP = pMyShip_->_Y;
                move_target_Z_VP = pMyShip_->_Z;
                if (pCam->_X < pVP->_X) {
                    move_target_XY_CAM_UP = D45ANG;
                } else {
                    move_target_XY_CAM_UP = D315ANG;
                }
            } else if (pos_camera_ == VAM_POS_BOTTOM) {
                move_target_X_CAM = -Dx - Ddx_hw + (-pMyShip_->_X-125000)*2;
                if ((-Dx - Ddx_hw) > move_target_X_CAM) {
                    move_target_X_CAM = -Dx - Ddx_hw;
                } else if (move_target_X_CAM > (Dx + Ddx_hw)/2) {
                    move_target_X_CAM = (Dx + Ddx_hw)/2;
                }
                move_target_Y_CAM = pMyShip_->_Y - dZ_camera_init_ - Ddx_hw;
                move_target_Z_CAM = pMyShip_->_Z;
                move_target_X_VP = Dx + Ddx_hw - (-pMyShip_->_X-125000)*2;
                if (Dx + Ddx_hw < move_target_X_VP) {
                    move_target_X_VP = Dx + Ddx_hw;
                } else if ( move_target_X_VP < -(Dx + Ddx_hw)/2) {
                    move_target_X_VP = -(Dx + Ddx_hw)/2;
                }
                move_target_Y_VP = pMyShip_->_Y;
                move_target_Z_VP = pMyShip_->_Z;
                if (pCam->_X < pVP->_X) {
                    move_target_XY_CAM_UP = D135ANG;
                } else {
                    move_target_XY_CAM_UP = D255ANG;
                }
            }
        } else if (pos_camera_ > VAM_POS_TO_BEHIND) {
            move_target_X_CAM = pMyShip_->_X - (dZ_camera_init_*0.6);
            move_target_Y_CAM = pMyShip_->_Y;
            move_target_Z_CAM = pMyShip_->_Z;
            move_target_X_VP = pMyShip_->_X + (dZ_camera_init_*2);
            move_target_Y_VP = pMyShip_->_Y;
            move_target_Z_VP = pMyShip_->_Z;
            move_target_XY_CAM_UP = D90ANG;
    //        if (pos_camera_ == VAM_POS_BEHIND_RIGHT) {
    //            move_target_Z_CAM -= Dd;
    //        } else if (pos_camera_ == VAM_POS_BEHIND_LEFT) {
    //            move_target_Z_CAM += Dd;
    //        } else if (pos_camera_ == VAM_POS_BEHIND_TOP) {
    //            move_target_Y_CAM += Dd;
    //        } else if (pos_camera_ == VAM_POS_BEHIND_BOTTOM) {
    //            move_target_Y_CAM -= Dd;
    //        }
        } else {
            throwGgafCriticalException("World::processBehavior() spos_camera_="<<pos_camera_);
        }
        //J̖ڕWWAr[|Cg̖ڕWWɂāA݂̓Ăւ̎኱ʊsBiɺj
        move_target_Z_CAM -= (pMyShip_->_Z*0.05);
        move_target_Y_CAM -= (pMyShip_->_Y*0.05);
    }

//
//    GgafDxGeoElem* pGeoMyShip = pMyShip_->pRing_GeoHistory_->getCurrent(); //݂̎@W
//    GgafDxGeoElem* pGeoMyShip_prev= pMyShip_->pRing_GeoHistory_->getPrev(); //݂̂ЂƂÕt[̎@W
//    stop_dZ_ += (pGeoMyShip_prev->_Z - pGeoMyShip->_Z)*0.1; //@̈ړʂ1̈ړʂ
//    stop_dY_ += (pGeoMyShip_prev->_Y - pGeoMyShip->_Y)*0.1; //J̖ڕWWɉZĂ܂B
//    move_target_Z_CAM += stop_dZ_;
//    move_target_Y_CAM += stop_dY_;


    int cam_velo_renge;  //J̈ړx̍őAŏ~l
    //VB_VIEW̏
    if (pVbPlay->isBeingPressed(VB_VIEW)) {
        //VB_VIEWςȂ́AȈړxɐ
        cam_velo_renge = cam_velo_renge_ / 100;
    } else {
        //ʏ̃Jړxɂ
        cam_velo_renge = cam_velo_renge_;
    }
    //VB_VIEW̏
    if (pVbPlay->isReleasedUp(VB_VIEW)) {
        if (pVbPlay->isPushedUp(VB_VIEW, 20)) {
            //`̏ꍇAȂɂȂiʂɃr[|CgړƂȂj
        } else {
            //AVB_VIEW
            if (pos_camera_ < VAM_POS_TO_BEHIND) { //wʃr[|Cgł͂ȂꍇA
                //ꂼ̌̑Ήr[|Cg֖߂B
                pos_camera_ += VAM_POS_TO_BEHIND;
            } else if (pos_camera_ > VAM_POS_TO_BEHIND) {//wʃr[|Cgꍇ
                //̂܂

                //ꂼ̌̑Ήwʃr[|Cg֖߂B
                //pos_camera_ -= VAM_POS_TO_BEHIND;
            }
        }
    }
    //J̈ړx̍őAŏݒ
    pCamKurokoB->forceVxyzMvVeloRange(-cam_velo_renge, cam_velo_renge);
    pVpKurokoB->forceVxyzMvVeloRange(-cam_velo_renge, cam_velo_renge);

    //Jƃr[|Cg̈ړW𐧌B
    //@ړ͈͂ɉāAʒ[̊o邽߁B(ƂȂH)
    if (pos_camera_ < VAM_POS_TO_BEHIND) {
        if (pos_camera_ == VAM_POS_RIGHT) {
            if (move_target_Y_CAM > lim_CAM_top_) {
                move_target_Y_CAM = lim_CAM_top_;
            }
            if (move_target_Y_CAM < lim_CAM_bottom_ ) {
                move_target_Y_CAM = lim_CAM_bottom_;
            }
        } else if (pos_camera_ == VAM_POS_LEFT) {
            if (move_target_Y_CAM > lim_CAM_top_) {
                move_target_Y_CAM = lim_CAM_top_;
            }
            if (move_target_Y_CAM < lim_CAM_bottom_ ) {
                move_target_Y_CAM = lim_CAM_bottom_;
            }
        } else if (pos_camera_ == VAM_POS_TOP) {
            if (move_target_Z_CAM > lim_CAM_zleft_) {
                move_target_Z_CAM = lim_CAM_zleft_;
            }
            if (move_target_Z_CAM < lim_CAM_zright_) {
                move_target_Z_CAM = lim_CAM_zright_;
            }
        } else if (pos_camera_ == VAM_POS_BOTTOM) {
            if (move_target_Z_CAM > lim_CAM_zleft_) {
                move_target_Z_CAM = lim_CAM_zleft_;
            }
            if (move_target_Z_CAM < lim_CAM_zright_) {
                move_target_Z_CAM = lim_CAM_zright_;
            }
        }
    } else if (pos_camera_ > VAM_POS_TO_BEHIND) {
        if (move_target_Y_CAM > lim_CAM_top_ - correction_height_) {
            move_target_Y_CAM = lim_CAM_top_ - correction_height_;
        }
        if (move_target_Y_CAM < lim_CAM_bottom_ + correction_height_) {
            move_target_Y_CAM = lim_CAM_bottom_ + correction_height_;
        }
        if (move_target_Z_CAM > lim_CAM_zleft_ - correction_width_) {
            move_target_Z_CAM = lim_CAM_zleft_ - correction_width_;
        }
        if (move_target_Z_CAM < lim_CAM_zright_ + correction_width_) {
            move_target_Z_CAM = lim_CAM_zright_ + correction_width_;
        }
    }
    if (pos_camera_ < VAM_POS_TO_BEHIND) {
        if (pos_camera_ == VAM_POS_RIGHT) {
            if (move_target_Y_VP > lim_VP_top_) {
                move_target_Y_VP = lim_VP_top_;
            }
            if (move_target_Y_VP < lim_VP_bottom_ ) {
                move_target_Y_VP = lim_VP_bottom_;
            }
        } else if (pos_camera_ == VAM_POS_LEFT) {
            if (move_target_Y_VP > lim_VP_top_) {
                move_target_Y_VP = lim_VP_top_;
            }
            if (move_target_Y_VP < lim_VP_bottom_ ) {
                move_target_Y_VP = lim_VP_bottom_;
            }
        } else if (pos_camera_ == VAM_POS_TOP) {
            if (move_target_Z_VP > lim_VP_zleft_) {
                move_target_Z_VP = lim_VP_zleft_;
            }
            if (move_target_Z_VP < lim_VP_zright_) {
                move_target_Z_VP = lim_VP_zright_;
            }
        } else if (pos_camera_ == VAM_POS_BOTTOM) {
            if (move_target_Z_VP > lim_VP_zleft_) {
                move_target_Z_VP = lim_VP_zleft_;
            }
            if (move_target_Z_VP < lim_VP_zright_) {
                move_target_Z_VP = lim_VP_zright_;
            }
        }
    } else if (pos_camera_ > VAM_POS_TO_BEHIND) {
        if (move_target_Y_VP > lim_VP_top_ - correction_height_) {
            move_target_Y_VP = lim_VP_top_ - correction_height_;
        }
        if (move_target_Y_VP < lim_VP_bottom_ + correction_height_) {
            move_target_Y_VP = lim_VP_bottom_ + correction_height_;
        }
        if (move_target_Z_VP > lim_VP_zleft_ - correction_width_) {
            move_target_Z_VP = lim_VP_zleft_ - correction_width_;
        }
        if (move_target_Z_VP < lim_VP_zright_ + correction_width_) {
            move_target_Z_VP = lim_VP_zright_ + correction_width_;
        }
    }

    //JAyуr[|Cg̈ړx߂B

    //J̖ڕWW܂ł̊e̋iWj
    int dX_CAM = move_target_X_CAM - pCam->_X;
    int dY_CAM = move_target_Y_CAM - pCam->_Y;
    int dZ_CAM = move_target_Z_CAM - pCam->_Z;
    //r[|Cg̖ڕWW܂ł̊e̋iWj
    int dX_VP = move_target_X_VP - pVP->_X;
    int dY_VP = move_target_Y_VP - pVP->_Y;
    int dZ_VP = move_target_Z_VP - pVP->_Z;
    velo veloVxRenge = 4000;
    velo veloVyRenge = 4000;
    velo veloVzRenge = 4000;
    if (pos_camera_ == VAM_POS_BEHIND_RIGHT || pos_camera_ == VAM_POS_BEHIND_LEFT) {
        if (pMyShip_->_X > -Dx) {
            //Zړ𑁂
            veloVzRenge *= 1.8;
            veloVxRenge *= 0.2;
        } else {
            //Zړx
            veloVzRenge *= 0.2;
            veloVxRenge *= 1.8;
        }
    } else if (pos_camera_ == VAM_POS_BEHIND_TOP || pos_camera_ == VAM_POS_BEHIND_BOTTOM) {
        if (pMyShip_->_X > -Dx) {
            //Yړ𑁂
            veloVyRenge *= 1.8;
            veloVxRenge *= 0.2;
        } else {
            //Yړx
            veloVyRenge *= 0.2;
            veloVxRenge *= 1.8;
        }
    } else if (pos_camera_ == VAM_POS_RIGHT || pos_camera_ == VAM_POS_LEFT) {
        if (pMyShip_->_X > -Dx) {
            //Xړ𑁂
            veloVxRenge *= 1.8;
            veloVzRenge *= 0.2;
        } else {
            //Xړx
            veloVxRenge *= 0.2;
            veloVzRenge *= 1.8;
        }
    } else if (pos_camera_ == VAM_POS_TOP || pos_camera_ == VAM_POS_BOTTOM) {
        if (pMyShip_->_X > -Dx) {
            //Xړ𑁂
            veloVxRenge *= 1.8;
            veloVyRenge *= 0.2;
        } else {
            //Xړx
            veloVxRenge *= 0.2;
            veloVyRenge *= 1.8;
        }
    }

    velo last_CAM_veloVxMv = pCamKurokoB->_veloVxMv;
    velo  new_CAM_veloVxMv = pMyShip_->iMoveSpeed_*(dX_CAM*1.0 / stop_renge_);
    if (last_CAM_veloVxMv-veloVxRenge <= new_CAM_veloVxMv && new_CAM_veloVxMv <= last_CAM_veloVxMv+veloVxRenge) {
        pCamKurokoB->setVxMvVelo(new_CAM_veloVxMv);
    } else {
        if (last_CAM_veloVxMv-veloVxRenge > new_CAM_veloVxMv) {
            pCamKurokoB->setVxMvVelo(last_CAM_veloVxMv-veloVxRenge);
        } else if (new_CAM_veloVxMv > last_CAM_veloVxMv+veloVxRenge) {
            pCamKurokoB->setVxMvVelo(last_CAM_veloVxMv+veloVxRenge);
        }
    }
    velo last_VP_veloVxMv = pVpKurokoB->_veloVxMv;
    velo  new_VP_veloVxMv = pMyShip_->iMoveSpeed_*(dX_VP*1.0 / stop_renge_);
    if (last_VP_veloVxMv-veloVxRenge <= new_VP_veloVxMv && new_VP_veloVxMv <= last_VP_veloVxMv+veloVxRenge) {
        pVpKurokoB->setVxMvVelo(new_VP_veloVxMv);
    } else {
        if (last_VP_veloVxMv-veloVxRenge > new_VP_veloVxMv) {
            pVpKurokoB->setVxMvVelo(last_VP_veloVxMv-veloVxRenge);
        } else if (new_VP_veloVxMv > last_VP_veloVxMv+veloVxRenge) {
            pVpKurokoB->setVxMvVelo(last_VP_veloVxMv+veloVxRenge);
        }
    }

    velo last_CAM_veloVyMv = pCamKurokoB->_veloVyMv;
    velo  new_CAM_veloVyMv = pMyShip_->iMoveSpeed_*(dY_CAM*1.0 / stop_renge_);
    if (last_CAM_veloVyMv-veloVyRenge <= new_CAM_veloVyMv && new_CAM_veloVyMv <= last_CAM_veloVyMv+veloVyRenge) {
        pCamKurokoB->setVyMvVelo(new_CAM_veloVyMv);
    } else {
        if (last_CAM_veloVyMv-veloVyRenge > new_CAM_veloVyMv) {
            pCamKurokoB->setVyMvVelo(last_CAM_veloVyMv-veloVyRenge);
        } else if (new_CAM_veloVyMv > last_CAM_veloVyMv+veloVyRenge) {
            pCamKurokoB->setVyMvVelo(last_CAM_veloVyMv+veloVyRenge);
        }
    }
    velo last_VP_veloVyMv = pVpKurokoB->_veloVyMv;
    velo  new_VP_veloVyMv = pMyShip_->iMoveSpeed_*(dY_VP*1.0 / stop_renge_);
    if (last_VP_veloVyMv-veloVyRenge <= new_VP_veloVyMv && new_VP_veloVyMv <= last_VP_veloVyMv+veloVyRenge) {
        pVpKurokoB->setVyMvVelo(new_VP_veloVyMv);
    } else {
        if (last_VP_veloVyMv-veloVyRenge > new_VP_veloVyMv) {
            pVpKurokoB->setVyMvVelo(last_VP_veloVyMv-veloVyRenge);
        } else if (new_VP_veloVyMv > last_VP_veloVyMv+veloVyRenge) {
            pVpKurokoB->setVyMvVelo(last_VP_veloVyMv+veloVyRenge);
        }
    }

    velo last_CAM_veloVzMv = pCamKurokoB->_veloVzMv;
    velo  new_CAM_veloVzMv = pMyShip_->iMoveSpeed_*(dZ_CAM*1.0 / stop_renge_);
    if (last_CAM_veloVzMv-veloVzRenge <= new_CAM_veloVzMv && new_CAM_veloVzMv <= last_CAM_veloVzMv+veloVzRenge) {
        pCamKurokoB->setVzMvVelo(new_CAM_veloVzMv);
    } else {
        if (last_CAM_veloVzMv-veloVzRenge > new_CAM_veloVzMv) {
            pCamKurokoB->setVzMvVelo(last_CAM_veloVzMv-veloVzRenge);
        } else if (new_CAM_veloVzMv > last_CAM_veloVzMv+veloVzRenge) {
            pCamKurokoB->setVzMvVelo(last_CAM_veloVzMv+veloVzRenge);
        }
    }

    velo last_VP_veloVzMv = pVpKurokoB->_veloVzMv;
    velo  new_VP_veloVzMv = pMyShip_->iMoveSpeed_*(dZ_VP*1.0 / stop_renge_);
    if (last_VP_veloVzMv-veloVzRenge <= new_VP_veloVzMv && new_VP_veloVzMv <= last_VP_veloVzMv+veloVzRenge) {
        pVpKurokoB->setVzMvVelo(new_VP_veloVzMv);
    } else {
        if (last_VP_veloVzMv-veloVzRenge > new_VP_veloVzMv) {
            pVpKurokoB->setVzMvVelo(last_VP_veloVzMv-veloVzRenge);
        } else if (new_VP_veloVzMv > last_VP_veloVzMv+veloVzRenge) {
            pVpKurokoB->setVzMvVelo(last_VP_veloVzMv+veloVzRenge);
        }
    }

    //JUPvZ
    angvelo angvelo_cam_up = cam_velo_renge/20; //cam_velo_rengeVB_VIEWςŒᑬɂȂ̑x
    if (angXY_nowCamUp_ != move_target_XY_CAM_UP) {
        angle da = UTIL::getAngDiff(angXY_nowCamUp_, move_target_XY_CAM_UP);
        if (-angvelo_cam_up < da && da < angvelo_cam_up) {
            angXY_nowCamUp_ = move_target_XY_CAM_UP;
        } else {
            angXY_nowCamUp_ += (angvelo_cam_up * SGN(da));
        }
        angXY_nowCamUp_ = UTIL::simplifyAng(angXY_nowCamUp_);
        pCam->_pVecCamUp->x = ANG_COS(angXY_nowCamUp_);
        pCam->_pVecCamUp->y = ANG_SIN(angXY_nowCamUp_);
        pCam->_pVecCamUp->z = 0.0f;
    }

    pCamKurokoB->behave();
    pVpKurokoB->behave();

//    _TRACE_(getActiveFrame()<<","<<dX_CAM<<","<<dY_CAM<<","<<dZ_CAM<<","<<pCam->_X<<","<<pCam->_Y<<","<<pCam->_Z<<","<<last_CAM_veloVxMv<<","<<new_CAM_veloVxMv<<","<<last_CAM_veloVyMv<<","<<new_CAM_veloVyMv<<","<<last_CAM_veloVzMv<<","<<new_CAM_veloVzMv<<","<<pCamKurokoB->_veloVxMv<<","<<pCamKurokoB->_veloVyMv<<","<<pCamKurokoB->_veloVzMv);

}
VamSysCamWorker::~VamSysCamWorker() {
}
