#include "stdafx.h"
#include "MyOptionWateringLaserChip001.h"

#include "jp/gecchi/VioletVreath/actor/my/MyLockonController.h"
#include "jp/gecchi/VioletVreath/actor/my/option/MyOption.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/ggaf/core/util/GgafLinkedListRing.hpp"
#include "jp/ggaf/core/util/GgafResourceConnection.hpp"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoB.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/manager/GgafDxTextureConnection.h"
#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/dxcore/texture/GgafDxTexture.h"
#include "jp/ggaf/lib/actor/laserchip/WateringLaserChip.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;



GgafDxCore::GgafDxModel* MyOptionWateringLaserChip001::pModel_  = nullptr;
char MyOptionWateringLaserChip001::aaTextureName[3][51];
int MyOptionWateringLaserChip001::tex_no_ = 0;


MyOptionWateringLaserChip001::MyOptionWateringLaserChip001(const char* prm_name) :
        WateringLaserChip(prm_name, "MyOptionWateringLaserChip001", STATUS(MyOptionWateringLaserChip001)) {
    _class_name = "MyOptionWateringLaserChip001";
    default_stamina_ = _pStatus->get(STAT_Stamina);
    pOrg_ = nullptr;
    lockon_st_ = 0;
    is_lockon_ = false;
    max_acce_renge_ = 0;
    max_velo_renge_ = 160000; //̒l傫ƁAōxȂB
    r_max_acce_ = 20; //̒l傫ƁAJ[uɂȂ
    if (!MyOptionWateringLaserChip001::pModel_) {
        if (_pModel->_num_materials != 3) {
            throwGgafCriticalException("MyOptionWateringLaserChip001::onCreateModel() MyOptionWateringLaserChip001f́A}eARKvłB");
        }
        for (DWORD i = 0; i < _pModel->_num_materials; i ++) {
            strcpy(MyOptionWateringLaserChip001::aaTextureName[i], _pModel->_papTextureConnection[i]->peek()->getName());
        }
        MyOptionWateringLaserChip001::pModel_ = _pModel;
    }
}

void MyOptionWateringLaserChip001::initialize() {
    _pKurokoA->relateMvFaceAng(true);
    registerHitAreaCube_AutoGenMidColli(80000);
    setHitAble(true);
    setScaleR(6.0);
    setAlpha(0.99);
}

void MyOptionWateringLaserChip001::onCreateModel() {

}

void MyOptionWateringLaserChip001::onActive() {
    _pStatus->reset();
    default_stamina_ = _pStatus->get(STAT_Stamina);
    WateringLaserChip::onActive();
    GgafDxGeometricActor* pMainLockOnTarget = pOrg_->pLockonCtrler_->pRingTarget_->getCurrent();
    if (pMainLockOnTarget && pMainLockOnTarget->isActiveInTheTree()) {
        if (_pChip_front == nullptr) {
            //[`bv
            lockon_st_ = 1;
        } else {
            //[ȊO
            MyOptionWateringLaserChip001* pF = (MyOptionWateringLaserChip001*) _pChip_front;
            lockon_st_ = pF->lockon_st_;//ÕbNIp
        }
    } else {
        if (_pChip_front == nullptr) {
            //[`bv
            lockon_st_ = 0;
        } else {
            //[ȊO
            MyOptionWateringLaserChip001* pF = (MyOptionWateringLaserChip001*) _pChip_front;
            lockon_st_ = pF->lockon_st_;//ÕbNIp
        }
    }
    _pKurokoB->setZeroVxyzMvAcce(); //xZbg
    //Vxyz̑x̓IvVŐݒ肳


    _pKurokoB->forceVxyzMvVeloRange(-max_velo_renge_, max_velo_renge_);
    max_acce_renge_ = max_velo_renge_/r_max_acce_;
    _pKurokoB->forceVxyzMvAcceRange(-max_acce_renge_, max_acce_renge_);
}

void MyOptionWateringLaserChip001::processBehavior() {
    GgafDxGeometricActor* pMainLockOnTarget = pOrg_->pLockonCtrler_->pRingTarget_->getCurrent();
    if (getActiveFrame() > 6) {
        if (lockon_st_ == 1) {
            if (pMainLockOnTarget && pMainLockOnTarget->isActiveInTheTree()) {
                moveChip(pMainLockOnTarget->_X,
                         pMainLockOnTarget->_Y,
                         pMainLockOnTarget->_Z );
            } else {
                //_pKurokoB->setZeroVxyzMvAcce();
                lockon_st_ = 2;
            }
        }

        if (lockon_st_ == 2) {
            if (_pLeader) {
                if (_pLeader == this) {
                    moveChip(_X + _pKurokoB->_veloVxMv*4+1,
                             _Y + _pKurokoB->_veloVyMv*2+1,
                             _Z + _pKurokoB->_veloVzMv*2+1 );
                } else {
                    moveChip(_pLeader->_X, _pLeader->_Y, _pLeader->_Z);
                }
            }
        }
    }

    WateringLaserChip::processBehavior();//WړĂĂяo
    //烌[U[\̂ߋIɍW␳
    if (onChangeToActive()) {
        positionAs(pOrg_);
        _tmpX = _X;
        _tmpY = _Y;
        _tmpZ = _Z;
    }

}

void MyOptionWateringLaserChip001::moveChip(int tX, int tY, int tZ) {
    //    |                            vVT I                        |
    //    |                                ^                         |
    //    |                 |I| > 5*vM /    _  vVP I      |      I
    //    |                 ƂȂ悤 /       _                    |       
    //    |                 vVTݒ   /                            |      
    //    |                            /        ^vVM              |       
    //    |                           /       ^  (vVMx,vVMy,vVMz)     |       b
    //    |                          /      ^                         |       b
    //    |                         /     ^                           |       b
    //    |                        /    ^ || = 5*vM = lVM         |       b
    //    |                   vT I   ^                               |       I
    //    |                    ^  ^                                 |       
    //    |               _    / vM ݂̈ړxNg          |       b
    //    | vVP I  _ /^ (veloVxMv_,veloVyMv_,veloVzMv_)     |       b
    //    |                                                          |       
    // ---+------------------------------------------               ---+---------------------------
    //    |                                                            |
    //
    // vVP BvVP߂I

    GgafDxKurokoB* const pKurokoB = _pKurokoB;
    //I
    int vTx = tX - _X;
    int vTy = tY - _Y;
    int vTz = tZ - _Z;

    //B} || = 5*vM
    int vVMx = pKurokoB->_veloVxMv*5;
    int vVMy = pKurokoB->_veloVyMv*5;
    int vVMz = pKurokoB->_veloVzMv*5;

    //||
    int lVM = MAX3(ABS(vVMx), ABS(vVMy), ABS(vVMz)); //xNg傫ȈՔ
    //|I|
    int lT =  MAX3(ABS(vTx), ABS(vTy), ABS(vTz)); //IxNg傫ȈՔ
    //||/|I|      vT ̉{ vVT I ɂȂ̂߂B
    double r = (lVM*1.5) / lT;
    //* 2 E}̂悤Ɉ꒼ɕ񂾍ۂAisێ邽߂ɁA
    //|I| > || Ƃ֌Wێ邽߂ɂKȊ

    //vVP I ̉xݒ
    double accX = ((vTx * r) - vVMx) / r_max_acce_;
    double accY = ((vTy * r) - vVMy) / r_max_acce_;
    double accZ = ((vTz * r) - vVMz) / r_max_acce_;

    if (_pChip_front == nullptr) {
        //擪͂⑬߂
        pKurokoB->setVxMvAcce(accX+SGN(accX)*5); //SGN(accX)*5 Ẑ́Ax0ɂȂ
        pKurokoB->setVyMvAcce(accY+SGN(accY)*5);
        pKurokoB->setVzMvAcce(accZ+SGN(accZ)*5);
    } else {
        pKurokoB->setVxMvAcce(accX+SGN(accX)*3); //SGN(accX)*3 Ẑ́Ax0ɂȂ
        pKurokoB->setVyMvAcce(accY+SGN(accY)*3);
        pKurokoB->setVzMvAcce(accZ+SGN(accZ)*3);
    }
    //lW`悪ȂȂ悤ɉ]𐧌
    if (lVM > max_velo_renge_/2) {
        angle RZ_temp, RY_temp;
        UTIL::convVectorToRzRy(vVMx, vVMy, vVMz, RZ_temp, RY_temp);
        angle angDRZ = UTIL::getAngDiff(RZ_temp, _RZ);
        angle angDRY = UTIL::getAngDiff(RY_temp, _RY);
        if (-4000 <= angDRZ) {
            _RZ -= 4000;
        } else if (angDRZ <= 4000) {
            _RZ += 4000;
        } else {
            _RZ += angDRZ;
        }
        if (-4000 <= angDRY) {
            _RY -= 4000;
        } else if (angDRY <= 4000) {
            _RY += 4000;
        } else {
            _RY += angDRY;
        }
        if (_RZ >= D360ANG) {
            _RZ -= D360ANG;
        }
        if (_RZ < 0) {
            _RZ += D360ANG;
        }
        if (_RY >= D360ANG) {
            _RY -= D360ANG;
        }
        if (_RY < 0) {
            _RY += D360ANG;
        }
    }

}

void MyOptionWateringLaserChip001::executeHitChk_MeAnd(GgafActor* prm_pOtherActor) {
    if (((GgafMainActor*)prm_pOtherActor)->getKind() & KIND_CHIKEI) {
        if (_chip_kind != 2 || _can_chikei_hit) {
            GgafDxDrawableActor::executeHitChk_MeAnd(prm_pOtherActor);
        } else {
            return;
        }
    } else {
        GgafDxDrawableActor::executeHitChk_MeAnd(prm_pOtherActor);
    }
}

void MyOptionWateringLaserChip001::onHit(GgafActor* prm_pOtherActor) {
    GgafDxGeometricActor* pOther = (GgafDxGeometricActor*) prm_pOtherActor;
    GgafDxGeometricActor* pMainLockOnTarget = pOrg_->pLockonCtrler_->pRingTarget_->getCurrent();
    //qbgGtFNg
    UTIL::activateExplosionEffectOf(this); //GtFNgo

    if ((pOther->getKind() & KIND_ENEMY_BODY) ) {
        if (pMainLockOnTarget) { //ɃIvV̓bNI
            if (pOther == pMainLockOnTarget) {
                //IvṼbNIɌꍇ

                lockon_st_ = 2; //bNI߂B񃍃bNIibNI񃍃bNIj
                if (_pChip_front && _pChip_front->_pChip_front == nullptr) {
                    //Ԑ擪`bvqbgꍇA[ɂ`([͓蔻ȂߒԐ擪Ɠlɂ)
                    ((MyOptionWateringLaserChip001*)_pChip_front)->lockon_st_ = 2;
                }
            } else {
                //IvṼbNIȊÕAN^[ɖꍇ
            }
        } else {
            //IvV񃍃bNIɖꍇ
        }

        int stamina = UTIL::calcMyStamina(this, pOther);
        if (stamina <= 0) {
            //ꌂŃ`bvł̍U
            //bNI\AN^[Ȃ烍bNI
            if (pOther->_pStatus->get(STAT_LockonAble) == 1) {
                pOrg_->pLockonCtrler_->lockon(pOther);
            }
            sayonara();
        } else {
            //ςȂ΁AʊтAX^~i񕜁iU100̎GȂΒʊсj
            _pStatus->set(STAT_Stamina, default_stamina_);
            //bNI\AN^[Ȃ烍bNI
            if (pOther->_pStatus->get(STAT_LockonAble) == 1) {
                pOrg_->pLockonCtrler_->lockon(pOther);
            }
        }
    } else if (pOther->getKind() & KIND_CHIKEI) {
        //n`͖悤Ȃ
        sayonara();
    }
}

void MyOptionWateringLaserChip001::onInactive() {
    WateringLaserChip::onInactive();
    lockon_st_ = 0;
}

void MyOptionWateringLaserChip001::chengeTex(int prm_tex_no) {
    if (MyOptionWateringLaserChip001::pModel_) {
        MyOptionWateringLaserChip001::tex_no_ = prm_tex_no;
        MyOptionWateringLaserChip001::pModel_->swapTopTextureOrder(aaTextureName[prm_tex_no]);
    }
}

MyOptionWateringLaserChip001::~MyOptionWateringLaserChip001() {
    MyOptionWateringLaserChip001::pModel_ = nullptr;
}

