#include "stdafx.h"
#include "EnemyOmulus.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxMorpher.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxScaler.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/dxcore/model/supporter/GgafDxTextureBlinker.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

#define MORPHTARGET_HATCH_OPEN 1

EnemyOmulus::EnemyOmulus(const char* prm_name) :
        DefaultMorphMeshActor(prm_name, "1/Omulus", STATUS(EnemyOmulus)) {
    _class_name = "EnemyOmulus";
    _pActor_Base = nullptr;
    is_open_hatch_ = false;
    frame_of_open_interval_  = 3*60;
    frame_of_close_interval_ = 20*60;
    frame_of_morph_interval_   = 120;

    pDepo_Fired_ = nullptr;
    pDepoConnection_ = connect_DepositoryManager("Talante");

    _pSeTx->set(SE_DAMAGED  , "WAVE_ENEMY_DAMAGED_001");
    _pSeTx->set(SE_EXPLOSION, "WAVE_EXPLOSION_001");
    useProgress(PROG_HATCH_OPEN);
}

void EnemyOmulus::onCreateModel() {
    _pModel->_pTexBlinker->setBlinkableRange(0.9, 0.1, 1.0);
    _pModel->_pTexBlinker->setPower(0.1);
    _pModel->_pTexBlinker->beat(120, 60, 1, -1);
    _pModel->setSpecular(5.0, 1.0);
}

void EnemyOmulus::initialize() {
    setHitAble(true);
    _pKurokoA->relateMvFaceAng(true);
    _pMorpher->forceWeightRange(MORPHTARGET_HATCH_OPEN, 0.0f, 1.0f);
    _pMorpher->setWeight(MORPHTARGET_HATCH_OPEN, 0.0f);
    _pColliChecker->makeCollision(1);
    _pColliChecker->setColliAAB_Cube(0, 200000);
    _pScaler->setScale(1000);
    _pScaler->forceRange(1000, 1200);
    _pScaler->beat(30, 5, 5, -1);
    pDepo_Fired_ = pDepoConnection_->peek();
}

void EnemyOmulus::onActive() {
    _pStatus->reset();
    _pMorpher->setWeight(MORPHTARGET_HATCH_OPEN, 0.0f);
    is_open_hatch_ = false;
//    frame_of_moment_nextopen_ = frame_of_close_interval_;
    _pProg->reset(PROG_HATCH_CLOSE);
}

void EnemyOmulus::processBehavior() {
    //{[ɂAN^[̃
    //_X, _Y, _Z, _RX, _RY, _RZ ɂĂQ̍WnZbg؂ւKvȎdlłB
    //ꂼꃍ[JWAŏIi΁jWƌĂԂƂɂ܂B
    //EŏIi΁jW EEE ʂ̃[hWn̎łB
    //E[JW     EEE eAN^[̊_(0,0,0)̑ΓIȍWnӖ܂B
    //                          WvZ͂ōsĉB
    //j
    //  @WvZ͎Ƀ[JWňvZłBGgafDxKurokoA Ń[JWn̑sƂƂB
    //    AWؓo^A蔻A^[QbgWȂǁÃIuWFNg烏[hWQƂ铙A
    //    {Ԃ͍ŏIi΁jWnB
    //    processBehavior()Jn ŏIi΁jWn(changeGeoFinal())̏ԂƂȂĂB
    //  AprocessBehavior()ŕKvɉ changeGeoLocal() Ńo[ _X, _Y, _Z, _RX, _RY, _RZ [JWn
    //    ؂ւ邱Ƃ\Bړ̍WvZsB
    //  BA processBehavior() 𔲂ۂɂ͕KŏIW(changeGeoFinal())̏Ԃɖ߂ĂB
    //  CŏIi΁jWƁA[JW݂͌ɓƗA͂ȂA
    //    \̃[hϊs쐬AsςōAŏIIȕ\ʒu肷B

    //changeGeoLocal(); s
    //[JWnɐؑւ܂B
    //E_X, _Y, _Z     EEE ́A[JWӖ悤ɂȂ܂B
    //                        changeGeoLocal(); sƎI_X, _Y, _Z 
    //                        [JWlɐ؂ւ܂B
    //E_RX, _RY, _RZ  EEE ́A[JWł̎]lӖ悤ɂȂ܂B
    //                        changeGeoLocal(); sƎI_RX, _RY, _RZ
    //                        [JW]lɐ؂ւ܂B

    //changeGeoFinal(); s
    //ŏIi΁jWnɐ؂ւ܂B
    //E_X, _Y, _Z    EEE t[ GgafDxGeometricActor::processSettlementBehavior() ŌvZꎩXVĂ܂B
    //                       processBehavior()  changeGeoFinal() sƁAPt[O_X, _Y, _Zɐ؂ւ鎖ɂȂ܂B
    //                       _X, _Y, _Z ͎QƐpBlĂӖL܂
    //E_RX, _RY, _RZ EEE t[ GgafDxGeometricActor::processSettlementBehavior() ܂I
    //                       changeGeoFinal(); sĂA_RX, _RY, _RZ ͈ȑO̍ŏIi΁jWn̒l
    //                       ςȂŕω܂B
    //                       ̃IuWFNgA{[ɂAN^[QƂƂA_RX, _RY, _RZ͑SMpł܂B

    //Ӂ
    //EGgafDxKurokoA(_pKurokoA) behave() ȊO\bh́AɃ[JW̑ƂB
    //  behave()ȊO\bh͎ۂɍWvZĂ킯ł͂Ȃ̂ŁA
    //  changeGeoFinal()AchangeGeoLocal()Ɋ֌WȂAĂяo\B
    //EGgafDxKurokoA(_pKurokoA) behave() \bh͍WPt[̏ԂɂvZsB
    //  āÂ悤 [JW(changeGeoLocal())ŌĂяoƂB
    //    changeGeoLocal();
    //    _pKurokoA->behave();
    //    changeGeoFinal();
    //TODO:݊ƂȂB

    switch (_pProg->get()) {
        case PROG_INIT: {
            _pProg->change(PROG_HATCH_CLOSE);
            break;
        }
        case PROG_HATCH_CLOSE: {
            if (_pProg->isJustChanged()) {
                _pMorpher->morphLinerUntil(MORPHTARGET_HATCH_OPEN,
                                                0.0f, frame_of_morph_interval_);
                _pKurokoA->setFaceAngVelo(AXIS_X, -3000);
            }

            //
            if (_pProg->getFrameInProgress() >= frame_of_close_interval_ + frame_of_morph_interval_) {
                _pProg->change(PROG_HATCH_OPEN);
            }
            break;
        }
        case PROG_HATCH_OPEN: {
            if (_pProg->isJustChanged()) {
                _pMorpher->morphLinerUntil(MORPHTARGET_HATCH_OPEN,
                                                1.0f, frame_of_morph_interval_);
                _pKurokoA->setFaceAngVelo(AXIS_X, 0);
            }

            //I[vGo
            if (_pMorpher->_weight[MORPHTARGET_HATCH_OPEN] > 0.5) { //[Vȏ܂œBȂ
                if (_pProg->getFrameInProgress() % (frame)(RF_EnemyOmulus_ShotInterval(G_RANK)) == 0) { //oԊu
                    if (pDepo_Fired_) {
                        GgafDxDrawableActor* pActor = (GgafDxDrawableActor*)pDepo_Fired_->dispatch();
                        if (pActor) {
                            //݂̍ŏIIȌARzRyŎ擾遄
                            //xNg̓[hϊs̐ρi_matWorldRotMv)ŕϊA݂̍ŏIIȌɌB
                            //̕xNg(Xorg_,Yorg_,Zorg_)A
                            //[hϊs̉]̐ρi_matWorldRotMv)̐ mat_xxA
                            //ŏIIȕxNg(vX, vY, vZ) Ƃ
                            //
                            //                      | mat_11 mat_12 mat_13 |
                            //| Xorg_ Yorg_ Zorg_ | | mat_21 mat_22 mat_23 | = | vX vY vZ |
                            //                      | mat_31 mat_32 mat_33 |
                            //
                            //vX = Xorg_*mat_11 + Yorg_*mat_21 + Zorg_*mat_31
                            //vY = Xorg_*mat_12 + Yorg_*mat_22 + Zorg_*mat_32
                            //vZ = Xorg_*mat_13 + Yorg_*mat_23 + Zorg_*mat_33
                            //
                            //ĂŁAXO̒PʕxNg(1,0,0)̏ꍇ͂ǂȂ邩l
                            //
                            //vX = Xorg_*mat_11
                            //vY = Xorg_*mat_12
                            //vZ = Xorg_*mat_13
                            //
                            //ƂȂB{Avł́Af͑S(1,0,0)OƂĂ邽
                            //ŏIIȕxNǵiXorg_*mat_11, Xorg_*mat_12, Xorg_*mat_13) łB
                            angle Rz, Ry;
                            UTIL::convVectorToRzRy(_matWorldRotMv._11, _matWorldRotMv._12, _matWorldRotMv._13,
                                                   Rz, Ry); //݂̍ŏIIȌARzRyŎ擾I
                            pActor->_pKurokoA->setRzRyMvAng(Rz, Ry); //RzRyMoverɐݒ
                            pActor->positionAs(this);
                            pActor->reset();
                        }
                    }
                }
            }
            if (_pProg->getFrameInProgress() >= frame_of_open_interval_+ frame_of_morph_interval_) {
                _pProg->change(PROG_HATCH_CLOSE);
            }
            break;
        }
        default :
            break;
    }
    //ZN|Cg
    _pStatus->mul(STAT_AddRankPoint, _pStatus->getDouble(STAT_AddRankPoint_Reduction));

    if (getActiveFrame() % 10U == 0                   && 1 == 2) {
        //@֕
        //lF[JWnŗ\߂ǂ̕ɌĂ΁AŏIIɎ@ɌƂɂȂ邩߂
        //
        //@ւ̌߂̕ϊOԂł̃^[Qbgʒu(TvX, TvY, TvZ) ƂA
        //uy܂Łv̍s̐ρi_pActor_Base->_matWorldRotMv)  b_mat_xx ƂB
        //݂̍ŏIW玩@ւ̌̃xNgA(MvX, MvY, MvZ) ƂƁA
        //
        //                | b_mat_11 b_mat_12 b_mat_13 |
        //| TvX TvY TvZ | | b_mat_21 b_mat_22 b_mat_23 | = | MvX MvY MvZ |
        //                | b_mat_31 b_mat_32 b_mat_33 |
        //
        //ƂȂB[JW(TvX, TvY, TvZ) ̕ƁA
        //ŏIIɎ@ɌƂɂȂB
        //ts|(TvX, TvY, TvZ) ߂Ηǂ
        //
        //                                   | b_mat_11 b_mat_12 b_mat_13 | -1
        // | TvX TvY TvZ | = | MvX MvY MvZ | | b_mat_21 b_mat_22 b_mat_23 |
        //                                   | b_mat_31 b_mat_32 b_mat_33 |
        //

        //MvX MvY MvZ ߂
        int MvX = P_MYSHIP->_X - _X;
        int MvY = P_MYSHIP->_Y - _Y;
        int MvZ = P_MYSHIP->_Z - _Z;
        //ts擾
        D3DXMATRIX* pBaseInvMatRM = _pActor_Base->getInvMatWorldRotMv();
        //[JWł̃^[QbgƂȂxNgvZ
        int TvX = MvX*pBaseInvMatRM->_11 + MvY*pBaseInvMatRM->_21 + MvZ * pBaseInvMatRM->_31;
        int TvY = MvX*pBaseInvMatRM->_12 + MvY*pBaseInvMatRM->_22 + MvZ * pBaseInvMatRM->_32;
        int TvZ = MvX*pBaseInvMatRM->_13 + MvY*pBaseInvMatRM->_23 + MvZ * pBaseInvMatRM->_33;
        //V[NGXJn
        angle angRz_Target, angRy_Target;
        UTIL::convVectorToRzRy(TvX, TvY, TvZ, angRz_Target, angRy_Target);
        _pKurokoA->turnRzRyMvAngTo(angRz_Target, angRy_Target,
                                   1000, 0,
                                   TURN_CLOSE_TO, false);
    }

    _pScaler->behave();
    _pMorpher->behave();

    //_pKurokoǍvZ̓[Jōs
    changeGeoLocal();
    _pKurokoA->behave();
    changeGeoFinal();

}

void EnemyOmulus::processJudgement() {
    if (_pActor_Base != nullptr && _pActor_Base->isActiveInTheTree()) {
//        (*(_pActor_Base->_pFunc_calcRotMvWorldMatrix))(_pActor_Base, _matWorld);
    } else {
        //y䂪ȂΎ
        sayonara();
    }


//    if (isOutOfUniverse()) {
//        sayonara();
//    }
}

void EnemyOmulus::onHit(GgafActor* prm_pOtherActor) {
    bool was_destroyed = UTIL::proceedEnemyHit(this, (GgafDxGeometricActor*)prm_pOtherActor);
    if (was_destroyed) {
        //j
        _pSeTx->play3D(SE_EXPLOSION);
    } else {
        //j
        _pSeTx->play3D(SE_DAMAGED);
    }
}

void EnemyOmulus::onInactive() {
    sayonara();
}

EnemyOmulus::~EnemyOmulus() {
    pDepoConnection_->close();
}
