#include "stdafx.h"
#include "jp/ggaf/lib/util/spline/FixedVelocitySplineManufacture.h"

#include "jp/ggaf/lib/util/spline/SplineLine.h"
#include "jp/ggaf/lib/util/spline/FixedVelocitySplineKurokoLeader.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;

FixedVelocitySplineManufacture::FixedVelocitySplineManufacture(const char* prm_source_file,
                                                               angvelo prm_angveloRzRyMv,
                                                               int prm_turn_way,
                                                               bool prm_turn_optimaize) :
        SplineManufacture(prm_source_file) {
    _angveloRzRyMv = prm_angveloRzRyMv;
    _turn_way = prm_turn_way;
    _turn_optimize = prm_turn_optimaize;
    _point_index = 0;
    _veloMvUnit = PX_C(1); //x PX_C(1) Ƃꍇ̊eԂ̃t[{Ƃ
    _paFrame_need_at = NEW float[_sp->_rnum];
}

FixedVelocitySplineManufacture::FixedVelocitySplineManufacture(SplineSource* prm_pSplSrc,
                                                               angvelo prm_angveloRzRyMv,
                                                               int prm_turn_way,
                                                               bool prm_turn_optimaize) :
        SplineManufacture(prm_pSplSrc) {
    _angveloRzRyMv = prm_angveloRzRyMv;
    _turn_way = prm_turn_way;
    _turn_optimize = prm_turn_optimaize;
    _point_index = 0;
    _veloMvUnit = PX_C(1); //x PX_C(1) Ƃꍇ̊eԂ̃t[{Ƃ
    _paFrame_need_at = NEW float[_sp->_rnum];
}

void FixedVelocitySplineManufacture::calculate() {
    //̂Q̃e[uČvZXV܂B
    // _paDistance_to[] : ݂̕⊮_A̕⊮_܂ł̋
    // _paFrame_need_at[] : n_⊮_BɕKvȃt[̔z

    //e_̎_́AƕKvȃt[\ߑS߂Ă
    // _[2][3] = { {1000,2000,3000}, {2000,1000,0}, {3900, 0, 1000} }
    // point_num = 3          //_̐
    // accuracy = 0.25(=1/4)  //⊮_x
    //
    // ̏ꍇA}̂悤ɂȂ܂B
    //
    // X:_
    // o:_Ԃ̕⊮_iXvCȐʉߓ_j
    // X--o: ړ\̍W
    // _paDistance_to[] : ݂̕⊮_A̕⊮_܂ł̋
    // _paFrame_need_at[] : n_⊮_BɕKvȃt[̔z
    //
    // sp._rnum ͍v̓_̐ԂB sp._rnum = 9 ɂȂB
    // prm_accuracy YȕɂȂȂꍇA_ɕ⊮_J邩ƂASR킩Ȃ̂ŁAsp._rnumKgp
    // }YɏdȂꍇ̐}łB
    //
    //                             _veloMvUnit = 1000
    //
    //               _paFrame_need_at[1] Kvȃt[
    //                     ||              _paFrame_need_at[5]
    //                   <--->                      ||                 _paFrame_need_at[8]
    //                   <----------------------------->                      ||
    //                   <------------------------------------------------------->
    //
    //              _paDistance_to[1]      _paDistance_to[5]         _paDistance_to[8]
    //                    ||                     ||                         ||
    //                   <--->                <------->                  <------->
    //                  X----o----o----o-----X--------o---------o--------o-------X
    //                  ^                    ^        ^                          ^
    //                  |                    |        |                          |
    //            (sp._X_compute[0],         | (sp._X_compute[5],        sp._X_compute[8]
    //             sp._Y_compute[0],         |  sp._Y_compute[5],        sp._Y_compute[8]
    //             sp._Z_compute[0])         |  sp._Z_compute[5])        sp._Z_compute[8]
    //                  |                    |                                   |
    //            (_[0][0],           (_[1][0],                   (_[2][0],
    //             _[0][1],            _[1][1],                    _[2][1],
    //             _[0][2])            _[1][2])                    _[2][2])
    //              = (1000,2000,3000)    = (2000,1000,0)                   = (3900, 0, 1000)
    //
    //                 <--------------------------------------------------------->
    //                          veloMoveUnit ̑xňړƂꍇvZ
    //
    SplineManufacture::calculate();
    _paFrame_need_at[0] = 0; //n_ɍs܂łɕKvȃt[͕s
    for (int t = 1; t < _sp->_rnum; t ++) {
        // paDistanceTo[t] Ax _veloMvUnit(=1000) ňړ̂ɕKvȃt[߂B
        //ԁ
        _paFrame_need_at[t] = _paFrame_need_at[t-1] + (float)(1.0*_paDistance_to[t] / _veloMvUnit);
    }
}

SplineKurokoLeader* FixedVelocitySplineManufacture::createKurokoLeader(GgafDxCore::GgafDxKurokoA* const prm_pKurokoA) {
    return NEW FixedVelocitySplineKurokoLeader(this, prm_pKurokoA);
}

FixedVelocitySplineManufacture::~FixedVelocitySplineManufacture() {
    GGAF_DELETEARR_NULLABLE(_paDistance_to);
    GGAF_DELETEARR_NULLABLE(_paFrame_need_at);
}
