#include "stdafx.h"
#include "jp/ggaf/lib/scene/WalledScene.h"

#include "jp/ggaf/core/actor/ex/GgafActorDepository.h"
#include "jp/ggaf/core/actor/GgafSceneDirector.h"
#include "jp/ggaf/lib/scene/WalledSectionScene.h"
#include "jp/ggaf/lib/actor/WallPartsActor.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;

WalledScene::WalledScene(const char* prm_name) : DefaultScene(prm_name) {
    _obj_class |= Obj_WalledScene;
    _class_name = "WalledScene";
    _pDepo_WallAAB = nullptr;
    _pDepo_WallAAPrism = nullptr;
    _pLastSectionScene = nullptr;
    _is_all_active_section_scenes = false;
    _is_finished = false;
}

void WalledScene::buildWalledScene(
        coord prm_wall_dep, coord prm_wall_width, coord prm_wall_height,
        coord prm_wall_start_X,
        WalledSectionScene** prm_papSection, int prm_section_num,
        GgafActorDepository* prm_pDepo_WallAAB,
        GgafActorDepository* prm_pDepo_WallAAPrism) {
    _TRACE_("WalledScene::buildWalledScene ["<<getName()<<"] build...");
    setScrollingFunction(WalledScene::scrollX);

    _pDepo_WallAAB = prm_pDepo_WallAAB;
    _pDepo_WallAAPrism = prm_pDepo_WallAAPrism;
    if (_pDepo_WallAAB->getPlatformScene()) {
        //ɏĂȂOK
    } else {
        getSceneDirector()->addSubGroup(_pDepo_WallAAB); // initialize() Ŗ{
    }
    if (_pDepo_WallAAPrism) {
        if (_pDepo_WallAAPrism->getPlatformScene()) {
            //ɏĂȂOK
        } else {
            getSceneDirector()->addSubGroup(_pDepo_WallAAPrism); // initialize() Ŗ{
        }
    }
    for (int i = 0; i < prm_section_num; i++) {
        addSubLast(prm_papSection[i]); //zV[ɏ
        prm_papSection[i]->config(_pDepo_WallAAB, _pDepo_WallAAPrism,
                                  prm_wall_start_X,
                                  prm_wall_dep, prm_wall_width, prm_wall_height);
        prm_papSection[i]->inactivateImmed();
        _ringHoldSection.addLast(prm_papSection[i], false);
    }
    // 0b 00abcdef
    //
    //    c
    // a b d f
    //      e
    //
    //    FACE_A_BIT = 0b100000
    //    FACE_B_BIT = 0b010000
    //    FACE_C_BIT = 0b001000
    //    FACE_D_BIT = 0b000100
    //    FACE_E_BIT = 0b000010
    //    FACE_F_BIT = 0b000001
    //    A          = 0b111110 = 62
    //    A          = 0b101111 = 47

    //ZNVȂڂBOX`̏
    if (prm_section_num >= 2) {
        //ŏAԁAeZNV̍ŖubNʂ̑SBOXFACE_F`ׂ
        for (int i = 0; i < prm_section_num-1; i++) {
            WalledSectionScene* pSection = prm_papSection[i];
            for (int j = 0; j < pSection->_paWallInfoLen[pSection->_area_len-1]; j++) {
                pSection->_papaWallInfo[pSection->_area_len-1][j]._wall_draw_face &= 62; //FACE_Fׂ 0b111110
            }
        }
        //ԁAŌAeZNV̍őOubNʂ̑SBOXFACE_B`ׂ
        for (int i = 1; i < prm_section_num; i++) {
            WalledSectionScene* pSection = prm_papSection[i];
            for (int j = 0; j < pSection->_paWallInfoLen[0]; j++) {
                pSection->_papaWallInfo[0][j]._wall_draw_face &= 47; //FACE_Bׂ 0b111110
            }
        }
    }
    _ringHoldSection.first();
    _is_all_active_section_scenes = false;
    _pLastSectionScene = prm_papSection[prm_section_num-1];
    _TRACE_("WalledScene::buildWalledScene ["<<getName()<<"] done");
}

void WalledScene::initialize() {
    if (_pDepo_WallAAB == nullptr) {
        throwGgafCriticalException("WalledScene["<<getName()<<"] IuWFNgłBbuildWalledScene()s\zĂB");
    }
    //buildWalledScene pNX̃RXgN^ŎsꂽꍇAgetSceneDirector() ͐EV[Ԃ
    //ǃf|Wg̏V[͐EV[ɂȂĂ\BA
    //XN[s߂ɂAǃf|Wg  this ̔zɒuKv邽߁Aȉ̗l
    //zV[ɍĐݒ肷B
    getSceneDirector()->addSubGroup(_pDepo_WallAAB->extract());
    if (_pDepo_WallAAPrism) {
        getSceneDirector()->addSubGroup(_pDepo_WallAAPrism->extract());
    }
}

void WalledScene::onActive() {
    WalledSectionScene* pCurrentSection = _ringHoldSection.getCurrent();
    pCurrentSection->activate();
}

void WalledScene::processBehavior() {

    if (!_is_finished) {
        if (!_is_all_active_section_scenes) {

            WalledSectionScene* pCurrentSection = _ringHoldSection.getCurrent();
            if (!pCurrentSection->isLast()) {
                if (pCurrentSection->_is_loop_end) {
                    WalledSectionScene* pNewSection = _ringHoldSection.next();
                    pNewSection->activate();
                    pNewSection->_pWallPartsLast = pCurrentSection->getLastWallParts();
                    _ringLoopEndSection.addLast(pCurrentSection, false);
                }
            } else {
                if (pCurrentSection->_is_loop_end) {
                    _ringLoopEndSection.addLast(pCurrentSection, false);
                    _is_all_active_section_scenes = true;
                }
            }
        }

        //_ringLoopEndSection`FbN
        //WallPartsActor::_pWalledSectionScene s|C^ɂȂȂ߂̍lłB
        for (int i = 0; i < _ringLoopEndSection.length(); i++) {
            WalledSectionScene* pSection =_ringLoopEndSection.next();
            if (pSection->_pWallPartsLast->_pWalledSectionScene != pSection || !pSection->_pWallPartsLast->isActive() ) {
                //
                //pSection->_pWallPartsLast->_pWalledSectionScene != pSection ́A
                //pSection->_pWallPartsLast ܂ŏIǂ̕RtZNV͂łȂA
                //܂ÃZNVV[ dispatchForce() ꂽOKAƍlB
                //܂A!pSection->_pWallPartsLast->isActive() 
                //̃ZNVV[ dispatchForce() ꂸɁA͈͊OɏOKAƍlB
                _TRACE_("WalledScene::processBehavior() ["<<getName()<<"] V[̃ZNV["<<pSection->getName()<<"]inactivate!!");
                pSection->inactivateDelay(60*60);
                _ringLoopEndSection.remove();
                if (pSection == _pLastSectionScene) {
                    //ŏIZNVȂΈxR[obNsACB
                    //iȑO͂sayonara()Ăj
                    _TRACE_("WalledScene::processBehavior() ["<<getName()<<"] ŏIZNVV[onFinishedAllSection() R[obN");
                    _is_finished = true;
                    onFinishedAllSection(); //R[obN
                }
            }
        }
    } else {
    }

}

void WalledScene::processFinal() {
}

void WalledScene::scrollX(GgafObject* pThat, void* p1, void* p2) {
    if (pThat->instanceOf(Obj_GgafDxGeometricActor)) {
        GgafDxGeometricActor* pActor = (GgafDxGeometricActor*)pThat;
        if (pActor->_is_active_flg && !pActor->_was_paused_flg && pActor->_can_live_flg) {
            pActor->_X -= (*((coord*)p1));
        }
    }
}

WalledScene::~WalledScene() {
}
