#include "stdafx.h"
#include "jp/ggaf/lib/actor/laserchip/RefractionLaserChip.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"
#include "jp/ggaf/lib/actor/laserchip/LaserChipDepository.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;

RefractionLaserChip::RefractionLaserChip(const char* prm_name, const char* prm_model, GgafStatus* prm_pStat) :
        LaserChip(prm_name, prm_model, prm_pStat) {
    _class_name = "RefractionLaserChip";
    _is_leader = false;
    _num_refraction = 2;
    _frame_standstill_refraction = 10;
    _frame_between_refraction = 20;

    _cnt_refraction = 0;
    _frame_refraction_enter = 0;
    _frame_refraction_out = 0;
    _is_refracting = false;

    _pDispatche_RefractionEffect = nullptr;
    _pRefractionEffect = nullptr;
    _prev_pRefractionEffect = nullptr;

    _begining_X = _X;
    _begining_Y = _Y;
    _begining_Z = _Z;
    _begining_RX = _RX;
    _begining_RY = _RY;
    _begining_RZ = _RZ;
    _prev_X  = _X;
    _prev_Y  = _Y;
    _prev_Z  = _Z;
    _prev_RX = _RX;
    _prev_RY = _RY;
    _prev_RZ = _RZ;
    _prev_is_refracting = false;
    _is_fix_begin_pos = true;
}

void RefractionLaserChip::config(int prm_num_refraction,
                                 frame prm_frame_between_refraction,
                                 frame prm_frame_standstill_refraction,
                                 bool prm_is_fix_begin_pos,
                                 GgafActorDepository* prm_pDispatche_RefractionEffect) {
#ifdef MY_DEBUG
    if (prm_frame_between_refraction == 0) {
        throwGgafCriticalException("RefractionLaserChip::config iԊut[0͐ݒsłBname="<<getName());
    }
    if (prm_frame_standstill_refraction == 0) {
        throwGgafCriticalException("RefractionLaserChip::config ܗt[0͐ݒsłBname="<<getName());
    }
#endif
    _num_refraction = prm_num_refraction;
    _frame_between_refraction = prm_frame_between_refraction;
    _frame_standstill_refraction = prm_frame_standstill_refraction;
    _is_fix_begin_pos = prm_is_fix_begin_pos;
    _pDispatche_RefractionEffect = prm_pDispatche_RefractionEffect;
}

void RefractionLaserChip::onActive() {
    //Ǝݒ肵ꍇApĕʃNX쐬AI[o[ChĂB
    //̍ ́A{NX onActive() \bhĂяoĂB
    LaserChip::onActive();

    RefractionLaserChip* pChip_front =  (RefractionLaserChip*)_pChip_front;
    //[U[`bvo
    if (pChip_front == nullptr) {
        _is_leader = true;
        //g擪̏ꍇ
        _begining_X = _X;
        _begining_Y = _Y;
        _begining_Z = _Z;
        _begining_RX = _RX;
        _begining_RY = _RY;
        _begining_RZ = _RZ;
        _cnt_refraction = 0;
        _frame_refraction_enter = getBehaveingFrame() + _frame_between_refraction;
        _frame_refraction_out = _frame_refraction_enter + _frame_standstill_refraction;
        //onRefractionBegin(_cnt_refraction);
        onRefractionFinish(_cnt_refraction);  //R[obN 0ڂ̋܏IX^[g
    } else {
        _is_leader = false;
        _begining_X = pChip_front->_begining_X;
        _begining_Y = pChip_front->_begining_Y;
        _begining_Z = pChip_front->_begining_Z;
        _begining_RX = pChip_front->_begining_RX;
        _begining_RY = pChip_front->_begining_RY;
        _begining_RZ = pChip_front->_begining_RZ;
        if (_is_fix_begin_pos) {
            _X = _begining_X;
            _Y = _begining_Y;
            _Z = _begining_Z;
            _RX = _begining_RX;
            _RY = _begining_RY;
            _RZ = _begining_RZ;
        }
        _cnt_refraction = 0;
        _frame_refraction_enter = INT_MAX;
        _frame_refraction_out = INT_MAX;
    }

    _is_refracting = false;
    _prev_is_refracting = false;
}

void RefractionLaserChip::onInactive() {
    //[U[`bv

    //̃`bv΁ÄӎviړȂǁjp
    //́A[U[ꂽꍇAȉ̃p[^[݈̂pAړp邽߁B
    //xAړ\ȂǈpȂ̂̂ŁAGȈړۂ́ARRɒӂ𕥂ƁI
    //[U[Q[̈OɂƂA擪`bv珇ɘAňp邱ƂɂȂB
    //ƖʂۂǁAȂΐ擪̎̃`bv̈OɌĈړƂ͌Ȃ̂ŁA͂KvB
    if (_pChip_behind) {
        RefractionLaserChip* const pChip_behind = (RefractionLaserChip*)_pChip_behind;
        GgafDxKurokoA* const pChip_behind_pKurokoA = pChip_behind->_pKurokoA;
        GgafDxKurokoA* const pKurokoA = _pKurokoA;

        pChip_behind_pKurokoA->_vX = pKurokoA->_vX;
        pChip_behind_pKurokoA->_vY = pKurokoA->_vY;
        pChip_behind_pKurokoA->_vZ = pKurokoA->_vZ;
        pChip_behind_pKurokoA->_angRzMv = pKurokoA->_angRzMv;
        pChip_behind_pKurokoA->_angRyMv = pKurokoA->_angRyMv;
        pChip_behind_pKurokoA->_veloMv = pKurokoA->_veloMv;
        pChip_behind_pKurokoA->_angFace[AXIS_X] = pKurokoA->_angFace[AXIS_X];
        pChip_behind_pKurokoA->_angFace[AXIS_Y] = pKurokoA->_angFace[AXIS_Y];
        pChip_behind_pKurokoA->_angFace[AXIS_Z] = pKurokoA->_angFace[AXIS_Z];
        pChip_behind->_cnt_refraction = _cnt_refraction;
        pChip_behind->_frame_refraction_enter = _frame_refraction_enter;
        pChip_behind->_frame_refraction_out = _frame_refraction_out;
        pChip_behind->_is_refracting = _is_refracting;
        //܃GtFNg
        if (_pRefractionEffect) {
            _pRefractionEffect->sayonara();
            _pRefractionEffect = nullptr;
        }
        if (_prev_pRefractionEffect) {
            _prev_pRefractionEffect->sayonara();
            _prev_pRefractionEffect = nullptr;
        }
        pChip_behind->_pRefractionEffect = _pRefractionEffect;
    } else {
        //܃GtFNg
        if (_pRefractionEffect) {
            _pRefractionEffect->sayonara();
            _pRefractionEffect = nullptr;
        }
        if (_prev_pRefractionEffect) {
            _prev_pRefractionEffect->sayonara();
            _prev_pRefractionEffect = nullptr;
        }
    }
    LaserChip::onInactive(); //Ȃؒf
}

void RefractionLaserChip::processBehavior() {
    //[U[`bv
    //Ǝݒ肵ꍇApĕʃNX쐬AI[o[ChĂB
    //̍ ́A{NX processBehavior() \bhĂяoĂB
    //Wɔf
    RefractionLaserChip* pChip_front =  (RefractionLaserChip*)_pChip_front;
    if (getActiveFrame() > 1) {
        //GgafActorDepository::dispatch() 
        //擾łꍇA|C^ԂƋɁÃAN^[̓AN^[҂̃TüԌɈړB
        //āA[U[̐擪珇ԂprocessBehavior() Ă΂邽߁Aȉ̂悤ɂ
        //qɂȂB
        if (pChip_front == nullptr) {
            //{̐擪`bvA͂ɂ킩擪`bv̏ꍇ̋ʏ
            _prev_X  = _X;
            _prev_Y  = _Y;
            _prev_Z  = _Z;
            _prev_RX = _RX;
            _prev_RY = _RY;
            _prev_RZ = _RZ;
            _prev_is_refracting = _is_refracting;
            _prev_pRefractionEffect = _pRefractionEffect;

            _pRefractionEffect = nullptr;
            if (!_is_refracting) {
                if (getBehaveingFrame() >= _frame_refraction_enter) {
                    if (_cnt_refraction < _num_refraction) {
                        _cnt_refraction++;
                        onRefractionBegin(_cnt_refraction); //R[obN
                        _frame_refraction_out = getBehaveingFrame()  + _frame_standstill_refraction;
                        _is_refracting = true;

                        if (_pDispatche_RefractionEffect) {
                            _pRefractionEffect = (GgafDxDrawableActor*)_pDispatche_RefractionEffect->dispatch();
                            if (_pRefractionEffect) {
                                _pRefractionEffect->positionAs(this);
                                //ŒԂ̉\B
                                //̔qŃ[U[`bvłꍇAsayonara()oȂꍇB̏ꍇ̕یB
                                _pRefractionEffect->inactivateDelay(_pDepo->_num_chip_max +_frame_standstill_refraction);
                            }
                        }
                    }
                }
            }

            if (_is_refracting) {
                if (getBehaveingFrame() >= _frame_refraction_out) {
                    onRefractionFinish(_cnt_refraction); //R[obN
                    _frame_refraction_enter = getBehaveingFrame() + _frame_between_refraction;
                    //Wς]
                    int X = _X; int Y = _Y; int Z = _Z;
                    _pKurokoA->behave(); //
                    _X = X; _Y = Y; _Z = Z;
                    _is_refracting = false;

                    return;
                }
            }

            if (!_is_refracting) {
                //_is_refracting͒~ȂĂ͂Ȃ_pKurokoA->behave()sȂB
                //_pKurokoA->behave();ȊOōW𑀍삵Ăꍇ́ASȒ~ɂȂȂ̂Œ
                _pKurokoA->behave();
            }

        } else {
            //擪ȊÕ`bvq
            _prev_X  = _X;
            _prev_Y  = _Y;
            _prev_Z  = _Z;
            _prev_RX = _RX;
            _prev_RY = _RY;
            _prev_RZ = _RZ;
            _prev_is_refracting = _is_refracting;
            _prev_pRefractionEffect = _pRefractionEffect;
            _X  = pChip_front->_prev_X;
            _Y  = pChip_front->_prev_Y;
            _Z  = pChip_front->_prev_Z;
            _RX = pChip_front->_prev_RX;
            _RY = pChip_front->_prev_RY;
            _RZ = pChip_front->_prev_RZ;
            _is_refracting =  pChip_front->_prev_is_refracting;
            _pRefractionEffect = pChip_front->_prev_pRefractionEffect;
            if (_pChip_behind == nullptr) {
                if (_pRefractionEffect) {
                    //_TRACE_("_pRefractionEffect->sayonara();");
                    _pRefractionEffect->sayonara(_frame_standstill_refraction);
                }
            }
        }
    }
}

void RefractionLaserChip::processSettlementBehavior() {
    if (_was_paused_flg) {
        GgafDxGeometricActor::processSettlementBehavior();
    } else {
        LaserChip::processSettlementBehavior();
    }
}

RefractionLaserChip::~RefractionLaserChip() {
}

