#include "stdafx.h"
#include "jp/ggaf/lib/actor/laserchip/HomingLaserChip.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;

HomingLaserChip::HomingLaserChip(const char* prm_name, const char* prm_model, GgafStatus* prm_pStat) :
            LaserChip(prm_name, prm_model, prm_pStat) {
    _class_name = "HomingLaserChip";
    _is_leader = false;

    _begining_X = _X;
    _begining_Y = _Y;
    _begining_Z = _Z;
    _begining_RX = _RX;
    _begining_RY = _RY;
    _begining_RZ = _RZ;
    _prev_X = _X;
    _prev_Y = _Y;
    _prev_Z = _Z;
    _prev_RX = _RX;
    _prev_RY = _RY;
    _prev_RZ = _RZ;
    _is_fix_begin_pos = true;
}

void HomingLaserChip::onActive() {
    //Ǝݒ肵ꍇApĕʃNX쐬AI[o[ChĂB
    //̍ ́A{NX onActive() \bhĂяoĂB
    LaserChip::onActive();
    HomingLaserChip* pChip_front =  (HomingLaserChip*)_pChip_front;

    //[U[`bvo
    if (pChip_front == nullptr) {
        //_TRACE_("HomingLaserChip::onActive() "<<getName()<<" pChip_front == nullptr");
        _is_leader = true;
        //g擪̏ꍇ
        _begining_X = _X;
        _begining_Y = _Y;
        _begining_Z = _Z;
        _begining_RX = _RX;
        _begining_RY = _RY;
        _begining_RZ = _RZ;
    } else {
        _is_leader = false;
        //_TRACE_("HomingLaserChip::onActive() "<<getName()<<" pChip_front =="<<(pChip_front->getName()));
        _begining_X = pChip_front->_begining_X;
        _begining_Y = pChip_front->_begining_Y;
        _begining_Z = pChip_front->_begining_Z;
        _begining_RX = pChip_front->_begining_RX;
        _begining_RY = pChip_front->_begining_RY;
        _begining_RZ = pChip_front->_begining_RZ;
        if (_is_fix_begin_pos) {
            _X = _begining_X;
            _Y = _begining_Y;
            _Z = _begining_Z;
            _RX = _begining_RX;
            _RY = _begining_RY;
            _RZ = _begining_RZ;
        }
    }
}

void HomingLaserChip::onInactive() {
    //[U[`bv
    //      -==========<>            [U[
    //
    //      -= === === === <>        ȂӂɕfĂ܂B
    //
    //    | -=|===|===|===|<> |      }̓[U[IuWFNgŋ؂̐}
    //
    //    <--><--><--><--><-->^
    //    ^   ^   ^   ^   ^   |
    //    |   |   |   |   |   |
    //    |   |   |   |   |    `----- 4:[`bv(\ŁAԐ擪`bv\邽߂ɑ)
    //    |   |   |   |    `----- 3:Ԑ擪`bv(\̐擪)
    //    |   |   |    `----- 2:ԃ`bv
    //    |   |    `----- 2:ԃ`bv
    //    |    `----- 2:ԃ`bv
    //     `----- 1:`bv
    //

    //_TRACE_("A HomingLaserChip::onInactive() _chip_kind ="<<_chip_kind <<")");
    if (_chip_kind == 1) {

    } else if (_chip_kind == 2) {
        LaserChip* pChip_behind = _pChip_behind;
        //ԃ`bv̏ꍇ
        //g̃`bv邱ƂɂA[U[̐Ȃ\QĂ܂B
        //O̐擪ȊÕ`bv́AOɒǏ]Ă邾Ȃ̂ŁAԃ`bv Mover p[^͕sB
        //`bvVȐ擪`bvƂȂ郌[U[\̃O[v _pKurokoA->behave() œp邽߂ɁA
        //VȐ擪`bv֌݂̈ړƈړx̏`BKvB
        if (pChip_behind) {
            int D = (int)(sqrt(
                              (
                                ((double)(pChip_behind->_X - _X)) * ((double)(pChip_behind->_X - _X))
                              ) + (
                                ((double)(pChip_behind->_Y - _Y)) * ((double)(pChip_behind->_Y - _Y))
                              ) + (
                                ((double)(pChip_behind->_Z - _Z)) * ((double)(pChip_behind->_Z - _Z))
                              )
                            )
                         );
            pChip_behind->_pKurokoA->setMvVelo(D); //xɂȂ
            pChip_behind->_pKurokoA->setMvAngTwd(this);
        } else {
            //throwGgafCriticalException("HomingLaserChip::onInactive() _chip_kind == 2 łɂւ炸A_pChip_behind݂܂");
        }
    } else if (_chip_kind == 3) {
        //Ԑ擪`bv̏ꍇ
        //wǂ̏ꍇA擪珇ɏĂ͂łB
        //sƂ͒ԃ`bv̏ꍇƓŁA`bv֏`BKvB
        //[`bv Mover p[^̈ړƈړx̏Rs[邱ƂOK
        //vZx҂
        if (_pChip_behind && _pChip_front) {
            GgafDxKurokoA* const pChip_behind_pKurokoA = _pChip_behind->_pKurokoA;
            GgafDxKurokoA* const pChip_front_pKurokoA = _pChip_front->_pKurokoA;
            pChip_behind_pKurokoA->_vX = pChip_front_pKurokoA->_vX;
            pChip_behind_pKurokoA->_vY = pChip_front_pKurokoA->_vY;
            pChip_behind_pKurokoA->_vZ = pChip_front_pKurokoA->_vZ;
            pChip_behind_pKurokoA->_angRzMv = pChip_front_pKurokoA->_angRzMv;
            pChip_behind_pKurokoA->_angRyMv = pChip_front_pKurokoA->_angRyMv;
            pChip_behind_pKurokoA->_veloMv =  pChip_front_pKurokoA->_veloMv;
        } else {
            //throwGgafCriticalException("HomingLaserChip::onInactive() _chip_kind == 2 łɂւ炸A_pChip_front  _pChip_behind ݂܂");
        }
    } else if (_chip_kind == 4) {
        if (_pChip_behind) {
            GgafDxKurokoA* const pChip_behind_pKurokoA = _pChip_behind->_pKurokoA;
            pChip_behind_pKurokoA->_vX = _pKurokoA->_vX;
            pChip_behind_pKurokoA->_vY = _pKurokoA->_vY;
            pChip_behind_pKurokoA->_vZ = _pKurokoA->_vZ;
            pChip_behind_pKurokoA->_angRzMv = _pKurokoA->_angRzMv;
            pChip_behind_pKurokoA->_angRyMv = _pKurokoA->_angRyMv;
            pChip_behind_pKurokoA->_veloMv = _pKurokoA->_veloMv;
        } else {
            //throwGgafCriticalException("HomingLaserChip::onInactive() _chip_kind == 4 łɂւ炸A_pChip_behind ݂܂");
        }
    }
    LaserChip::onInactive(); //Ȃؒf
}

void HomingLaserChip::processBehavior() {
    //Ǝݒ肵ꍇApĕʃNX쐬AI[o[ChĂB
    //̍ ́A{NX processBehavior() \bhĂяoĂB
    //Wɔf
    HomingLaserChip* pChip_front =  (HomingLaserChip*)_pChip_front;
    if (getActiveFrame() > 1) {
        //GgafActorDepository::dispatch() 
        //擾łꍇA|C^ԂƋɁÃAN^[̓AN^[҂̃TüԌɈړB
        //āA[U[̐擪珇ԂprocessBehavior() Ă΂邽߁Aȉ̂悤ɂ
        //qɂȂB
        if (pChip_front == nullptr) {
            //{̐擪`bvA͂ɂ킩擪`bv̏ꍇ̋ʏ
            _prev_X  = _X;
            _prev_Y  = _Y;
            _prev_Z  = _Z;
            _prev_RX = _RX;
            _prev_RY = _RY;
            _prev_RZ = _RZ;
            processBehaviorHeadChip(); //擪`bv݈̂ړ
        } else {
            _prev_X  = _X;
            _prev_Y  = _Y;
            _prev_Z  = _Z;
            _prev_RX = _RX;
            _prev_RY = _RY;
            _prev_RZ = _RZ;
            _X  = pChip_front->_prev_X;
            _Y  = pChip_front->_prev_Y;
            _Z  = pChip_front->_prev_Z;
            _RX = pChip_front->_prev_RX;
            _RY = pChip_front->_prev_RY;
            _RZ = pChip_front->_prev_RZ;
        }
    }
}

void HomingLaserChip::processSettlementBehavior() {
    if (_was_paused_flg) {
        GgafDxGeometricActor::processSettlementBehavior();
    } else {
        LaserChip::processSettlementBehavior();
    }
}

HomingLaserChip::~HomingLaserChip() {
}

