#ifndef GGAFLIB_STGUTIL_H_
#define GGAFLIB_STGUTIL_H_
#include "jp/ggaf/dxcore/util/GgafDxUtil.h"

#include "jp/ggaf/lib/util/ColliAAB.h"
#include "jp/ggaf/lib/util/ColliSphere.h"
#include "jp/ggaf/lib/util/ColliAAPrism.h"
#include "jp/ggaf/dxcore/actor/GgafDxGeometricActor.h"

#ifdef UTIL
    #undef UTIL
#endif
#define UTIL GgafLib::StgUtil

namespace GgafLib {

/**
 * [eBeB .
 * @version 1.00
 * @since 2008/09/08
 * @author Masatoshi Tsuge
 */
class StgUtil: public GgafDxCore::GgafDxUtil {
public:
    struct Pos {
        coord X;
        coord Y;
        coord Z;
    };

    static inline bool isHit(GgafDxCore::GgafDxGeometricActor* pActor01, ColliAAB* pAAB01,
                             GgafDxCore::GgafDxGeometricActor* pActor02, ColliAAB* pAAB02 ) {
        //AAB  AAB
        //vȂmȏ(X>Z>Y)ɔ
        if (pActor01->_X + pAAB01->_x2 >= pActor02->_X + pAAB02->_x1) {
            if (pActor01->_X + pAAB01->_x1 <= pActor02->_X + pAAB02->_x2) {
                if (pActor01->_Z + pAAB01->_z2 >= pActor02->_Z + pAAB02->_z1) {
                    if (pActor01->_Z + pAAB01->_z1 <= pActor02->_Z + pAAB02->_z2) {
                        if (pActor01->_Y + pAAB01->_y2 >= pActor02->_Y + pAAB02->_y1) {
                            if (pActor01->_Y + pAAB01->_y1 <= pActor02->_Y + pAAB02->_y2) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    static inline bool isHit(GgafDxCore::GgafDxGeometricActor* pActor01, ColliSphere* pSphere01,
                             GgafDxCore::GgafDxGeometricActor* pActor02, ColliSphere* pSphere02 ) {
        //  
        //1 F S_̍WP1(x1, y1, z1), ar1
        //2 F S_̍WP2(x2, y2, z2), ar2
        //(x2-x1)^2 + (y2-y1)^2 + (z2-z1)^2 <= (r1+r2)^2
        double d2 = (double)((pActor02->_X+pSphere02->_x) - (pActor01->_X+pSphere01->_x)) * ((pActor02->_X+pSphere02->_x) - (pActor01->_X+pSphere01->_x)) +
                    (double)((pActor02->_Y+pSphere02->_y) - (pActor01->_Y+pSphere01->_y)) * ((pActor02->_Y+pSphere02->_y) - (pActor01->_Y+pSphere01->_y)) +
                    (double)((pActor02->_Z+pSphere02->_z) - (pActor01->_Z+pSphere01->_z)) * ((pActor02->_Z+pSphere02->_z) - (pActor01->_Z+pSphere01->_z));
        if (d2 <= (double)(pSphere02->_r + pSphere01->_r) * (pSphere02->_r + pSphere01->_r)
        ) {
            return true;
        } else {
            return false;
        }
    }

    static inline bool isHit(GgafDxCore::GgafDxGeometricActor* pActor01, ColliAAB*    pAAB01,
                             GgafDxCore::GgafDxGeometricActor* pActor02, ColliSphere* pSphere02) {
        //AAB  
        coord o_scx = pActor02->_X + pSphere02->_cx;
        coord o_scy = pActor02->_Y + pSphere02->_cy;
        coord o_scz = pActor02->_Z + pSphere02->_cz;
        coord bx1 = pActor01->_X + pAAB01->_x1;
        coord bx2 = pActor01->_X + pAAB01->_x2;
        coord by1 = pActor01->_Y + pAAB01->_y1;
        coord by2 = pActor01->_Y + pAAB01->_y2;
        coord bz1 = pActor01->_Z + pAAB01->_z1;
        coord bz2 = pActor01->_Z + pAAB01->_z2;
        double square_length = 0; //̒SAAB̍ŒZ悵l
        if(o_scx < bx1) {
            square_length += (double)(o_scx - bx1) * (o_scx - bx1);
        }
        if(o_scx > bx2) {
            square_length += (double)(o_scx - bx2) * (o_scx - bx2);
        }
        if(o_scy < by1) {
            square_length += (double)(o_scy - by1) * (o_scy - by1);
        }
        if(o_scy > by2) {
            square_length += (double)(o_scy - by2) * (o_scy - by2);
        }
        if(o_scz < bz1) {
            square_length += (double)(o_scz - bz1) * (o_scz - bz1);
        }
        if(o_scz > bz2) {
            square_length += (double)(o_scz - bz2) * (o_scz - bz2);
        }
        //square_length̔ai̓jZΏՓ˂Ă
        if (square_length <= pSphere02->_rr) {
            return true;
        } else {
            return false;
        }
    }


    static inline bool isHit(GgafDxCore::GgafDxGeometricActor* pActor01, ColliAAPrism* pAAPrism01,
                             GgafDxCore::GgafDxGeometricActor* pActor02, ColliAAB*     pAAB02     ) {
        //vY  AAB
        int aX1 = pActor01->_X + pAAPrism01->_x1;
        int aY1 = pActor01->_Y + pAAPrism01->_y1;
        int aZ1 = pActor01->_Z + pAAPrism01->_z1;
        int aX2 = pActor01->_X + pAAPrism01->_x2;
        int aY2 = pActor01->_Y + pAAPrism01->_y2;
        int aZ2 = pActor01->_Z + pAAPrism01->_z2;

        int bX1 = pActor02->_X + pAAB02->_x1;
        int bY1 = pActor02->_Y + pAAB02->_y1;
        int bZ1 = pActor02->_Z + pAAB02->_z1;
        int bX2 = pActor02->_X + pAAB02->_x2;
        int bY2 = pActor02->_Y + pAAB02->_y2;
        int bZ2 = pActor02->_Z + pAAB02->_z2;

        if (aZ2 >= bZ1 && aZ1 <= bZ2 && aY2 >= bY1 && aY1 <= bY2 && aX2 >= bX1 && aX1 <= bX2) {
            //̎_AAB  AAB Ȃ΃qbg
            int pos = pAAPrism01->_pos_prism;
            double a = pAAPrism01->_a;
            if (pos & POS_PRISM_XY) { //XYʃXCX̃vY
                //[hWł̃vYE̐ؕЂ߂ b = y - ax
                double b = ((pActor01->_Y+pAAPrism01->_cy) - pAAPrism01->_a * (pActor01->_X+pAAPrism01->_cx)) + pAAPrism01->_b;

                if (pos & POS_PRISM_pp) {
                    //             y+
                    //
                    //        
                    //        _
                    // x-   @_焠   x+
                    //      @_
                    //      
                    //      
                    //             y-
                    //
                    //vYE y = ax + b 
                    //̍W(bX2, bY2)AƂ̈ʒu֌Wl
                    //y > ax + b ł΃qbg
                    if (bY2 > a * bX2 +  b) {
                        return true;
                    }

                } else if (pos & POS_PRISM_np) {
                    //             y+
                    //
                    //        
                    //        ^
                    // x-   ^@   x+
                    //        ^@
                    //        Opp
                    //              
                    //             y-
                    //
                    //vYE y = ax + b 
                    //̍W(bX1, bY2)AƂ̈ʒu֌Wl
                    //y > ax + b ł΃qbg
                    if (bY2 > a * bX1 +  b) {
                        return true;
                    }

                } else if (pos & POS_PRISM_pn) {
                    //             y+
                    //      
                    //      
                    //      @^
                    // x-   @^   x+
                    //        ^焠
                    //        
                    //
                    //             y-
                    //
                    //vYE y = ax + b 
                    //̍W(bX2, bY1)AƂ̈ʒu֌Wl
                    //y < ax + b ł΃qbg
                    if (bY1 < a * bX2 +  b) {
                        return true;
                    }

                } else { // ̂ POS_PRISM_nn ݂̂ł
                    //             y+
                    //              
                    //        Opp
                    //        _@
                    // x-   _@   x+
                    //        _
                    //        
                    //
                    //             y-
                    //
                    //vYE y = ax + b 
                    //̍W(bX1, bY1)AƂ̈ʒu֌Wl
                    //y < ax + b ł΃qbg
                    if (bY1 < a * bX1 +  b) {
                        return true;
                    }


                }
            } else if (pos & POS_PRISM_YZ) {//YZʃXCX̃vY
                //[hWł̃vYE̐ؕЂ߂ b = z - ay
                int b = ((pActor01->_Z+pAAPrism01->_cz) - pAAPrism01->_a * (pActor01->_Y+pAAPrism01->_cy)) + pAAPrism01->_b;
                if (pos & POS_PRISM_pp) {
                    //             z+
                    //
                    //        
                    //        _
                    // y-   @_焠   y+
                    //      @_
                    //      
                    //      
                    //             z-
                    //
                    //vYE z = ay + b 
                    //̍W(bY2, bZ2)AƂ̈ʒu֌Wl
                    //z > ay + b ł΃qbg
                    if (bZ2 > a * bY2 +  b) {
                        return true;
                    }

                } else if (pos & POS_PRISM_np) {
                    //             z+
                    //
                    //        
                    //        ^
                    // y-   ^@   y+
                    //        ^@
                    //        Opp
                    //              
                    //             z-
                    //
                    //vYE z = ay + b 
                    //̍W(bY1, bZ2)AƂ̈ʒu֌Wl
                    //z > ay + b ł΃qbg
                    if (bZ2 > a * bY1 +  b) {
                        return true;
                    }

                } else if (pos & POS_PRISM_pn) {
                    //             z+
                    //      
                    //      
                    //      @^
                    // y-   @^   y+
                    //        ^焠
                    //        
                    //
                    //             z-
                    //
                    //vYE z = ay + b 
                    //̍W(bY2, bZ1)AƂ̈ʒu֌Wl
                    //z < ay + b ł΃qbg
                    if (bZ1 < a * bY2 +  b) {
                        return true;
                    }

                } else { //̂ POS_PRISM_nn ݂̂ł
                    //             z+
                    //              
                    //        Opp
                    //        _@
                    // y-   _@   y+
                    //        _
                    //        
                    //
                    //             z-
                    //
                    //vYE z = ay + b 
                    //̍W(bY1, bZ1)AƂ̈ʒu֌Wl
                    //z < ay + b ł΃qbg
                    if (bZ1 < a * bY1 +  b) {
                        return true;
                    }
                }

            } else if (pos & POS_PRISM_ZX) {
                //[hWł̃vYE̐ؕЂ߂ b = x - az
                int b = ((pActor01->_X+pAAPrism01->_cx) - pAAPrism01->_a * (pActor01->_Z+pAAPrism01->_cz)) + pAAPrism01->_b;
                if (pos & POS_PRISM_pp) {
                    //             x+
                    //
                    //        
                    //        _
                    // z-   @_焠   z+
                    //      @_
                    //      
                    //      
                    //             x-
                    //
                    //vYE x = az + b 
                    //̍W(bZ2, bX2)AƂ̈ʒu֌Wl
                    //x > az + b ł΃qbg
                    if (bX2 > a * bZ2 +  b) {
                        return true;
                    }

                } else if (pos & POS_PRISM_np) {
                    //             x+
                    //
                    //        
                    //        ^
                    // z-   ^@   z+
                    //        ^@
                    //        Opp
                    //              
                    //             x-
                    //
                    //vYE x = az + b 
                    //̍W(bZ1, bX2)AƂ̈ʒu֌Wl
                    //x > az + b ł΃qbg
                    if (bX2 > a * bZ1 +  b) {
                        return true;
                    }

                } else if (pos & POS_PRISM_pn) {
                    //             x+
                    //      
                    //      
                    //      @^
                    // z-   @^   z+
                    //        ^焠
                    //        
                    //
                    //             x-
                    //
                    //vYE x = az + b 
                    //̍W(bZ2, bX1)AƂ̈ʒu֌Wl
                    //x < az + b ł΃qbg
                    if (bX1 < a * bZ2 +  b) {
                        return true;
                    }

                } else { //c POS_PRISM_nn ݂̂ł
                    //             x+
                    //              
                    //        Opp
                    //        _@
                    // z-   _@   z+
                    //        _
                    //        
                    //
                    //             x-
                    //
                    //vYE x = az + b 
                    //̍W(bZ1, bX1)AƂ̈ʒu֌Wl
                    //x < az + b ł΃qbg
                    if (bX1 < a * bZ1 +  b) {
                        return true;
                    }
                }
            }
        }
        return false;
    }



    static inline bool isHit(GgafDxCore::GgafDxGeometricActor* pActor01, ColliAAPrism* pAAPrism01,
                             GgafDxCore::GgafDxGeometricActor* pActor02, ColliSphere*  pSphere02  ) {
        //vY  
        //MEMO:ȓ蔻vZ͍sĂ܂B
        int aX1 = pActor01->_X + pAAPrism01->_x1;
        int aY1 = pActor01->_Y + pAAPrism01->_y1;
        int aZ1 = pActor01->_Z + pAAPrism01->_z1;
        int aX2 = pActor01->_X + pAAPrism01->_x2;
        int aY2 = pActor01->_Y + pAAPrism01->_y2;
        int aZ2 = pActor01->_Z + pAAPrism01->_z2;

        //AAB  ł܂肷
        if (isHit(pActor01, (ColliAAB*)pAAPrism01,
                  pActor02, pSphere02             ) ) {
            //̎_AAB  ŃqbgBvYłqbg؂
            int pos = pAAPrism01->_pos_prism;
            double a = pAAPrism01->_a;
            if (pos & POS_PRISM_XY) { //XYʃXCX̃vY
                //[hWł̃vYE̐ؕЂ߂ b = y - ax
                double b = ((pActor01->_Y+pAAPrism01->_cy) - pAAPrism01->_a * (pActor01->_X+pAAPrism01->_cx)) + pAAPrism01->_b;

                int oppX, oppY;
                int bZc = pActor02->_Z + pSphere02->_cz; //̒SZW
                if (aZ1 < bZc && bZc < aZ2) {
                    //̒SZWvYZ͈͓Ȃ΁A\ߕێĂ_vIH_x,_vIH_ygp
                    //vYΕӂƍŒZ̉~XYW߂
                    oppX = (pActor02->_X + pSphere02->_x) + pAAPrism01->_vIH_x * pSphere02->_r;
                    oppY = (pActor02->_Y + pSphere02->_y) + pAAPrism01->_vIH_y * pSphere02->_r;
                } else {
                    if (bZc >= aZ2) {
                        //̒SZWvYZ͈͊Ȍꍇ
                        //鋗ɉāA̔a(pSphere02->_r)čvZ
                        //銄 ROOT_1_MINUS_XX (1/4~̉̃e[uzjgpB
                        //                 |
                        //                 _
                        //         `
                        // z-            z+
                        int r = pSphere02->_r * UTIL::ROOT_1_MINUS_XX[(int)((1.0*(bZc - aZ2) / pSphere02->_r)*1000)];
                        oppX = (pActor02->_X + pSphere02->_x) + pAAPrism01->_vIH_x * r;
                        oppY = (pActor02->_Y + pSphere02->_y) + pAAPrism01->_vIH_y * r;
                    } else if (aZ1 >= bZc) {
                        int r = pSphere02->_r * UTIL::ROOT_1_MINUS_XX[(int)((1.0*(aZ1 - bZc) / pSphere02->_r)*1000)];
                        oppX = (pActor02->_X + pSphere02->_x) + pAAPrism01->_vIH_x * r;
                        oppY = (pActor02->_Y + pSphere02->_y) + pAAPrism01->_vIH_y * r;
                    }
                }

                if (pos & POS_PRISM_pp) {
                    //             y+
                    //
                    //        
                    //        _
                    // x-   @_焠   x+
                    //       ,@_
                    //      
                    //       `'
                    //             y-
                    //
                    //vYE y = ax + b 
                    //̍W(bX2, bY2)AƂ̈ʒu֌Wl
                    //y > ax + b ł΃qbg
                    if (oppY > a * oppX +  b) {
                        return true;
                    }

                } else if (pos & POS_PRISM_np) {
                    //             y+
                    //
                    //        
                    //        ^
                    // x-   ^@   x+
                    //        ^@A
                    //        Opp
                    //               `'
                    //             y-
                    //
                    //vYE y = ax + b 
                    //̍W(bX1, bY2)AƂ̈ʒu֌Wl
                    //y > ax + b ł΃qbg
                    if (oppY > a * oppX +  b) {
                        return true;
                    }

                } else if (pos & POS_PRISM_pn) {
                    //             y+
                    //       ,A
                    //      
                    //       `@^
                    // x-   @^   x+
                    //        ^焠
                    //        
                    //
                    //             y-
                    //
                    //vYE y = ax + b 
                    //̍W(bX2, bY1)AƂ̈ʒu֌Wl
                    //y < ax + b ł΃qbg
                    if (oppY < a * oppX +  b) {
                        return true;
                    }

                } else { // ̂ POS_PRISM_nn ݂̂ł
                    //             y+
                    //               ,A
                    //        Opp
                    //        _@'
                    // x-   _@   x+
                    //        _
                    //        
                    //
                    //             y-
                    //
                    //vYE y = ax + b 
                    //̍W(bX1, bY1)AƂ̈ʒu֌Wl
                    //y < ax + b ł΃qbg
                    if (oppY < a * oppX +  b) {
                        return true;
                    }


                }
            } else if (pos & POS_PRISM_YZ) {//YZʃXCX̃vY
                //[hWł̃vYE̐ؕЂ߂ b = z - ay
                int b = ((pActor01->_Z+pAAPrism01->_cz) - pAAPrism01->_a * (pActor01->_Y+pAAPrism01->_cy)) + pAAPrism01->_b;
                int oppY, oppZ;

                int bXc = pActor02->_X + pSphere02->_cx;
                if (aX1 < bXc && bXc < aX2) {
                    oppY = (pActor02->_Y + pSphere02->_y) + pAAPrism01->_vIH_x * pSphere02->_r;
                    oppZ = (pActor02->_Z + pSphere02->_z) + pAAPrism01->_vIH_y * pSphere02->_r;
                } else {
                    if (bXc >= aX2) {
                        int r = pSphere02->_r * UTIL::ROOT_1_MINUS_XX[(int)((1.0*(bXc - aX2) / pSphere02->_r)*1000)];
                        oppY = (pActor02->_Y + pSphere02->_y) + pAAPrism01->_vIH_x * r;
                        oppZ = (pActor02->_Z + pSphere02->_z) + pAAPrism01->_vIH_y * r;
                    } else if (aX1 >= bXc) {
                        int r = pSphere02->_r * UTIL::ROOT_1_MINUS_XX[(int)((1.0*(aX1 - bXc) / pSphere02->_r)*1000)];
                        oppY = (pActor02->_Y + pSphere02->_y) + pAAPrism01->_vIH_x * r;
                        oppZ = (pActor02->_Z + pSphere02->_z) + pAAPrism01->_vIH_y * r;
                    }
                }
                if (pos & POS_PRISM_pp) {
                    //             z+
                    //
                    //        
                    //        _
                    // y-   @_焠   y+
                    //       ,@_
                    //      
                    //       `'
                    //             z-
                    //
                    //vYE z = ay + b 
                    //̍W(bY2, bZ2)AƂ̈ʒu֌Wl
                    //z > ay + b ł΃qbg
                    if (oppZ > a * oppY +  b) {
                        return true;
                    }

                } else if (pos & POS_PRISM_np) {
                    //             z+
                    //
                    //        
                    //        ^
                    // y-   ^@   y+
                    //        ^@A
                    //        Opp
                    //               `'
                    //             z-
                    //
                    //vYE z = ay + b 
                    //̍W(bY1, bZ2)AƂ̈ʒu֌Wl
                    //z > ay + b ł΃qbg
                    if (oppZ > a * oppY +  b) {
                        return true;
                    }

                } else if (pos & POS_PRISM_pn) {
                    //             z+
                    //       ,A
                    //      
                    //       `@^
                    // y-   @^   y+
                    //        ^焠
                    //        
                    //
                    //             z-
                    //
                    //vYE z = ay + b 
                    //̍W(bY2, bZ1)AƂ̈ʒu֌Wl
                    //z < ay + b ł΃qbg
                    if (oppZ < a * oppY +  b) {
                        return true;
                    }

                } else { //̂ POS_PRISM_nn ݂̂ł
                    //             z+
                    //               ,A
                    //        Opp
                    //        _@'
                    // y-   _@   y+
                    //        _
                    //        
                    //
                    //             z-
                    //
                    //vYE z = ay + b 
                    //̍W(bY1, bZ1)AƂ̈ʒu֌Wl
                    //z < ay + b ł΃qbg
                    if (oppZ < a * oppY +  b) {
                        return true;
                    }
                }

            } else if (pos & POS_PRISM_ZX) {
                //[hWł̃vYE̐ؕЂ߂ b = x - az
                int b = ((pActor01->_X+pAAPrism01->_cx) - pAAPrism01->_a * (pActor01->_Z+pAAPrism01->_cz)) + pAAPrism01->_b;
                int oppZ,oppX;
                int bYc = pActor02->_Y + pSphere02->_cy;
                if (aY1 < bYc && bYc < aY2) {
                    oppZ = (pActor02->_Z + pSphere02->_z) + pAAPrism01->_vIH_x * pSphere02->_r;
                    oppX = (pActor02->_X + pSphere02->_x) + pAAPrism01->_vIH_y * pSphere02->_r;
                } else {
                    if (bYc >= aY2) {
                        int r = pSphere02->_r * UTIL::ROOT_1_MINUS_XX[(int)((1.0*(bYc - aY2) / pSphere02->_r)*1000)];
                        oppZ = (pActor02->_Z + pSphere02->_z) + pAAPrism01->_vIH_x * r;
                        oppX = (pActor02->_X + pSphere02->_x) + pAAPrism01->_vIH_y * r;
                    } else if (aY1 >= bYc) {
                        int r = pSphere02->_r * UTIL::ROOT_1_MINUS_XX[(int)((1.0*(aY1 - bYc) / pSphere02->_r)*1000)];
                        oppZ = (pActor02->_Z + pSphere02->_z) + pAAPrism01->_vIH_x * r;
                        oppX = (pActor02->_X + pSphere02->_x) + pAAPrism01->_vIH_y * r;
                    }
                }
                if (pos & POS_PRISM_pp) {
                    //             x+
                    //
                    //        
                    //        _
                    // z-   @_焠   z+
                    //       ,@_
                    //      
                    //       `'
                    //             x-
                    //
                    //vYE x = az + b 
                    //̍W(bZ2, bX2)AƂ̈ʒu֌Wl
                    //x > az + b ł΃qbg
                    if (oppX > a * oppZ +  b) {
                        return true;
                    }

                } else if (pos & POS_PRISM_np) {
                    //             x+
                    //
                    //        
                    //        ^
                    // z-   ^@   z+
                    //        ^@A
                    //        Opp
                    //               `'
                    //             x-
                    //
                    //vYE x = az + b 
                    //̍W(bZ1, bX2)AƂ̈ʒu֌Wl
                    //x > az + b ł΃qbg
                    if (oppX > a * oppZ +  b) {
                        return true;
                    }

                } else if (pos & POS_PRISM_pn) {
                    //             x+
                    //       ,A
                    //      
                    //       `@^
                    // z-   @^   z+
                    //        ^焠
                    //        
                    //
                    //             x-
                    //
                    //vYE x = az + b 
                    //̍W(bZ2, bX1)AƂ̈ʒu֌Wl
                    //x < az + b ł΃qbg
                    if (oppX < a * oppZ +  b) {
                        return true;
                    }

                } else { //c POS_PRISM_nn ݂̂ł
                    //             x+
                    //               ,A
                    //        Opp
                    //        _@'
                    // z-   _@   z+
                    //        _
                    //        
                    //
                    //             x-
                    //
                    //vYE x = az + b 
                    //̍W(bZ1, bX1)AƂ̈ʒu֌Wl
                    //x < az + b ł΃qbg
                    if (oppX < a * oppZ +  b) {
                        return true;
                    }
                }
            }
        }
        return false;
    }


    /**
     * e𕡐 .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _X, _Y, _Z W <BR>
     * EVbg GgafDxKurokoA ̈ړAړxAx<BR>
     * @param prm_X               ˌXW
     * @param prm_Y               ˌYW
     * @param prm_Z               ˌZW
     * @param prm_RZ              ˕Rz
     * @param prm_RY              ˕Ry
     * @param prm_pDepo_Shot      ˂Vbg̃f|Wg
     * @param prm_r               ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_velo_first      ẽVbgx
     * @param prm_acce            ẽVbgx
     * @param prm_set_num         e̍v
     * @param prm_interval_frames eƒȅot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SeĔˁBj
     * @param prm_attenuated      eȍ~̃VbgxEx̌(< 1.0)A͑(>1.0)
     * @param pFunc_CallBackDispatched ef|Wg dispach() ꂽɌĂяoR[obNB
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxDrawableActor* shotWay001(coord prm_X, coord prm_Y, coord prm_Z,
                                                       angle prm_RZ, angle prm_RY,
                                                       GgafCore::GgafActorDepository* prm_pDepo_Shot,
                                                       coord prm_r,
                                                       velo prm_velo_first, acce prm_acce,
                                                       int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                       void (*pFunc_CallBackDispatched)(GgafDxCore::GgafDxDrawableActor*, int, int) = nullptr);

    /**
     * ˌĂi_RZ > _RYjɌ e𕡐 .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _X, _Y, _Z W <BR>
     * EVbg GgafDxKurokoA ̈ړAړxAx<BR>
     * @param prm_from_X          ˌXW
     * @param prm_from_Y          ˌYW
     * @param prm_from_Z          ˌZW
     * @param prm_to_X            ڕWXW
     * @param prm_to_Y            ڕWYW
     * @param prm_to_Z            ڕWZW
     * @param prm_pDepo_Shot      ˂Vbg̃f|Wg
     * @param prm_r               ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_velo_first      ẽVbgxBeȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce            Vbgx
     * @param prm_set_num         e̍v
     * @param prm_interval_frames eƒȅot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SeĔˁBj
     * @param prm_attenuated      eȍ~̃Vbgx̌(< 1.0)A͑(>1.0)
     * @param pFunc_CallBackDispatched
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxDrawableActor* shotWay001(coord prm_from_X, coord prm_from_Y, coord prm_from_Z,
                                                       coord prm_to_X, coord prm_to_Y, coord prm_to_Z,
                                                       GgafCore::GgafActorDepository* prm_pDepo_Shot,
                                                       coord prm_r,
                                                       velo prm_velo_first, acce prm_acce,
                                                       int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                       void (*pFunc_CallBackDispatched)(GgafDxCore::GgafDxDrawableActor*, int, int) = nullptr);

    /**
     * ˌĂi_RZ > _RYjɌ e𕡐 .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _X, _Y, _Z W <BR>
     * EVbg GgafDxKurokoA ̈ړAړxAx<BR>
     * @param prm_pFrom           ˌ
     * @param prm_pDepo_Shot      ˂Vbg̃f|Wg
     * @param prm_r               ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_velo_first      ẽVbgxBeȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce            Vbgx
     * @param prm_set_num         e̍v
     * @param prm_interval_frames eƒȅot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SeĔˁBj
     * @param prm_attenuated      eȍ~̃Vbgx̌(< 1.0)A͑(>1.0)
     * @param pFunc_CallBackDispatched
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxDrawableActor* shotWay001(GgafDxCore::GgafDxGeometricActor* prm_pFrom,
                                                       GgafCore::GgafActorDepository* prm_pDepo_Shot,
                                                       coord prm_r,
                                                       velo prm_velo_first, acce prm_acce,
                                                       int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                       void (*pFunc_CallBackDispatched)(GgafDxCore::GgafDxDrawableActor*, int, int) = nullptr);


    /**
     * N-WayeiRzωj𕡐Zbg .
     * prm_RX, prm_RZ, prm_RY = (0,0,0) ŁAXYʏRzω N-Waye ܂B
     * @param prm_X                ˌXW
     * @param prm_Y                ˌYW
     * @param prm_Z                ˌZW
     * @param prm_RX               N Waỷ]p
     * @param prm_RZ               ˕Rz
     * @param prm_RY               ˕Ry
     * @param prm_pDepo_Shot       ˂Vbg̃f|Wg
     * @param prm_r                ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_way_N            N-WayiRzωj
     * @param prm_angClearance_N   N-WaẙԊupx
     * @param prm_velo_first       N-WayeeZbg̃VbgxBeZbgȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce             N-WayeeZbg̃Vbgx
     * @param prm_set_num          ˂ N-WayeZbg̍vZbg
     * @param prm_interval_frames  eZbgƒeZbg̏ot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SZbgĔˁBj
     * @param prm_attenuated       eZbgȍ~̊eZbg̃Vbgx̌(< 1.0)A͑(>1.0)
     * @param pFunc_CallBackDispatched
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxDrawableActor* shotWay002(coord prm_X, coord prm_Y, coord prm_Z,
                                                       angle prm_RX, angle prm_RZ, angle prm_RY,
                                                       GgafCore::GgafActorDepository* prm_pDepo_Shot,
                                                       coord prm_r,
                                                       int prm_way_N,
                                                       angle prm_angClearance_N,
                                                       velo prm_velo_first, acce prm_acce,
                                                       int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                       void (*pFunc_CallBackDispatched)(GgafDxCore::GgafDxDrawableActor*, int, int, int) = nullptr);

    /**
     * ˌĂi_RX, _RZ > _RYjN-WayeiRzωj𕡐Zbg .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _X, _Y, _Z W <BR>
     * EVbg GgafDxKurokoA ̈ړAړxAx<BR>
     * @param prm_pFrom                  ˌ
     * @param prm_pDepo_Shot             ˂Vbg̃f|Wg
     * @param prm_r                      ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_way_N                  N-WayiRzωj
     * @param prm_angClearance_N         N-WaẙԊupx
     * @param prm_velo_first             N-WayeeZbg̃VbgxBeZbgȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce                   N-WayeeZbg̃Vbgx
     * @param prm_set_num                ˂ N-WayeZbg̍vZbg
     * @param prm_interval_frames        eZbgƒeZbg̏ot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SZbgĔˁBj
     * @param prm_attenuated             eZbgȍ~̊eZbg̃Vbgx̌(< 1.0)A͑(>1.0)
     * @param pFunc_CallBackDispatched
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxDrawableActor* shotWay002(GgafDxCore::GgafDxGeometricActor* prm_pFrom,
                                                       GgafCore::GgafActorDepository* prm_pDepo_Shot,
                                                       coord prm_r,
                                                       int prm_way_N,
                                                       angle prm_angClearance_N,
                                                       velo prm_velo_first, acce prm_acce,
                                                       int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                       void (*pFunc_CallBackDispatched)(GgafDxCore::GgafDxDrawableActor*, int, int, int) = nullptr);

    /**
     * N*M-Waye𕡐Zbg .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _X, _Y, _Z W <BR>
     * EVbg GgafDxKurokoA ̈ړAړxAx<BR>
     * @param prm_X                ˌXW
     * @param prm_Y                ˌYW
     * @param prm_Z                ˌZW
     * @param prm_RX               N*M `̉]p
     * @param prm_RZ               ˕Rz
     * @param prm_RY               ˕Ry
     * @param prm_pDepo_Shot1      ˂Vbg̃f|WĝP
     * @param prm_paUint32_dotmat1 VbĝPgphbg}gbNX
     * @param prm_pDepo_Shot2      ˂Vbg̃f|WĝQ
     * @param prm_paUint32_dotmat2 VbĝQgphbg}gbNX
     * @param prm_pDepo_Shot3      ˂Vbg̃f|WĝR
     * @param prm_paUint32_dotmat3 VbĝRgphbg}gbNX
     * @param prm_r                ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_way_N            N-WayiRzωj
     * @param prm_way_M            M-WayiRyωj
     * @param prm_angClearance_N   N-WaẙԊupx
     * @param prm_angClearance_M   M-WaẙԊupx
     * @param prm_velo_first       N*M-WayeeZbg̃VbgxBeZbgȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce             N*M-WayeeZbg̃Vbgx
     * @param prm_set_num          ˂ N*M-WayeZbg̍vZbg
     * @param prm_interval_frames  eZbgƒeZbg̏ot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SZbgĔˁBj
     * @param prm_attenuated       eZbgȍ~̊eZbg̃Vbgx̌(< 1.0)A͑(>1.0)
     * @param pFunc_CallBackDispatched
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxDrawableActor* shotWay003(coord prm_X, coord prm_Y, coord prm_Z,
                                                       angle prm_RX, angle prm_RZ, angle prm_RY,
                                                       GgafCore::GgafActorDepository* prm_pDepo_Shot1, uint32_t* prm_paUint32_dotmat1,
                                                       GgafCore::GgafActorDepository* prm_pDepo_Shot2, uint32_t* prm_paUint32_dotmat2,
                                                       GgafCore::GgafActorDepository* prm_pDepo_Shot3, uint32_t* prm_paUint32_dotmat3,
                                                       coord prm_r,
                                                       int prm_way_N, int prm_way_M,
                                                       angle prm_angClearance_N, angle prm_angClearance_M,
                                                       velo prm_velo_first, acce prm_acce,
                                                       int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                       void (*pFunc_CallBackDispatched)(GgafDxCore::GgafDxDrawableActor*, int, int, int, int, int) = nullptr);


    /**
     * ˌĂi_RX > _RZ > _RYjɌ N*M-Waye𕡐Zbg .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _X, _Y, _Z W <BR>
     * EVbg GgafDxKurokoA ̈ړAړxAx<BR>
     * @param prm_pFrom            ˌ
     * @param prm_pDepo_Shot1      ˂Vbg̃f|WĝP
     * @param prm_paUint32_dotmat1 VbĝPgphbg}gbNX
     * @param prm_pDepo_Shot2      ˂Vbg̃f|WĝQ
     * @param prm_paUint32_dotmat2 VbĝQgphbg}gbNX
     * @param prm_pDepo_Shot3      ˂Vbg̃f|WĝR
     * @param prm_paUint32_dotmat3 VbĝRgphbg}gbNX
     * @param prm_r                ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_way_N            N-WayiRzωj
     * @param prm_way_M            M-WayiRyωj
     * @param prm_angClearance_N   N-WaẙԊupx
     * @param prm_angClearance_M   M-WaẙԊupx
     * @param prm_velo_first       N*M-WayeeZbg̃VbgxBeZbgȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce             N*M-WayeeZbg̃Vbgx
     * @param prm_set_num          ˂ N*M-WayeZbg̍vZbg
     * @param prm_interval_frames  eZbgƒeZbg̏ot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SZbgĔˁBj
     * @param prm_attenuated       eZbgȍ~̊eZbg̃Vbgx̌(< 1.0)A͑(>1.0)
     * @param pFunc_CallBackDispatched
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxDrawableActor* shotWay003(GgafDxCore::GgafDxGeometricActor* prm_pFrom,
                                                       GgafCore::GgafActorDepository* prm_pDepo_Shot1, uint32_t* prm_paUint32_dotmat1,
                                                       GgafCore::GgafActorDepository* prm_pDepo_Shot2, uint32_t* prm_paUint32_dotmat2,
                                                       GgafCore::GgafActorDepository* prm_pDepo_Shot3, uint32_t* prm_paUint32_dotmat3,
                                                       coord prm_r,
                                                       int prm_way_N, int prm_way_M,
                                                       angle prm_angClearance_N, angle prm_angClearance_M,
                                                       velo prm_velo_first, acce prm_acce,
                                                       int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                       void (*pFunc_CallBackDispatched)(GgafDxCore::GgafDxDrawableActor*, int, int, int, int, int) = nullptr);



    /**
     * gU˒e𕡐ZbgɌ .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _X, _Y, _Z W <BR>
     * EVbg GgafDxKurokoA ̈ړAړxAx<BR>
     * @param prm_X               ˌXW
     * @param prm_Y               ˌYW
     * @param prm_Z               ˌZW
     * @param prm_RZ              ˕Rz
     * @param prm_RY              ˕Ry
     * @param prm_pDepo_Shot      ˂Vbg̃f|Wg
     * @param prm_r               ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_radial_way_num  PZbgWay
     * @param prm_expanse_angle   ˒ȅƎˊp(0 ` D180ANGBď̍Lp̂悤ȃC[WBƒe̊Ԋu)
     * @param prm_velo_first      eZbg̃VbgxBeZbgȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce            eZbg̃Vbgx
     * @param prm_set_num         WAYe̍vZbg
     * @param prm_interval_frames eZbgƒeZbg̏ot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SZbgĔˁBj
     * @param prm_attenuated      eZbgȍ~̃Zbg̃Vbgx(< 1.0)A͑(>1.0)
     * @param pFunc_CallBackDispatched f|Wg(prm_pDepo_Shot) dispatch() āA
     *                                 ړAxAxݒ肳ꂽɃR[obN֐ݒB
     *                                 ɂ͎̒lnB
     *                                 void f(GgafDxCore::GgafDxDrawableActor* prm_pActor, int prm_dispatch_num, int prm_set_index, int prm_way_index)
     *                                 prm_pActor         dispatch()ꂽẽAN^[
     *                                 prm_dispatch_num   ڂ dispatch() ̒e  (1`)
     *                                 prm_set_index      WAYeZbgڂł邩 (0`)
     *                                 prm_way_index      WAYڂ̒eł邩         (0`)
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxDrawableActor* shotWay004(coord prm_X, coord prm_Y, coord prm_Z,
                                                       angle prm_RZ, angle prm_RY,
                                                       GgafCore::GgafActorDepository* prm_pDepo_Shot,
                                                       coord prm_r,
                                                       int prm_radial_way_num, angle prm_expanse_angle,
                                                       velo prm_velo_first, acce prm_acce,
                                                       int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                       void (*pFunc_CallBackDispatched)(GgafDxCore::GgafDxDrawableActor*, int, int, int) = nullptr);

    /**
     * ˌĂi_RZ > _RYjɌĊgU˒e𕡐ZbgɌ .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _X, _Y, _Z W <BR>
     * EVbg GgafDxKurokoA ̈ړAړxAx<BR>
     * @param prm_pFrom           ˌ
     * @param prm_pDepo_Shot      ˂Vbg̃f|Wg
     * @param prm_r               ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_radial_way_num  PZbgWay
     * @param prm_expanse_angle   ˒ȅƎ˒Sp(0 ` D180ANGBď̍L̐p̂悤ȃC[WBƒe̊Ԋu)
     * @param prm_velo_first      eZbg̃Vbgx
     * @param prm_acce            eZbg̃Vbgx
     * @param prm_set_num         WAYe̍vZbg
     * @param prm_interval_frames eZbgƒeZbg̏ot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SZbgĔˁBj
     * @param prm_attenuated      eZbgȍ~̃Zbg̃VbgxEx̌(> 1.0)A͑(>1.0)
     * @param pFunc_CallBackDispatched f|Wg(prm_pDepo_Shot) dispatch() āA
     *                                 ړAxAxݒ肳ꂽɃR[obN֐ݒB
     *                                 ɂ͎̒lnB
     *                                 void f(GgafDxCore::GgafDxDrawableActor* prm_pActor, int prm_dispatch_num, int prm_set_index, int prm_way_index)
     *                                 prm_pActor         dispatch()ꂽẽAN^[
     *                                 prm_dispatch_num   ڂ dispatch() ̒e  (1`)
     *                                 prm_set_index      WAYeZbgڂł邩 (0`)
     *                                 prm_way_index      WAYڂ̒eł邩         (0`)
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxDrawableActor* shotWay004(GgafDxCore::GgafDxGeometricActor* prm_pFrom,
                                                       GgafCore::GgafActorDepository* prm_pDepo_Shot,
                                                       coord prm_r,
                                                       int prm_radial_way_num, angle prm_expanse_angle,
                                                       velo prm_velo_first, acce prm_acce,
                                                       int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                       void (*pFunc_CallBackDispatched)(GgafDxCore::GgafDxDrawableActor*, int, int, int) = nullptr);

    /**
     * pgU˒e𕡐ZbgɌ .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _X, _Y, _Z W <BR>
     * EVbg GgafDxKurokoA ̈ړAړxAx<BR>
     * @param prm_X               ˌXW
     * @param prm_Y               ˌYW
     * @param prm_Z               ˌZW
     * @param prm_RZ              ˕Rz
     * @param prm_RY              ˕Ry
     * @param prm_pDepo_Shot      ˂Vbg̃f|Wg
     * @param prm_r               ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_way_num         PZbgː(1`999)
     * @param prm_first_expanse_angle   ˒ȅƎˊp(0 ` D180ANGBď̍Lp̂悤ȃC[WBƒe̊Ԋu)
     * @param prm_inc_expanse_angle     1eɉZƎˊp(0 ` D180ANG)
     * @param prm_velo_first      eZbg̃VbgxBeZbgȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce            eZbg̃Vbgx
     * @param prm_set_num         WAYe̍vZbg
     * @param prm_interval_frames eZbgƒeZbg̏ot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SZbgĔˁBj
     * @param prm_attenuated      eZbgȍ~̃Zbg̃Vbgx(< 1.0)A͑(>1.0)
     * @param pFunc_CallBackDispatched
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxDrawableActor* shotWayGoldenAng(coord prm_X, coord prm_Y, coord prm_Z,
                                                             angle prm_RZ, angle prm_RY,
                                                             GgafCore::GgafActorDepository* prm_pDepo_Shot,
                                                             coord prm_r,
                                                             int prm_way_num,
                                                             angle prm_first_expanse_angle, angle prm_inc_expanse_angle,
                                                             velo prm_velo_first, acce prm_acce,
                                                             int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                             void (*pFunc_CallBackDispatched)(GgafDxCore::GgafDxDrawableActor*, int, int, int) = nullptr);

    /**
     * ˌĂi_RZ > _RYjɌĉpgU˒e𕡐ZbgɌ .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _X, _Y, _Z W <BR>
     * EVbg GgafDxKurokoA ̈ړAړxAx<BR>
     * @param prm_pFrom           ˌ
     * @param prm_pDepo_Shot      ˂Vbg̃f|Wg
     * @param prm_r               ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_way_num         PZbgː(1`999)
     * @param prm_first_expanse_angle   ˒ȅƎˊp(0 ` D180ANGBď̍Lp̂悤ȃC[WBƒe̊Ԋu)
     * @param prm_inc_expanse_angle     1eɉZƎˊp(0 ` D180ANG)
     * @param prm_velo_first      eZbg̃VbgxBeZbgȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce            eZbg̃Vbgx
     * @param prm_set_num         WAYe̍vZbg
     * @param prm_interval_frames eZbgƒeZbg̏ot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SZbgĔˁBj
     * @param prm_attenuated      eZbgȍ~̃Zbg̃Vbgx(< 1.0)A͑(>1.0)
     * @param pFunc_CallBackDispatched
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDxCore::GgafDxDrawableActor* shotWayGoldenAng(GgafDxCore::GgafDxGeometricActor* prm_pFrom,
                                                             GgafCore::GgafActorDepository* prm_pDepo_Shot,
                                                             coord prm_r,
                                                             int prm_way_num,
                                                             angle prm_first_expanse_angle, angle prm_inc_expanse_angle,
                                                             velo prm_velo_first, acce prm_acce,
                                                             int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                             void (*pFunc_CallBackDispatched)(GgafDxCore::GgafDxDrawableActor*, int, int, int) = nullptr);


};

}
#endif /*GGAFLIB_STGUTIL_H_*/
