#ifndef GGAFLIB_COLIAAB_H_
#define GGAFLIB_COLIAAB_H_
#include "jp/ggaf/dxcore/util/GgafDxCollisionPart.h"

namespace GgafLib {

/**
 * AAB(śFAxis-Aligned Box)蔻vfNX
 * @version 1.00
 * @since 2008/03/13
 * @author Masatoshi Tsuge
 */
class ColliAAB : public GgafDxCore::GgafDxCollisionPart {
public:
    /** AABxW̏ */
    coord _x1;
    /** AAByW̏ */
    coord _y1;
    /** AABzW̏ */
    coord _z1;
    /** AAB̑Ίp̒_ƂȂxW傫 */
    coord _x2;
    /** AAB̑Ίp̒_ƂȂyW傫 */
    coord _y2;
    /** AAB̑Ίp̒_ƂȂzW傫 */
    coord _z2;

public:
    ColliAAB();

    void set(coord x1, coord y1, coord z1, coord x2, coord y2, coord z2, bool rotX, bool rotY, bool rotZ);

    void rotateRxRzRy(angle rX, angle rY, angle rZ) override;

    virtual ~ColliAAB();
};

}
#endif /*GGAFLIB_COLIAAB_H_*/
