#ifndef GGAFLIB_MENUACTOR_H_
#define GGAFLIB_MENUACTOR_H_

#include "jp/ggaf/core/util/GgafLinkedListRing.hpp"
#include "jp/ggaf/dxcore/actor/GgafDxDrawableActor.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"
#include "jp/ggaf/dxcore/util/GgafDxUtil.h"
#include "jp/ggaf/lib/actor/DefaultBoardActor.h"
#include "jp/ggaf/lib/actor/DefaultBoardSetActor.h"
#include "jp/ggaf/lib/actor/DefaultSpriteActor.h"
#include "jp/ggaf/lib/actor/DefaultSpriteSetActor.h"
#include "jp/ggaf/lib/actor/menu/MenuActor.hpp"
#include "jp/ggaf/lib/actor/StringBoardActor.h"
#include "jp/ggaf/lib/actor/StringSpriteActor.h"

using GgafDxCore::GgafDxUtil;


namespace GgafLib {

/**
 * j[ .
 * GUIȈՃj[ȒPɎ邽߂̃ev[głB<BR>
 * <b>y܂킵p̋ʁz</b><BR>
 * ELZij[ACejc uLZv̓삪҂GUIi̎wBiF [Cancel]  [] ̃{^́j<BR>
 * EiU镑j              c [U[ŁAuv̈ӎv\wBiF [ENTER]L[A[]{^j<BR>
 * ELZiU镑j        c [U[ŁAuLZv̈ӎv\wBiF [ESC]L[A[~]{^j<BR>
 * ɁuLZvƌ鎖ɂāA{eł̐ł́A<BR>
 * wuLZij[ACejvŁAuiU镑j vBx<BR>
 * Ƃ߂ǂ\ɂȂĂ܂B<BR>
 * <BR>
 * Ӂ<BR>
 * {NX́uLZij[ACejvuiU镑jvuLZiU镑jvʈA
 * lXȋ@\T|[g܂A[OK]{^́uij[ACejvɂĂ̋@\͍̂Ƃ날܂B<BR>
 * @version 1.00
 * @since 2011/12/20
 * @author Masatoshi Tsuge
 */
template<class T>
class MenuActor : public T {

protected:

    enum MenuItemWay {
        ITEM_RELATION_EX_NEXT = 0,
        ITEM_RELATION_EX_PREV,
        ITEM_RELATION_TO_CANCEL,
    };




    /** tF[hC true */
    bool _with_rising;
    /** tF[hAEg true */
    bool _with_sinking;
    /** tF[hCJnuԂ̃t[ true */
    bool _is_just_risen;
    /** tF[hAEgJnuԂ̃t[ true */
    bool _is_just_sunk;
    /** uiU镑jvuԂ̃t[ true */
    bool _is_just_decided;
    /** uLZiU镑jvuԂ̃t[ true */
    bool _is_just_cancelled;

    bool _will_be_rising_next_frame;

    bool _will_be_sinking_next_frame;

    bool _will_be_just_decided_next_frame;

    bool _will_be_just_cancelled_next_frame;

    bool _can_controll;

    bool _will_be_able_to_controll;


    /** CJ[\̕␳XW */
    coord _X_cursor_adjust;
    /** CJ[\̕␳YW */
    coord _Y_cursor_adjust;
    /** CJ[\̕␳ZW */
    coord _Z_cursor_adjust;
    /** CJ[\ړACȇOt[XW */
    coord _X_cursor_target_prev;
    /** CJ[\ړACȇOt[YW */
    coord _Y_cursor_target_prev;
    /** CJ[\ړACȇOt[ZW */
    coord _Z_cursor_target_prev;
    /** [r]CJ[\Aj[ACeԂړۂɔ₷Xt[ */
    int _cursor_move_frames;
    /** [r]CJ[\ړAACeԈړ̑xO`ōɒB鎞_̊ */
    float _cursor_move_p1;
    /** [r]CJ[\ړAACeԈړ̍ō猸Jn銄 */
    float _cursor_move_p2;
    /** [r]Cj[J[\ */
    GgafDxCore::GgafDxDrawableActor* _pCursorActor;

    /**
     * ⏕J[\ .
     */
    class SupCursor {
    public:
        /** [r]⏕J[\AN^[ */
        GgafDxCore::GgafDxDrawableActor* _pActor;
        /** I𒆃CfbNX  */
        int _select_index;
        /** ⏕J[\̕␳XW */
        coord _X_adjust;
        /** ⏕J[\̕␳YW */
        coord _Y_adjust;
        /** ⏕J[\̕␳ZW */
        coord _Z_adjust;
        /** ⏕J[\ړACȇOt[XW */
        coord _X_target_prev;
        /** ⏕J[\ړACȇOt[YW */
        coord _Y_target_prev;
        /** ⏕J[\ړACȇOt[ZW */
        coord _Z_target_prev;
        /** [r]⏕J[\Aj[ACeԂړۂɔ₷Xt[ */
        int _move_frames;
        /** [r]⏕J[\ړAACeԈړ̑xO`ōɒB鎞_̊ */
        float _move_p1;
        /** [r]⏕J[\ړAACeԈړ̍ō猸Jn銄 */
        float _move_p2;
    public:
        SupCursor() {
            _select_index = 0;
            _move_frames = 10;
            _move_p1 = 0.2;
            _move_p2 = 0.7;
//            _X_cursor_target_prev = T::_X;
//            _Y_cursor_target_prev = T::_Y;
//            _Z_target_prev = T::_Z;

            _X_target_prev = 0;
            _Y_target_prev = 0;
            _Z_target_prev = 0;

            _pActor = nullptr;
            _X_adjust = 0;
            _Y_adjust = 0;
            _Z_adjust = 0;
        }



    };
protected:
    /**
     * CJ[\IACe(_lstItems ̃ANeBuvf)ֈړ .
     * uIvƁuJ[\̈ړv́AʁXōlĉB<BR>
     * {\bh͗\ߑIς݂̃ACeցuJ[\̈ړvłAoʂ̏ɓĂ܂B<BR>
     * uIv̂ŝł͂܂BuIv selectItem() ōs܂B<BR>
     * ܂AselectItem() ŁA moveCursor() ͎s܂B<BR>
     * ]āAmoveCursor() P̂ŌĂяo͖wǑz肵ĂȂ̂ŒӂĉB<BR>
     * J[\ړ̌ʉ炷ꍇ́AI[o[ChčĒ`邱ƂŎĂB<BR>
     * ̏ɏ moveCursor() ĂяôYȂ悤ɁB<BR>
     * @param prm_smooth X[Yړ邩ۂ
     */
    virtual void moveCursor(bool prm_smooth = true);

    /**
     * ⏕J[\IACeֈړ .
     * uIvƁuJ[\̈ړv́AʁXōlĉB<BR>
     * {\bh͗\ߑIς݃ACeցuJ[\̈ړvłAoʂ̏ɓĂ܂B<BR>
     * uIv̂ŝł͂܂BuIv selectItemBySupCursor() ōs܂B<BR>
     * ܂AselectItemBySupCursor() ŁA moveSupCursor() ͎s܂B<BR>
     * ]āAmoveCursor() P̂ŌĂяo͖wǑz肵ĂȂ̂ŒӂĉB<BR>
     * J[\ړ̌ʉ炷ꍇ́AI[o[ChčĒ`邱ƂŎĂB<BR>
     * ̏ɏ moveSupCursor() ĂяôYȂ悤ɁB<BR>
     * @param prm_supcur_no
     * @param prm_smooth
     */
    virtual void moveSupCursor(int prm_supcur_no, bool prm_smooth = true);

public:
    /** [r]j[ACẽXgAANeBu̓CJ[\IĂ */
    GgafCore::GgafLinkedListRing<GgafDxCore::GgafDxDrawableActor> _lstItems;
    /** [r]̑\ACẽXg */
    GgafCore::GgafLinkedListRing<GgafDxCore::GgafDxDrawableActor> _lstDispActors;
    /** [r]CJ[\ړj[ACeCfbNX̃qXg[(0`NAA͑S -1 ) */
    GgafCore::GgafLinkedListRing<int> _lstMvCursorHistory;
    /** [r]Ij[ACeCfbNX̃qXg[(0`NAA͑S -1 ) */
    GgafCore::GgafLinkedListRing<int> _lstMvSelectHistory;
    /** [r]j[tFChCEAEg̃t[ */
    frame _fade_frames;
    /** [r]j[tFChCEAEg̃At@x */
    float _velo_alpha_fade;
    /** [r]Tuj[̃Xg */
    GgafCore::GgafLinkedListRing<MenuActor<T>> _lstSubMenu;
    /** [r]Tuj[̃Xg */
    GgafCore::GgafLinkedListRing<SupCursor> _lstSupCursor;

public:
    /**
     * RXgN^ .
     * yӁz񊈓ԂftHgƂĂ܂B<BR>
     * ̓Iɂ T::inactivateImmed(); R[Ă܂B
     * @param prm_name
     * @param prm_model fʖ
     */
    MenuActor(const char* prm_name, const char* prm_model);

    /**
     * ݓ͂󂯕tĂԂԂ .
     * Tuj[\Ăԓ́AsɂȂA{\bhfalseԂ܂B
     * @return true:Rg[\/false:Rg[s\
     */
    virtual bool canControll() {
        return _can_controll;
    }

    /**
     * ͂󂯕t𖳌 .
     * IɌĂяoA̎gpzB
     */
    virtual void disableControll() {
        _will_be_able_to_controll = false;
    }

    /**
     * ͂󂯕tL .
     */
    virtual void enableControll() {
        _will_be_able_to_controll = true;
    }

    /**
     * j[tFChCEAEg̃At@xݒ .
     * @param prm_menu_fade_frames tF[ht[
     */
    virtual void setFadeFrames(frame prm_menu_fade_frames) {
        _fade_frames = prm_menu_fade_frames;
        if (prm_menu_fade_frames == 0) {
            _velo_alpha_fade = 1.0;
        } else {
            _velo_alpha_fade = 1.0 / prm_menu_fade_frames;
        }
    }

    /**
     * I\j[ACeǉAj[ACeԂ̃I[_[Aǉ .
     * ǉꂽACe̓j[IuWFNg(this)̃Tuɓo^邽߁A
     * j[IuWFNg^XNc[ɓo^Ȃ delete Kv͂ȂB
     * yӁz<BR>
     * ZWȂ΁A addItem() AOɕ\ƂȂB<BR>
     * @param prm_pItem j[ACe
     * @param prm_X_local j[IuWFNg̃[JW(0,0,0)̑ΈʒuXW
     * @param prm_Y_local j[IuWFNg̃[JW(0,0,0)̑ΈʒuYW
     * @param prm_Z_local j[IuWFNg̃[JW(0,0,0)̑ΈʒuZW
     */
    virtual void addItem(GgafDxCore::GgafDxDrawableActor* prm_pItem,
                         coord prm_X_local, coord prm_Y_local, coord prm_Z_local);
    /**
     * I\j[ACeǉAj[ACeԂ̃I[_[Aǉ .
     * ǉꂽACe̓j[IuWFNg(this)̃Tuɓo^邽߁A
     * j[IuWFNg^XNc[ɓo^Ȃ delete Kv͂ȂB<BR>
     * yӁz<BR>
     * ZWȂ΁A addItem() AOɕ\ƂȂB<BR>
     * ZẂAItZbg0ݒ肳B܂ACe̐ZẂÃ݂j[ZWƈvB<BR>
     * j[2DŁAACe̕\vCIeB̍lKvȏꍇ́AItZbg-1ɖݒ\B
     * @param prm_pItem j[ACe
     * @param prm_X_local j[IuWFNg̃[JW(0,0,0)̑ΈʒuXW
     * @param prm_Y_local j[IuWFNg̃[JW(0,0,0)̑ΈʒuYW
     */
    virtual void addItem(GgafDxCore::GgafDxDrawableActor* prm_pItem,
                         coord prm_X_local, coord prm_Y_local) {
        addItem(prm_pItem, prm_X_local, prm_Y_local, 0);
    }

    virtual void addItem(GgafDxCore::GgafDxDrawableActor* prm_pItem) {
        addItem(prm_pItem, 0, 0, 0);
    }

    virtual void positionItem(int prm_index_of_item,
                            coord prm_X_local, coord prm_Y_local, coord prm_Z_local);

    virtual void positionItem(int prm_index_of_item,
                            coord prm_X_local, coord prm_Y_local) {
        positionItem(prm_index_of_item, prm_X_local, prm_Y_local, 0);
    }


    /**
     * Is̕\pj[ACe(x)ǉ .
     * yӁz<BR>
     * ZWȂ΁Ȁ addDisp() AOɕ\ƂȂB<BR>
     * @param prm_pItem \px̃AN^[
     * @param prm_X_local \pIuWFNg̃[JW(0,0,0)̑ΈʒuXW
     * @param prm_Y_local \pIuWFNg̃[JW(0,0,0)̑ΈʒuYW
     * @param prm_Z_local \pIuWFNg̃[JW(0,0,0)̑ΈʒuZW
     */
    virtual void addDisp(GgafDxCore::GgafDxDrawableActor* prm_pDisp,
                         coord prm_X_local, coord prm_Y_local, coord prm_Z_local);

    /**
     * Is̕\pj[xǉ .
     * yӁz<BR>
     * ZWȂ΁Ȁ addDisp() AOɕ\ƂȂB<BR>
     * ZẂAItZbg0ݒ肳B܂\pAN^[̐ZẂÃ݂j[ZWƈvB
     * j[2DŁAACe̕\vCIeB̍lKvȏꍇ́AItZbg-1ɖݒ\B
     * @param prm_pItem \px̃AN^[
     * @param prm_X_local \pIuWFNg̃[JW(0,0,0)̑ΈʒuXW
     * @param prm_Y_local \pIuWFNg̃[JW(0,0,0)̑ΈʒuYW
     */
    virtual void addDisp(GgafDxCore::GgafDxDrawableActor* prm_pDisp,
                         coord prm_X_local, coord prm_Y_local) {
        addDisp(prm_pDisp, prm_X_local, prm_Y_local, 0);
    }


    virtual void addDisp(GgafDxCore::GgafDxDrawableActor* prm_pDisp) {
        addDisp(prm_pDisp, 0, 0, 0);
    }

    virtual void positionDisp(int prm_index_of_disp,
                            coord prm_X_local, coord prm_Y_local, coord prm_Z_local);

    virtual void positionDisp(int prm_index_of_disp,
                            coord prm_X_local, coord prm_Y_local) {
        positionItem(prm_index_of_disp, prm_X_local, prm_Y_local, 0);
    }

    /**
     * CJ[\IuWFNgݒ肷 .
     * yӁz<BR>
     * J[\ړ𐧌䂷邽߁AMenuActor<T>::processBehavior() ŁA<BR>
     * _pCursorActor->_pKurokoA->behave(); <BR>
     * sĂ܂BāÃJ[\NXŁA<BR>
     * _pKurokoA->behave(); <BR>
     * sKv͂܂B<BR>
     * @param prm_pCursorActor CJ[\
     * @param prm_X_cursor_adjust ACeƂ̏dȂ␳邽߂̉Z鍷XW
     * @param prm_Y_cursor_adjust ACeƂ̏dȂ␳邽߂̉Z鍷YW
     * @param prm_Z_cursor_adjust ACeƂ̏dȂ␳邽߂̉Z鍷ZW
     * @param prm_cursor_move_frames CJ[\ACeԈړɔ₷t[(ftHg8t[)
     * @param prm_cursor_move_p1 CJ[\ړAACeԈړ̑xO`ōɒB鎞_̊(ftHg0.2)
     * @param prm_cursor_move_p2 CJ[\ړAACeԈړ̍ō猸Jn銄(ftHg0.7)
     */
    virtual void setMainCursor(GgafDxCore::GgafDxDrawableActor* prm_pCursorActor,
                               coord prm_X_cursor_adjust = 0,
                               coord prm_Y_cursor_adjust = 0,
                               coord prm_Z_cursor_adjust = 0,
                               int prm_cursor_move_frames = 8,
                               float prm_cursor_move_p1 = 0.2,
                               float prm_cursor_move_p2 = 0.7);

    /**
     * ⏕J[\IuWFNgݒ肷 .
     * yӁz<BR>
     * J[\ړ𐧌䂷邽߁AMenuActor<T>::processBehavior() ŁA<BR>
     * _lstSupCursor.getFromFirst(i)->_pActor->_pKurokoA->behave(); <BR>
     * sĂ܂BāÃJ[\NXŁA<BR>
     * _pKurokoA->behave(); <BR>
     * sKv͂܂B<BR>
     * @param prm_pCursorActor ⏕J[\
     * @param prm_X_cursor_adjust ACeƂ̏dȂ␳邽߂̉Z鍷XW
     * @param prm_Y_cursor_adjust ACeƂ̏dȂ␳邽߂̉Z鍷YW
     * @param prm_Z_cursor_adjust ACeƂ̏dȂ␳邽߂̉Z鍷ZW
     * @param prm_cursor_move_frames ⏕J[\ACeԈړɔ₷t[(ftHg8t[)
     * @param prm_cursor_move_p1 ⏕J[\ړAACeԈړ̑xO`ōɒB鎞_̊(ftHg0.2)
     * @param prm_cursor_move_p2 ⏕J[\ړAACeԈړ̍ō猸Jn銄(ftHg0.7)
     */
    virtual void addSupCursor(GgafDxCore::GgafDxDrawableActor* prm_pCursorActor,
                              coord prm_X_cursor_adjust = 0,
                              coord prm_Y_cursor_adjust = 0,
                              coord prm_Z_cursor_adjust = 0,
                              int prm_cursor_move_frames = 8,
                              float prm_cursor_move_p1 = 0.2,
                              float prm_cursor_move_p2 = 0.7);

    /**
     * j[ACeԂ̃I[_[Agݒ(gFrom  To) .
     * addItem(GgafDxCore::GgafDxDrawableActor*) ɂAǉsƂŁAI<BR>
     * AOA̐`I[_[\zĂ邪A<BR>
     * ̃\bh͂Ƃ͕ʂɃACeԂ́uvAuOvÅ֌Wǉݒ肷B<BR>
     * Ⴆ΁AuvL[ŁuvAuvL[Łu߂vƂɂȂĂƂɁA
     * Ɂuvuv̈ړʓrݒ肷Ƃgp@zB<BR>
     * @param prm_index_of_fromitem Ãj[ACẽCfbNX
     * @param prm_index_of_toitem Ãj[ACẽCfbNX
     *                            uvɑΉÃj[ACẽCfbNX
     */
    virtual void relateItemExNext(int prm_index_of_fromitem, int prm_index_of_toitem);

    /**
     * j[ACeԂ̃I[_[Agݒ(item1  item2   item3) .
     * @param prm_index_of_item1 gA郁j[ACẽCfbNX1
     * @param prm_index_of_item2 gA郁j[ACẽCfbNX2
     * @param prm_index_of_item3 gA郁j[ACẽCfbNX3
     */
    virtual void relateItemExNext(int prm_index_of_item1,
                                  int prm_index_of_item2,
                                  int prm_index_of_item3);
    /**
     * j[ACeԂ̃I[_[Agݒ(item1  item2   item3  item4) .
     * @param prm_index_of_item1 gA郁j[ACẽCfbNX1
     * @param prm_index_of_item2 gA郁j[ACẽCfbNX2
     * @param prm_index_of_item3 gA郁j[ACẽCfbNX3
     * @param prm_index_of_item4 gA郁j[ACẽCfbNX4
     */
    virtual void relateItemExNext(int prm_index_of_item1,
                                  int prm_index_of_item2,
                                  int prm_index_of_item3,
                                  int prm_index_of_item4);
    /**
     * j[ACeԂ̃I[_[Agݒ(item1  item2   item3  item4  item5).
     * @param prm_index_of_item1 gA郁j[ACẽCfbNX1
     * @param prm_index_of_item2 gA郁j[ACẽCfbNX2
     * @param prm_index_of_item3 gA郁j[ACẽCfbNX3
     * @param prm_index_of_item4 gA郁j[ACẽCfbNX4
     * @param prm_index_of_item5 gA郁j[ACẽCfbNX5
     */
    virtual void relateItemExNext(int prm_index_of_item1,
                                  int prm_index_of_item2,
                                  int prm_index_of_item3,
                                  int prm_index_of_item4,
                                  int prm_index_of_item5);


//    virtual void relateItemExNext(int prm_index_of_fromitem, ...);

    /**
     * j[ACeԂ̃I[_[Agݒ(From  gTo) .
     * addItem(GgafDxCore::GgafDxDrawableActor*) ɂAǉsƂŁAI<BR>
     * AOA̐`I[_[\zĂ邪A<BR>
     * ̃\bh͂Ƃ͕ʂɃACeԂ́uOvAuvÅ֌Wǉݒ肷B<BR>
     * Ⴆ΁AuvL[ŁuvAuvL[Łu߂vƂɂꍇ
     * uvuv̈ړݒ肷Ƃgp@zB<BR>
     * @param prm_index_of_fromitem Ãj[ACẽCfbNX
     * @param prm_index_of_toitem Ãj[ACẽCfbNX
     *                            uOvɑΉÃj[ACẽCfbNX
     */
    virtual void relateItemExPrev(int prm_index_of_fromitem, int prm_index_of_toitem);

    /**
     * ACeSĂɑ΂AuLZij[ACejvւ̃I[_[Agݒ肷 .
     * @param prm_index_of_cancel_item LZACeւ̃ACeCfbNX
     */
    virtual void relateAllItemCancel(int prm_index_of_cancel_item);

    /**
     * j[ɐݒ肳Ă郁CJ[\擾 .
     * @return CJ[\IuWFNg
     */
    virtual GgafDxCore::GgafDxDrawableActor* getCursor();

    /**
     * j[ɐݒ肳Ă⏕J[\擾 .
     * @param prm_supcur_no ⏕J[\ԍ
     * @return ⏕J[\IuWFNg
     */
    virtual GgafDxCore::GgafDxDrawableActor* getSupCursor(int prm_supcur_no);

    /**
     * CJ[\ŁuṽACeICJ[\ړ .
     */
    virtual void selectNext();

    /**
     * CJ[\ŁuOṽACeICJ[\ړ .
     */
    virtual void selectPrev();

    /**
     * CJ[\Łuiʂ́jṽACeICJ[\ړ .
     */
    virtual void selectExNext();

    /**
     * CJ[\Łuiʂ́jOṽACeICJ[\ړ .
     */
    virtual void selectExPrev();

    /**
     * CJ[\ŁuLZvACeICJ[\ړ .
     */
    virtual void selectCancel();

    /**
     * CJ[\Ŏw̃CfbNX̃j[ACeuIvACJ[\ړ .
     *  moveCursor() R[obNACJ[\ړ邱ƂɂȂB<BR>
     * Ɏw̃CfbNXI𒆂̏ꍇ̓CJ[\͉ړB<BR>
     * łɁACfbNX̃ACeIuWFNgQbgoB<BR>
     * @param prm_index ^[Qbg̃ACeCfbNX
     * @return prm_index̃ACeIuWFNg
     */
    virtual GgafDxCore::GgafDxDrawableActor* selectItem(int prm_index);

    /**
     * ⏕J[\Ŏw̃CfbNX̃j[ACeuIvA⏕J[\ړ .
     *  moveCursor() R[obNACJ[\ړ邱ƂɂȂB<BR>
     * Ɏw̃CfbNXI𒆂̏ꍇ̓CJ[\͉ړB<BR>
     * łɁACfbNX̃ACeIuWFNgQbgoB<BR>
     * @param prm_index ^[Qbg̃ACeCfbNX
     * @param prm_supcur_no ⏕J[\ԍ
     * @return prm_index̃ACeIuWFNg
     */
    virtual GgafDxCore::GgafDxDrawableActor* selectItemBySupCursor(int prm_supcur_no, int prm_item_index);

    /**
     * CJ[\Ŏw̃j[ACeuIvACJ[\ړ .
     *  moveCursor() R[obNAJ[\ړ邱ƂɂȂB<BR>
     * Ɏw̃CfbNXI𒆂̏ꍇ̓J[\͉ړB<BR>
     * łɁAACeIuWFNg̃CfbNXQbgoB<BR>
     * @param prm_item ^[Qbg̃ACe
     * @return ^[Qbg̃ACeCfbNX
     */
    virtual int selectItem(GgafDxCore::GgafDxDrawableActor* prm_item);

    /**
     * ⏕J[\Ŏw̃j[ACeuIvA⏕J[\ړ .
     *  moveSupCursor() R[obNAJ[\ړ邱ƂɂȂB<BR>
     * Ɏw̃CfbNXI𒆂̏ꍇ̓J[\͉ړB<BR>
     * łɁAACeIuWFNg̃CfbNXQbgoB<BR>
     * @param prm_item ^[Qbg̃ACe
     * @param prm_supcur_no ⏕J[\ԍ
     * @return
     */
    virtual int selectItemBySupCursor(int prm_supcur_no, GgafDxCore::GgafDxDrawableActor* prm_item);

    /**
     * ݃CJ[\I𒆂̃ACẽCfbNX擾 .
     * @return I𒆂̃ACẽCfbNX
     */
    virtual int getSelectedIndex();

    /**
     * ݕ⏕J[\I𒆂̃ACẽCfbNX擾 .
     * @param prm_supcur_no ⏕J[\ԍ
     * @return I𒆂̃ACẽCfbNX
     */
    virtual int getSelectedIndexOnSupCursor(int prm_supcur_no);

    /**
     * ݃CJ[\I𒆂̃ACẽIuWFNg擾 .
     * @return I𒆂̃ACeIuWFNg
     */
    virtual GgafDxCore::GgafDxDrawableActor* getSelectedItem();

    /**
     * ݕ⏕J[\I𒆂̃ACẽIuWFNg擾 .
     * @param prm_supcur_no ⏕J[\ԍ
     * @return I𒆂̃ACeIuWFNg
     */
    virtual GgafDxCore::GgafDxDrawableActor* getSelectedItemOnSupCursor(int prm_supcur_no);

    /**
     * ߋɃCJ[\I𒆂ACẽCfbNX擾 .
     * getMvCursorHistoryIndex(0)  getSelectedIndex() ƓłB
     * w̉ߋȂꍇ -1 Ԃ܂B
     * @param prm_n ߋ̃J[\ʒu(0 `)
     * @return I𒆂̃ACeIuWFNg̃CfbNXiꍇ -1j
     */
    virtual int getMvCursorHistoryIndex(int prm_n);

    /**
     * uiU镑jvsꂽɁÃj[ACẽCfbNXԂ܂ .
     * ȊO̎  -1 Ԃ܂<BR>
     * j[̑Iڂ肳ꂽꍇ̏LqR[h̏ꏊɂā<BR>
     * processBehavior()  getOnDecidedIndex() ̖߂l𖈃t[ׂ邱ƂŁA莞̏Lq邱Ƃ\B<BR>
     *  onDecision() ĂяôŁAI[o[ChA swith`case LqĂǂB<BR>
     * ǂłǂAp\B<BR>
     * @return 肳ꂽF̃ACẽCfbNX(>=0)^肳ĂȂꍇF -1
     */
    virtual int getOnDecidedIndex();

    /**
     * uiU镑jvsꂽɁÃj[ACeԂ܂ .
     * ȊO̎  nullptr Ԃ܂<BR>
     * j[̑Iڂ肳ꂽꍇ̏LqR[h̏ꏊɂā<BR>
     * processBehavior()  getOnDecidedItem() ̖߂l𖈃t[ׂ邱ƂŁA莞̏Lq邱Ƃ\B<BR>
     *  onDecision() ĂяôŁAI[o[ChA swith`case LqĂǂB<BR>
     * ǂłǂAp\B<BR>
     * @return 肳ꂽF̃ACe^肳ĂȂꍇF nullptr
     */
    virtual GgafDxCore::GgafDxDrawableActor* getOnDecidedItem();

    /**
     * uLZiU镑jvsꂽɁÃj[ACẽCfbNXԂ܂ .
     * ȊO̎  -1 Ԃ܂<BR>
     * j[̑IڂLZꂽꍇ̏LqR[h̏ꏊɂā<BR>
     * processBehavior()  getOnCancelledIndex() ̖߂l𖈃t[ׂ邱ƂŁALZ̏Lq邱Ƃ\B<BR>
     *  onCancel() ĂяôŁAI[o[ChA swith`case LqĂǂB<BR>
     * ǂłǂAp\B<BR>
     * @return LZꂽF̃ACẽCfbNX(>=0)^LZĂȂꍇF -1
     */
    virtual int getOnCancelledIndex();

    /**
     * uLZiU镑jvsꂽɁÃj[ACeԂ܂ .
     * ȊO̎  -1 Ԃ܂<BR>
     * j[̑IڂLZꂽꍇ̏LqR[h̏ꏊɂā<BR>
     * processBehavior()  getOnCancelledItem() ̖߂l𖈃t[ׂ邱ƂŁALZ̏Lq邱Ƃ\B<BR>
     *  onCancel() ĂяôŁAI[o[ChA swith`case LqĂǂB<BR>
     * ǂłǂAp\B<BR>
     * @return LZꂽF̃ACe^LZĂȂꍇF nullptr
     */
    virtual GgafDxCore::GgafDxDrawableActor* getOnCancelledItem();

    /**
     * IΏۃACẽIuWFNg擾 .
     * @param prm_index 擾IΏۃACẽCfbNX(0`)
     * @return ACeIuWFNg
     */
    virtual GgafDxCore::GgafDxDrawableActor* getItem(int prm_index);

    /**
     * ̑\pACẽIuWFNg擾 .
     * @param prm_index 擾\pACẽCfbNX(0`)
     * @return \pACeIuWFNg
     */
    virtual GgafDxCore::GgafDxDrawableActor* getDisp(int prm_index);

    /**
     * uiU镑jvAƂ̐ .
     * ʃNXŃI[o[ChāAĂB <BR>
     * t[ condDecision()  condCancel() ̏͂ǂ炩A
     * D揇ʂ́AcondDecision() ̕łB<BR>
     * @return uiU镑jv̏ / false:s
     */
    virtual bool condDecision() = 0;

    /**
     * uLZiU镑jvAƂ̐ .
     * ʃNXŃI[o[ChāAĂB<BR>
     * t[ condDecision()  condCancel() ̏͂ǂ炩A
     * D揇ʂ́AcondDecision() ̕łB<BR>
     * @return uLZiU镑jv̏ / false:s
     */
    virtual bool condCancel() = 0;
    /**
     * CJ[\ũj[ACevֈړ .
     * ʃNXŃI[o[ChāAĂB
     * @return true:ũj[ACevֈړ̏ / false:s
     */
    virtual bool condSelectNext() = 0;

    /**
     * CJ[\uÕj[ACevֈړ .
     * ʃNXŃI[o[ChāAĂB
     * @return true:uÕj[ACevֈړ̏ / false:s
     */
    virtual bool condSelectPrev() = 0;

    /**
     * CJ[\u̕ʂ̎̃j[ACevֈړ .
     * ʃNXŃI[o[ChāAĂB
     * @return true:u̕ʂ̎̃j[ACevֈړ̏ / false:s
     */
    virtual bool condSelectExNext() = 0;

    /**
     * CJ[\u̕ʂ̑Õj[ACevֈړ .
     * ʃNXŃI[o[ChāAĂB
     * @return true:u̕ʂ̑Õj[ACevֈړ̏ / false:s
     */
    virtual bool condSelectrExPrev() = 0;

    /**
     * CJ[\uLZ̃j[ACev֔ԏ .
     * ʃNXŃI[o[ChāAĂB
     * @return true:uLZ̃j[ACevֈړ̏ / false:s
     */
    virtual bool condSelectCancel() = 0;

    /**
     * uiU镑jvꂽꍇɌĂяoR[obNB
     * I[o[ChĎĂB<BR>
     * j[̑Iڂ肳ꂽꍇ̏LqR[h̏ꏊɂā<BR>
     * processBehavior() ŁAgetOnDecidedIndex() ̖߂l𖈃t[ׂ邱ƂŁA莞̏Lq邱Ƃ\B<BR>
     *  onDecision() ĂяôŁAI[o[ChA swith`case LqĂǂB<BR>
     * ǂłǂAp\B
     * @param prm_pItem 肳ꂽ̃ACe
     * @param prm_item_index 肳ꂽ̃ACẽCfbNX
     */
    virtual void onDecision(GgafDxCore::GgafDxDrawableActor* prm_pItem, int prm_item_index) = 0;

    /**
     * uLZiU镑jvꂽꍇɌĂяoR[obNB .
     * I[o[ChĎĂB<BR>
     * j[̑IڂLZꂽꍇ̏LqR[h̏ꏊɂā<BR>
     * processBehavior() ŁAgetCancelIndex() ̖߂l𖈃t[ׂ邱ƂŁALZ̏Lq邱Ƃ\B<BR>
     *  onCancel() ĂяôŁAI[o[ChA swith`case LqĂǂB<BR>
     * ǂłǂAp\B
     * @param prm_pItem
     * @param prm_item_index
     */
    virtual void onCancel(GgafDxCore::GgafDxDrawableActor* prm_pItem, int prm_item_index) = 0;

    /**
     * CJ[\ړꍇɌĂяoR[obNB .
     * I[o[ChĎĂB<BR>
     * yߑz<BR>
     * onMoveCursor(int,int)  onSelect(int,int) ̃R[obN^C~O̍ɂāB<BR>
     * onSelect(int,int) ́AselectXxxxx n ̃\bhsɁAȂĂяo܂B<BR>
     * onMoveCursor(int,int) ́AselectXxxxx ñ\bhs̍ہAJ[\ړꍇ̂݌Ăяo܂B<BR>
     * Ăяo鏇́AonMoveCursor(int,int)   onSelect(int,int) ̏łB<BR>
     * @param prm_from ړ̃ACẽCfbNXiíjꍇ -1j
     * @param prm_to   ړ̃ACẽCfbNX
     */
    virtual void onMoveCursor(int prm_from, int prm_to) = 0;

    /**
     * CJ[\ACeIꂽꍇɌĂяoR[obNB .
     * I[o[ChĎĂB<BR>
     * yߑz<BR>
     * onMoveCursor(int,int)  onSelect(int,int) ̃R[obN^C~O̍ɂāB<BR>
     * onSelect(int,int) ́AselectXxxxx ñ\bhsɁAȂĂяo܂B<BR>
     * onMoveCursor(int,int) ́AselectXxxxx ñ\bhs̍ہAJ[\ړꍇ̂݌Ăяo܂B<BR>
     * Ăяo鏇́AonMoveCursor(int,int)   onSelect(int,int) ̏łB<BR>
     * @param prm_from IiIOj̃ACẽCfbNXiíjꍇ -1j
     * @param prm_to   ĨACẽCfbNX
     */
    virtual void onSelect(int prm_from, int prm_to) = 0;


    /**
     * j[\Jn .
     * {IuWFNg𐶐A^XNɒǉA\^C~OŎsĂB<BR>
     */
    virtual void riseMe();

    /**
     * j[\JñR[obN .
     * riseMe() sAP񂾂R[obN܂B<BR>
     * KvɉăI[o[ChĂB<BR>
     */
    virtual void onRise();

    /**
     * j[\gWV .
     * riseMe() s ` tF[hC܂ł̊ԃR[ꑱ܂B
     * At@ZtF[hCʂsAAt@1.0ɂȂΏIB
     * ƂgWVς݂łB<BR>
     * gWVƎɍsꍇ̓I[o[ChAgWV<BR>
     * _with_rising = false;<BR>
     * sĂB<BR>
     */
    virtual void processRising();

    /**
     * ԃtOXVǉ̂߃I[o[Ch .
     *  T::nextFrame(); R[Ă܂B
     */
    virtual void nextFrame() override;

    /**
     * j[̐U镑 .
     * J[\̈ړyсAACeƃJ[\j[̍̕WɒǏ]
     * ς݂łB<BR>
     * j[̐U镑ǉꍇ́AI[o[ChāA
     * ɏ processBehavior() ĂяôYȂ悤ɁB<BR>
     */
    virtual void processBehavior() override;

    /**
     * j[ďI .
     */
    virtual void sinkMe();

    /**
     * riseMe()sꂽォۂԂ .
     * @return true:x riseMe() sꂽł/false:ł͂Ȃ
     */
    virtual bool isJustRisen() {
        return _is_just_risen;
    }

    /**
     * sinkMe() sꂽォۂԂ .
     * @return true:x sinkMe() sꂽł/false:ł͂Ȃ
     */
    virtual bool isJustSunk() {
        return _is_just_sunk;
    }

    /**
     * uiU镑jvsꂽォۂԂ .
     * @return rue:x uiU镑jv sꂽł/false:ł͂Ȃ
     */
    virtual bool isJustDecided() {
        if (_is_just_decided && _can_controll) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * uLZiU镑jvsꂽォۂԂ .
     * @return rue:x uLZiU镑jv sꂽł/false:ł͂Ȃ
     */
    virtual bool isJustCancelled() {
        if (_is_just_cancelled && _can_controll) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * j[JñR[obN .
     * sinkMe() sAP񂾂R[obN܂B<BR>
     * KvɉăI[o[ChĂB<BR>
     */
    virtual void onSink();

    /**
     * j[̃gWV .
     * sinkMe() s ` tF[hAEg܂ł̊ԃR[ꑱ܂B
     * At@ZtF[hAEgʂsAAt@1.0ɂȂΏI
     * ƂgWVς݂łB<BR>
     * gWVƎɍsꍇ̓I[o[ChAgWV<BR>
     * _with_sinking = false;<BR>
     * T::inactivateTreeImmed();<BR>
     * sĂB<BR>
     */
    virtual void processSinking();

    /**
     * Tuj[ǉB
     * @param prm_pSubMenu Tuj[
     */
    virtual void addSubMenu(MenuActor<T>* prm_pSubMenu);

    /**
     * ej[Ԃ .
     * @return ej[
     */
    virtual MenuActor<T>* getParentMenu();

    /**
     * Tuj[擾 .
     * O addSubMenu() ŃTuj[ݒ肷Kv܂B<BR>
     * @param prm_index Tuj[̃CfbNX
     * @return
     */
    virtual MenuActor<T>* getSubMenu(int prm_index);

    /**
     * ݃ANeBuȃTuj[擾 .
     * Tuj[o^̏ꍇB͓o^ĂĂAANeBuł͂Ȃꍇ nullptr ԂB
     * @return ANeBuȃTuj[/nullptr
     */
    virtual MenuActor<T>* getRisingSubMenu();

    /**
     * Tuj[ANeBuɂĕ\ .
     * O addSubMenu() ŃTuj[ݒ肷Kv܂B<BR>
     * ܂A{\bhɂ茻݃ANeBuȃTuj[(getRisingSubMenu())́A
     * CfbNX̃j[ɕύX܂B
     * Tuj[\ƁATuj[(sinkCurrentSubMenu()) ܂ŁA
     * Ăяoj[͑s\ɂȂ܂B
     * @param prm_index ANeBuɂTuj[̃CfbNX
     */
    virtual void riseSubMenu(int prm_index);

    /**
     * ݃ANeBuȃTuj[ďI .
     * O addSubMenu() ŃTuj[ݒ肷Kv܂B<BR>
     */
    virtual void sinkCurrentSubMenu();

    virtual ~MenuActor();
};


template<class T>
MenuActor<T>::MenuActor(const char* prm_name, const char* prm_model) :
  T(prm_name, prm_model, nullptr),_lstItems(3) { //SACe}RǉFȗvȗOvuLZv̂R
    T::_class_name = "MenuActor";

    _fade_frames = 0;
    _velo_alpha_fade = 1.0;

    _with_rising = false;
    _with_sinking = false;
    _is_just_risen = false;
    _is_just_sunk = false;
    _is_just_decided = false;
    _is_just_cancelled = false;
    _will_be_rising_next_frame = false;
    _will_be_sinking_next_frame = false;
    _will_be_just_decided_next_frame = false;
    _will_be_just_cancelled_next_frame = false;
    _can_controll = false;
    _will_be_able_to_controll = false;

    _cursor_move_frames = 10;
    _cursor_move_p1 = 0.2;
    _cursor_move_p2 = 0.7;
    _X_cursor_target_prev = T::_X;
    _Y_cursor_target_prev = T::_Y;
    _Z_cursor_target_prev = T::_Z;
    _pCursorActor = nullptr;
    _X_cursor_adjust = 0;
    _Y_cursor_adjust = 0;
    _Z_cursor_adjust = 0;

    for (int i = 0; i < 10; i++) {
        _lstMvCursorHistory.addLast(new int(-1), true);
        _lstMvSelectHistory.addLast(new int(-1), true);
    }
    T::inactivateImmed(); //j[Ȃ̂ŁAԂ͔񊈓ԂftHgƂ
}

template<class T>
void MenuActor<T>::nextFrame() {
    T::nextFrame();
    _is_just_risen = false;
    if (_will_be_rising_next_frame) {
        _with_rising = true;
        _is_just_risen = true;
        _will_be_rising_next_frame = false;
        onRise();
    }

    _is_just_sunk = false;
    if (_will_be_sinking_next_frame) {
        _with_sinking = true;
        _is_just_sunk = true;
        _will_be_sinking_next_frame = false;
        onSink();
    }

    if (_will_be_just_decided_next_frame && _can_controll) {
        _is_just_decided = true;
        _will_be_just_decided_next_frame = false;
        onDecision(_lstItems.getCurrent(), _lstItems.getCurrentIndex());
    } else {
        _is_just_decided = false;
        _will_be_just_decided_next_frame = false;
    }

    if (_will_be_just_cancelled_next_frame && _can_controll) {
        _is_just_cancelled = true;
        _will_be_just_cancelled_next_frame = false;
        onCancel(_lstItems.getCurrent(), _lstItems.getCurrentIndex());
    } else {
        _is_just_cancelled = false;
        _will_be_just_cancelled_next_frame = false;
    }

    _can_controll = _will_be_able_to_controll;

}

template<class T>
void MenuActor<T>::addItem(GgafDxCore::GgafDxDrawableActor* prm_pItem,
                           coord prm_X_local, coord prm_Y_local, coord prm_Z_local) {
    prm_pItem->_X_local = prm_X_local;
    prm_pItem->_Y_local = prm_Y_local;
    prm_pItem->_Z_local = prm_Z_local;
    prm_pItem->_alpha = T::_alpha; //LB
    prm_pItem->inactivateImmed();
    _lstItems.addLast(prm_pItem, false);
    T::addSubLast(prm_pItem);
}

template<class T>
void MenuActor<T>::positionItem(int prm_index_of_item,
                              coord prm_X_local, coord prm_Y_local, coord prm_Z_local) {
    GgafDxCore::GgafDxDrawableActor* p = getItem(prm_index_of_item);
    p->_X_local = prm_X_local;
    p->_Y_local = prm_Y_local;
    p->_Z_local = prm_Z_local;
}

template<class T>
void MenuActor<T>::addDisp(GgafDxCore::GgafDxDrawableActor* prm_pDisp,
                           coord prm_X_local, coord prm_Y_local, coord prm_Z_local) {
    prm_pDisp->_X_local = prm_X_local;
    prm_pDisp->_Y_local = prm_Y_local;
    prm_pDisp->_Z_local = prm_Z_local;
    prm_pDisp->_alpha = T::_alpha; //LB
    prm_pDisp->inactivateImmed();
    _lstDispActors.addLast(prm_pDisp, false);
    T::addSubLast(prm_pDisp);
}

template<class T>
void MenuActor<T>::positionDisp(int prm_index_of_item,
                              coord prm_X_local, coord prm_Y_local, coord prm_Z_local) {
    GgafDxCore::GgafDxDrawableActor* p = getItem(prm_index_of_item);
    p->_X_local = prm_X_local;
    p->_Y_local = prm_Y_local;
    p->_Z_local = prm_Z_local;
}

template<class T>
void MenuActor<T>::relateItemExNext(int prm_index_of_fromitem, int prm_index_of_toitem) {
    _lstItems.getElemFromFirst(prm_index_of_fromitem)->connect(
            ITEM_RELATION_EX_NEXT, _lstItems.getElemFromFirst(prm_index_of_toitem));
    _lstItems.getElemFromFirst(prm_index_of_toitem)->connect(
            ITEM_RELATION_EX_PREV, _lstItems.getElemFromFirst(prm_index_of_fromitem));
}

template<class T>
void MenuActor<T>::relateItemExNext(int prm_index_of_item1,
                                    int prm_index_of_item2,
                                    int prm_index_of_item3 ) {
    relateItemExNext(prm_index_of_item1, prm_index_of_item2);
    relateItemExNext(prm_index_of_item2, prm_index_of_item3);
}

template<class T>
void MenuActor<T>::relateItemExNext(int prm_index_of_item1,
                                    int prm_index_of_item2,
                                    int prm_index_of_item3,
                                    int prm_index_of_item4 ) {
    relateItemExNext(prm_index_of_item1, prm_index_of_item2, prm_index_of_item3);
    relateItemExNext(prm_index_of_item3, prm_index_of_item4);
}

template<class T>
void MenuActor<T>::relateItemExNext(int prm_index_of_item1,
                                    int prm_index_of_item2,
                                    int prm_index_of_item3,
                                    int prm_index_of_item4,
                                    int prm_index_of_item5 ) {
    relateItemExNext(prm_index_of_item1, prm_index_of_item2, prm_index_of_item3, prm_index_of_item4);
    relateItemExNext(prm_index_of_item4, prm_index_of_item5);
}


//template<class T>
//void MenuActor<T>::relateItemExNext(int prm_index_of_fromitem, ...) {
//    va_list pArg;
//    va_start(pArg, prm_index_of_fromitem);         //ϒJn
//        va_arg( argptr, int );
//
//
//
//    va_end(pArg);      //ϒI
//}


template<class T>
void MenuActor<T>::relateItemExPrev(int prm_index_of_fromitem, int prm_index_of_toitem) {
    _lstItems.getElemFromFirst(prm_index_of_fromitem)->connect(
            ITEM_RELATION_EX_PREV, _lstItems.getElemFromFirst(prm_index_of_toitem));
    _lstItems.getElemFromFirst(prm_index_of_toitem)->connect(
            ITEM_RELATION_EX_NEXT, _lstItems.getElemFromFirst(prm_index_of_fromitem));
}

template<class T>
void MenuActor<T>::relateAllItemCancel(int prm_index_of_cancel_item) {
    GgafCore::GgafLinkedListRing<GgafDxCore::GgafDxDrawableActor>::Elem* pCancelElem =
            _lstItems.getElemFromFirst(prm_index_of_cancel_item);
    GgafCore::GgafLinkedListRing<GgafDxCore::GgafDxDrawableActor>::Elem* pElem =
            _lstItems.getElemFirst();
    for (int i = 0; i < _lstItems.length(); i++) {
        pElem->connect(ITEM_RELATION_TO_CANCEL, pCancelElem);
        pElem = pElem->_pNext;
    }
}


template<class T>
GgafDxCore::GgafDxDrawableActor* MenuActor<T>::selectItem(int prm_index) {
    int n = getSelectedIndex();
#ifdef MY_DEBUG
    if (n == -1) {
        throwGgafCriticalException("MenuActor<T>::selectItem() j[ACeo^ł name="<<T::getName()<<" _lstItems.length()="<<_lstItems.length()<<" prm_index="<<prm_index);
    }
#endif
    if (n == prm_index) {
        //ɑIĂB
        *(_lstMvSelectHistory.next()) = _lstItems.getCurrentIndex();
        onSelect(*(_lstMvSelectHistory.getPrev()), *(_lstMvSelectHistory.getCurrent())); //R[obN
        return _lstItems.getCurrent();
    } else {
#ifdef MY_DEBUG
        if (_lstItems.length() <= prm_index) {
            throwGgafCriticalException("MenuActor<T>::selectItem() j[ACevfI[o[ name="<<T::getName()<<" _lstItems.length()="<<_lstItems.length()<<" prm_index="<<prm_index);
        }
#endif
        GgafDxCore::GgafDxDrawableActor* pTargetItem = _lstItems.current(prm_index); //ŃZNgI
        if (T::getActiveFrame() > 1) {
            moveCursor(true);  //X[YړL
        } else {
            moveCursor(false); //X[Yړ(ÏׂselectItem)
        }
        *(_lstMvSelectHistory.next()) = _lstItems.getCurrentIndex();
        onSelect(*(_lstMvSelectHistory.getPrev()), *(_lstMvSelectHistory.getCurrent())); //R[obN
        return pTargetItem;
    }
}

template<class T>
GgafDxCore::GgafDxDrawableActor* MenuActor<T>::selectItemBySupCursor(int prm_supcur_no, int prm_item_index) {
    int n = getSelectedIndexOnSupCursor(prm_supcur_no);
#ifdef MY_DEBUG
    if (n == -1) {
        throwGgafCriticalException("MenuActor<T>::selectItemBySupCursor() j[ACeo^ł name="<<T::getName()<<" _lstItems.length()="<<_lstItems.length()<<" prm_item_index="<<prm_item_index);
    }
#endif
    //⏕J[\̓R[obNȂ
    if (n == prm_item_index) {
        //ɑIĂB
        return _lstItems.getFromFirst(n);
    } else {
#ifdef MY_DEBUG
        if (_lstItems.length() <= prm_item_index) {
            throwGgafCriticalException("MenuActor<T>::selectItemBySupCursor() j[ACevfI[o[ name="<<T::getName()<<" _lstItems.length()="<<_lstItems.length()<<" prm_item_index="<<prm_item_index);
        }
#endif
        _lstSupCursor.getFromFirst(prm_supcur_no)->_select_index = prm_item_index; //ŃZNgI
        GgafDxCore::GgafDxDrawableActor* pTargetItem = _lstItems.getFromFirst(prm_item_index);

        if (T::getActiveFrame() > 1) {
            moveSupCursor(prm_supcur_no, true);  //X[YړL
        } else {
            moveSupCursor(prm_supcur_no, false); //X[Yړ(ÏׂselectItem)
        }
        return pTargetItem;
    }
}



template<class T>
int MenuActor<T>::selectItem(GgafDxCore::GgafDxDrawableActor* prm_item) {
    int index = _lstItems.indexOf(prm_item);
    if (index == -1) {
        throwGgafCriticalException("MenuActor<T>::selectItem() ̑OɃj[ACeo^ł name="<<T::getName()<<" _lstItems.length()="<<_lstItems.length()<<" prm_item="<<prm_item->getName());
    }
    selectItem(index);
    return index;
}

template<class T>
int MenuActor<T>::selectItemBySupCursor(int prm_supcur_no, GgafDxCore::GgafDxDrawableActor* prm_item) {
    int index = _lstItems.indexOf(prm_item);
    if (index == -1) {
        throwGgafCriticalException("MenuActor<T>::selectItemBySupCursor() ̑OɃj[ACeo^ł name="<<T::getName()<<" _lstItems.length()="<<_lstItems.length()<<" prm_item="<<prm_item->getName());
    }
    selectItemBySupCursor(index, prm_supcur_no);
    return index;
}

template<class T>
void MenuActor<T>::setMainCursor(GgafDxCore::GgafDxDrawableActor* prm_pCursorActor,
                                 coord prm_X_cursor_adjust,
                                 coord prm_Y_cursor_adjust,
                                 coord prm_Z_cursor_adjust,
                                 int prm_cursor_move_frames,
                                 float prm_cursor_move_p1,
                                 float prm_cursor_move_p2) {
    _pCursorActor = prm_pCursorActor;
    _pCursorActor->_alpha = T::_alpha;
    _pCursorActor->inactivateImmed();
    T::addSubLast(_pCursorActor);
    _X_cursor_adjust = prm_X_cursor_adjust;
    _Y_cursor_adjust = prm_Y_cursor_adjust;
    _Z_cursor_adjust = prm_Z_cursor_adjust;
    _cursor_move_frames = prm_cursor_move_frames;
    _cursor_move_p1 = prm_cursor_move_p1;
    _cursor_move_p2 = prm_cursor_move_p2;
    selectItem(0);
}

template<class T>
void MenuActor<T>::addSupCursor(GgafDxCore::GgafDxDrawableActor* prm_pCursorActor,
                                 coord prm_X_cursor_adjust,
                                 coord prm_Y_cursor_adjust,
                                 coord prm_Z_cursor_adjust,
                                 int prm_cursor_move_frames,
                                 float prm_cursor_move_p1,
                                 float prm_cursor_move_p2) {


    MenuActor<T>::SupCursor* pSupCursor = NEW MenuActor<T>::SupCursor();
    pSupCursor->_pActor = prm_pCursorActor;
    pSupCursor->_pActor->_alpha = T::_alpha;
    pSupCursor->_pActor->inactivateImmed();
    pSupCursor->_select_index = 0;
    pSupCursor->_X_adjust = prm_X_cursor_adjust;
    pSupCursor->_Y_adjust = prm_Y_cursor_adjust;
    pSupCursor->_Z_adjust = prm_Z_cursor_adjust;
    pSupCursor->_move_frames = prm_cursor_move_frames;
    pSupCursor->_move_p1 = prm_cursor_move_p1;
    pSupCursor->_move_p2 = prm_cursor_move_p2;
    _lstSupCursor.addLast(pSupCursor, true);
    T::addSubLast(pSupCursor->_pActor);
    selectItemBySupCursor(0, _lstSupCursor.length()-1);
}


template<class T>
GgafDxCore::GgafDxDrawableActor* MenuActor<T>::getCursor() {
    return _pCursorActor;
}

template<class T>
GgafDxCore::GgafDxDrawableActor* MenuActor<T>::getSupCursor(int prm_supcur_no) {
    return _lstSupCursor.getFromFirst(prm_supcur_no)->_pActor;
}

template<class T>
int MenuActor<T>::getSelectedIndex() {
    return _lstItems.getCurrentIndex();
}

template<class T>
int MenuActor<T>::getSelectedIndexOnSupCursor(int prm_supcur_no) {
    return _lstSupCursor.getFromFirst(prm_supcur_no)->_select_index;
}


template<class T>
GgafDxCore::GgafDxDrawableActor* MenuActor<T>::getSelectedItem() {
    return _lstItems.getCurrent();
}

template<class T>
GgafDxCore::GgafDxDrawableActor* MenuActor<T>::getSelectedItemOnSupCursor(int prm_supcur_no) {
    return _lstItems.getFromFirst(getSelectedIndexOnSupCursor(prm_supcur_no));
}

template<class T>
int MenuActor<T>::getMvCursorHistoryIndex(int prm_n) {
    return (*(_lstMvCursorHistory.getPrev(prm_n)));
}

template<class T>
int MenuActor<T>::getOnDecidedIndex() {
    if (_is_just_decided) {
        return _lstItems.getCurrentIndex();
    } else {
        return -1;
    }
}
template<class T>
GgafDxCore::GgafDxDrawableActor* MenuActor<T>::getOnDecidedItem() {
    if (_is_just_decided) {
        return _lstItems.getCurrent();
    } else {
        return nullptr;
    }
}

template<class T>
int MenuActor<T>::getOnCancelledIndex() {
    if (_is_just_cancelled) {
        return _lstItems.getCurrentIndex();
    } else {
        return -1;
    }
}

template<class T>
GgafDxCore::GgafDxDrawableActor* MenuActor<T>::getOnCancelledItem() {
    if (_is_just_cancelled) {
        return _lstItems.getCurrent();
    } else {
        return nullptr;
    }
}

template<class T>
GgafDxCore::GgafDxDrawableActor* MenuActor<T>::getItem(int prm_index) {
    return _lstItems.getFromFirst(prm_index);
}

template<class T>
GgafDxCore::GgafDxDrawableActor* MenuActor<T>::getDisp(int prm_index) {
    return _lstDispActors.getFromFirst(prm_index);
}


template<class T>
void MenuActor<T>::selectNext() {
    if (_pCursorActor) {
        _pCursorActor->positionAs(_lstItems.getCurrent());
    }
    _lstItems.next();
    moveCursor();
    *(_lstMvSelectHistory.next()) = _lstItems.getCurrentIndex();
    onSelect(*(_lstMvSelectHistory.getPrev()), *(_lstMvSelectHistory.getCurrent())); //R[obN
}

template<class T>
void MenuActor<T>::selectPrev() {
    if (_pCursorActor) {
        _pCursorActor->positionAs(_lstItems.getCurrent());
    }
    _lstItems.prev();
    moveCursor();
    *(_lstMvSelectHistory.next()) = _lstItems.getCurrentIndex();
    onSelect(*(_lstMvSelectHistory.getPrev()), *(_lstMvSelectHistory.getCurrent())); //R[obN
}


template<class T>
void MenuActor<T>::selectExNext() {
    if (_lstItems.getRelation(ITEM_RELATION_EX_NEXT)) {
        if (_pCursorActor) {
            _pCursorActor->positionAs(_lstItems.getCurrent());
        }
        _lstItems.gotoRelation(ITEM_RELATION_EX_NEXT);
        moveCursor();
    } else {

    }
    *(_lstMvSelectHistory.next()) = _lstItems.getCurrentIndex();
    onSelect(*(_lstMvSelectHistory.getPrev()), *(_lstMvSelectHistory.getCurrent())); //R[obN
}

template<class T>
void MenuActor<T>::selectExPrev() {
    if (_lstItems.getRelation(ITEM_RELATION_EX_PREV)) {
        if (_pCursorActor) {
            _pCursorActor->positionAs(_lstItems.getCurrent());
        }
        _lstItems.gotoRelation(ITEM_RELATION_EX_PREV);
        moveCursor();
    } else {

    }
    *(_lstMvSelectHistory.next()) = _lstItems.getCurrentIndex();
    onSelect(*(_lstMvSelectHistory.getPrev()), *(_lstMvSelectHistory.getCurrent())); //R[obN
}

template<class T>
void MenuActor<T>::selectCancel() {
    if (_lstItems.getRelation(ITEM_RELATION_TO_CANCEL)) {
        if (_pCursorActor) {
            _pCursorActor->positionAs(_lstItems.getCurrent());
        }
        _lstItems.gotoRelation(ITEM_RELATION_TO_CANCEL);
        moveCursor();
    } else {

    }
    *(_lstMvSelectHistory.next()) = _lstItems.getCurrentIndex();
    onSelect(*(_lstMvSelectHistory.getPrev()), *(_lstMvSelectHistory.getCurrent())); //R[obN
}

template<class T>
void MenuActor<T>::moveCursor(bool prm_smooth) {
    if (_pCursorActor) {
        GgafDxCore::GgafDxDrawableActor* pTargetItem = _lstItems.getCurrent();
        if (prm_smooth) {
            _pCursorActor->_pKurokoA->setMvAngTwd(
                                    pTargetItem->_X + _X_cursor_adjust,
                                    pTargetItem->_Y + _Y_cursor_adjust,
                                    pTargetItem->_Z + _Z_cursor_adjust
                                );
            _pCursorActor->_pKurokoA->stopMv();
            _pCursorActor->_pKurokoA->slideMvByDT(
                                     0,
                                     UTIL::getDistance(
                                             _pCursorActor->_X,
                                             _pCursorActor->_Y,
                                             _pCursorActor->_Z,
                                             pTargetItem->_X + _X_cursor_adjust,
                                             pTargetItem->_Y + _Y_cursor_adjust,
                                             pTargetItem->_Z + _Z_cursor_adjust),
                                     _cursor_move_frames,
                                     _cursor_move_p1, _cursor_move_p2
                                 );
            _X_cursor_target_prev = pTargetItem->_X;
            _Y_cursor_target_prev = pTargetItem->_Y;
            _Z_cursor_target_prev = pTargetItem->_Z;
        } else {
            _pCursorActor->_pKurokoA->stopSlidingMv();
            _pCursorActor->_pKurokoA->stopMv();
            _pCursorActor->_X = pTargetItem->_X + _X_cursor_adjust;
            _pCursorActor->_Y = pTargetItem->_Y + _Y_cursor_adjust;
            _pCursorActor->_Z = pTargetItem->_Z + _Z_cursor_adjust;
        }
        *(_lstMvCursorHistory.next()) = _lstItems.getCurrentIndex();
        onMoveCursor(*(_lstMvCursorHistory.getPrev()), *(_lstMvCursorHistory.getCurrent())); //R[obN
    }
}


template<class T>
void MenuActor<T>::moveSupCursor(int prm_supcur_no, bool prm_smooth) {
    if (_lstSupCursor.length() > 0) {
        GgafDxCore::GgafDxDrawableActor* pTargetItem = getSelectedItemOnSupCursor(prm_supcur_no);
        SupCursor* pSupCursor = _lstSupCursor.getFromFirst(prm_supcur_no);
        GgafDxCore::GgafDxDrawableActor* pSupCursorActor = pSupCursor->_pActor;
        if (prm_smooth) {
            pSupCursorActor->_pKurokoA->setMvAngTwd(
                                    pTargetItem->_X + pSupCursor->_X_adjust,
                                    pTargetItem->_Y + pSupCursor->_Y_adjust,
                                    pTargetItem->_Z + pSupCursor->_Z_adjust
                                );
            pSupCursorActor->_pKurokoA->stopMv();
            pSupCursorActor->_pKurokoA->slideMvByDT(
                                     0,
                                     UTIL::getDistance(
                                             pSupCursorActor->_X,
                                             pSupCursorActor->_Y,
                                             pSupCursorActor->_Z,
                                             pTargetItem->_X + pSupCursor->_X_adjust,
                                             pTargetItem->_Y + pSupCursor->_Y_adjust,
                                             pTargetItem->_Z + pSupCursor->_Z_adjust),
                                             pSupCursor->_move_frames,
                                             pSupCursor->_move_p1, pSupCursor->_move_p2
                                 );
            pSupCursor->_X_target_prev = pTargetItem->_X;
            pSupCursor->_Y_target_prev = pTargetItem->_Y;
            pSupCursor->_Z_target_prev = pTargetItem->_Z;
        } else {
            pSupCursorActor->_pKurokoA->stopSlidingMv();
            pSupCursorActor->_pKurokoA->stopMv();
            pSupCursorActor->_X = pTargetItem->_X + pSupCursor->_X_adjust;
            pSupCursorActor->_Y = pTargetItem->_Y + pSupCursor->_Y_adjust;
            pSupCursorActor->_Z = pTargetItem->_Z + pSupCursor->_Z_adjust;
        }
    }
}

template<class T>
void MenuActor<T>::riseMe() {
    _with_rising = false;
    _with_sinking = false;
    _is_just_risen = false;
    _is_just_sunk = false;
    _will_be_rising_next_frame = true;
    _will_be_sinking_next_frame = false;
    enableControll();
    if (_velo_alpha_fade >= 1.0) {
        T::setAlpha(1.0);
    } else {
        T::setAlpha(0.0);
    }
    T::activate();
    //j[ACezu
    GgafDxCore::GgafDxDrawableActor* p;
    GgafCore::GgafLinkedListRing<GgafDxCore::GgafDxDrawableActor>::Elem* pElem = _lstItems.getElemFirst();
    for (int i = 0; i < _lstItems.length(); i++) {
        p = pElem->_pValue;
        p->position(T::_X + p->_X_local,
                  T::_Y + p->_Y_local,
                  T::_Z + p->_Z_local);
        p->setAlpha(T::getAlpha());
        p->activate();
        pElem = pElem->_pNext;
    }
    //\ACezu
    pElem = _lstDispActors.getElemFirst();
    for (int i = 0; i < _lstDispActors.length(); i++) {
        p = pElem->_pValue;
        p->position(T::_X + p->_X_local,
                  T::_Y + p->_Y_local,
                  T::_Z + p->_Z_local);
        p->setAlpha(T::getAlpha());
        p->activate();
        pElem = pElem->_pNext;
    }

    if (_pCursorActor) {
        _pCursorActor->activate();
    }
    for (int i = 0; i < _lstSupCursor.length(); i++) {
        _lstSupCursor.getFromFirst(i)->_pActor->activate();
    }
}

template<class T>
void MenuActor<T>::onRise() {
}

template<class T>
void MenuActor<T>::processRising() {
    T::addAlpha(_velo_alpha_fade);
    if (T::getAlpha() >= 1.0) {
        T::setAlpha(1.0);
        _with_rising = false;
    }
}

template<class T>
void MenuActor<T>::processBehavior() {
    if (_with_sinking) {
        processSinking();
    }
    if (_with_rising) {
        processRising();
    }
    if (_can_controll && T::getActiveFrame() > 2) {
        if (condDecision()) {
            _will_be_just_decided_next_frame = true;
        } else if (condCancel()) {
            _will_be_just_cancelled_next_frame = true;
        } else if (condSelectNext()) {
            selectNext();
        } else if (condSelectPrev()) {
            selectPrev();
        } else if (condSelectExNext()) {
            selectExNext();
        } else if (condSelectrExPrev()) {
            selectExPrev();
        } else if (condSelectCancel()) {
            selectCancel();
        }
    }

    if (_pCursorActor) {
        _pCursorActor->_pKurokoA->behave();
        //CJ[\ŁA_pKurokoA->behave() Ȃ悤ɒ
    }
    for (int i = 0; i < _lstSupCursor.length(); i++) {
        _lstSupCursor.getFromFirst(i)->_pActor->_pKurokoA->behave();
        //⏕J[\ŁA_pKurokoA->behave() Ȃ悤ɒ
    }

    //j[ACej[ɒǏ]
    GgafDxCore::GgafDxDrawableActor* p;
    GgafCore::GgafLinkedListRing<GgafDxCore::GgafDxDrawableActor>::Elem* pElem = _lstItems.getElemFirst();
    for (int i = 0; i < _lstItems.length(); i++) {
        p = pElem->_pValue;
        p->position(T::_X + p->_X_local,
                  T::_Y + p->_Y_local,
                  T::_Z + p->_Z_local);
        if (_with_sinking || _with_rising) {
            p->setAlpha(T::getAlpha());
        }
        pElem = pElem->_pNext;
    }
    //\ACej[ɒǏ]
    pElem = _lstDispActors.getElemFirst();
    for (int i = 0; i < _lstDispActors.length(); i++) {
        p = pElem->_pValue;
        p->position(T::_X + p->_X_local,
                  T::_Y + p->_Y_local,
                  T::_Z + p->_Z_local);
        if (_with_sinking || _with_rising) {
            p->setAlpha(T::getAlpha());
        }
        pElem = pElem->_pNext;
    }

    //CJ[\j[ACeɒǏ]
    if (_pCursorActor) {
        GgafDxCore::GgafDxDrawableActor* pTargetItem = _lstItems.getCurrent();
        if (_pCursorActor->_pKurokoA->isSlidingMv()) {
            _pCursorActor->_X += (pTargetItem->_X - _X_cursor_target_prev);
            _pCursorActor->_Y += (pTargetItem->_Y - _Y_cursor_target_prev);
            _pCursorActor->_Z += (pTargetItem->_Z - _Z_cursor_target_prev);
            _X_cursor_target_prev = pTargetItem->_X;
            _Y_cursor_target_prev = pTargetItem->_Y;
            _Z_cursor_target_prev = pTargetItem->_Z;
        } else {
            _pCursorActor->position(pTargetItem->_X + _X_cursor_adjust,
                                  pTargetItem->_Y + _Y_cursor_adjust,
                                  pTargetItem->_Z + _Z_cursor_adjust );
        }
        _pCursorActor->setAlpha(T::getAlpha());
    }
    //⏕J[\j[ACeɒǏ]
    for (int i = 0; i < _lstSupCursor.length(); i++) {
        SupCursor* pSupCursor = _lstSupCursor.getFromFirst(i);
        GgafDxCore::GgafDxDrawableActor* pTargetItem = _lstItems.getFromFirst(pSupCursor->_select_index);
        GgafDxCore::GgafDxDrawableActor* pSupCursorActor = pSupCursor->_pActor;
        if (pSupCursorActor->_pKurokoA->isSlidingMv()) {
            pSupCursorActor->_X += (pTargetItem->_X - pSupCursor->_X_target_prev);
            pSupCursorActor->_Y += (pTargetItem->_Y - pSupCursor->_Y_target_prev);
            pSupCursorActor->_Z += (pTargetItem->_Z - pSupCursor->_Z_target_prev);
            pSupCursor->_X_target_prev = pTargetItem->_X;
            pSupCursor->_Y_target_prev = pTargetItem->_Y;
            pSupCursor->_Z_target_prev = pTargetItem->_Z;
        } else {
            pSupCursorActor->position(pTargetItem->_X + pSupCursor->_X_adjust,
                                   pTargetItem->_Y + pSupCursor->_Y_adjust,
                                   pTargetItem->_Z + pSupCursor->_Z_adjust );
        }
        pSupCursorActor->setAlpha(T::getAlpha());

    }

    //Tuj[riseMe() sinkMe() 
    for (int i = 0; i < _lstSubMenu.length(); i++) {
        MenuActor<T>* pSubMenu = _lstSubMenu.getFromFirst(i);
        if (pSubMenu->isJustRisen()) {
            disableControll(); //Tuj[オ̂ŁAg͑s
            _can_controll = false; //
        }
        if (pSubMenu->isJustSunk()) {
            if (_with_sinking || _is_just_sunk || _will_be_sinking_next_frame) {
                disableControll(); //gɕĂꍇ
                _can_controll = false; //
            } else {
                enableControll(); //Tuj[̂ŁAg̑앜A
            }
        }
    }
}

template<class T>
void MenuActor<T>::sinkMe() {
    _with_rising = false;
    _with_sinking = false;
    _is_just_risen = false;
    _is_just_sunk = false;
    _will_be_rising_next_frame = false;
    _will_be_sinking_next_frame = true;
    disableControll();
    _can_controll = false; //
    if (_velo_alpha_fade >= 1.0) {
        T::setAlpha(0.0);
        T::inactivateTree();
    }
}

template<class T>
void MenuActor<T>::onSink() {
}

template<class T>
void MenuActor<T>::processSinking() {
    T::addAlpha(-_velo_alpha_fade);
    if (T::getAlpha() <= 0.0) {
        T::setAlpha(0.0);
        _with_sinking = false;
        T::inactivateTree();
    }
}

template<class T>
void MenuActor<T>::addSubMenu(MenuActor<T>* prm_pSubMenu) {
    _lstSubMenu.addLast(prm_pSubMenu, false);
    T::addSubLast(prm_pSubMenu); //Tuɒǉ
}

template<class T>
MenuActor<T>* MenuActor<T>::getParentMenu() {
    GgafCore::GgafActor* pActor = T::getParent(); //Tuɒǉ
#ifdef MY_DEBUG
    MenuActor<T>* pMenuActor = dynamic_cast<MenuActor<T>*>(pActor);
    if (pMenuActor == nullptr) {
        throwGgafCriticalException(" MenuActor<T>::getParentMenu em[h͓j[ł͂܂łBname="<<T::getName()<<" this="<<this);
    }
#endif
    return (MenuActor<T>*)pActor;
}

template<class T>
MenuActor<T>* MenuActor<T>::getSubMenu(int prm_index) {
#ifdef MY_DEBUG
    if (_lstSubMenu.length() < prm_index+1) {
        throwGgafCriticalException("MenuActor<T>::getSubMenu() Tuj[ACevfI[o[ name="<<T::getName()<<" _lstSubMenu.length()="<<_lstSubMenu.length()<<" prm_index="<<prm_index);
    }
#endif
    return _lstSubMenu.getFromFirst(prm_index);
}

template<class T>
MenuActor<T>* MenuActor<T>::getRisingSubMenu() {
    MenuActor<T>* pSub = _lstSubMenu.getCurrent();
    if (pSub) {
        if (pSub->isActiveInTheTree()) {
            return pSub;
        }
    }
    return nullptr;
}


template<class T>
void MenuActor<T>::riseSubMenu(int prm_index) {
#ifdef MY_DEBUG
    if (_lstSubMenu.length() < prm_index+1) {
        throwGgafCriticalException("MenuActor<T>::riseSubMenu() Tuj[ACevfI[o[ name="<<T::getName()<<" _lstSubMenu.length()="<<_lstSubMenu.length()<<" prm_index="<<prm_index);
    }
#endif
    _lstSubMenu.current(prm_index)->riseMe();
}

template<class T>
void MenuActor<T>::sinkCurrentSubMenu() {
    _lstSubMenu.getCurrent()->sinkMe();
}

template<class T>
MenuActor<T>::~MenuActor() {
}

/** j[̂̕ GgafLib::DefaultBoardActor Ƃ郁j[ */
typedef GgafLib::MenuActor<GgafLib::DefaultBoardActor> DefaultBoardMenu;
/** j[̂̕ GgafLib::DefaultBoardSetActor Ƃ郁j[ */
typedef GgafLib::MenuActor<GgafLib::DefaultBoardSetActor> DefaultBoardSetMenu;
/** j[̂̕ GgafLib::DefaultSpriteActor Ƃ郁j[ */
typedef GgafLib::MenuActor<GgafLib::DefaultSpriteActor> DefaultSpriteMenu;
/** j[̂̕ GgafLib::DefaultSpriteSetActor Ƃ郁j[ */
typedef GgafLib::MenuActor<GgafLib::DefaultSpriteSetActor> DefaultSpriteSetMenu;
/** j[̂̕ GgafLib::StringBoardActor Ƃ郁j[ */
typedef GgafLib::MenuActor<GgafLib::StringBoardActor> StringBoardMenu;
/** j[̂̕ GgafLib::StringSpriteActor Ƃ郁j[ */
typedef GgafLib::MenuActor<GgafLib::StringSpriteActor> StringSpriteMenu;

}
#endif /*GGAFLIB_MENUACTOR_H_*/
