#ifndef GGAFLIB_STRAIGHTLASERCHIP_H_
#define GGAFLIB_STRAIGHTLASERCHIP_H_
#include "jp/ggaf/lib/actor/laserchip/LaserChip.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"

namespace GgafLib {

/**
 * Xg[g[U[p|C̃`bv .
 * Xg[g[U[Ȃǂƕ\Ă邪Amɂ<BR>
 * EˍWCӁAˌWړƁAɂƂȂĕsړiƂ\j<BR>
 * E˕CӁAˌ̊pxωƁAɂƂȂĔˌ𒆐Sɉ]ړiƂ\j<BR>
 * Eړ@͊{Œi<BR>
 * EAS`bvˌIuWFNgWƌ̍ZBƂB<BR>
 * ƌׂAOfBEXC_[\ȃ[U[ƌׂAȊB<BR>
 * o[ _veloMv ňړ܂Bdispatch() AWƕy _veloMv ݒ肵ĉB<BR>
 * ˌƘAēꍇ setSource() ݒ肵ĉB̏ꍇAWƕ͎ݒ肳܂B
 * @version 1.00
 * @since 2009/08/25
 * @author Masatoshi Tsuge
 */
class StraightLaserChip : public LaserChip {
    friend class LaserChipDepository;

public:
    /** [U[̈ʒu𓯊邽߂́AXWϐꏊ */
    int* _pSource_X;
    /** [U[̈ʒu𓯊邽߂́AYWϐꏊ */
    int* _pSource_Y;
    /** [U[̈ʒu𓯊邽߂́AZWϐꏊ */
    int* _pSource_Z;
    /** [U[̌̂𓯊邽߂́AX]AOlϐꏊ */
    angle* _pSource_RX;
    /** [U[̌̂𓯊邽߂́AY]AOlϐꏊ */
    angle* _pSource_RY;
    /** [U[̌̂𓯊邽߂́AZ]AOlϐꏊ */
    angle* _pSource_RZ;
    /** [U[̈ړ𓯊邽߂́APʕxNgXϐꏊ */
    float* _pSource_vX;
    /** [U[̈ړ𓯊邽߂́APʕxNgYϐꏊ */
    float* _pSource_vY;
    /** [U[̈ړ𓯊邽߂́APʕxNgZϐꏊ */
    float* _pSource_vZ;
    /** [r/w]ړx */
    velo _veloMv;

    GgafDxGeometricActor* _pSourceActor;

public:
    StraightLaserChip(const char* prm_name, const char* prm_model, GgafCore::GgafStatus* prm_pStat=nullptr);

    virtual void onCreateModel() override {}

    virtual void initialize() override {}

    /**
     * [U[`bvWvZ .
     * Ǝݒ肵ꍇApĕʃNX쐬AI[o[ChĂB
     * ̍ ́A{NX processBehavior() \bhĂяoĂB
     */
    virtual void processBehavior() override;

    virtual void processJudgement() override {}

    virtual void processSettlementBehavior() override;

    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) override {}

    /**
     * ˌ̈ړƉ]ɂāAƂ锭˃AN^[ݒ .
     * @param prm_pGeoActor ˌAN^[
     */
    void setSource(GgafDxCore::GgafDxGeometricActor* prm_pGeoActor) {
        _pSource_X = &prm_pGeoActor->_X;
        _pSource_Y = &prm_pGeoActor->_Y;
        _pSource_Z = &prm_pGeoActor->_Z;
        _pSource_RX = &prm_pGeoActor->_RX;
        _pSource_RY = &prm_pGeoActor->_RY;
        _pSource_RZ = &prm_pGeoActor->_RZ;
        _pSource_vX = &prm_pGeoActor->_pKurokoA->_vX;
        _pSource_vY = &prm_pGeoActor->_pKurokoA->_vY;
        _pSource_vZ = &prm_pGeoActor->_pKurokoA->_vZ;
        _pSourceActor = prm_pGeoActor;
    }

    /**
     * ˌ̈ړ݂̂ɂāAƂ锭˃AN^[ݒ .
     * ǂĂĂɔˁB
     * @param prm_pGeoActor ˌAN^[
     */
    void setPositionSource(GgafDxCore::GgafDxGeometricActor* prm_pGeoActor) {
        _pSource_X = &prm_pGeoActor->_X;
        _pSource_Y = &prm_pGeoActor->_Y;
        _pSource_Z = &prm_pGeoActor->_Z;
        _pSource_RX = &_RX;
        _pSource_RY = &_RY;
        _pSource_RZ = &_RZ;
        _pSource_vX = &_pKurokoA->_vX;
        _pSource_vY = &_pKurokoA->_vY;
        _pSource_vZ = &_pKurokoA->_vZ;
        _pSourceActor = prm_pGeoActor;
    }

    /**
     * ˌ̉]݂̂ɂāAƂ锭˃AN^[ݒ .
     * {˂ȂǂɎgp邩ȁEEEB
     * @param prm_pGeoActor ˌAN^[
     */
    void setAngleSource(GgafDxCore::GgafDxGeometricActor* prm_pGeoActor) {
        _pSource_X = &_X;
        _pSource_Y = &_Y;
        _pSource_Z = &_Z;
        _pSource_RX = &prm_pGeoActor->_RX;
        _pSource_RY = &prm_pGeoActor->_RY;
        _pSource_RZ = &prm_pGeoActor->_RZ;
        _pSource_vX = &prm_pGeoActor->_pKurokoA->_vX;
        _pSource_vY = &prm_pGeoActor->_pKurokoA->_vY;
        _pSource_vZ = &prm_pGeoActor->_pKurokoA->_vZ;
        _pSourceActor = prm_pGeoActor;
    }

    virtual ~StraightLaserChip();
};

}
#endif /*GGAFLIB_STRAIGHTLASERCHIP_H_*/

