#ifndef GRAPHBARACTOR_H_
#define GRAPHBARACTOR_H_
#include "jp/ggaf/lib/actor/DefaultBoardActor.h"
#include "jp/ggaf/lib/util/PxQuantity.h"

namespace GgafLib {

/**
 * ʃo[iP`j .
 * @version 1.00
 * @since 2012/09/17
 * @author Masatoshi Tsuge
 */
class GraphBarActor : public DefaultBoardActor {

public:
    /** sNZ */
    const float _chip_width;
    const float _rate_org_chip_width;

    /** e */
    PxQuantity* _pPxQuantity;
    int _min_val;
    int _max_val;
    bool _is_new_PxQuantity;
public:
    /**
     *
     * @param prm_name
     * @param prm_pPxQuantity configς݂ PxQuantityIuWFNg̎Q
     */
    GraphBarActor(const char* prm_name, const char* prm_model, PxQuantity* prm_pPxQuantity);

    GraphBarActor(const char* prm_name, const char* prm_model);

    /**
     * ̃o[̒lێ PxQuantity u .
     * @param prm_pPxQuantity
     */
    void linkQty(PxQuantity* prm_pPxQuantity);

    /**
     * o[̒lɑ΂sNZlݒ .
     * @param prm_max_val o[̒l̍ől
     * @param prm_max_val_px    o[̒l̍őlɑ΂ʂ̃sNZl
     */

    /**
     * o[̒lɑ΂sNZ̖ڐtB
     * @param prm_min_val o[ŏlݒiȉ̒l̓ZbgłȂȂj
     * @param prm_max_val o[őlݒiȏ̒l̓ZbgłȂȂj
     * @param prm_px_from_min_to_max ŏl`ől̉ʏ̃sNZݒ
     */
    inline void graduate(int prm_min_val, int prm_max_val, pixcoord prm_px_from_min_to_max ) {
        _min_val = prm_min_val;
        _max_val = prm_max_val;
        _pPxQuantity->graduate(prm_max_val - prm_min_val, prm_px_from_min_to_max);
    }

    /**
     * o[̒lݒ .
     * @param prm_val [^[l
     */
    inline void setQty(int prm_val) {
        if (_max_val < prm_val) {
            _pPxQuantity->set(_max_val);
        } else if (_min_val > prm_val) {
            _pPxQuantity->set(_min_val);
        } else {
            _pPxQuantity->set(prm_val);
        }
    }

    /**
     * o[̒l擾 .
     * @return o[̒l
     */
    inline int getQty() {
        return _pPxQuantity->get();
    }

    /**
     * o[̌ݒlɑΉsNZl擾
     * @return sNZl
     */
    inline pixcoord getBarPx() {
        return _pPxQuantity->getPx();
    }

    /**
     * o[̒lZ .
     * @param prm_val o[̉Zl
     */
    inline void incQty(int prm_val) {
        setQty(_pPxQuantity->get() + prm_val);
    }

    /**
     * o[̒lZ .
     * @param prm_val o[̌Zl
     */
    inline void decQty(int prm_val) {
        setQty(_pPxQuantity->get() - prm_val);
    }

    void processDraw() override;

    virtual ~GraphBarActor();
};

}
#endif /*GRAPHBARACTOR_H_*/

