#include "stdafx.h"
#include "jp/ggaf/dxcore/sound/GgafDxSeTransmitter.h"

#include "jp/ggaf/dxcore/manager/GgafDxSeManager.h"
#include "jp/ggaf/dxcore/manager/GgafDxSeConnection.h"
#include "jp/ggaf/dxcore/sound/GgafDxSound.h"
#include "jp/ggaf/dxcore/sound/GgafDxSe.h"
#include <stdio.h>

using namespace GgafCore;
using namespace GgafDxCore;


GgafDxSeTransmitter::GgafDxSeTransmitter() : GgafObject() {
    _se_num = 0;
    _papSeConnection = nullptr;
}

void GgafDxSeTransmitter::declareSeNum(int prm_se_num) {
    _se_num = prm_se_num;
    _papSeConnection = NEW GgafDxSeConnection*[_se_num];
    for (int i = 0; i < _se_num; i++) {
        _papSeConnection[i] = nullptr;
    }
}

void GgafDxSeTransmitter::set(int prm_id, const char* prm_se_key, int prm_cannel) {

//    if (_se_num <= 0) {
//        throwGgafCriticalException("GgafDxSeTransmitter::set() useSeŎgpSeOɐ錾ĂBprm_id="<<prm_id);
//    }
    if (_papSeConnection == nullptr) {
        declareSeNum(prm_id+1); //declareSeNumȂꍇprm_id+1܂
    }
    if (prm_id < 0) {
        throwGgafCriticalException("GgafDxSeTransmitter::set() ID͈͊OłB̐ł肢܂B prm_id="<<prm_id);
    } else if (prm_id >= _se_num) {
        //_papSeConnection[] gB
        GgafDxSeConnection** papSeConnection = NEW GgafDxSeConnection*[_se_num];
        for (int i = 0; i < _se_num; i++) { //ޔ
            papSeConnection[i] = _papSeConnection[i];
        }
        GGAF_DELETEARR_NULLABLE(_papSeConnection);
        int wk_se_num = _se_num;
        declareSeNum(prm_id+1); //prm_id+1 ֌gB̎_ _se_num  prm_id+1 ōXV
        for (int i = 0; i < wk_se_num; i++) { //piޔ߂j
            _papSeConnection[i] = papSeConnection[i];
        }
        GGAF_DELETEARR_NULLABLE(papSeConnection);
    }
    if (strlen(prm_se_key) > 128) {
        throwGgafCriticalException("GgafDxSeTransmitter::play() SEID߂܂B128ɗ}ĉBprm_se_key="<<prm_se_key);
    }
    char idstr[140];
    sprintf(idstr, "%d/%s", prm_cannel, prm_se_key); //RlNV̎ID u`lԍ + "/" + waveʖv
                                                      //Ƃ邱ƂɂA`lԍȂ new ȂB
    if (_papSeConnection[prm_id]) {
        _TRACE_("GgafDxSeTransmitter::set() x ID="<<prm_id<<" ɂSE("<<(_papSeConnection[prm_id]->getIdStr())<<")ݒς݂łBڑ close AVSE("<<idstr<<")㏑܂BӐ}Ă܂H");
        _papSeConnection[prm_id]->close();
    }
    _papSeConnection[prm_id] = connect_SeManager(idstr);
}


void GgafDxSeTransmitter::play(int prm_id) {
#ifdef MY_DEBUG
    if (prm_id < 0 || prm_id >= _se_num) {
        throwGgafCriticalException("GgafDxSeTransmitter::play() ID͈͊OłB0~"<<(_se_num-1)<<"ł肢܂Bprm_id="<<prm_id);
    }
#endif
    _papSeConnection[prm_id]->peek()->play();
}

void GgafDxSeTransmitter::stop(int prm_id) {
#ifdef MY_DEBUG
    if (prm_id < 0 || prm_id >= _se_num) {
        throwGgafCriticalException("GgafDxSeTransmitter::stop() ID͈͊OłB0~"<<(_se_num-1)<<"ł肢܂Bprm_id="<<prm_id);
    }
#endif
    _papSeConnection[prm_id]->peek()->stop();
}

void GgafDxSeTransmitter::setLooping(int prm_id, bool prm_can_looping) {
#ifdef MY_DEBUG
    if (prm_id < 0 || prm_id >= _se_num) {
        throwGgafCriticalException("GgafDxSeTransmitter::setLooping() ID͈͊OłB0~"<<(_se_num-1)<<"ł肢܂Bprm_id="<<prm_id);
    }
#endif
    _papSeConnection[prm_id]->peek()->setLooping(prm_can_looping);
}

GgafDxSe* GgafDxSeTransmitter::get(int prm_id) {
#ifdef MY_DEBUG
    if (prm_id < 0 || prm_id >= _se_num) {
        throwGgafCriticalException("GgafDxSeTransmitter::play() ID͈͊OłB0~"<<(_se_num-1)<<"ł肢܂Bprm_id="<<prm_id);
    }
#endif
    return _papSeConnection[prm_id]->peek();
}


GgafDxSeTransmitter::~GgafDxSeTransmitter() {
    for (int i = 0; i < _se_num; i++) {
        if (_papSeConnection[i]) {
            _papSeConnection[i]->close();
        }
    }
    GGAF_DELETEARR_NULLABLE(_papSeConnection);
}

