#include "stdafx.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"

#include "jp/ggaf/dxcore/util/GgafDxUtil.h"
#include "jp/ggaf/dxcore/actor/GgafDxDrawableActor.h"

using namespace GgafCore;
using namespace GgafDxCore;

GgafDxKurokoA::GgafDxKurokoA(GgafDxGeometricActor* prm_pActor) : GgafObject(),
_pActor(prm_pActor) {

    for (int i = 0; i < 3; i++) { // i=0:XA1:YA2:Z \
        //ʕp
        _angFace[i] = 0; //0 angle  R̕pĂ
        //ʕp̊pxiʕp̑j= 0 angle/fream
        _angveloFace[i] = 0; //1t[ɉZ鐳ʕp̊pBftHg͐ʕp̊pA܂UB
        //ʕp̊px  360,000 angle/fream
        _angveloTopFace[i] = D360ANG; //_angveloFace[n] ̑̏BftHg1t[ōDȐʕpɐUo鎖Ӗ
        //ʕp̊px  -360,000 angle/fream
        _angveloBottomFace[i] = D360ANG * -1; //_angveloFace[n] ̑̉BftHg1t[ōDȐʕpɐUo鎖Ӗ
        //ʕp̊pxipx̑j  0 angle/fream^2
        _angacceFace[i] = 0; //_angveloFace[n] ̑BftHg͐ʕp̊px

        _angjerkFace[i] = 0;
        //ڕWʕpւ̎tO = 
        _face_ang_targeting_flg[i] = false;
        //ڕWʕpւ̎~tO = 
        _face_ang_targeting_stop_flg[i] = false;
        //ڕW̐ʕp
        _angTargetFace[i] = 0; //ڕWʕpւ̎tO = Ȁꍇ͖Ӗ
        //ڕW̐ʕp~@\LɂȂ]
        _face_ang_target_allow_way[i] = TURN_BOTH;
        //ڕW̐ʕp~@\LɂȂpxi]ʁj
        _face_ang_target_allow_velo[i] = D180ANG;
    }

    //////////////////////////////////////////////////////
    //L̈ړpPʃxNg
    _vX = 1.0f;
    _vY = _vZ = 0.0f;
    //ړpZ]
    _angRzMv = 0;
    //ړpY]
    _angRyMv = 0;
    //ړx
    _veloMv = 0;
    //ړx = 256 px/fream
    _veloTopMv = INT_MAX; //_veloMv  256000(=256px) ړʂłĂAIɍW 256px ɗ}B
    //ړx = 0   px/fream
    _veloBottomMv = INT_MIN; //_veloMv  -256000(-256px) ړʂĂAIɍW -256000px ɗ}B
    //ړxiړx̑j = 0 px/fream^2
    _accMv = 0; //_veloMv ̑BftHg͉

    //_jerkMv = 0;
    //ړpiZ]j̊px = 0 angle/fream
    _angveloRzMv = 0; //1t[ɉZړp̊pBftHg͈ړp̊pA܂蒼ړB
    //ړpiZ]j̊px = +360,000 angle/fream
    _angveloRzTopMv = D360ANG; //_angveloRzMv ̑̏BftHg1t[ōDȈړɕύXo鎖Ӗ
    //ړpiZ]j̊px = -360,000 angle/fream
    _angveloRzBottomMv = D360ANG * -1; //_angveloRzMv ̑̉BftHg1t[ōDȈړɕύXo鎖Ӗ
    //ړpiZ]j̊px = 0 angle/fream^2
    _angacceRzMv = 0; //_angveloRzMv ̑BftHg͈ړp̊px

    _angjerkRzMv = 0;
    //ڕWړpiZ]jւ̎tO = 
    _mv_ang_rz_target_flg = false;
    //ڕWړpiZ]jւ̎~tO = 
    _mv_ang_rz_target_stop_flg = false;

    //ڕẄړpiZ]j
    _angTargetRzMv = 0;
    //ڕẄړpiZ]j~@\LɂȂ]
    _mv_ang_rz_target_allow_way = TURN_BOTH;
    //ڕẄړpiZ]j~@\LɂȂړppx(px)
    _mv_ang_rz_target_allow_velo = D180ANG;
    //ړpiZ]jɔZʕp̓@\tO  
    _relate_RzFaceAng_with_RzMvAng_flg = false; //L̏ꍇ́Aړpݒ肷ZʕpɂȂB

    //ړpiY]j̊px = 0 angle/fream
    _angveloRyMv = 0; //1t[ɉZړp̊pBftHg͈ړp̊pA܂蒼ړB
    //ړpiY]j̊px = +360,000 angle/fream
    _angveloRyTopMv = D360ANG; //_angveloRyMv ̑̏BftHg1t[ōDȈړɕύXo鎖Ӗ
    //ړpiY]j̊px = -360,000 angle/fream
    _angveloRyBottomMv = D360ANG * -1; //_angveloRyMv ̑̉BftHg1t[ōDȈړɕύXo鎖Ӗ
    //ړpiY]j̊px = 0 angle/fream^2
    _angacceRyMv = 0; //_angveloRyMv ̑BftHg͈ړp̊px

    _angjerkRyMv = 0;
    //ڕWړpiY]jւ̎tO = 
    _mv_ang_ry_target_flg = false;
    //ڕWړpiY]jւ̎~tO = 
    _mv_ang_ry_target_stop_flg = false;
    //ڕẄړpiY]j
    _angTargetRyMv = 0;
    //ڕẄړpiY]j~@\LɂȂ]
    _mv_ang_ry_target_allow_way = TURN_BOTH;
    //ڕẄړpiY]j~@\LɂȂړppx(px)
    _mv_ang_ry_target_allow_velo = D180ANG;
    //ړpiY]jɔZʕp̓@\tO  
    _relate_RyFaceAng_with_RyMvAng_flg = false; //L̏ꍇ́Aړpݒ肷ZʕpɂȂB

    _slide_mv_flg = false;
    _slide_mv_endacc_flg = true;
    _slide_mv_top_velo = 0;
    _slide_mv_end_velo = 0;
    _slide_mv_target_distance = 0;
    _slide_mv_mv_distance = 0;
    _slide_mv_target_frames = 0;
    _slide_mv_frame_of_spent = 0;
    _slide_mv_p1 = 0;
    _slide_mv_p2 = 0;
    _slide_mv_progress = -1;


    _taget_face_ang_alltime_flg = false;
    _taget_face_ang_alltime_pActor = nullptr;
    _taget_face_ang_alltime_tX = 0;
    _taget_face_ang_alltime_tY = 0;
    _taget_face_ang_alltime_tZ = 0;
    _taget_face_ang_alltime_angVelo = 0;
    _taget_face_ang_alltime_angAcce = 0;
    _taget_face_ang_alltime_way = TURN_CLOSE_TO;
    _taget_face_ang_alltime_optimize_ang = true;

}

void GgafDxKurokoA::behave() {

    //ʕp
    for (int i = 0; i < 3; i++) {
        if (_face_ang_targeting_flg[i]) { //^[Qbgꍇ
            _angveloFace[i] += _angacceFace[i];
            if (_angveloFace[i] > _angveloTopFace[i]) {
                _angveloFace[i] = _angveloTopFace[i];
            } else if (_angveloFace[i] < _angveloBottomFace[i]) {
                _angveloFace[i] = _angveloBottomFace[i];
            }

            if (_angveloFace[i] > 0) { //v̏ꍇ
                angle angDistance = getFaceAngDistance((axis)i, _angTargetFace[i], TURN_COUNTERCLOCKWISE);
                if (_angveloFace[i] > angDistance && _face_ang_target_allow_way[i] != TURN_CLOCKWISE
                        && _face_ang_target_allow_velo[i] >= _angveloFace[i]) {
                    addFaceAng((axis)i, angDistance);
                    if (_face_ang_targeting_stop_flg[i]) {
                        _face_ang_targeting_flg[i] = false; //tO߂ďI
                        _face_ang_targeting_stop_flg[i] = false;
                    }
                } else {
                    addFaceAng((axis)i, _angveloFace[i]);
                }
            } else if (_angveloFace[i] < 0) { //v̏ꍇ
                angle angDistance = getFaceAngDistance((axis)i, _angTargetFace[i], TURN_CLOCKWISE);
                if (_angveloFace[i] < angDistance && _face_ang_target_allow_way[i] != TURN_COUNTERCLOCKWISE
                        && -1 * _face_ang_target_allow_velo[i] <= _angveloFace[i]) { //ڕWs߂Ă܂EEEȓ
                    addFaceAng((axis)i, angDistance);
                    if (_face_ang_targeting_stop_flg[i]) { //~ėLȂ
                        _face_ang_targeting_flg[i] = false; //tO߂ďI
                    }
                } else {
                    addFaceAng((axis)i, _angveloFace[i]);
                }
            } else {
                //_angveloFace[i] == 0
                addFaceAng((axis)i, 0);
            }

            if (_face_ang_targeting_flg[i] == false) {
                //ڕWɓB̏
                //_angveloTopFace[i] = D360ANG; //ʕp̊px  360,000 angle/fream
                //_angveloBottomFace[i] = D360ANG * -1; //ʕp̊px  -360,000 angle/fream

                //ڕWɓBA~sȂ
                _angacceFace[i] = 0; //]pApxO
                setFaceAngVelo((axis)i, 0); //]pApxO
            }

        } else {
            //if (_angacceFace[i] != 0) {
            //t[̐ʕp̏
            _angveloFace[i] += _angacceFace[i];
            if (_angveloFace[i] != 0) {
                addFaceAng((axis)i, _angveloFace[i]);
            }
            //}
        }
    }

    //Actorɔf
    _pActor->_RX = _angFace[AXIS_X];
    _pActor->_RY = _angFace[AXIS_Y];
    _pActor->_RZ = _angFace[AXIS_Z];

    ///////////////////////////////////////////////////Mover

    //_accMv += _jerkMv;
    //ړx̏
    _veloMv += _accMv;
    if (_veloMv > _veloTopMv) {
        _veloMv = _veloTopMv;
    } else if (_veloMv < _veloBottomMv) {
        _veloMv = _veloBottomMv;
    }
    //Ȃ߂炩ړV[NGXN
    if (_slide_mv_flg) {
        if (_slide_mv_target_frames < 0) {
            //ڕWw̏ꍇ
            if (_slide_mv_progress == 0) {
                //ݒ
                setMvAcceByD(_slide_mv_p1, _slide_mv_top_velo);
                _slide_mv_progress++;
            } else if (_slide_mv_progress == 1) {
                //
                if (_slide_mv_mv_distance >= _slide_mv_p1) {
                    //p1 ɓB 
                    setMvAcce(0);
                    setMvVelo(_slide_mv_top_velo);
                    _slide_mv_progress++;
                }
            } else if (_slide_mv_progress == 2) {
                //
                if (_slide_mv_mv_distance >= _slide_mv_p2) {
                    //p2 ɓB t[猸
                    setMvAcceByD(_slide_mv_target_distance - _slide_mv_mv_distance, _slide_mv_end_velo);
                    _slide_mv_progress++;
                }
            } else if (_slide_mv_progress == 3) {
                //
                if (_pActor->getBehaveingFrame() % 8U == 0) {
                    //␳E␳E␳
                    setMvAcceByD(_slide_mv_target_distance - _slide_mv_mv_distance, _slide_mv_end_velo);
                }

                if (_slide_mv_mv_distance >= _slide_mv_target_distance) {
                    //ڕW֓B
                    setMvVelo(_slide_mv_end_velo);
                    if (_slide_mv_endacc_flg) {
                        setMvAcce(0);
                    }
                    _slide_mv_progress++;
                    _slide_mv_flg = false; //܂
                }
            }
        } else {
            //ڕWԎw̏ꍇ
            if (_slide_mv_progress == 0) {
                //ݒ
                setMvAcceByT(_slide_mv_p1, _slide_mv_top_velo);
                _slide_mv_progress++;
            } else if (_slide_mv_progress == 1) {
                //
                if (_slide_mv_frame_of_spent >= _slide_mv_p1) {
                    //p1 ɓB 
                    setMvAcce(0);
                    setMvVelo(_slide_mv_top_velo);
                    _slide_mv_progress++;
                }
            } else if (_slide_mv_progress == 2) {
                //
                if (_slide_mv_frame_of_spent >= _slide_mv_p2) {
                    //p2 ɓB t[猸
                    setMvAcceByT(_slide_mv_target_frames - _slide_mv_frame_of_spent, _slide_mv_end_velo);
                    _slide_mv_progress++;
                }
            } else if (_slide_mv_progress == 3) {
                //
                if (_pActor->getBehaveingFrame() % 8U == 0) {
                    //␳E␳E␳
                    setMvAcceByT(_slide_mv_target_frames - _slide_mv_frame_of_spent, _slide_mv_end_velo);
                }

                if (_slide_mv_frame_of_spent >= _slide_mv_target_frames) {
                    //ڕW֓B
                    setMvVelo(_slide_mv_end_velo);
                    if (_slide_mv_endacc_flg) {
                        setMvAcce(0);
                    }
                    _slide_mv_progress++;
                    _slide_mv_flg = false; //܂
                }
            }
        }
    } else {
        _slide_mv_progress = -1;
    }

    if (_slide_mv_flg) {
        if (_slide_mv_target_frames < 0) {
            _slide_mv_mv_distance+=ABS(_veloMv);
        } else {
            _slide_mv_frame_of_spent++;
        }
    } else {

    }

    ///////////
    //ڕWړpiZ]jAO~@\gp̏ꍇ
    if (_mv_ang_rz_target_flg) {

        _angveloRzMv += _angacceRzMv;
        setRzMvAngVelo(_angveloRzMv);

        if (_angveloRzMv > 0) { //v̏ꍇ
            angle angDistance = getRzMvAngDistance(_angTargetRzMv, TURN_COUNTERCLOCKWISE);
            if (_angveloRzMv > angDistance && _mv_ang_rz_target_allow_way != TURN_CLOCKWISE
                    && _mv_ang_rz_target_allow_velo >= _angveloRzMv) { //ڕWs߂Ă܂EEEȓ
                addRzMvAng(angDistance);
                if (_mv_ang_rz_target_stop_flg) { //~w肠Ȃ
                    _mv_ang_rz_target_flg = false; //tO߂ďI
                }
            } else {
                addRzMvAng(_angveloRzMv);
            }
        } else if (_angveloRzMv < 0) { //v̏ꍇ

            angle angDistance = getRzMvAngDistance(_angTargetRzMv, TURN_CLOCKWISE);
            if (_angveloRzMv < angDistance && _mv_ang_rz_target_allow_way != TURN_COUNTERCLOCKWISE
                    && -1*_mv_ang_rz_target_allow_velo <= _angveloRzMv) {
                addRzMvAng(angDistance);
                if (_mv_ang_rz_target_stop_flg) { //~w肠Ȃ
                    _mv_ang_rz_target_flg = false; //tO߂ďI
                }
            } else {
                addRzMvAng(_angveloRzMv);
            }
        } else {
            addRzMvAng(0);
        }
        if (_mv_ang_rz_target_flg == false) {
            //_angveloRzTopMv = D360ANG; //ړpiZ]j̊px  360,000 angle/fream
            //_angveloRzBottomMv = D360ANG * -1; //ړpiZ]j̊px  -360,000 angle/fream

            //ڕWɓBA~sȂ
            _angacceRzMv = 0; //ZړpApxO
            setRzMvAngVelo(0); //ZړpApxO
        }

    } else {
        //if (_angacceRzMv != 0) {

        _angacceRzMv += _angjerkRzMv;
        //t[̈ړpiZ]j̏
        _angveloRzMv += _angacceRzMv;
        if (_angveloRzMv != 0) {
            addRzMvAng(_angveloRzMv);
        }
        //}
    }
    ////////////////
    //ڕWړpiY]jAO~@\gp̏ꍇ
    if (_mv_ang_ry_target_flg) {

        _angveloRyMv += _angacceRyMv;
        setRyMvAngVelo(_angveloRyMv);

        if (_angveloRyMv > 0) { //݂͔v̏ꍇ
            angle angDistance = getRyMvAngDistance(_angTargetRyMv, TURN_COUNTERCLOCKWISE);
            if (_angveloRyMv > angDistance &&
                _mv_ang_ry_target_allow_way != TURN_CLOCKWISE &&
                _mv_ang_ry_target_allow_velo >= _angveloRyMv)
            { //ڕWs߂Ă܂EEEȓ
                addRyMvAng(angDistance);
                if (_mv_ang_ry_target_stop_flg) { //~w肠Ȃ
                    _mv_ang_ry_target_flg = false; //tO߂ďI
                }
            } else {
                addRyMvAng(_angveloRyMv);
            }
        } else if (_angveloRyMv < 0) { //݂͎v̏ꍇ

            angle angDistance = getRyMvAngDistance(_angTargetRyMv, TURN_CLOCKWISE);
            if (_angveloRyMv < angDistance &&
                _mv_ang_ry_target_allow_way != TURN_COUNTERCLOCKWISE &&
                -1*_mv_ang_ry_target_allow_velo <= _angveloRyMv)
            {
                addRyMvAng(angDistance);
                if (_mv_ang_ry_target_stop_flg) { //~w肠Ȃ
                    _mv_ang_ry_target_flg = false; //tO߂ďI
                }
            } else {
                addRyMvAng(_angveloRyMv);
            }
        } else {
            //_angveloRyMv==0
            addRyMvAng(0);
        }
        if (_mv_ang_ry_target_flg == false) {
            //_angveloRyTopMv = D360ANG; //ړpiY]j̊px  360,000 angle/fream
            //_angveloRyBottomMv = D360ANG*-1; //ړpiY]j̊px  -360,000 angle/fream

            //ڕWɓBA~sȂ
            _angacceRyMv = 0; //YړpApxO
            setRyMvAngVelo(0); //YړpApxO
        }

    } else {
        //if (_angacceRyMv != 0) {
        _angacceRyMv += _angjerkRyMv;
        //t[̈ړpiY]j̏
        _angveloRyMv += _angacceRyMv;
        if(_angveloRyMv != 0) {
            addRyMvAng(_angveloRyMv);
        }
        //}
    }
    ///////////////
    if (_taget_face_ang_alltime_flg && _face_ang_targeting_flg[AXIS_Z] == false && _face_ang_targeting_flg[AXIS_Y] == false) {
        if (_taget_face_ang_alltime_pActor) {
            keepOnTurningFaceAngTwd(
                    _taget_face_ang_alltime_pActor,
                    _taget_face_ang_alltime_angVelo,
                    _taget_face_ang_alltime_angAcce,
                    _taget_face_ang_alltime_way,
                    _taget_face_ang_alltime_optimize_ang);
        } else {
            keepOnTurningFaceAngTwd(
                    _taget_face_ang_alltime_pActor->_X,
                    _taget_face_ang_alltime_pActor->_Y,
                    _taget_face_ang_alltime_pActor->_Z,
                    _taget_face_ang_alltime_angVelo,
                    _taget_face_ang_alltime_angAcce,
                    _taget_face_ang_alltime_way,
                    _taget_face_ang_alltime_optimize_ang);
        }

    }
    //Actorɔf
    _pActor->_X += (coord)(_vX * _veloMv);
    _pActor->_Y += (coord)(_vY * _veloMv);
    _pActor->_Z += (coord)(_vZ * _veloMv);
}

void GgafDxKurokoA::setFaceAng(axis prm_axis, angle prm_angFace) {
    _angFace[prm_axis] = UTIL::simplifyAng(prm_angFace);
}

void GgafDxKurokoA::setFaceAngTwd(coord prm_tX, coord prm_tY, coord prm_tZ) {
    UTIL::convVectorToRzRy(
                   prm_tX - _pActor->_X,
                   prm_tY - _pActor->_Y,
                   prm_tZ - _pActor->_Z,
                   _angFace[AXIS_Z],
                   _angFace[AXIS_Y]
                 );
}

void GgafDxKurokoA::addFaceAng(axis prm_axis, angle prm_angDistance) {
    angle angOffsetrot_FaceAng;
    angOffsetrot_FaceAng = prm_angDistance;
    if (_angveloBottomFace[prm_axis] > prm_angDistance) {
        angOffsetrot_FaceAng = _angveloBottomFace[prm_axis];
    } else if (prm_angDistance > _angveloTopFace[prm_axis]) {
        angOffsetrot_FaceAng = _angveloTopFace[prm_axis];
    }
    setFaceAng(prm_axis, _angFace[prm_axis] + angOffsetrot_FaceAng);
}

void GgafDxKurokoA::setFaceAngVelo(axis prm_axis, angvelo prm_angveloRot) {
    if (prm_angveloRot > _angveloTopFace[prm_axis]) {
        _angveloFace[prm_axis] = _angveloTopFace[prm_axis];
    } else if (prm_angveloRot < _angveloBottomFace[prm_axis]) {
        _angveloFace[prm_axis] = _angveloBottomFace[prm_axis];
    } else {
        _angveloFace[prm_axis] = prm_angveloRot;
    }
}

void GgafDxKurokoA::setFaceAngVelo(angvelo prm_axis_X_angveloRot,
                                   angvelo prm_axis_Y_angveloRot,
                                   angvelo prm_axis_Z_angveloRot) {
    setFaceAngVelo(AXIS_X, prm_axis_X_angveloRot);
    setFaceAngVelo(AXIS_Y, prm_axis_Y_angveloRot);
    setFaceAngVelo(AXIS_Z, prm_axis_Z_angveloRot);
}

void GgafDxKurokoA::forceFaceAngVeloRange(axis prm_axis,
                                          angvelo prm_angveloRot01,
                                          angvelo prm_angveloRot02) {
    if (prm_angveloRot01 < prm_angveloRot02) {
        _angveloTopFace[prm_axis] = prm_angveloRot02;
        _angveloBottomFace[prm_axis] = prm_angveloRot01;
    } else {
        _angveloTopFace[prm_axis] = prm_angveloRot01;
        _angveloBottomFace[prm_axis] = prm_angveloRot02;
    }
    setFaceAngVelo(prm_axis, _angveloFace[prm_axis]); //Đݒ肵Ĕ͈͓ɕ␳
}

void GgafDxKurokoA::setFaceAngAcce(axis prm_axis, angacce prm_angacceRot) {
    _angacceFace[prm_axis] = prm_angacceRot;
}

void GgafDxKurokoA::setStopTargetFaceAngTwd(axis prm_axis,
                                            coord prm_tX,
                                            coord prm_tY,
                                            int prm_way_allow,
                                            angvelo prm_angveloAllowRyMv) {
    setStopTargetFaceAng(
      prm_axis,
      UTIL::getAngle2D(prm_tX - (_pActor->_X), prm_tY - (_pActor->_Y)),
      prm_way_allow,
      prm_angveloAllowRyMv
    );
}

void GgafDxKurokoA::setStopTargetFaceAng(axis prm_axis,
                                         angle prm_angTargetRot,
                                         int prm_way_allow,
                                         angvelo prm_angveloAllow) {
    _face_ang_targeting_flg[prm_axis] = true;
    _face_ang_targeting_stop_flg[prm_axis] = true;
    _angTargetFace[prm_axis] = UTIL::simplifyAng(prm_angTargetRot);
    _face_ang_target_allow_way[prm_axis] = prm_way_allow;
    _face_ang_target_allow_velo[prm_axis] = prm_angveloAllow;
}

angle GgafDxKurokoA::getFaceAngDistance(axis prm_axis, coord prm_tX, coord prm_tY, int prm_way) {
    return getFaceAngDistance(
               prm_axis,
               UTIL::getAngle2D(prm_tX-(_pActor->_X), prm_tY-(_pActor->_Y)),
               prm_way);
}

angle GgafDxKurokoA::getFaceAngDistance(axis prm_axis, angle prm_angTargetRot, int prm_way) {
    angle _angTargetRot;
    _angTargetRot = UTIL::simplifyAng(prm_angTargetRot);
    if (prm_way == TURN_CLOSE_TO) { //߂ق]
        if (0 <= _angFace[prm_axis] && _angFace[prm_axis] < D180ANG) {
            if (0 <= _angTargetRot && _angTargetRot < _angFace[prm_axis]) {
                return -1 * (_angFace[prm_axis] - _angTargetRot);
            } else if (_angTargetRot == _angFace[prm_axis]) {
                //dȂĂꍇ
                return 0;
            } else if (_angFace[prm_axis] < _angTargetRot && _angTargetRot < _angFace[prm_axis]
                    + D180ANG) {
                return _angTargetRot - _angFace[prm_axis];
            } else if (_angTargetRot == _angFace[prm_axis] + D180ANG) {
                //΂Ăi͓j
                //dȂ̂Ő̒lƂB
                return D180ANG;
            } else if (_angFace[prm_axis] + D180ANG < _angTargetRot && _angTargetRot <= D360ANG) {
                return -1 * (_angFace[prm_axis] + (D360ANG - _angTargetRot));
            } else {
                //
                _TRACE_("_angFace["<<prm_axis<<"]=" << _angFace[prm_axis] << "/_angTargetRot=" << _angTargetRot);
                throwGgafCriticalException("GgafDxKurokoA::getFaceAngDistance() ݂̐ʕpAOlA^[QbgAOl͈͊Oł(1)B_pActor="<<_pActor->getName());
            }
        } else if (D180ANG <= _angFace[prm_axis] && _angFace[prm_axis] <= D360ANG) {
            if (0 <= _angTargetRot && _angTargetRot < _angFace[prm_axis] - D180ANG) {
                return D360ANG - _angFace[prm_axis] + _angTargetRot;
            } else if (_angTargetRot == _angFace[prm_axis] - D180ANG) {
                //΂Ăi͓j
                //dȂ̂ŕ̒lƂB
                return -D180ANG;
            } else if (_angFace[prm_axis] - D180ANG < _angTargetRot && _angTargetRot
                    < _angFace[prm_axis]) {
                return -1 * (_angFace[prm_axis] - _angTargetRot);
            } else if (_angFace[prm_axis] == _angTargetRot) {
                //dȂĂꍇ
                return 0;
            } else if (_angFace[prm_axis] < _angTargetRot && _angTargetRot <= D360ANG) {
                return _angTargetRot - _angFace[prm_axis];
            } else {
                //
                _TRACE_("_angFace["<<prm_axis<<"]=" << _angFace[prm_axis] << "/_angTargetRot=" << _angTargetRot);
                throwGgafCriticalException("GgafDxKurokoA::getFaceAngDistance() ݂̐ʕpAOlA^[QbgAOl͈͊Oł(2)B_pActor="<<_pActor->getName());
            }
        }
    } else if (prm_way == TURN_ANTICLOSE_TO) { //̉]
        if (0 <= _angFace[prm_axis] && _angFace[prm_axis] < D180ANG) {
            if (0 <= _angTargetRot && _angTargetRot < _angFace[prm_axis]) {
                return D360ANG - _angFace[prm_axis] + _angTargetRot;
            } else if (_angTargetRot == _angFace[prm_axis]) {
                //dȂĂꍇ
                return D360ANG;
            } else if (_angFace[prm_axis] < _angTargetRot && _angTargetRot < _angFace[prm_axis] + D180ANG) {
                return -1 * ( _angFace[prm_axis] + (D360ANG -_angTargetRot));
            } else if (_angTargetRot == _angFace[prm_axis] + D180ANG) {
                //΂Ăi͓j
                //dȂ̂Ő̒lƂB
                return D180ANG;
            } else if (_angFace[prm_axis] + D180ANG < _angTargetRot && _angTargetRot <= D360ANG) {
                return _angTargetRot - _angFace[prm_axis];
            } else {
                //
                _TRACE_("_angFace["<<prm_axis<<"]=" << _angFace[prm_axis] << "/_angTargetRot=" << _angTargetRot);
                throwGgafCriticalException("GgafDxKurokoA::getFaceAngDistance() ݂̐ʕpAOlA^[QbgAOl͈͊Oł(3)B_pActor="<<_pActor->getName());
            }
        } else if (D180ANG <= _angFace[prm_axis] && _angFace[prm_axis] <= D360ANG) {
            if (0 <= _angTargetRot && _angTargetRot < _angFace[prm_axis] - D180ANG) {
                return -1 * (_angTargetRot - _angFace[prm_axis]);
            } else if (_angTargetRot == _angFace[prm_axis] - D180ANG) {
                //΂Ăi͓j
                //dȂ̂Ő̒lƂB
                return -D180ANG;
            } else if (_angFace[prm_axis] - D180ANG < _angTargetRot && _angTargetRot < _angFace[prm_axis]) {
                return (D360ANG - _angFace[prm_axis]) + _angTargetRot;
            } else if (_angFace[prm_axis] == _angTargetRot) {
                //dȂĂꍇ
                return -D360ANG;
            } else if (_angFace[prm_axis] < _angTargetRot && _angTargetRot <= D360ANG) {
                return (_angFace[prm_axis] + (D360ANG - _angTargetRot)) ;
            } else {
                //
                _TRACE_("_angFace["<<prm_axis<<"]=" << _angFace[prm_axis] << "/_angTargetRot=" << _angTargetRot);
                throwGgafCriticalException("GgafDxKurokoA::getFaceAngDistance() ݂̐ʕpAOlA^[QbgAOl͈͊Oł(4)B_pActor="<<_pActor->getName());
            }
        }
    } else if (prm_way == TURN_COUNTERCLOCKWISE) { //v̏ꍇ
        if (0 <= _angFace[prm_axis] && _angFace[prm_axis] < _angTargetRot) {
            return (_angTargetRot - _angFace[prm_axis]);
        } else if (_angTargetRot < _angFace[prm_axis] && _angFace[prm_axis] <= D360ANG) {
            return D360ANG - _angFace[prm_axis] + _angTargetRot;
        } else if (_angFace[prm_axis] == _angTargetRot) {
            //dȂĂꍇ
            return 0;
        } else {
            //
            _TRACE_("_angFace["<<prm_axis<<"]=" << _angFace[prm_axis] << "/_angTargetRot=" << _angTargetRot);
            throwGgafCriticalException("GgafDxKurokoA::getFaceAngDistance() ݂̐ʕpAOlA^[QbgAOl͈͊Oł(5)B_pActor="<<_pActor->getName());
        }
    } else if (prm_way == TURN_CLOCKWISE) { //v̏ꍇ
        if (0 <= _angFace[prm_axis] && _angFace[prm_axis] < _angTargetRot) {
            return -1 * (_angFace[prm_axis] + D360ANG - _angTargetRot);
        } else if (_angTargetRot < _angFace[prm_axis] && _angFace[prm_axis] <= D360ANG) {
            return -1 * (_angFace[prm_axis] - _angTargetRot);
        } else if (_angFace[prm_axis] == _angTargetRot) {
            //dȂĂꍇ
            return 0;
        } else {
            //
            _TRACE_("_angFace["<<prm_axis<<"]=" << _angFace[prm_axis] << "/_angTargetRot=" << _angTargetRot);
            throwGgafCriticalException("GgafDxKurokoA::getFaceAngDistance() ݂̐ʕpAOlA^[QbgAOl͈͊Oł(6)B_pActor="<<_pActor->getName());
        }
    }
    _TRACE_("_angFace["<<prm_axis<<"]=" << _angFace[prm_axis] << "/_angTargetRot=" << _angTargetRot);
    throwGgafCriticalException("GgafDxKurokoA::getFaceAngDistance() ̂p̋߂܂Bprm_way͐łH(2)Bprm_way="<<prm_way<<" _pActor="<<_pActor->getName());
}

void GgafDxKurokoA::forceMvVeloRange(velo prm_velo) {
    forceMvVeloRange(-prm_velo, prm_velo);
}

void GgafDxKurokoA::forceMvVeloRange(velo prm_veloMv01, velo prm_veloMv02) {
    if (prm_veloMv01 < prm_veloMv02) {
        _veloTopMv = prm_veloMv02;
        _veloBottomMv = prm_veloMv01;
    } else {
        _veloTopMv = prm_veloMv01;
        _veloBottomMv = prm_veloMv02;
    }
    setMvVelo(_veloMv); //Đݒ肵Ĕ͈͓ɕ␳
}

void GgafDxKurokoA::setMvVelo(velo prm_veloMv) {
    if (prm_veloMv > _veloTopMv) {
        _veloMv = _veloTopMv;
    } else if (prm_veloMv < _veloBottomMv) {
        _veloMv = _veloBottomMv;
    } else {
        _veloMv = prm_veloMv;
    }
}

void GgafDxKurokoA::addMvVelo(velo prm_veloMv_Offset) {
    setMvVelo(_veloMv + prm_veloMv_Offset);
}

void GgafDxKurokoA::setMvAcce(int prm_acceMove) {
    _accMv = prm_acceMove;
}

frame GgafDxKurokoA::setMvAcceToStop(coord prm_target_distance) {
    double acc = UTIL::getAcceToStop(prm_target_distance, _veloMv);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _accMv = acc;
    return (frame)((2.0*prm_target_distance) / _veloMv); //gpt[
}

frame GgafDxKurokoA::setMvAcceByD(coord prm_target_distance, velo prm_target_velo) {
    double acc = UTIL::getAcceByD(prm_target_distance, _veloMv, prm_target_velo);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _accMv = acc;
    return (frame)((1.0*prm_target_velo - _veloMv) / _accMv); //gpt[
}
    // y⑫z
    // V0 <= 0    Vt <= 0 ꍇA邢  V0 >= 0    Vt >= 0  ꍇ́AD(ڕW)LŖȂB
    // ł
    // V0 < 0     Vt > 0  ꍇA邢  V0 > 0     Vt < 0   ꍇ́AǂȂ邩H
    //
    //    x(v)
    //     ^        a:x
    //     |        D:ړiڕWBxɒB܂łɔ₷j
    //     |       V0:_̑x
    //     |       Vt:ڕWBx
    //     |       Te:ڕWBxɒB̎ԁit[j
    //  V0 |
    //     |_
    //     |  _  Xa
    //     | D1 _
    //     |      _ Tc     Te
    //   --+--------_------+---> (t)
    //   0 |          _ D2 |
    //     |            _  |
    //   Vt|.............._|
    //     |
    //
    //    D Ŝ̈ړƂ
    //    D = D1 - D2 , v = 0  t  Tc Ƃ
    //
    //    D1 = (1/2) V0 Tc
    //    D2 = (1/2) -Vt (Te - Tc)
    //    D = D1 - D2 
    //    D = (1/2) V0 Tc -  { (1/2) -Vt (Te - Tc) }
    //      = (V0 Tc + Vt Te - Vt Tc) / 2    EEE@
    //
    //     v = a t + V0 ɂ v = 0  t = Tc ł̂
    //    0 = a Tc + V0
    //    Tc = -V0 / a
    //     @ ֑
    //    D = (V0 (-V0 / a) + Vt Te - Vt (-V0 / a)) / 2 EEEA
    //    ܂ a = (Vt - V0) / Te ł̂
    //    Te = (Vt - V0) / a  A ֑
    //    
    //    D = (V0 (-V0 / a) + Vt ((Vt - V0) / a) - Vt (-V0 / a)) / 2
    //
    //    a ɂĉ
    //
    //    D = ( -(V0^2) / a  + (Vt (Vt - V0)) / a + (Vt V0) / a) / 2
    //    a D = { -(V0^2) + (Vt (Vt - V0)) + (Vt V0) } / 2
    //    a = { -(V0^2) + (Vt (Vt - V0)) + (Vt V0) } / 2D
    //    a = (-(V0^2) + Vt^2 - Vt V0 + Vt V0) / 2D
    //    a = (Vt^2 - V0^2) / 2D
    //
    //     a = (Vt^2 - V0^2) / 2D ƂȂ̂
    //    V0 <= 0    Vt <= 0 ꍇA邢  V0 >= 0    Vt >= 0  ꍇƓł

coord GgafDxKurokoA::setMvAcceByT(frame prm_target_frames, velo prm_target_velo) {
    double acc = UTIL::getAcceByT(prm_target_frames, _veloMv, prm_target_velo);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _accMv = acc;
    //  D = (1/2) (Vo + Vt) Te
    return ((_veloMv + prm_target_velo) * prm_target_frames)  / 2 ;
}

void GgafDxKurokoA::slideMvByDT(velo prm_end_velo, coord prm_target_distance,
                                int prm_target_frames, float prm_p1, float prm_p2,
                                bool prm_endacc_flg) {
    _slide_mv_flg = true;
    _slide_mv_p1 = (int)(prm_target_frames*prm_p1);
    _slide_mv_p2 = (int)(prm_target_frames*prm_p2);
    _slide_mv_end_velo = prm_end_velo;
    _slide_mv_target_distance = prm_target_distance;
    _slide_mv_mv_distance = 0;
    _slide_mv_target_frames = prm_target_frames;
    _slide_mv_frame_of_spent = 0;
    _slide_mv_progress = 0;

    //gbvXs[h(Vt) vZ
    //
    //    x(v)
    //     ^
    //     |                          D:ڕWړ
    //     |                         V0:_̑x
    //     |                         Vt:gbvXs[h
    //     |                         Ve:ŏIx
    //   Vt|....QQQQQ           Te:ڕWԁit[j
    //     |   /:         :_        p1:gbvXs[hɒB鎞ƂȂ悤ȁATeɑ΂銄
    //   Ve|../.:.........:.._      p2:JnƂȂ悤ȁATeɑ΂銄
    //     | /  :         :    |        (0.0 < p1 < p2 < 1.0)
    //     |/   :         :    |
    //   V0|    :    D    :    |
    //     |    :         :    |
    //   --+----+---------+----+-----> (t:t[)
    //   0 |  p1*Te     p2*Te  Te
    //
    // ړD́Ȃ`{̒`{Ȇ` ̖ʐςłA
    // D = (1/2) (V0 + Vt) p1 Te + Vt (p2-p1)Te  +  (1/2) (Ve + Vt) (1-p2)Te
    // Vtɂĉ
    // Vt = ( 2D - p1 Te V0 + (p2 - 1) Te Ve ) / ( (p2 - p1 + 1) Te )
    _slide_mv_top_velo =
         ((2.0*prm_target_distance) - (prm_p1*prm_target_frames*_veloMv) + ((prm_p2-1.0)*prm_target_frames*prm_end_velo))
         / ((prm_p2-prm_p1+1.0)*prm_target_frames);

}

void GgafDxKurokoA::slideMvByVD(velo prm_top_velo, velo prm_end_velo,
                                coord prm_target_distance, float prm_p1, float prm_p2,
                                bool prm_endacc_flg) {
    _slide_mv_flg = true;
    _slide_mv_endacc_flg = prm_endacc_flg;
    _slide_mv_top_velo = prm_top_velo;
    _slide_mv_end_velo = prm_end_velo;
    _slide_mv_target_distance = prm_target_distance;
    _slide_mv_mv_distance = 0;
    _slide_mv_target_frames = -1; //ڕWԂ͎gȂꍇ͕ݒ肵Ă(Ŏgp)
    _slide_mv_frame_of_spent = 0;
    _slide_mv_p1 = (int)(prm_target_distance*prm_p1);
    _slide_mv_p2 = (int)(prm_target_distance*prm_p2);
    _slide_mv_progress = 0;
}


void GgafDxKurokoA::slideMvByVT(velo prm_top_velo, velo prm_end_velo,
                                int prm_target_frames, float prm_p1, float prm_p2,
                                bool prm_endacc_flg) {
    _slide_mv_flg = true;
    _slide_mv_endacc_flg = prm_endacc_flg;
    _slide_mv_top_velo = prm_top_velo;
    _slide_mv_end_velo = prm_end_velo;
    _slide_mv_target_distance = 0;
    _slide_mv_mv_distance = 0;
    _slide_mv_target_frames = prm_target_frames;
    _slide_mv_frame_of_spent = 0;
    _slide_mv_p1 = (int)(prm_target_frames*prm_p1);
    _slide_mv_p2 = (int)(prm_target_frames*prm_p1);
    _slide_mv_progress = 0;
}


//void GgafDxKurokoA::slideMv4(velo prm_end_velo, coord prm_target_distance, int prm_target_frames,
//                                                      bool prm_endacc_flg) {
//    _slide_mv_flg = true;
//    _slide_mv_p1 = (int)(prm_target_distance*1.0 / 4.0);
//    _slide_mv_p2 = (int)(prm_target_distance*3.0 / 4.0);
//    _slide_mv_end_velo = prm_end_velo;
//    _slide_mv_target_distance = prm_target_distance;
//    _slide_mv_mv_distance = 0;
//    _slide_mv_target_frames = -1; //ڕWԂ͎gȂꍇ͕ݒ肵Ă(Ŏgp)
//    _slide_mv_frame_of_spent = 0;
//    _slide_mv_progress = 0;
//
//    //    x
//    //     ^
//    //     |                       D:ړ
//    //     |                      V0:_̑x
//    //     |                      Vt:1/4 ` 3/4 ̑x
//    //     |                      Ve:ŏIڕWBx
//    //   Vt|....QQQQ            Te:ڕWBxɒB̎ԁit[j
//    //     |   /|      |_
//    //   Ve|../.|......|.._
//    //     | /  |      |   |
//    //     |/   |      |   |
//    //   V0| 1/4|  2/4 |1/4|
//    //     |  D |   D  | D |
//    //   --+----+------+---+-----> (t[)
//    //   0 |   tp1    tp2  Te
//
//    //  u`{`{`v ̖ʐρB䂦
//    // (1/4)D = (1/2) (V0 + Vt) tp1           c@ `
//    // (2/4)D = Vt (tp2 - tp1)                cA `
//    // (1/4)D = (1/2) (Ve + Vt) (Te - tp2)     cB `
//
//
//    // (1/4)D = Vt tp1 -  (1/2) tp1 (Vt - V0)
//    // ܂A uŜ̒` ] Op`Qv ̖ʐςłB䂦
//    // D = Te Vt - (1/2) tp1 (Vt - V0) - (1/2) (Te - tp2) (Vt - Ve) cC
//
//    //@
//    //tp1 = (D / 2 (V0 + Vt) )        cD
//    //B
//    //(Te - tp2) = (D / 2 (Ve + Vt) )  cE
//    //DEC֑
//    //D = Te Vt - D(Vt - V0) / 4 (V0 + Vt) - D(Vt - Ve) / 4 (Ve + Vt)
//    //Vtɂĉ
//
//    //    Vt =
//    //    (sqrt((-9*V0^2+9*Ve*V0-9*Ve^2)*D^4-(4*Te*V0^3-6*Te*Ve*V0^2-6*Te*Ve^2*V0+4*Te*Ve^3)*D^3+(-4*Te^2*V0^4+8*Te^2*Ve*V0^3-12*Te^2*Ve^2*V0^2+8*Te^2*Ve^3*V0-4*Te^2*Ve^4)*D^2-4*Te^4*Ve^2*V0^4+8*Te^4*Ve^3*V0^3-4*Te^4*Ve^4*V0^2)/(4*3^(3/2)*Te^2)-
//    //    (Te^3*(8*V0^3-12*Ve*V0^2-12*Ve^2*V0+8*Ve^3)-27*D^3)/(216*Te^3))^(1/3)+(9*D^2+Te^2*(4*V0^2-4*Ve*V0+4*Ve^2))/(36*Te^2*(
//    //    sqrt((-9*V0^2+9*Ve*V0-9*Ve^2)*D^4-(4*Te*V0^3-6*Te*Ve*V0^2-6*Te*Ve^2*V0+4*Te*Ve^3)*D^3+(-4*Te^2*V0^4+8*Te^2*Ve*V0^3-12*Te^2*Ve^2*V0^2+8*Te^2*Ve^3*V0-4*Te^2*Ve^4)*D^2-4*Te^4*Ve^2*V0^4+8*Te^4*Ve^3*V0^3-4*Te^4*Ve^4*V0^2)/(4*3^(3/2)*Te^2)-
//    //    (Te^3*(8*V0^3-12*Ve*V0^2-12*Ve^2*V0+8*Ve^3)-27*D^3)/(216*Te^3))^(1/3))+(3*D-Te*(2*V0+2*Ve))/(6*Te)
//    //Ȃ񂶂ႱEEE
//
//
//
//
//
//    _slide_mv_top_velo = (8.0*prm_target_distance/prm_target_frames - _veloMv - prm_end_velo) / 6.0;
//}



bool GgafDxKurokoA::isSlidingMv() {
    return _slide_mv_flg;
}

void GgafDxKurokoA::stopSlidingMv() {
    _slide_mv_flg = false;
}

bool GgafDxKurokoA::isJustFinishSlidingMv() {
    if (_slide_mv_flg == false && _slide_mv_progress != -1) {
        return true;
    } else {
        return false;
    }
}

void GgafDxKurokoA::setRzMvAng(angle prm_ang) {
    if (prm_ang !=  _angRzMv) {
        _angRzMv = UTIL::simplifyAng(prm_ang);
        UTIL::convRzRyToVector(_angRzMv, _angRyMv, _vX, _vY, _vZ);
    }
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        setFaceAng(AXIS_Z, _angRzMv);
    }
}

void GgafDxKurokoA::addRzMvAng(angle prm_angDistance) {
    angle angOffset = prm_angDistance;
    if (_angveloRzBottomMv > prm_angDistance) {
        angOffset = _angveloRzBottomMv;
    } else if (prm_angDistance > _angveloRzTopMv) {
        angOffset = _angveloRzTopMv;
    }
    setRzMvAng(_angRzMv + angOffset);
}

void GgafDxKurokoA::setRzMvAngVelo(angvelo prm_angveloRzMv) {
    if (prm_angveloRzMv > _angveloRzTopMv) {
        _angveloRzMv = _angveloRzTopMv;
    } else if (prm_angveloRzMv < _angveloRzBottomMv) {
        _angveloRzMv = _angveloRzBottomMv;
    } else {
        _angveloRzMv = prm_angveloRzMv;
    }
}

void GgafDxKurokoA::setRzMvAngAcce(angacce prm_angacceRzMv) {
    _angacceRzMv = prm_angacceRzMv;
}

void GgafDxKurokoA::forceRzMvAngVeloRange(angvelo prm_angveloRzMv01,
                                          angvelo prm_angveloRzMv02) {
    if (prm_angveloRzMv01 < prm_angveloRzMv02) {
        _angveloRzTopMv = prm_angveloRzMv02;
        _angveloRzBottomMv = prm_angveloRzMv01;
    } else {
        _angveloRzTopMv = prm_angveloRzMv01;
        _angveloRzBottomMv = prm_angveloRzMv02;
    }
    setRzMvAngVelo(_angveloRzMv); //Đݒ肵Ĕ͈͓ɕ␳
}

void GgafDxKurokoA::setStopTargetRzMvAng(angle prm_angTargetRzMv,
                                         int prm_way_allow,
                                         angvelo prm_angveloAllowRyMv) {
    _mv_ang_rz_target_flg = true;
    _mv_ang_rz_target_stop_flg = true;
    _angTargetRzMv = UTIL::simplifyAng(prm_angTargetRzMv);
    _mv_ang_rz_target_allow_way = prm_way_allow;
    _mv_ang_rz_target_allow_velo = prm_angveloAllowRyMv;
}

angle GgafDxKurokoA::getRzMvAngDistanceTwd(coord prm_tX, coord prm_tY, int prm_way) {
    return getRzMvAngDistance(UTIL::getAngle2D(prm_tX - (_pActor->_X), prm_tY - (_pActor->_Y)), prm_way);
}

angle GgafDxKurokoA::getRzMvAngDistance(angle prm_angTargetRzMv, int prm_way) {
    angle angTargetRzMv = UTIL::simplifyAng(prm_angTargetRzMv);
    if (prm_way == TURN_CLOSE_TO) { //߂ق]
        if (0 <= _angRzMv && _angRzMv < D180ANG) {
            if (0 <= angTargetRzMv && angTargetRzMv < _angRzMv) {
                return -1 * (_angRzMv - angTargetRzMv);
            } else if (angTargetRzMv == _angRzMv) {
                //dȂĂꍇ
                return 0;
            } else if (_angRzMv < angTargetRzMv && angTargetRzMv < _angRzMv + D180ANG) {
                return angTargetRzMv - _angRzMv;
            } else if (angTargetRzMv == _angRzMv + D180ANG) {
                //΂Ăi͓j
                //dȂ̂Ő̒lƂB
                return D180ANG;
            } else if (_angRzMv + D180ANG < angTargetRzMv && angTargetRzMv <= D360ANG) {
                return -1 * (_angRzMv + (D360ANG - angTargetRzMv));
            } else {
                //
                _TRACE_("_angRzMv=" << _angRzMv << "/angTargetRzMv=" << angTargetRzMv);
                throwGgafCriticalException("GgafDxKurokoA::getRzMvAngDistance() ړpiZ]jAOlA^[QbgAOl͈͊Oł(1)B_pActor="<<_pActor->getName());
            }
        } else if (D180ANG <= _angRzMv && _angRzMv <= D360ANG) {
            if (0 <= angTargetRzMv && angTargetRzMv < _angRzMv - D180ANG) {
                return D360ANG - _angRzMv + angTargetRzMv;
            } else if (angTargetRzMv == _angRzMv - D180ANG) {
                //΂Ăi͓j
                //dȂ̂ŕ̒lƂB
                return -D180ANG;
            } else if (_angRzMv - D180ANG < angTargetRzMv && angTargetRzMv < _angRzMv) {
                return -1 * (_angRzMv - angTargetRzMv);
            } else if (_angRzMv == angTargetRzMv) {
                //dȂĂꍇ
                return 0;
            } else if (_angRzMv < angTargetRzMv && angTargetRzMv <= D360ANG) {
                return angTargetRzMv - _angRzMv;
            } else {
                //
                _TRACE_("_angRzMv=" << _angRzMv << "/angTargetRzMv=" << angTargetRzMv);
                throwGgafCriticalException("GgafDxKurokoA::getRzMvAngDistance() ړpiZ]jAOlA^[QbgAOl͈͊Oł(2)B_pActor="<<_pActor->getName());
            }
        }
    } else if (prm_way == TURN_ANTICLOSE_TO) { //̉]
        if (0 <= _angRzMv && _angRzMv < D180ANG) {
            if (0 <= angTargetRzMv && angTargetRzMv < _angRzMv) {
                return D360ANG - _angRzMv + angTargetRzMv;
            } else if (angTargetRzMv == _angRzMv) {
                //dȂĂꍇ
                return D360ANG;
            } else if (_angRzMv < angTargetRzMv && angTargetRzMv < _angRzMv + D180ANG) {
                return -1*(_angRzMv + (D360ANG-angTargetRzMv));
            } else if (angTargetRzMv == _angRzMv + D180ANG) {
                //΂Ăi͓j
                //dȂ̂Ő̒lƂB
                return D180ANG;
            } else if (_angRzMv + D180ANG < angTargetRzMv && angTargetRzMv <= D360ANG) {
                return angTargetRzMv - _angRzMv;
            } else {
                //
                _TRACE_("_angRzMv=" << _angRzMv << "/angTargetRzMv=" << angTargetRzMv);
                throwGgafCriticalException("GgafDxKurokoA::getRzMvAngDistance() ړpiZ]jAOlA^[QbgAOl͈͊Oł(3)B_pActor="<<_pActor->getName());
            }
        } else if (D180ANG <= _angRzMv && _angRzMv <= D360ANG) {
            if (0 <= angTargetRzMv && angTargetRzMv < _angRzMv - D180ANG) {
                return  -1*(_angRzMv - angTargetRzMv);
            } else if (angTargetRzMv == _angRzMv - D180ANG) {
                //΂Ăi͓j
                //dȂ̂ŕ̒lƂB
                return -D180ANG;
            } else if (_angRzMv - D180ANG < angTargetRzMv && angTargetRzMv < _angRzMv) {
                return _angRzMv + (D360ANG - angTargetRzMv);
            } else if (_angRzMv == angTargetRzMv) {
                //dȂĂꍇ
                return -D360ANG;
            } else if (_angRzMv < angTargetRzMv && angTargetRzMv <= D360ANG) {
                return angTargetRzMv + (D360ANG - _angRzMv);
            } else {
                //
                _TRACE_("_angRzMv=" << _angRzMv << "/angTargetRzMv=" << angTargetRzMv);
                throwGgafCriticalException("GgafDxKurokoA::getRzMvAngDistance() ړpiZ]jAOlA^[QbgAOl͈͊Oł(4)B_pActor="<<_pActor->getName());
            }
        }
    } else if (prm_way == TURN_COUNTERCLOCKWISE) { //v̏ꍇ
        if (0 <= _angRzMv && _angRzMv < angTargetRzMv) {
            return (angTargetRzMv - _angRzMv);
        } else if (angTargetRzMv < _angRzMv && _angRzMv <= D360ANG) {
            return D360ANG - _angRzMv + angTargetRzMv;
        } else if (_angRzMv == angTargetRzMv) {
            //dȂĂꍇ
            return 0;
        } else {
            //
            _TRACE_("_angRzMv=" << _angRzMv << "/angTargetRzMv=" << angTargetRzMv);
            throwGgafCriticalException("GgafDxKurokoA::getRzMvAngDistance() ړpiZ]jAOlA^[QbgAOl͈͊Oł(5)B_pActor="<<_pActor->getName());
        }
    } else if (prm_way == TURN_CLOCKWISE) { //v̏ꍇ
        if (0 <= _angRzMv && _angRzMv < angTargetRzMv) {
            return -1 * (_angRzMv + D360ANG - angTargetRzMv);
        } else if (angTargetRzMv < _angRzMv && _angRzMv <= D360ANG) {
            return -1 * (_angRzMv - angTargetRzMv);
        } else if (_angRzMv == angTargetRzMv) {
            //dȂĂꍇ
            return 0;
        } else {
            //
            _TRACE_("_angRzMv=" << _angRzMv << "/angTargetRzMv=" << angTargetRzMv);
            throwGgafCriticalException("GgafDxKurokoA::getRzMvAngDistance() ړpiZ]jAOlA^[QbgAOl͈͊Oł(6)B_pActor="<<_pActor->getName());
        }
    }
    _TRACE_("_angRzMv=" << _angRzMv << "/angTargetRzMv=" << angTargetRzMv);
    throwGgafCriticalException("GgafDxKurokoA::getRzMvAngDistance() ̂p̋߂܂(1)B_pActor="<<_pActor->getName());
}


//void GgafDxKurokoA::setRyMvAngTwd(coord prm_tX, coord prm_tY) {
//    setRyMvAng(UTIL::getAngle2D(prm_tX - (_pActor->_X), prm_tY - (_pActor->_Y)));
//}

void GgafDxKurokoA::setRyMvAng(angle prm_ang) {
    if (prm_ang != _angRyMv) {
        _angRyMv = UTIL::simplifyAng(prm_ang);
        UTIL::convRzRyToVector(_angRzMv, _angRyMv, _vX, _vY, _vZ);
    }
    if (_relate_RyFaceAng_with_RyMvAng_flg) {
        setFaceAng(AXIS_Y, _angRyMv);
    }
}

void GgafDxKurokoA::addRyMvAng(angle prm_angDistance) {
    angle angOffset = prm_angDistance;
    if (_angveloRyBottomMv > prm_angDistance) {
        angOffset = _angveloRyBottomMv;
    } else if (prm_angDistance > _angveloRyTopMv) {
        angOffset = _angveloRyTopMv;
    }
    setRyMvAng(_angRyMv + angOffset);
}

void GgafDxKurokoA::setRyMvAngVelo(angvelo prm_angveloRyMv) {
    if (prm_angveloRyMv > _angveloRyTopMv) {
        _angveloRyMv = _angveloRyTopMv;
    } else if (prm_angveloRyMv < _angveloRyBottomMv) {
        _angveloRyMv = _angveloRyBottomMv;
    } else {
        _angveloRyMv = prm_angveloRyMv;
    }
}

void GgafDxKurokoA::setRyMvAngAcce(angacce prm_angacceRyMv) {
    _angacceRyMv = prm_angacceRyMv;
}

void GgafDxKurokoA::forceRyMvAngVeloRange(angvelo prm_angveloRyMv01,
                                          angvelo prm_angveloRyMv02) {
    if (prm_angveloRyMv01 < prm_angveloRyMv02) {
        _angveloRyTopMv = prm_angveloRyMv02;
        _angveloRyBottomMv = prm_angveloRyMv01;
    } else {
        _angveloRyTopMv = prm_angveloRyMv01;
        _angveloRyBottomMv = prm_angveloRyMv02;
    }
    setRyMvAngVelo(_angveloRyMv); //Đݒ肵Ĕ͈͓ɕ␳
}

void GgafDxKurokoA::forceRzRyMvAngVeloRange(angvelo prm_angveloRzRyMv01, angvelo prm_angveloRzRyMv02) {
    if (prm_angveloRzRyMv01 < prm_angveloRzRyMv02) {
        _angveloRzTopMv = prm_angveloRzRyMv02;
        _angveloRzBottomMv = prm_angveloRzRyMv01;
        _angveloRyTopMv = prm_angveloRzRyMv02;
        _angveloRyBottomMv = prm_angveloRzRyMv01;
    } else {
        _angveloRzTopMv = prm_angveloRzRyMv01;
        _angveloRzBottomMv = prm_angveloRzRyMv02;
        _angveloRyTopMv = prm_angveloRzRyMv01;
        _angveloRyBottomMv = prm_angveloRzRyMv02;
    }
    setRzMvAngVelo(_angveloRzMv); //Đݒ肵Ĕ͈͓ɕ␳
    setRyMvAngVelo(_angveloRyMv); //Đݒ肵Ĕ͈͓ɕ␳
}
void GgafDxKurokoA::setRzRyMvAngVelo(angvelo prm_angveloRzRyMv) {
    if (prm_angveloRzRyMv > _angveloRzTopMv) {
        _angveloRzMv = _angveloRzTopMv;
    } else if (prm_angveloRzRyMv < _angveloRzBottomMv) {
        _angveloRzMv = _angveloRzBottomMv;
    } else {
        _angveloRzMv = prm_angveloRzRyMv;
    }
    if (prm_angveloRzRyMv > _angveloRyTopMv) {
        _angveloRyMv = _angveloRyTopMv;
    } else if (prm_angveloRzRyMv < _angveloRyBottomMv) {
        _angveloRyMv = _angveloRyBottomMv;
    } else {
        _angveloRyMv = prm_angveloRzRyMv;
    }
}
void GgafDxKurokoA::setRzRyMvAngAcce(angacce prm_angacceRzRyMv) {
    _angacceRzMv = prm_angacceRzRyMv;
    _angacceRyMv = prm_angacceRzRyMv;
}
void GgafDxKurokoA::setRzRyMvAngAcce(angacce prm_angacceRzMv, angacce prm_angacceRyMv) {
    _angacceRzMv = prm_angacceRzMv;
    _angacceRyMv = prm_angacceRyMv;
}

void GgafDxKurokoA::setRzRyMvAngVelo(angvelo prm_angveloRzMv, angvelo prm_angveloRyMv) {
    if (prm_angveloRzMv > _angveloRzTopMv) {
        _angveloRzMv = _angveloRzTopMv;
    } else if (prm_angveloRzMv < _angveloRzBottomMv) {
        _angveloRzMv = _angveloRzBottomMv;
    } else {
        _angveloRzMv = prm_angveloRzMv;
    }
    if (prm_angveloRyMv > _angveloRyTopMv) {
        _angveloRyMv = _angveloRyTopMv;
    } else if (prm_angveloRyMv < _angveloRyBottomMv) {
        _angveloRyMv = _angveloRyBottomMv;
    } else {
        _angveloRyMv = prm_angveloRyMv;
    }
}

void GgafDxKurokoA::setStopTargetRyMvAng(angle prm_angTargetRyMv,
                                         int prm_way_allow,
                                         angvelo prm_angveloAllowRyMv) {
    _mv_ang_ry_target_flg = true;
    _mv_ang_ry_target_stop_flg = true;
    _angTargetRyMv = UTIL::simplifyAng(prm_angTargetRyMv);
    _mv_ang_ry_target_allow_way = prm_way_allow;
    _mv_ang_ry_target_allow_velo = prm_angveloAllowRyMv;
}

angle GgafDxKurokoA::getRyMvAngDistanceTwd(coord prm_tX, coord prm_tY, int prm_way) {
    return getRyMvAngDistance(UTIL::getAngle2D(prm_tX - (_pActor->_X), prm_tY - (_pActor->_Y)),
                                        prm_way);
}

angle GgafDxKurokoA::getRyMvAngDistance(angle prm_angTargetRyMv, int prm_way) {
    angle angTargetRyMv;
    angTargetRyMv = UTIL::simplifyAng(prm_angTargetRyMv);
    if (prm_way == TURN_CLOSE_TO) { //߂ق]
        if (0 <= _angRyMv && _angRyMv < D180ANG) {
            if (0 <= angTargetRyMv && angTargetRyMv < _angRyMv) {
                return -1 * (_angRyMv - angTargetRyMv);
            } else if (angTargetRyMv == _angRyMv) {
                //dȂĂꍇ
                return 0;
            } else if (_angRyMv < angTargetRyMv && angTargetRyMv < _angRyMv + D180ANG) {
                return angTargetRyMv - _angRyMv;
            } else if (angTargetRyMv == _angRyMv + D180ANG) {
                //΂Ăi͓j
                //dȂ̂Ő̒lƂB
                return D180ANG;
            } else if (_angRyMv + D180ANG < angTargetRyMv && angTargetRyMv <= D360ANG) {
                return -1 * (_angRyMv + (D360ANG - angTargetRyMv));
            } else {
                //
                _TRACE_("_angRyMv=" << _angRyMv << "/angTargetRyMv=" << angTargetRyMv);
                throwGgafCriticalException("GgafDxKurokoA::getRyMvAngDistance() ړpiY]jAOlA^[QbgAOl͈͊Oł(1)B_pActor="<<_pActor->getName());
            }
        } else if (D180ANG <= _angRyMv && _angRyMv <= D360ANG) {
            if (0 <= angTargetRyMv && angTargetRyMv < _angRyMv - D180ANG) {
                return D360ANG - _angRyMv + angTargetRyMv;
            } else if (angTargetRyMv == _angRyMv - D180ANG) {
                //΂Ăi͓j
                //dȂ̂ŕ̒lƂB
                return -D180ANG;
            } else if (_angRyMv - D180ANG < angTargetRyMv && angTargetRyMv < _angRyMv) {
                return -1 * (_angRyMv - angTargetRyMv);
            } else if (_angRyMv == angTargetRyMv) {
                //dȂĂꍇ
                return 0;
            } else if (_angRyMv < angTargetRyMv && angTargetRyMv <= D360ANG) {
                return angTargetRyMv - _angRyMv;
            } else {
                //
                _TRACE_("_angRyMv=" << _angRyMv << "/angTargetRyMv=" << angTargetRyMv);
                throwGgafCriticalException("GgafDxKurokoA::getRyMvAngDistance() ړpiY]jAOlA^[QbgAOl͈͊Oł(2)B_pActor="<<_pActor->getName());
            }
        }
    } else if (prm_way == TURN_ANTICLOSE_TO) { //̉]
        if (0 <= _angRyMv && _angRyMv < D180ANG) {
            if (0 <= angTargetRyMv && angTargetRyMv < _angRyMv) {
                return D360ANG - _angRyMv + angTargetRyMv;
            } else if (angTargetRyMv == _angRyMv) {
                //dȂĂꍇ
                return D360ANG;
            } else if (_angRyMv < angTargetRyMv && angTargetRyMv < _angRyMv + D180ANG) {
                return -1*(_angRyMv + (D360ANG-angTargetRyMv));
            } else if (angTargetRyMv == _angRyMv + D180ANG) {
                //΂Ăi͓j
                //dȂ̂Ő̒lƂB
                return D180ANG;
            } else if (_angRyMv + D180ANG < angTargetRyMv && angTargetRyMv <= D360ANG) {
                return angTargetRyMv - _angRyMv;
            } else {
                //
                _TRACE_("_angRyMv=" << _angRyMv << "/angTargetRyMv=" << angTargetRyMv);
                throwGgafCriticalException("GgafDxKurokoA::getRyMvAngDistance() ړpiZ]jAOlA^[QbgAOl͈͊Oł(3)B_pActor="<<_pActor->getName());
            }
        } else if (D180ANG <= _angRyMv && _angRyMv <= D360ANG) {
            if (0 <= angTargetRyMv && angTargetRyMv < _angRyMv - D180ANG) {
                return  -1*(_angRyMv - angTargetRyMv);
            } else if (angTargetRyMv == _angRyMv - D180ANG) {
                //΂Ăi͓j
                //dȂ̂Ő̒lƂB
                return -D180ANG;
            } else if (_angRyMv - D180ANG < angTargetRyMv && angTargetRyMv < _angRyMv) {
                return _angRyMv + (D360ANG - angTargetRyMv);
            } else if (_angRyMv == angTargetRyMv) {
                //dȂĂꍇ
                return -D360ANG;
            } else if (_angRyMv < angTargetRyMv && angTargetRyMv <= D360ANG) {
                return angTargetRyMv + (D360ANG - _angRyMv);
            } else {
                //
                _TRACE_("_angRyMv=" << _angRyMv << "/angTargetRyMv=" << angTargetRyMv);
                throwGgafCriticalException("GgafDxKurokoA::getRyMvAngDistance() ړpiZ]jAOlA^[QbgAOl͈͊Oł(4)B_pActor="<<_pActor->getName());
            }
        }
    } else if (prm_way == TURN_COUNTERCLOCKWISE) { //v̏ꍇ
        if (0 <= _angRyMv && _angRyMv < angTargetRyMv) {
            return (angTargetRyMv - _angRyMv);
        } else if (angTargetRyMv < _angRyMv && _angRyMv <= D360ANG) {
            return D360ANG - _angRyMv + angTargetRyMv;
        } else if (_angRyMv == angTargetRyMv) {
            //dȂĂꍇ
            return 0;
        } else {
            //
            _TRACE_("_angRyMv=" << _angRyMv << "/angTargetRyMv=" << angTargetRyMv);
            throwGgafCriticalException("GgafDxKurokoA::getRyMvAngDistance() ړpiY]jAOlA^[QbgAOl͈͊Oł(5)B_pActor="<<_pActor->getName());
        }
    } else if (prm_way == TURN_CLOCKWISE) { //v̏ꍇ
        if (0 <= _angRyMv && _angRyMv < angTargetRyMv) {
            return -1 * (_angRyMv + D360ANG - angTargetRyMv);
        } else if (angTargetRyMv < _angRyMv && _angRyMv <= D360ANG) {
            return -1 * (_angRyMv - angTargetRyMv);
        } else if (_angRyMv == angTargetRyMv) {
            //dȂĂꍇ
            return 0;
        } else {
            //
            _TRACE_("_angRyMv=" << _angRyMv << "/angTargetRyMv=" << angTargetRyMv);
            throwGgafCriticalException("GgafDxKurokoA::getRyMvAngDistance() ړpiY]jAOlA^[QbgAOl͈͊Oł(6)B_pActor="<<_pActor->getName());
        }
    }
    _TRACE_("_angRyMv=" << _angRyMv << "/angTargetRyMv=" << angTargetRyMv);
    throwGgafCriticalException("GgafDxKurokoA::getRyMvAngDistance() ̂p̋߂܂(1)B_pActor="<<_pActor->getName());
}

void GgafDxKurokoA::getRzRyMvAngDistance(int prm_way,
                                         angle prm_target_angRz, angle prm_target_angRy,
                                         angle& out_d_angRz, angle& out_d_angRy,
                                         angle& out_target_angRz, angle& out_target_angRy) {
    angle target_angRz = prm_target_angRz;
    angle target_angRy = prm_target_angRy;
    if (prm_way == TURN_CLOSE_TO) { //߂ق]
        //ڕWɓB邽߂ɂ́AɂQp^[B
        //ꂼꋅʏ̂Q_̋ȈՋߎlixD̂߁jŔrA߂Ǝvق̗pB
        angle d1_angRz = getRzMvAngDistance(target_angRz, TURN_CLOSE_TO); //Rz̍
        angle d1_angRy = getRyMvAngDistance(target_angRy, TURN_CLOSE_TO);
        angle d1 = ABS(d1_angRz) > ABS(d1_angRy) ? ABS(d1_angRz) : ABS(d1_angRy);
        UTIL::anotherRzRy(target_angRz, target_angRy);
        angle d2_angRz = getRzMvAngDistance(target_angRz, TURN_CLOSE_TO);
        angle d2_angRy = getRyMvAngDistance(target_angRy, TURN_CLOSE_TO);
        angle d2 = ABS(d2_angRz) > ABS(d2_angRy) ? ABS(d2_angRz) : ABS(d2_angRy);
        if (d1 <= d2) {
            out_d_angRz = d1_angRz;
            out_d_angRy = d1_angRy;
            out_target_angRz = prm_target_angRz;
            out_target_angRy = prm_target_angRy;
        } else {
            out_d_angRz = d2_angRz;
            out_d_angRy = d2_angRy;
            out_target_angRz = target_angRz;
            out_target_angRy = target_angRy;
        }
    } else if (prm_way == TURN_ANTICLOSE_TO) { //̉]
        angle d1_angRz = getRzMvAngDistance(target_angRz, TURN_ANTICLOSE_TO);
        angle d1_angRy = getRyMvAngDistance(target_angRy, TURN_ANTICLOSE_TO);
        angle d1 = ABS(d1_angRz) > ABS(d1_angRy) ? ABS(d1_angRz) : ABS(d1_angRy);
        UTIL::anotherRzRy(target_angRz, target_angRy);
        angle d2_angRz = getRzMvAngDistance(target_angRz, TURN_ANTICLOSE_TO);
        angle d2_angRy = getRyMvAngDistance(target_angRy, TURN_ANTICLOSE_TO);
        angle d2 = ABS(d2_angRz) > ABS(d2_angRy) ? ABS(d2_angRz) : ABS(d2_angRy);
        if (d1 >= d2) {
            out_d_angRz = d1_angRz;
            out_d_angRy = d1_angRy;
            out_target_angRz = prm_target_angRz;
            out_target_angRy = prm_target_angRy;
        } else {
            out_d_angRz = d2_angRz;
            out_d_angRy = d2_angRy;
            out_target_angRz = target_angRz;
            out_target_angRy = target_angRy;
        }
    } else if (prm_way == TURN_COUNTERCLOCKWISE) { //v̏ꍇ
        out_d_angRz = getRzMvAngDistance(target_angRz, TURN_COUNTERCLOCKWISE);
        out_d_angRy = getRyMvAngDistance(target_angRy, TURN_COUNTERCLOCKWISE);
        out_target_angRz = target_angRz;
        out_target_angRy = target_angRy;
    } else if (prm_way == TURN_CLOCKWISE) { //v̏ꍇ
        out_d_angRz = getRzMvAngDistance(target_angRz, TURN_CLOCKWISE);
        out_d_angRy = getRyMvAngDistance(target_angRy, TURN_CLOCKWISE);
        out_target_angRz = target_angRz;
        out_target_angRy = target_angRy;
    } else {
        //
        throwGgafCriticalException("GgafDxKurokoA::getRzRyMvAngDistance() prm_way="<<prm_way<<" ͑zOłB_pActor="<<_pActor->getName());
    }
}

void GgafDxKurokoA::getRzRyFaceAngDistance(int prm_way,
                                           angle prm_target_angRz, angle prm_target_angRy,
                                           angle& out_d_angRz, angle& out_d_angRy,
                                           angle& out_target_angRz, angle& out_target_angRy) {
    angle target_angRz = prm_target_angRz;
    angle target_angRy = prm_target_angRy;
    if (prm_way == TURN_CLOSE_TO) { //߂ق]
        angle d1_angRz = getFaceAngDistance(AXIS_Z, target_angRz, TURN_CLOSE_TO);
        angle d1_angRy = getFaceAngDistance(AXIS_Y, target_angRy, TURN_CLOSE_TO);
        angle d1 = ABS(d1_angRz) > ABS(d1_angRy) ? ABS(d1_angRz) : ABS(d1_angRy);
        UTIL::anotherRzRy(target_angRz, target_angRy);
        angle d2_angRz = getFaceAngDistance(AXIS_Z, target_angRz, TURN_CLOSE_TO);
        angle d2_angRy = getFaceAngDistance(AXIS_Y, target_angRy, TURN_CLOSE_TO) * ((UTIL::COS[UTIL::simplifyAng(target_angRz*2)/SANG_RATE]/2.0) + 0.5);
        angle d2 = ABS(d2_angRz) > ABS(d2_angRy) ? ABS(d2_angRz) : ABS(d2_angRy);
        if (d1 <= d2) {
            out_d_angRz = d1_angRz;
            out_d_angRy = d1_angRy;
            out_target_angRz = prm_target_angRz;
            out_target_angRy = prm_target_angRy;
        } else {
            out_d_angRz = d2_angRz;
            out_d_angRy = d2_angRy;
            out_target_angRz = target_angRz;
            out_target_angRy = target_angRy;
        }

    } else if (prm_way == TURN_ANTICLOSE_TO) { //̉]
        angle d1_angRz = getFaceAngDistance(AXIS_Z, target_angRz, TURN_ANTICLOSE_TO);
        angle d1_angRy = getFaceAngDistance(AXIS_Y, target_angRy, TURN_ANTICLOSE_TO);
        angle d1 = ABS(d1_angRz) > ABS(d1_angRy) ? ABS(d1_angRz) : ABS(d1_angRy);
        UTIL::anotherRzRy(target_angRz, target_angRy);
        angle d2_angRz = getFaceAngDistance(AXIS_Z, target_angRz, TURN_ANTICLOSE_TO);
        angle d2_angRy = getFaceAngDistance(AXIS_Y, target_angRy, TURN_ANTICLOSE_TO);
        angle d2 = ABS(d2_angRz) > ABS(d2_angRy) ? ABS(d2_angRz) : ABS(d2_angRy);
        if (d1 >= d2) {
            out_d_angRz = d1_angRz;
            out_d_angRy = d1_angRy;
            out_target_angRz = prm_target_angRz;
            out_target_angRy = prm_target_angRy;
        } else {
            out_d_angRz = d2_angRz;
            out_d_angRy = d2_angRy;
            out_target_angRz = target_angRz;
            out_target_angRy = target_angRy;
        }
    } else if (prm_way == TURN_COUNTERCLOCKWISE) { //v̏ꍇ
        out_d_angRz = getFaceAngDistance(AXIS_Z, target_angRz, TURN_COUNTERCLOCKWISE);
        out_d_angRy = getFaceAngDistance(AXIS_Y, target_angRy, TURN_COUNTERCLOCKWISE);
        out_target_angRz = target_angRz;
        out_target_angRy = target_angRy;
    } else if (prm_way == TURN_CLOCKWISE) { //v̏ꍇ
        out_d_angRz = getFaceAngDistance(AXIS_Z, target_angRz, TURN_CLOCKWISE);
        out_d_angRy = getFaceAngDistance(AXIS_Y, target_angRy, TURN_CLOCKWISE);
        out_target_angRz = target_angRz;
        out_target_angRy = target_angRy;
    } else {
        //
        throwGgafCriticalException("GgafDxKurokoA::getRzRyMvAngDistance() prm_way="<<prm_way<<" ͑zOłB_pActor="<<_pActor->getName());
    }
}

void GgafDxKurokoA::setRzRyMvAng(angle prm_angRz, angle prm_angRy) {
    if (prm_angRz != _angRzMv || prm_angRy !=_angRyMv ) {
        _angRzMv = UTIL::simplifyAng(prm_angRz);
        _angRyMv = UTIL::simplifyAng(prm_angRy);
        UTIL::convRzRyToVector(_angRzMv, _angRyMv, _vX, _vY, _vZ);
    }
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        setFaceAng(AXIS_Z, _angRzMv);
    }
    if (_relate_RyFaceAng_with_RyMvAng_flg) {
        setFaceAng(AXIS_Y, _angRyMv);
    }
}

void GgafDxKurokoA::setRzRyMvAng_by_RyRz(angle prm_angRyRz_Ry, angle prm_angRyRz_Rz) {
    angle RyRz_Ry = UTIL::simplifyAng(prm_angRyRz_Ry);
    angle RyRz_Rz = UTIL::simplifyAng(prm_angRyRz_Rz);
    float out_vY, out_vZ;
    UTIL::convRzRyToVector(RyRz_Ry, D360ANG-RyRz_Rz, _vX, out_vY, out_vZ);
    _vY = -1.0f*out_vZ;
    _vZ = out_vY;
    UTIL::convVectorToRzRy(_vX, _vZ, _vY, _angRzMv, _angRyMv);
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        setFaceAng(AXIS_Z, _angRzMv);
    }
    if (_relate_RyFaceAng_with_RyMvAng_flg) {
        setFaceAng(AXIS_Y, _angRyMv);
    }
}


void GgafDxKurokoA::setMvAngTwd(coord prm_tX, coord prm_tY, coord prm_tZ) {
    UTIL::convVectorToRzRy(prm_tX - _pActor->_X,
                           prm_tY - _pActor->_Y,
                           prm_tZ - _pActor->_Z,
                           _vX, _vY, _vZ,
                           _angRzMv, _angRyMv );
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        setFaceAng(AXIS_Z, _angRzMv);
    }
    if (_relate_RyFaceAng_with_RyMvAng_flg) {
        setFaceAng(AXIS_Y, _angRyMv);
    }
}

void GgafDxKurokoA::reverseMvAng() {
    _vX = -_vX;
    _vY = -_vY;
    _vZ = -_vZ;
    _angRzMv = UTIL::simplifyAng(_angRzMv-D180ANG);
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        setFaceAng(AXIS_Z, _angRzMv);
    }
}

void GgafDxKurokoA::setStopTargetMvAngTwd(GgafDxGeometricActor* prm_pActor_Target) {
    setStopTargetMvAngTwd(
        prm_pActor_Target->_X,
        prm_pActor_Target->_Y,
        prm_pActor_Target->_Z
    );
}

void GgafDxKurokoA::setStopTargetMvAngTwd(coord prm_tX, coord prm_tY, coord prm_tZ) {
    angle angRz_Target;
    angle angRy_Target;
    float dummy1, dummy2, dummy3;

    UTIL::convVectorToRzRy(
                   prm_tX - _pActor->_X,
                   prm_tY - _pActor->_Y,
                   prm_tZ - _pActor->_Z,
                   dummy1,
                   dummy2,
                   dummy3,
                   angRz_Target,
                   angRy_Target
                 );
    setStopTargetRzMvAng(angRz_Target);
    setStopTargetRyMvAng(angRy_Target);
}

void GgafDxKurokoA::turnRzRyFaceAngTo(angle prm_angRz_Target, angle prm_angRy_Target,
                                      angvelo prm_angVelo, angacce prm_angAcce,
                                      int prm_way, bool prm_optimize_ang) {
    angle out_d_angRz;
    angle out_d_angRy;
    if (prm_optimize_ang) {
        getRzRyFaceAngDistance(prm_way,
                               prm_angRz_Target, prm_angRy_Target,
                               out_d_angRz, out_d_angRy,
                               prm_angRz_Target, prm_angRy_Target);
    } else {
        out_d_angRz = getFaceAngDistance(AXIS_Z, prm_angRz_Target, prm_way);
        out_d_angRy = getFaceAngDistance(AXIS_Y, prm_angRy_Target, prm_way);
    }

    if (out_d_angRz > 0) {
        setFaceAngVelo(AXIS_Z, prm_angVelo);
        setFaceAngAcce(AXIS_Z, prm_angAcce);
    } else {
        setFaceAngVelo(AXIS_Z, -prm_angVelo);
        setFaceAngAcce(AXIS_Z, -prm_angAcce);
    }
    if (out_d_angRy > 0) {
        setFaceAngVelo(AXIS_Y, prm_angVelo);
        setFaceAngAcce(AXIS_Y, prm_angAcce);
    } else {
        setFaceAngVelo(AXIS_Y, -prm_angVelo);
        setFaceAngAcce(AXIS_Y, -prm_angAcce);
    }

    setStopTargetFaceAng(AXIS_Z, prm_angRz_Target);
    setStopTargetFaceAng(AXIS_Y, prm_angRy_Target);
    _taget_face_ang_alltime_pActor = nullptr;
    _taget_face_ang_alltime_flg = false;
}

void GgafDxKurokoA::turnFaceAngTwd(coord prm_tX, coord prm_tY, coord prm_tZ,
                                   angvelo prm_angVelo, angacce prm_angAcce,
                                   int prm_way, bool prm_optimize_ang) {
    angle out_angRz_Target;
    angle out_angRy_Target;
    UTIL::convVectorToRzRy(prm_tX - _pActor->_X,
                     prm_tY - _pActor->_Y,
                     prm_tZ - _pActor->_Z,
                     out_angRz_Target,
                     out_angRy_Target);

    turnRzRyFaceAngTo(out_angRz_Target, out_angRy_Target,
                      prm_angVelo, prm_angAcce,
                      prm_way, prm_optimize_ang);
}

void GgafDxKurokoA::turnRzFaceAngTo(angle prm_angRz_Target,
                                    angvelo prm_angVelo, angacce prm_angAcce,
                                    int prm_way) {
    if (getFaceAngDistance(AXIS_Z, prm_angRz_Target, prm_way) > 0) {
        setFaceAngVelo(AXIS_Z, prm_angVelo);
        setFaceAngAcce(AXIS_Z, prm_angAcce);
    } else {
        setFaceAngVelo(AXIS_Z, -prm_angVelo);
        setFaceAngAcce(AXIS_Z, -prm_angAcce);
    }
    setStopTargetFaceAng(AXIS_Z, prm_angRz_Target);
    _taget_face_ang_alltime_pActor = nullptr;
    _taget_face_ang_alltime_flg = false;
}

void GgafDxKurokoA::turnRyFaceAngTo(angle prm_angRy_Target,
                                    angvelo prm_angVelo, angacce prm_angAcce,
                                    int prm_way) {
    if (getFaceAngDistance(AXIS_Y, prm_angRy_Target, prm_way) > 0) {
        setFaceAngVelo(AXIS_Y, prm_angVelo);
        setFaceAngAcce(AXIS_Y, prm_angAcce);
    } else {
        setFaceAngVelo(AXIS_Y, -prm_angVelo);
        setFaceAngAcce(AXIS_Y, -prm_angAcce);
    }
    setStopTargetFaceAng(AXIS_Y, prm_angRy_Target);
    _taget_face_ang_alltime_pActor = nullptr;
    _taget_face_ang_alltime_flg = false;
}

void GgafDxKurokoA::turnRxSpinAngTo(angle prm_angRx_Target,
                                    angvelo prm_angVelo, angacce prm_angAcce,
                                    int prm_way) {
    if (getFaceAngDistance(AXIS_X, prm_angRx_Target, prm_way) > 0) {
        setFaceAngVelo(AXIS_X, prm_angVelo);
        setFaceAngAcce(AXIS_X, prm_angAcce);
    } else {
        setFaceAngVelo(AXIS_X, -prm_angVelo);
        setFaceAngAcce(AXIS_X, -prm_angAcce);
    }
    setStopTargetFaceAng(AXIS_X, prm_angRx_Target);
}

void GgafDxKurokoA::turnRzRyMvAngTo(angle prm_angRz_Target, angle prm_angRy_Target,
                                    angvelo prm_angVelo, angacce prm_angAcce,
                                    int prm_way, bool prm_optimize_ang) {
    angle out_d_angRz;
    angle out_d_angRy;
    angle out_target_angRz;
    angle out_target_angRy;
    if (prm_optimize_ang) {
        getRzRyMvAngDistance(prm_way,
                             prm_angRz_Target, prm_angRy_Target,
                             out_d_angRz, out_d_angRy,
                             out_target_angRz, out_target_angRy);
    } else {
        out_d_angRz = getRzMvAngDistance(prm_angRz_Target, prm_way);
        out_d_angRy = getRyMvAngDistance(prm_angRy_Target, prm_way);
        out_target_angRz = prm_angRz_Target;
        out_target_angRy = prm_angRy_Target;
    }
    if (out_d_angRz > 0) {
        setRzMvAngVelo(prm_angVelo);
        setRzMvAngAcce(prm_angAcce);
    } else {
        setRzMvAngVelo(-prm_angVelo);
        setRzMvAngAcce(-prm_angAcce);
    }
    if (out_d_angRy > 0) {
        setRyMvAngVelo(prm_angVelo);
        setRyMvAngAcce(prm_angAcce);
    } else {
        setRyMvAngVelo(-prm_angVelo);
        setRyMvAngAcce(-prm_angAcce);
    }

    setStopTargetRzMvAng(out_target_angRz);
    setStopTargetRyMvAng(out_target_angRy);

}


void GgafDxKurokoA::turnMvAngTwd(coord prm_tX, coord prm_tY, coord prm_tZ,
                                 angvelo prm_angVelo, angacce prm_angAcce,
                                 int prm_way, bool prm_optimize_ang) {
    angle out_angRz_Target;
    angle out_angRy_Target;
    UTIL::convVectorToRzRy(prm_tX - _pActor->_X,
                           prm_tY - _pActor->_Y,
                           prm_tZ - _pActor->_Z,
                           out_angRz_Target,
                           out_angRy_Target);
    turnRzRyMvAngTo(out_angRz_Target, out_angRy_Target,
                    prm_angVelo, prm_angAcce,
                    prm_way, prm_optimize_ang);
}


void GgafDxKurokoA::turnRzMvAngTo(angle prm_angRz_Target,
                                  angvelo prm_angVelo, angacce prm_angAcce,
                                  int prm_way) {
    if (getRzMvAngDistance(prm_angRz_Target, prm_way) > 0) {
        setRzMvAngVelo(prm_angVelo);
        setRzMvAngAcce(prm_angAcce);
    } else {
        setRzMvAngVelo(-prm_angVelo);
        setRzMvAngAcce(-prm_angAcce);
    }
    setStopTargetRzMvAng(prm_angRz_Target);

}

void GgafDxKurokoA::turnRyMvAngTo(angle prm_angRy_Target,
                                  angvelo prm_angVelo, angacce prm_angAcce,
                                  int prm_way) {
    if (getRyMvAngDistance(prm_angRy_Target, prm_way) > 0) {
        setRyMvAngVelo(prm_angVelo);
        setRyMvAngAcce(prm_angAcce);
    } else {
        setRyMvAngVelo(-prm_angVelo);
        setRyMvAngAcce(-prm_angAcce);
    }
    setStopTargetRyMvAng(prm_angRy_Target);
}

void GgafDxKurokoA::takeoverMvFrom(GgafDxKurokoA* const prm_pKurokoA) {
    // L̈ړpPʃxNg
    _vX = prm_pKurokoA->_vX;
    _vY = prm_pKurokoA->_vY;
    _vZ = prm_pKurokoA->_vZ;
    // ړpZ]p
    _angRzMv = prm_pKurokoA->_angRzMv;
    // ړpY]p
    _angRyMv = prm_pKurokoA->_angRyMv;
    // ړx
    _veloMv = prm_pKurokoA->_veloMv;
    // ړx
    _veloTopMv = prm_pKurokoA->_veloTopMv;
    // ړx
    _veloBottomMv = prm_pKurokoA->_veloBottomMv;
    // ړx
    _accMv = prm_pKurokoA->_accMv;
    // ړx
    //_jerkMv = prm_pKurokoA->_jerkMv;
}

GgafDxKurokoA::~GgafDxKurokoA() {
}



// yY^z{NX̍lƃRg̒P̕\
//
// Qނ̕
// uL̕vƂtBȂ߁ÂQނ̒P`BuړpijvƁuʕpijvB
// uړpv̓L̐iŝ݂\B́uړxvƔāAL͍Wړ邱ƂƂB
// uʕpv̓ĽiOĵ݂\鎖ƂB
// LN^ʂ̏㕔牺ֈړĂALN^͉Ƃ͌炸@ɌĂقꍇB
// ܂́AEɃLāAɈړƂBꂼQ̕ݒ肪KvB
//
// ړp̂Qނ̕\@
// LiޕA܂uړpv́̕A_Pʋ̕\ʂɌĐLтxNg (_vX, _vY, _vZ) ŕ\@ƁA
// Q]AOl (_angRzMv, _angRyMv) ŕ\@̂QޗpӂBNH[^jÎ͍Ƃ떳B
// _angRzMv  Z]pA _angRyMv  Y]p ӖĂB
// ͕xNgAܓxƌoxAipƃAW}Xj̊֌WɌāAΉ悤ƂB
// ӂ邱Ƃ́AY]pox ͏ɐ藧AZ]pܓx ́AZ]p  Y]p̏ԂłꍇɌ萬藧B
// {NXł́AuZ]  Y]̏ԂłZ]pEY]pvȗāAPɁuZ]pEY]pvƕ\鎖ƂB
// ꂼuړpiZjvuړpiYjvƕ\鎖B
//
// \[XR[h́Aϐ⃁\bh
// uRzMvvƂ\ĹuړpiZjvӖĂB
// uRyMvvƂ\ĹuړpiYjvӖĂB
// uRzRyMvvƂ\́uZ]  Y]̏Ԃ̈ړpv\ĂB
//
// Z]pAY]pƂ0xAxNg(1, 0, 0) ̕ƒ`B
// Z]p̐̑́AZ̐̕ĔvB
// Y]p̐̑́AY̐̕ĔvBƂB
//
// ƂŐwIɁupv́AxNgiXYZ̒ljŕ\邱ƂƎvB
// ̖{NXł́A悭ĝ͂Q\̕ŁA\bh _angRzMv  _angRyMv 𑀍삷̂SƂȂĂB
// ͌ǓŒPʕxNg߂Ă̂AW]vZA^ _angRzMv  _angRyMv ł񂴂sĂA
// ŌɂPPʃxNg߂BƂ̂ł͂ƍl߁Â悤Ȑ݌vɂȂB
// TODO:œK̗]nԎcĂnYB܂B
// (_angRzMv, _angRyMv)\bhɂ葀삵āAet[̍Ō̓ŕxNg(_vX, _vY, _vZ) 𓯊ĂB
// (_vX, _vY, _vZ)o[\bhg킸ڑ삷ƁA(_angRzMv, _angRyMv)Ƃ̓̂ŒӁB
// {NX̃\bhgpł́AȂƂ͋NȂB
//
// ړx:Velo or MvVelo
// Ĺuړxv(_veloMv)ێĂBړ@͊ȒPŁA{Iɖt[uړpvɁuړxvB
// Ẃuړpv(_vX, _vY, _vZ)Ɂuړxv(_veloMv)|ZĂB
// Pt[̍W݂͌̍W (_vX*_veloMv, _vY*_veloMv, _vZ*_veloMv) ړꏊłB
// ̃xNgɖ{Cu̒Pʋ(Q[̒Pƍl鐮{lj悶B
// āA(_vX*_veloMv*LEN_UNIT, _vY*_veloMv*LEN_UNIT, _vZ*_veloMv*LEN_UNIT)Pt[̍WB

// ʕp:AngFace
// L̃[JWŌĂpijuʕpvƌĂԂƂɂB
//uʕpv́A[hϊs̎]Ɠ]@łB
// [hϊs̎]Ƃ́AX]pAY]pAZ]p̂ƂŁAꂼA
// _angFace[AXIS_X], _angFace[AXIS_Y], _angFace[AXIS_Z] ƈvB
// {Cuł́AxNg(1, 0, 0) ĹuOvƐݒ肵ĂB
// Xt@CȂǂ̃Lf́AԂŐXɌĂ邱ƂOƂB܂Afúv́i0, 1, 0)ƂB
// [hϊs̉]s̊|鏇Ԃ́A{I uX]s > Z]s > Y]s > ړs v ƂB
// (  X > Y > Z ̏ł͂ȂIj
// āAX]p͊]悤ƂALĂ͕ς炸AcZ]pƁAY]pŃLĂ肷邱ƂƂB
// X]p̓L̃XsÂQpiZ]pEY]pjŃĹuOvp肷ƂꍇA
// uʕpvقǂ́uړpvƓ悤ɁAZ]pY]piܓxƌox)̂Q̃AOl
// (_angFace[AXIS_Z], _angFace[AXIS_Y])ŕ\łB
// ܂AuOv Z]pEY]p0xƂAႦ΁uv(Z]p,Y]p)=(0x,180x) ƕ\BB
// PɁuZ]pvȂǂƏƁAuړpvZ]pȂ̂AuʕpvZ]pȂ̂BɂȂ邽߁A
// uʕp(Z)vuʕp(Y)vƏƂƂBiuʕp(X)v邪A̓Xs\ւ̉e͂Ȃj
// Œӂ́AP̃LĂpɑ΂āAɂQʂ̃ANZX@ƂƁBႦ΁A
// uO(1, 0, 0)Đ^Ev  (ʕp(Z), ʕp(Y))=(0, 90x) or (180x,270x) Ƃŕ\łB
// iʕp(Y)͍nŴY̐Ĕvj
//  uOv (0x,0x) Ƃ (180x,180x) Ƃ\ł邵Au^v  (0x,180x) Ƃ (180x,0x) Ƃ\łB
// Ă͓Ap(L̏)قȂBpقȂƂ܂L͒ӂ邱ƁB
// RAuړpvłAQʂ̃ANZX@̂A͎p̂ŌڂŕȂB
// pxvZƂɉeoꍇ̂ŒӂKvB


// O@\
// Ă uړpiZjvuړpiYjvAꂼuʕp(Z)vuʕp(Y)v փRs[ĂƁA
// ړpƁALN^̌̓ȒPɎ邶ȂI
// uO@\vƂ́Auړpvݒ肷ƁAɔĎIɁuʕpvݒ肷鎖ƂB
// ̓Iɂ́Aȉ̂悤Ƀt[ɁAAOl㏑Rs[ijB͍Zi炩ɕ`jĂB
//  EړpiZj  ʕp(Z)
//  EړpiYj  ʕp(Y)
// uʕpvݒĂuړpvωȂit͊֘AȂĵŒӁB

// px:AngVelo
// uړpiZjvuړpiYjvAuʕp(Z)vuʕp(Y)vɂ́Aꂼ́upxv݂ĂB
// Ⴆ90xEɌꍇALȂJNƌςĂ͔߂̂ŁAt[pxpZ悤ɂāA
// 炩Ɍς悤ɂB
// upxv͐̒ӂKvB̏ꍇ͔vȀꍇ͎vɂȂB
// ]ꍇA^[QbgƂȂpxւ̓BAv[`͐]̂Qʂ肾A
// \5ʂ̍lŎwł悤݌vB
// 1.uɔvōsv TURN_ANTICLOSE_TO
// 2.uɎvōsv TURN_CLOCKWISE
// 3.u߂p̎ōsvTURN_CLOSE_TO
// 4.uȊp̎ōsvTURN_ANTICLOSE_TO
// 5.u݉Ă̂܂܂ōsv
// łBꂼpr̂ŁAIvVȂǂŁAIł悤ɂȁBłB



//̑ǋLA
//EړxAړppxA]ppxɂ́AꂼxݒłI
//E]́A{ Z > X > Y ̎]Ԃɂ̂ʓÎ悤B܂O̊TOZŉł킯AȂقǂ킩₷B
//  ݂ X > Z > Y ́AZOXłB
//  Ƃ2D̉XN[V[eBO낤ƎvĂA X > Z Ő݌vsĂ̂ł邪AǂȂB
//  ܂A3DV[eBOɂƂ͎łvĂ݂ȂEEE

// ړ: VxMv VyMv VzMv
// L̈ړ̌nƂ͂܂ʂɁAƗ XAYAZɕsȈړw肪łB
// uXړxvuYړxvuZړxvݒ肷ƁAt[(_X,_Y,_Z)ɂꂼ̈ړ
// ZB
// i̋@\ GgafDxKurokoB ɏW񂳂ƗNXƂȂ܂Ij

//2010/02/19ǋL
// ܂ɁuRyRzvƂ\݂iuRzRyvƈقȂjÁuY]  Z]̏Ԃ̈ړpv\Ă̂ŒӁB
//   ܂AuړpiZjv]̏Ԃ̈Ⴂ𖾊mɂ邽
//   uRzRyRzvuRyRzRzvƏ肵ĂƂBiPɁuRzv̏ꍇ́uRzRyRzvӖĂj

//ǋL
//E炩ړ\ɁI

//TODO:
//xixj̒ǉ
//Cӎ]iNH[^jIj
//NX̔剻  qB
//yzZ߂
